
<portlet:actionURL var="uploadFileURL">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="uploadTempFile" />
	<portlet:param name="replace" value="true" />
	<portlet:param name="type" value="POA" />
	<portlet:param name="TRACKER" value="${TRACKER}" />
	<portlet:param name="mvcPath" value="METADATA" />
</portlet:actionURL>

<portlet:actionURL var="deleteFileURL">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="removeFile" />
	<portlet:param name="type" value="POA" />
	<portlet:param name="TRACKER" value="${TRACKER}" />
	<portlet:param name="mvcPath" value="METADATA" />
</portlet:actionURL>

<span style="font-weight:bold">
Upload Document
</span>
<br/>
<p>
If you are not the Veteran applying for the PCAFC but have legal authority to act on behalf of the Veteran, documentation of this authority is required and should be uploaded here.  This is the only type of documentation that should be uploaded at this time. 
</p>
<div class="lfr-dynamic-uploader manage-layout">
<div class="lfr-upload-container"
	id="<portlet:namespace />fileUpload">&nbsp;</div>
</div>
<div id="<portlet:namespace/>fallback"></div>


<aui:button-row cssClass="form-buttons">
	<button onClick="showTab('5')" class="btn btn-online previous-screen" id="<portlet:namespace />prevScreen" type="button">
		<i class="icon-cancel">&nbsp;<liferay-ui:message key="&lt;&nbsp;Previous Screen" /></i>
	</button>
	<button class="btn btn-online save-application" id="<portlet:namespace />saveApp" type="button">
		<i class="icon-online">&nbsp;<liferay-ui:message key="Save Progress and Exit" /></i>
	</button>
	<button class="btn btn-online cancel-application" id="<portlet:namespace />cancelApp" type="button">
	<i class="icon-online">&nbsp;<liferay-ui:message key="Cancel" /></i>
	</button>
	<button onClick="showTab('7')" class="btn btn-online next-screen" id="<portlet:namespace />nextScreen" type="button">
	<i class="icon-online">&nbsp;<liferay-ui:message key="Next Screen&nbsp;&gt;" /></i>
	</button>
</aui:button-row>

<c:if test="${empty form_['documId']}">
<aui:script use="liferay-upload,aui-base">

	var liferayUpload = new Liferay.Upload({
	    allowedFileTypes: "${form_['extensions']}",
	    container: '#<portlet:namespace />fileUpload',
	    maxFileSize: ${form_['maxSize']},
	    namespace:'<portlet:namespace />',
	    uploadFile: '${uploadFileURL}', 
	    deleteFile: '${deleteFileURL}',    
	    tempFileRemoved: function(){
	    	log.console('remove temp file from server');
	    },
	    'strings.dropFilesText': 'Drag and drop document file here',
	    'strings.dropFileText': 'Drag and drop document file here',
	    'strings.selectFileText': 'Click to browse for document',
	    'strings.selectFilesText': 'Click to browse for document',
	    'strings.fileCannotBeSavedText': 'File cannot be saved',
	    'strings.pendingFileText': 'Upload of file pending',
	    'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
	    multipleFiles: false
	
	});
	
	A.on('domready', function( event ) {
		try {
	    	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUpload");
		} catch (e){
			// console.log('appendTo... failed');
		}
	});
	
	Liferay.on( 'tempFileRemoved', function(e) {
	A.all('#<portlet:namespace />fileUpload .upload-file').each( function (eee) {
		if( ! eee.hasClass('pending-file') ){
		    eee.hide();
		  }
	  });
	}
	);

</aui:script>
</c:if>