
<%@ include file="/jsp/init.jsp" %>	
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" 
prefix="fn" %> 


<script type="text/javascript">
	function handleChange(event) {	
		var v = event.target.value;	    
		if (!v || v.length == 0) {
	    	document.getElementById('myInputUl2').innerHTML = "";
	    }
	}
	function handleKey(event) {		
		var keyId = event.keyCode;
		switch(keyId) {
			case 8:  
			case 46:  
				var v = event.target.value;
			    if (v.length == 1) {
			    	document.getElementById('myInputUl2').innerHTML = "";
			    }
				break;
			default: 
				break;
		}
	}
</script>

<div class="vetHealthDiv">
	<%@include file="/jsp/online/searchFacility.jsp" %>

	<span style="font-weight: bold;">  Veteran VA Health Care Enrollment: </span> <br/><br/>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['vaHealthEnrolled']}"   >
		<label class="control-label ${searchCss} tab-click"> 
			<liferay-ui:message key="online-enrolled-in-va-health-care" />
		</label>	
		<aui:input type="radio" name="vcgAn_vaHealthEnrolled" value="true" label="yes" checked="${form_['vcgAn'].vaHealthEnrolled eq true}"  />
		<aui:input type="radio" name="vcgAn_vaHealthEnrolled" value="false" label="no" checked="${form_['vcgAn'].vaHealthEnrolled eq false}" />
	</aui:field-wrapper>
	
	<br/><br/>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['vaHealthEnrolled']}"   >
		<aui:input onkeydown="handleKey(event)" onchange="handleChange(event)" style="width: 450px; min-width: 450px; max-width: 450px; text-align: left; font-size: 16px;"
		type="text" name="tempGroupId" id="tempGroupId" label="online-treatment-plan-facility" inlineLabel="left" cssClass="" value="" />
		<br/>
		<aui:input label="online-last-recieved-ack" name="${ndx}_lastTreatment" id="${ndx}_lastTreatment" type="checkbox" />
	</aui:field-wrapper>
    <aui:field-wrapper cssClass="facil-field altFilterUl">
		<ul id="myInputUl2" name="myInputUl2" class="" ></ul>
	</aui:field-wrapper>
	<input type="hidden" id="<portlet:namespace/>facilDisplayName" name="<portlet:namespace/>facilDisplayName" value="${facil.facilDisplayName}" />
	<input type="hidden" cssClass="manage-layout ${cssClass['groupId']}" id="<portlet:namespace/>${ndx}_groupId" name="<portlet:namespace/>${ndx}_groupId" value="${person.groupId}" />
	
	<br/>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="true" cssClass="manage-layout ${cssClass['firstName']}"  >
		<label id="${ndx}_" tabindex='0' class="control-label ${searchCss} tab-click">
			<liferay-ui:message key="online-last-treated-facility" />
		</label>
		<br/>
		<input name="vcgAn_lastTreatmentPlace" id="vcgAn_lastTreatmentPlace" class="name-field" type="text" size="150" value="${form_['vcgAn'].lastTreatmentPlace}">
		<aui:input label="hospital" name="vcgAn_hospital" type="radio" value="true" checked="${form_['vcgAn'].hospital eq true}" />
		<aui:input label="clinic" name="vcgAn_clinic" type="radio" value="true" checked="${form_['vcgAn'].clinic eq true}" />
		
	</aui:field-wrapper>	
	
	<span class="vetHealthText"> 
		<p>Enter any of the following to search for a VA  medical center:</p>
		<p> &nbsp; e.g. Zip code</p>
		<p> &nbsp; e.g. State</p>
		<p> &nbsp; e.g. City</p>
		<p> &nbsp; e.g. Facility name</p>		
	</span>

</div>


<aui:button-row cssClass="form-buttons">
	<button onClick="showTab('1')" class="btn btn-online previous-screen" id="<portlet:namespace />prevScreen" type="button">
		<i class="icon-cancel">&nbsp;<liferay-ui:message key="&lt;&nbsp;Previous Screen" /></i>
	</button>
	<button class="btn btn-online save-application" id="<portlet:namespace />saveApp" type="button">
		<i class="icon-online">&nbsp;<liferay-ui:message key="Save Progress and Exit" /></i>
	</button>
	<button class="btn btn-online cancel-application" id="<portlet:namespace />cancelApp" type="button">
	<i class="icon-online">&nbsp;<liferay-ui:message key="Cancel" /></i>
	</button>
	<button onClick="showTab('3')" class="btn btn-online next-screen" id="<portlet:namespace />nextScreen" type="button">
	<i class="icon-online">&nbsp;<liferay-ui:message key="Next Screen&nbsp;&gt;" /></i>
	</button>
</aui:button-row>

<aui:script use="node,aui-base,node-event-simulate">
	AUI().use('event',function(A) {
		var input1 = A.one("#<portlet:namespace />${ndx}_groupId");
		var inputValue = "";
	    if (input1) {
	    	inputValue = input1.get("value");
	    	//console.log("_groupId - loaded: " + inputValue);
	    }
		if (inputValue) { 
			window.caretIo( 
				'${onlineResourceURL}', 
				'json', 
				{ action:'getFacilDisplayNameByGroupId',
				  inputText : inputValue,
				},
				function(data){
					var facilDisplayName = data.facilDisplayName;
					if (facilDisplayName && facilDisplayName != "null") {
						var input2 = A.one("#<portlet:namespace />facilDisplayName");
						input2.set("value", facilDisplayName);
						var input3 = A.one("#<portlet:namespace />tempGroupId");
						input3.set("value", facilDisplayName);
					}
				}
			);
		}
		else {
			console.log("jsp getFacilDisplayNameByGroupId..: nada, returning: "); 
		}		
	});
</aui:script>

