
<%@ include file="/jsp/init.jsp" %>	
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" 
prefix="fn" %> 

<style>
	.otherHealthBox {
		margin-left: 400px;
	}
	.certifyCheck {
		margin-left: 20px;
		margin-top: 10px;
		margin-bottom: 10px;
	}
</style>
<script type="text/javascript">
	function handleChange(event) {	
		var v = event.target.value;	    
		if (!v || v.length == 0) {
	    	document.getElementById('myInputUl2').innerHTML = "";
	    }
	}
	function handleKey(event) {		
		var keyId = event.keyCode;
		switch(keyId) {
			case 8:  
			case 46:  
				var v = event.target.value;
			    if (v.length == 1) {
			    	document.getElementById('myInputUl2').innerHTML = "";
			    }
				break;
			default: 
				break;
		}
	}
</script>

<div class="cgCertDiv">

	<span style="font-weight: bold;font-size:16px;">${form_['careGiverCategory']} Family Caregiver</span> 
	<br/>
	<span style="font-weight: bold;">  Relationship to Veteran </span> <br/><br/>

	<c:if test="${form_['careGiverCategory'] eq 'Primary'}">
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['primaryRelationship']}">
			<aui:select label="online-cg-relationship" name="vcgAn_primaryRelationship" id="vcgAn_primaryRelationship" >
				<aui:option label="select-relationship" value="" selected="true" />
				<aui:option label="family" cssClass="section" disabled="true" />
				<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
					<aui:option cssClass="family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].primaryRelationship eq relationship}" />
				</c:forEach>
				<aui:option label="not-family" cssClass="section" disabled="true" />
				<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
					<aui:option cssClass="not-family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].primaryRelationship eq relationship}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
	</c:if>
	<c:if test="${form_['careGiverCategory'] eq 'Secondary'}">
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['secondaryRelationship']}">
			<aui:select label="online-cg-relationship" name="vcgAn_secondaryRelationship" id="vcgAn_secondaryRelationship" >
				<aui:option label="select-relationship" value="" selected="true" />
				<aui:option label="family" cssClass="section" disabled="true" />
				<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
					<aui:option cssClass="family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryRelationship eq relationship}" />
				</c:forEach>
				<aui:option label="not-family" cssClass="section" disabled="true" />
				<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
					<aui:option cssClass="not-family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryRelationship eq relationship}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
	</c:if>
	<c:if test="${form_['careGiverCategory'] eq 'Secondary Two'}">
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['secondaryTwoRelationship']}">
			<aui:select label="online-cg-relationship" name="vcgAn_secondaryTwoRelationship" id="vcgAn_secondaryTwoRelationship" >
				<aui:option label="select-relationship" value="" selected="true" />
				<aui:option label="family" cssClass="section" disabled="true" />
				<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
					<aui:option cssClass="family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryTwoRelationship eq relationship}" />
				</c:forEach>
				<aui:option label="not-family" cssClass="section" disabled="true" />
				<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
					<aui:option cssClass="not-family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryTwoRelationship eq relationship}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
	</c:if>
	<c:choose>
		<c:when test="${form_['careGiverCategory'] eq 'Primary'}">
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['mediEnrolled']}"  >
					<label class="control-label ${searchCss} tab-click"> 
						<liferay-ui:message key="enrolled-in-medicare" />
					</label>
						<aui:input type="radio" name="vcgAn_mediEnrolled" id="vcgAn_mediEnrolled" label="yes" value="true" checked="${form_['vcgAn'].mediEnrolled eq true}"/>
						<aui:input type="radio" name="vcgAn_mediEnrolled" id="vcgAn_mediEnrolled" label="no" value="false" checked="${form_['vcgAn'].mediEnrolled eq false}"/>
				</aui:field-wrapper>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['otherHealthInsurance']}"  >
					<label class="control-label ${searchCss} tab-click"> 
						<liferay-ui:message key="cg-other-health-insurance" />
					</label>
						<aui:input type="radio" name="vcgAn_otherHealthInsuranceYesNo" id="vcgAn_otherHealthInsuranceYesNo" label="yes" value="true" checked="${person.otherHeathBoolean eq true}"/>
						<aui:input type="radio" name="vcgAn_otherHealthInsuranceYesNo" id="vcgAn_otherHealthInsuranceYesNo" label="no" value="false" checked="${person.otherHeathBoolean eq false}"/>
				</aui:field-wrapper>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass['otherHealthInsurance']} otherHealthBox"  >
					<aui:input label="" name="vcgAn_otherHealthInsurance" id="vcgAn_otherHealthInsurance" type="text" size="25" value="${person.otherHealthInsurance}" />
				</aui:field-wrapper>
		</c:when>
		<c:otherwise>
			<br/><br/><br/><br/><br/>
		</c:otherwise>
	</c:choose>

	<div class="clabel" >
		<liferay-ui:message key="certify-age" />
		<br/>
		<div style="font-weight:bold;font-size: 20px; ">And </div>
		<div class="my-shim"></div>
		* Check one: <br/>
		
		<aui:field-wrapper inlineField="true" first="false" last="false" cssClass="manage-layout certifyCheck ${cssClass['relationshipToVeteran']} "  >
			<label for="<portlet:namespace/>relationshipToVeteran1Checkbox">
			 <aui:input name="certifyFamily" label="" id="relationshipToVeteran" type="checkbox" cssClass="agreement-checkbox" value="${person.isFamily()}" />
			<liferay-ui:message key="caregiver-certify-as-family" />
			</label>
		</aui:field-wrapper>
		<div style="font-weight:bold; margin-left:20px;">Or </div>
		
		<aui:field-wrapper inlineField="true" first="false" last="false" cssClass="manage-layout ${cssClass['relationshipToVeteran']} certifyCheck"  >	
			<label for="<portlet:namespace/>relationshipToVeteran2Checkbox">
			<aui:input name="certifyNotFamily" label="" id="relationshipToVeteran" type="checkbox" cssClass="agreement-checkbox" value="${person.isNotFamily()}" />
			<liferay-ui:message key="caregiver-certify-not-as-family" />
			</label>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" first="false" last="false" cssClass="manage-layout certifyCheck"  >	
			<liferay-ui:message key="cg-agree-services-to-veteran" arguments="${form_['careGiverCategory']}"/>
		</aui:field-wrapper>
		
	</div>
	
	<div style="font-size: 20px; font-weight: bold; margin-top: 10px; margin-borrom:10px;">And </div>
	<div class="clabel" >
		<liferay-ui:message key="cg-perform-services-to-veteran" arguments="${form_['careGiverCategory']}"/>
	</div>

	
</div>


<aui:button-row cssClass="form-buttons">
	<button onClick="showTab('1')" class="btn btn-online previous-screen" id="<portlet:namespace />prevScreen" type="button">
		<i class="icon-cancel">&nbsp;<liferay-ui:message key="&lt;&nbsp;Previous Screen" /></i>
	</button>
	<button class="btn btn-online save-application" id="<portlet:namespace />saveApp" type="button">
		<i class="icon-online">&nbsp;<liferay-ui:message key="Save Progress and Exit" /></i>
	</button>
	<button class="btn btn-online cancel-application" id="<portlet:namespace />cancelApp" type="button">
	<i class="icon-online">&nbsp;<liferay-ui:message key="Cancel" /></i>
	</button>
	<button onClick="showTab('3')" class="btn btn-online next-screen" id="<portlet:namespace />nextScreen" type="button">
	<i class="icon-online">&nbsp;<liferay-ui:message key="Next Screen&nbsp;&gt;" /></i>
	</button>
</aui:button-row>

