<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>


<c:set var="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['vcgId']}" />
<c:set var="groupId" value="${SEARCH_CONTAINER_RESULT_ROW.object['groupId']}" />
<c:set var="myGroup" value="${fn:contains(caretMap_['groupId'], groupId)}" />
	
	<liferay-ui:icon-menu>
		<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['viewMember']}">
			<portlet:actionURL var="loadEntry">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="loadEntry"/>
				<portlet:param name="entry" value="MANAGE_VCG"/>
				<portlet:param name="vcgId" value="${vcgId}"/>
			</portlet:actionURL>
			<liferay-ui:icon image="edit" message="manage-vcg" url="${loadEntry}" />
		</c:if>

		<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.model.Vcg", 1, "UPDATE_ACTIVE_VCG_FACILITY") }' >
			<c:choose>
				<c:when test="${myGroup}" >
					<c:choose>
						<c:when test="${SEARCH_CONTAINER_RESULT_ROW.object['transferId'] gt 0}">
							<portlet:actionURL var="transferCancel">
							<portlet:param name="javax.portlet.action" value="doAction" />
							<portlet:param name="action" value="transferCancel"/>
							<portlet:param name="context" value="dashboard"/>
							<portlet:param name="vcgId" value="${vcgId}"/>
							</portlet:actionURL>
							<liferay-ui:icon image="post" message="cancel-transfer" url="${transferCancel}"  />
						</c:when>
						<c:otherwise>
							<liferay-ui:icon image="post" message="transfer-to-another-facility" url="javascript:transferAnother(${vcgId},'${caretMap_['context']}');"  />
						</c:otherwise>
					</c:choose>
				</c:when>
				<c:otherwise>
					<portlet:actionURL var="transferToMine">
						<portlet:param name="javax.portlet.action" value="doAction" />
						<portlet:param name="action" value="transferToMine"/>
						<portlet:param name="context" value="dashboard"/>
						<portlet:param name="vcgId" value="${vcgId}"/>
						<portlet:param name="TRACKER" value="${TRACKER}"/>
					</portlet:actionURL>
					<liferay-ui:icon image="post" message="transfer-to-my-facility" url="javascript:transferMineGroup(${vcgId},'dashboard');"  />
				</c:otherwise>
			</c:choose>
		</c:if>
	</liferay-ui:icon-menu>
	
		