<%@ include file="/jsp/init.jsp" %>


<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="queueName" value="${SEARCH_CONTAINER_RESULT_ROW.object['queueName']}" />

<liferay-ui:icon-menu>


	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['docLoaded']}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="classPk" value="${SEARCH_CONTAINER_RESULT_ROW.object['classPk']}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${SEARCH_CONTAINER_RESULT_ROW.object['worImId']});" />
	<c:if test="${fn:endsWith(SEARCH_CONTAINER_RESULT_ROW.object['type'], '_APP')}">
		<c:if test='${not permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.controller.dashboard.config.Dashboard", 1, "VIEW_FUNCTION") }' >
			<liferay-ui:icon image="add" message="new-note" url="javascript:newWorkNote(${SEARCH_CONTAINER_RESULT_ROW.object['worImId']}, 'manageVcg');" />
		</c:if>
	</c:if>
	
<c:choose>	
	<c:when test='${! empty queueName and queueName ne \"CORRECTION_Q\"}' >
		<c:set var="queuePerm" value="CBOPC_${SEARCH_CONTAINER_RESULT_ROW.object['queueName']}" />
    	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.view.GenericReport", 1, queuePerm) }' >
			<liferay-ui:icon image="reply" message="review-work"  url="javascript:manageOccWork(${SEARCH_CONTAINER_RESULT_ROW.object['worImId']}, \"${SEARCH_CONTAINER_RESULT_ROW.object['type']}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['personName']}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['caregiverName']}\");"  />
		</c:if>
	</c:when>
	<c:when test='{permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.controller.dashboard.config.Dashboard", 1, "CBOPC_FUNCTION") }' >
		<c:if test='${! empty queueName and queueName eq "CORRECTION_Q" and !empty form_["queueIds"] and fn:indexOf(form_["queueIds"], SEARCH_CONTAINER_RESULT_ROW.object["queueId"]) <> -1 }' >
			<liferay-ui:icon image="reply" message="review-work"  url="javascript:manageOccWork(${SEARCH_CONTAINER_RESULT_ROW.object['worImId']}, \"${SEARCH_CONTAINER_RESULT_ROW.object['type']}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['personName']}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['caregiverName']}\", \"manageVcg\");"  />
		</c:if>
	</c:when>	
</c:choose>

</liferay-ui:icon-menu>


<c:if test='${! empty queueName }' >
  <c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.view.GenericReport", 1, queuePerm ) }' >

<aui:script use="aui-io-request,aui-parse-content,aui-modal">

	window.manageOccWork = function( worImId, type, veteran, caregiver ) {
				    	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadOccWork" /><portlet:param name="page" value="manageOccWork"/><portlet:param name="strip" value="0"/><portlet:param name="fromParameter" value="true" /></portlet:resourceURL>', 'html', 
									{ 
				    	  				classPk: worImId,
				    	  				MODE: 3
									},
									function( data ){
										overwrite( A.one( '#review_work_entry' ), data );
										overwrite( A.one( '#work_header' ), (type + " (" + worImId + ") <p class='highlight-info'><i style='font-weight: bold;'> Veteran:</i>" + veteran + "</p><i style='font-weight: bold;'> Primary CG:</i>" + caregiver) );
										modalOccWork.render();
							        	modalOccWork.show();
							        	window.enforceFormats();
									} 
							);
				    };
	
	var modalOccWork = new A.Modal({
				headerContent: A.one("#work_header"),
		        bodyContent: A.one("#review_work_entry"),
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalUpdateWk',
		        visible: false,
				xy: [225, document.body.parentElement.scrollTop+25],
		        zIndex: 1100,
		        width: 920		        
		    });

</aui:script>

		<portlet:actionURL var="reviewMyWork">
			<portlet:param name="javax.portlet.action" value="doAction"/>
			<portlet:param name="action" value="reviewMyWork"/>
		</portlet:actionURL>
	<aui:form name="reviewMyWork_fm" method="post"  action="${reviewMyWork}"  >
				
    	<div id="modalUpdateWk">
    	</div>
    </aui:form>
	<div id="review_work_entry">
	</div>
	<div id="work_header" >
	</div>
	
  </c:if>	
</c:if>	
