<%@ include file="/jsp/init.jsp" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['workType']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['worImId']}" />
<c:set var="callId" value="${SEARCH_CONTAINER_RESULT_ROW.object['classPk']}" />
<c:set var="docLoaded" value="${SEARCH_CONTAINER_RESULT_ROW.object['docLoaded']}" />
<c:set var="complete" value="${SEARCH_CONTAINER_RESULT_ROW.object['complete'] }" />
<c:set var="mine" value="${SEARCH_CONTAINER_RESULT_ROW.object['userId'] eq user.userId}" />
<c:set var="ownerId" value="${SEARCH_CONTAINER_RESULT_ROW.object['userId'] eq 0 }" />
<c:set var="workItem" value="${SEARCH_CONTAINER_RESULT_ROW.object['this'] }" />


<portlet:actionURL var="openReferral">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="openReferral" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="callId" value="${callId}"/>
	<portlet:param name="type" value="${type}"/>
	<portlet:param name="onPageComplete" value="VCG_MANAGEMENT_PAGE" />
</portlet:actionURL>


<liferay-ui:icon-menu>
	<liferay-ui:icon image="preview" message="view-referral" cssClass="nav-away" url="${openReferral}" />
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${worImId});" />
	
<c:if test="${!complete && workItem.canAssign(resourceRequest) }" >
<c:if test="${!mine}" >
  <portlet:actionURL var="takeOwnership">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
	<portlet:param name="context" value="${caretMap_['context']}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="edit" message="take-ownership" url="javascript: window.escapePrevent(); window.location.assign('${takeOwnership}');"  />
</c:if>
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId});" />
<c:if test="${!ownerId}" >
  <portlet:actionURL var="unassignTo">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="unassignTo"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="context" value="${caretMap_['context']}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="unassign_user" message="unassign-ownership" url="javascript: window.escapePrevent(); window.location.assign('${unassignTo}');" />
</c:if>
</c:if>
	
	<c:if test="${docLoaded}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="classPk" value="${callId}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	
	<c:if test="${workItem.canTransfer(permissionChecker,scopeGroupId)}" >
		<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId});"  />
	</c:if>
	
	<c:if test='${not permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.controller.dashboard.config.Dashboard", 1, "VIEW_FUNCTION") }' >
		<liferay-ui:icon image="add" message="new-note" url="javascript:newWorkNote(${worImId});" />
	</c:if>
	
</liferay-ui:icon-menu>

