<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="workSupport" value="<%=gov.va.caret.model.support.WorkItemSupport.DEFAULT_WORKITEM%>" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="primaryKey" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx10']}" />

<c:set var="myGroup" value="${fn:contains(caretMap_['groupId'], SEARCH_CONTAINER_RESULT_ROW.object['ndx16'])}" />
<c:set var="targetGroup" value="${fn:contains(caretMap_['groupId'], SEARCH_CONTAINER_RESULT_ROW.object['ndx14'])}" />

<portlet:actionURL var="openReferral">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="openReferral" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="callId" value="${primaryKey}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>

<portlet:actionURL var="transferCancel">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="transferCancel" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="TRACKER" value="${TRACKER}"/>
</portlet:actionURL>

<liferay-ui:icon-menu>
	<c:if test="${workSupport.getCancelTransfer(resourceRequest, type, SEARCH_CONTAINER_RESULT_ROW.object['ndx14'], SEARCH_CONTAINER_RESULT_ROW.object['ndx16'])}" >
		<liferay-ui:icon image="view_locations" message="transfer-cancel"  url="${transferCancel}"  />
	</c:if> 
	<c:if test="${workSupport.getAcceptTransfer(resourceRequest, type, SEARCH_CONTAINER_RESULT_ROW.object['ndx14'], SEARCH_CONTAINER_RESULT_ROW.object['ndx16'] )}">
		<liferay-ui:icon image="reply" message="transfer-accept-reject" url="javascript:transferDo(${worImId}, '${caretMap_['context']}', '${TRACKER}' );"  />
	</c:if>
	
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${worImId});" />
	<c:if test="${fn:contains(type, 'REFERRAL')}">
			<liferay-ui:icon image="preview" message="view-referral" url="${openReferral}" />
	</c:if>
	<c:if test="${fn:endsWith(type, '_APP')}">
			<liferay-ui:icon image="add" message="new-note" url="javascript:newWorkNote(${worImId}, '${caretMap_['context']}');" />
		</c:if>
	
	<c:set var="documId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx12']}" />
	<c:if test="${documId gt 0}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="documId" value="${documId}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
</liferay-ui:icon-menu>



