<%@ include file="/jsp/init.jsp" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="status" value="${SEARCH_CONTAINER_RESULT_ROW.object['status']}" />
<c:set var="isBlocked" value="${fn:contains(status, 'BLOCKED-')}" />
<c:set var="isRejected" value="${fn:contains(SEARCH_CONTAINER_RESULT_ROW.object['reason'], 'PAYMENT_REJECTED')}" />
<c:set var="isSuccess" value="${fn:contains(SEARCH_CONTAINER_RESULT_ROW.object['reason'], 'successful')}" />

<c:set var="paymentLogId" value="${SEARCH_CONTAINER_RESULT_ROW.object['paymentLogId']}" />
<c:set var="vendorName" value="${SEARCH_CONTAINER_RESULT_ROW.object['vendorName']}" />


<liferay-ui:icon-menu>
		
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${paymentLogId});" />
	
	
	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.view.GenericReport", 1, "CBOPC_CONSIDER_Q") and (!isBlocked) and (isSuccess) }' >
			<liferay-ui:icon image="reply" message="lost-check"  url="javascript:vendorOccCreate(${paymentLogId}, \"Lost Check\", \"${vendorName}\");"  />
			<liferay-ui:icon image="reply" message="returned-payment"  url="javascript:vendorOccCreate(${paymentLogId}, \"Returned Payment\", \"${vendorName}\");"  />
			<!-- 
			<liferay-ui:icon image="reply" message="recoup-payment"  url="javascript:vendorOccCreate(${paymentLogId}, \"Recoup Payment\", \"${vendorName}\");"  />
			 -->
			
			<c:if test='${ ("one-time" eq SEARCH_CONTAINER_RESULT_ROW.object["stipendConfig"].stipendType) }' >
				<liferay-ui:icon image="close" message="recoup-manual-payment"  url="javascript:vendorOccCreate2(${SEARCH_CONTAINER_RESULT_ROW.object['vendrId']}, \"Recoup Payment\", \"${vendorName}\" );"  />
			</c:if>
			
	</c:if>	
				
	<c:if test='${permissionChecker.hasPermission( scopeGroupId, "gov.va.caret.actions.OCC", 1, "MANUAL_PAYMENT") and isRejected }' >
		<liferay-ui:icon image="add_article" message="manual-payment"  url="javascript:vendorOccCreate3(${paymentLogId}, \"New Manual Payment\", \"${vendorName}\");"  />
	</c:if>
				

	<portlet:resourceURL var="getDocum">
		<portlet:param name="action" value="getDocum"/>
		<portlet:param name="classPk" value="${SEARCH_CONTAINER_RESULT_ROW.object['vcgAnId']}"/>
	</portlet:resourceURL>
	<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	
</liferay-ui:icon-menu>

