
<%@ include file="/jsp/init.jsp" %>
      			
<%@ page import="gov.va.caret.model.support.PaymentLog" %>


<div class="rp_reportDiv">

<c:set var="isStaging" value="${true eq staging_ && total_['paymentConfig'] gt 0}" />

<c:choose>
	
  <c:when test="${isStaging}">
	
	<div class="my-shim"></div>
	<div class="my-shim"></div>
		Choose which Payment Definition should be Staged for Payment today.
		<ul>
			<li>Checkbox Selection of Payment Definitions will Stage them onto the OCC FM Daily list.</li>
			<li>Verified Manual Payment Definitions not Staged with the Daily will be processed with the OCC FM Weekly Payment list.</li>
		</ul>
	<portlet:actionURL var="saveEntry">
		<portlet:param name="javax.portlet.action" value="doAction"/>
		<portlet:param name="action" value="stagePayments"/>
		<portlet:param name="workType" value="paymentConfig"/>
	</portlet:actionURL>
	<aui:form name="rp_saveEntry" method="post" action="${saveEntry}"  >
		<input type="hidden" value="${TRACKER}" name="TRACKER" />
		<aui:input name="paymentConfig_rowCheckerIds" id="paymentConfig_rowCheckerIds" type="hidden" value="" />
		<a class="btn" id='<portlet:namespace/>submitStagedBulk' >Submit</a>
	</aui:form>
  </c:when>
  <c:otherwise>

		
  </c:otherwise>
</c:choose>


<liferay-ui:search-container  iteratorURL="${iteratorURL_['paymentConfig']}" total="${total_['paymentConfig']}"
	id="${randomStr}paymentConfig" delta="${delta_['paymentConfig']}" rowChecker="${isStaging ? rowChecker_['paymentConfig']: null}" orderByType="${orderByType_['paymentConfig']}" 
	orderByCol="${orderByColumn_['paymentConfig']}" emptyResultsMessage="no-cbopc-paymentConfig-found" >
	<liferay-ui:search-container-results
		results="${results_['paymentConfig']}" />
		


	<liferay-ui:search-container-row className="gov.va.caret.model.support.occ.StipendConfig" modelVar="paymentConfig" keyProperty="stiPtId">
	
		<liferay-ui:search-container-column-text name="Payment Definition #" property="stiPtId" />
		<liferay-ui:search-container-column-text name="Vendor Name" property="vendorName" /><!--  -->
		<liferay-ui:search-container-column-text name="Veteran Name" property="veteranName" /><!--  -->
		<liferay-ui:search-container-column-text name="Type" property="paymentTypeStr" translate="true" />
		<liferay-ui:search-container-column-text name="Verified By" property="verifierName" />
		<liferay-ui:search-container-column-text name="Status" value="${isStaging? paymentConfig['paymentStatusStage']: paymentConfig['paymentStatusStr']}" />
		<liferay-ui:search-container-column-text name="Start Date" property="stipendStartDateStr"  />
		<liferay-ui:search-container-column-text name="Initial Payment" translate="true" property="payslipDateStr"  />
		<fmt:formatNumber var="oneTimePayment" value="${paymentConfig['oneTimePayment']}" type="currency" />
		<liferay-ui:search-container-column-text name="Initial Amount" value="${oneTimePayment}"  />
		<fmt:formatNumber var="recurringPayment" value="${(paymentConfig['stipendType'] eq 'recurring')? paymentConfig['payment']: paymentConfig['payment']}" type="currency" />
		<liferay-ui:search-container-column-text name="Recurring Amount" value="${recurringPayment}" />

		<liferay-ui:search-container-column-jsp path="/jsp/internal/paymentsConfigActions.jsp"></liferay-ui:search-container-column-jsp>
		

	</liferay-ui:search-container-row>

	<liferay-ui:search-iterator />
</liferay-ui:search-container>

</div>

<c:if test="${isStaging}">
<aui:script use="aui-base" >
	A.one('#<portlet:namespace/>submitStagedBulk').on('click', function(){
	
		var buffer = [];
		var form = A.one("document.<portlet:namespace/>rp_saveEntry");
		if ( form ){
			var selector = '.rp_reportDiv input[type=checkbox]';
			form.all(selector).each(
				function( item, index, collection){
					var val = item.val();
					if ( val && item.get('name') != "allRowIds" && item.get('checked')  ){
						buffer.push(val);
					}
				}
			);
		}
		A.one('#<portlet:namespace/>paymentConfig_rowCheckerIds').val ( buffer.join() );
		document.forms['<portlet:namespace/>rp_saveEntry'].submit();
	
	} );
	
	A.one('#<portlet:namespace/>paymentConfig_col-rowChecker').on('click', function(){
		console.log('select all items and show button');
	});

</aui:script>
</c:if>
    

