
<%@ include file="/jsp/init.jsp" %>	

<c:set var="form_" value="${caretMap_['form_']}" />

<c:set var="payLog" value="${form_['payLog']}" /> 
<c:set var="workItem" value="${form_['workItem']}" /> 
<c:set var="calcInfo" value="${workItem.calcInfo}" />
<c:set var="veteran" value="${workItem.veteran}" /> 
<c:set var="vcgSupport" value="${workItem.vcgSupport}" /> 
<c:set var="caregiver" value="${workItem.caregiver}" /> 
<c:set var="stipendPaymentConfig" value="${calcInfo.stipendPaymentConfig}" /> 



<style>

.itemized-fract{
	font-size:1.5em;
}
</style>

<div id="${randomString}workTab">
  <ul class="nav nav-tabs">
	<li class="tab-click" ><a href="#tab-a1${randomString}"><div class="icon-bullhorn"></div> Create ${form_['workType']} </a></li>
    <li class="tab-click" ><a href="#tab-a2${randomString}"><div class="icon-user"></div> Additional Information </a></li>
     <li class="tab-click" ><a href="#tab-a3${randomString}"><div class="icon-credit"></div> Calculation Information </a></li>
  </ul>

  <div class="tab-content">
    
	
	
	<div id="tab-a1${randomString}" class="tab-pane">
	  	
	  	<div id="reviewOccWork2">
			<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
			<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
			<div class='portlet-msg-info' style="width:80%; margin-bottom:8px;" >(TBD) Top things to Highlight here....
				<div class="ten-ten-links" >
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="classPk" value="${workItem.classPk}"/>
					</portlet:resourceURL>
			  		<a href="${getDocum}" tabindex="0"  target="_blank" class="tab-click btn icon-file stipend-row float-right" title='<liferay-ui:message key="pdf-10-10cg" />' >&nbsp;<liferay-ui:message key="pdf-10-10cg-review-message" /></a>
		  		</div>
		  	
		  
		  <ul>
			<fmt:formatDate value="${stipendPaymentConfig.stipendStartDate}" var="stipendStartDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${stipendPaymentConfig.payslipDate}" var="payslipDate" type="date" pattern="MM/dd/yyyy"/>
		
			
		
		<c:if test="${! empty payLog}">
			<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
			<li> Timeframe of stipend payment: ${payLog.beginDateStr} to ${payLog.endDateStr} </li>
		
			<li> Check Submit Date: ${paymentDate}</li>
			
		</c:if>
			
					<li><liferay-ui:message key='cg-vendor' /> Name: ${caregiver.lastName}, ${caregiver.firstName} ${caregiver.middleName} &nbsp;</li>
					<li>SSN: ${caregiver.ssn} </li>
					<li> Recurring Payment Status: <liferay-ui:message key='${stipendPaymentConfig.stipendStatus}' /> </li>
			<c:if test="${! empty payLog}">
				<span class="icon-hand-right" title="FMS Payment Response: <liferay-ui:message key='${payLog.reason}' />" >&nbsp;</span>Stop Payment in FMS for <fmt:formatNumber value="${payLog.amount}" type="currency"/> &nbsp;
			</c:if>
					
				</ul>
			</div><!-- end Top things to Highlight here... -->
			
			<div class="clear-both" id="createVndrWk">
				<input type="hidden" name="<portlet:namespace/>worImId" id="<portlet:namespace/>worImId17" value="${workItem.worImId}">
				
				<input type="hidden" name="paymentLogId" value="${payLog.paymentLogId}" />
				<input type="hidden" value="${TRACKER}" name="TRACKER" />
				
				<c:choose>
					<c:when test="${form_['MODE'] eq \"Lost Check\" || form_['MODE'] eq \"Returned/Rejected Payment\" }">
						<input type="hidden" name="type" value="${form_['MODE']}" />
						<input type="hidden" name="cycleId" value="${payLog.cycleId}" />
						
						<div class="manage-layout float-left">
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:125px;" label="pay-period" name="config_cycle_month" id="config_cycle_month" disabled="${form_['disableDates']}"	>
									<aui:option value="" label="Please Select" selected="true" />
									<c:forEach var="month" items="${form_['MONTHS']}" varStatus="varStat" >
										<c:if test="${! empty month}" >
											<aui:option value="0${varStat.index}" label="${month}" selected="${month eq form_['MONTH']}" />
										</c:if>
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:80px;" label="" name="config_cycle_year" id="config_cycle_year" disabled="${form_['disableDates']}" >
									<c:forEach var="year" items="${form_['YEARS']}">
										<aui:option value="${year}" label="${year}" selected="${year eq form_['YEAR']}"  />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
						</div>
						<!-- 
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input float-left" data="${form_['restrictionDateData']}" >
							<aui:input label="${form_['MODE']} Event Date" name="checkDate" id="checkDate" cssClass="date-field not-future after-status-date" type="text" size="25" value=""  />
						</aui:field-wrapper>
						-->
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<fmt:formatNumber value="${payLog.amount}" var="amount" type="currency"/>
							<aui:input label="Amount" name="checkAmount" class='money-field' id="${randomString}dollarAmount" type="text" size="25" value="${amount}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
						
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<aui:input label="Reference Number" name="checkNumber" id="${randomString}checkNumber" type="text" size="25" value="${payLog.paymentNumber}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
						
					</c:when>
					
					<c:otherwise>
						<input type="hidden" name="type" value="${form_['MODE']}" />
						<div class="manage-layout float-left">
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:125px;" label="pay-period" name="config_cycle_month" id="config_cycle_month" disabled="${form_['disableDates']}"	>
									<aui:option value="" label="Please Select" selected="true" />
									<c:forEach var="month" items="${form_['MONTHS']}" varStatus="varStat" >
										<c:if test="${! empty month}" >
											<aui:option value="0${varStat.index}" label="${month}" selected="${month eq form_['MONTH']}" />
										</c:if>
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
							<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="required-input float-left">
								<aui:select style="width:80px;" label="" name="config_cycle_year" id="config_cycle_year" disabled="${form_['disableDates']}" >
									<c:forEach var="year" items="${form_['YEARS']}">
										<aui:option value="${year}" label="${year}" selected="${year eq form_['YEAR']}"  />
									</c:forEach>
								</aui:select>
							</aui:field-wrapper>
						</div>
						<!-- 
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input float-left" data="${form_['restrictionDateData']}" >
							<aui:input label="${form_['MODE']} Event Date" name="checkDate" id="checkDate" cssClass="date-field not-future after-status-date" type="text" size="25" value=""  />
						</aui:field-wrapper>
						 -->
						
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<fmt:formatNumber value="${payLog.amount}" var="amount" type="currency"/>
							<aui:input label="Amount" name="checkAmount" class='money-field' id="${randomString}dollarAmount" type="text" size="25" value="${amount}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
					
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
							<aui:input label="Reference Number" name="checkNumber" id="${randomString}checkNumber" type="text" size="25" value="${payLog.paymentNumber}" disabled="${form_['disableDates']}" />
						</aui:field-wrapper>
						
					</c:otherwise>
					
				</c:choose>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
					<aui:input label="Reason/Comments" name="worIm_comments" size="50" type="textarea"  />
				</aui:field-wrapper>

				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
					<a class="btn btn-primary" style="float:right; margin-left:30px; margin-bottom:-10px" href="javascript:submitWorkItem();" >&nbsp;<liferay-ui:message key="new-work-item" /></a>      			
				</aui:field-wrapper>

				<div id="validationResult" ></div>

			</div>		
		</div>
	</div>
	  	
	<div id="tab-a2${randomString}" class="tab-pane">

		<div style="padding:2px;" id="${randomString}itemization0" tabindex="0" class="header toggler-header-collapsed" >
		
			<div class="work-section" >
				<div class="center-position">
					<div class="care-giver-name" id="update_veteran">
						<div class="selected-vcg">
					    		<div class="selected-info">
					    	 		<div class="selected-vcg-row">
					    	 			<div class="srow-label">
					    	 			Veteran Name:</div>${veteran.lastName}, ${veteran.firstName}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">Facility:</div>${veteran.facilityName} 
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">SSN:</div>${veteran.ssn}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<fmt:formatDate value="${veteran.birthDate}" var="vbday" type="date" pattern="MM/dd/yyyy"/>
					    	 			<div class="lrow-label">DOB:</div>${vbday}
					    			</div>
					    			<div class="selected-vcg-row">
					    	 			<div class="lrow-label">Application Id:</div>${workItem.applicationId}
					    			</div>
					    			<div class="selected-vcg-row">
					    				<div class="srow-label">Insurance at time of Payment:</div>${form_['insurance']}
					    			</div>
					    			
					    		</div>
					    	</div>
						</div>
					</div>
				</div>
				<div class="work-section" id="viewVendor" >	
					<%@include file="/jsp/internal/viewVendor.jsp" %>    	
				</div>
			</div>
		</div>
	
	
		<div id="tab-a3${randomString}" class="tab-pane">
	    	<div class="work-section manage-layout" >
				<div class="center-position">
					<div id="tier-info">
						<div class="selected-vcg">
				    		<div class="selected-info">
				    			<fmt:formatDate value="${vcgSupport.tierEffectiveDate}" var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy"/>
				    		 
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Tier Level:</div><liferay-ui:message key="tier-level-${vcgSupport.tierLevel}" />
				    			</div>
			    				
				    			<c:choose>
						    		  <c:when test="${! empty payLog}">
						    		  	<div class="selected-vcg-row">
						    				<div class="srow-label">Payment Date Range:</div>${payLog.beginDateStr} to ${payLog.endDateStr}
						    			</div>
						    		  	
						    			<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
						    			<div class="selected-vcg-row">
						    				<div class="srow-label">Check Submit Date:</div>${paymentDate}
						    			</div>
						    			<div class="my-shim"></div>
						    			<div class="selected-vcg-row">
						    				<div class="srow-label">FMS Payment Response:</div> <liferay-ui:message key='${payLog.reason}' />
						    			</div>
						    		  </c:when>
						    		  <c:otherwise>
						    		  	<div class="my-shim"></div>
						    			<div class="selected-vcg-row">
						    				<div class="srow-label">Stipend Start Date:</div>${stipendStartDate}
						    			</div>
						    			<div class="selected-vcg-row">
						    				<div class="srow-label">Initial Payment Date:</div>${payslipDate}
						    			</div>
						    		  </c:otherwise>
				    			</c:choose>
				    		</div>
				    	</div>
					</div>	
				</div>
			</div>
			<div class="work-section" >	
				<div class="center-position">
					<div class="rate-info" id="update_primary">
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
					    	 		<div class="srow-label">Zip:</div>${caregiver.zip} &nbsp;
					    	 	</div>
								
								<%@include file="/jsp/internal/autoRecurring.jsp" %>	
								
		
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">Total Payment Amount:</div><fmt:formatNumber value="${payLog.amount}" type="currency"/> &nbsp;
					    			</div>
					    	</div>
				    	</div>
					</div>
				</div>
			</div>
		</div>
			
  	</div><!-- end tab-context -->
</div><!-- workTab -->

	
<aui:script use="aui-tabview,node-event-simulate,aui-tooltip">


   new A.TabView({
      srcNode: '#${randomString}workTab',
      type: 'pills'
    }
  ).render();

	window.submitWorkItem = function (){
		validateFields( function ( message ) {
	   		var validationNotice = A.one ('#validationResult');
	   		if ( message.length > 0 ){
  				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
  				validationNotice.html(msg);
  				validationNotice.scrollIntoView();
	    		return false;	
	   		}
			overwrite( A.one( "#modalVndrWk" ), A.one("#createVndrWk") );
			A.one("#<portlet:namespace/>createVndrWk_fm").submit();
		                 		    	}, '#createVndrWk');
	}
	
	
		
	
	new A.TooltipDelegate( { trigger: '.has-tooltip' } );
	
	A.one('#<portlet:namespace />${randomString}checkNumber').on('change', window.numberFormat);
	A.one('#<portlet:namespace />${randomString}dollarAmount').on('change', window.dollarFormat);
	enforceFormats();
	console.log("ok");
	
</aui:script>

		