<%@ include file="/jsp/init.jsp" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>


<c:set var="callState" value="${SEARCH_CONTAINER_RESULT_ROW.object['callState']}" />
<c:set var="isComplete" value="${fn:containsIgnoreCase(callState, 'complete')? 'view' : 'edit' }" />

<c:set var="lastName" value="${SEARCH_CONTAINER_RESULT_ROW.object['veteranLastName']}" />

<c:set var="callType" value="${SEARCH_CONTAINER_RESULT_ROW.object['callType']}" />
<c:set var="entry" value="${fn:contains(callType, 'Referral')? 'CREATE_REFERRAL' : 'CREATE_CALLS' }" />


<liferay-ui:icon-menu>
		<portlet:actionURL var="editEntry">
			<portlet:param name="javax.portlet.action" value="doAction"/>
			<portlet:param name="action" value="loadEntry"/>
			<portlet:param name="entry" value="${entry}"/>
			<portlet:param name="callId" value="${SEARCH_CONTAINER_RESULT_ROW.object['callId']}"/>
		</portlet:actionURL>
		<liferay-ui:icon image="${isComplete}" message="${isComplete}" url="${editEntry}" />
		
		
		<liferay-ui:icon image="group" message="search-vcg" url="javascript:searchVcgCall('${lastName}');" />

	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['docLoaded']}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="classPk" value="${SEARCH_CONTAINER_RESULT_ROW.object['callId']}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	
</liferay-ui:icon-menu>

