
<%@ include file="/jsp/init.jsp" %>	
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

		<c:set var="form_" value="${caretMap_['form_']}" />
		<c:set var="person" value="${form_['person']}" />
		<c:set var="vcg" value="${form_['vcg']}" />
		<c:set var="disabled" value="${form_['disabled']}" />
		<c:set var="dispositionDate" value="${form_['dispositionDate']}" />
		<c:set var="appReceivedDate" value="${form_['appReceivedDate']}" />
		<c:set var="role">${person.role}</c:set>
		<c:set var="dispositionReason" value="${form_['dispositionReason']}"></c:set>
		
		
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<input type="hidden" name="vcg_ndx" value="${ndx}" >
	
	
		<input id="<portlet:namespace/>${TRACKER}_primaryKey" type="hidden" value="${person.primaryKey}" name="<portlet:namespace/>${ndx}_primaryKey">
		
		<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
		<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
		<div class='portlet-msg-info' style="width:65%"]><liferay-ui:message key='baselines-for-caregiver' /> ${person.fullName}<ul>
		<c:if test="${!person.generalRole}" >
			<li> Application Received Date: ${appReceivedDate}</li>
		</c:if>
		<c:if test="${fn:startsWith(dispositionReason, 'revoked-')}" >
			<li> Revocation Date: ${form_['revocationDate']}</li>
			<li> Last Date you can perform Reinstatement on Caregiver: ${form_['reinstateEnd']}</li>
		</c:if>
		<c:if test="${person.generalRole and vcg.primaryApproved }" >
			<li> Primary Caregiver Approved <span class="icon-flag">&nbsp;</span></li>
		</c:if>
		<c:if test="${person.primaryRole and vcg.generalApproved }" >
			<li> General Caregiver Approved <span class="icon-flag">&nbsp;</span></li>
		</c:if>
			<c:if test="${!empty dispositionDate}">
				<li > Disposition Date: ${dispositionDate}</li>
			</c:if>
			<c:if test="${empty person.ssn}">
				<li > SSN Missing <span class="icon-flag">&nbsp;</span></li>
			</c:if>
			<c:choose>
				<c:when test="${person.validUspsAddress}">
					<li > Valid USPS Address <span class="icon-ok">&nbsp;</span></li>
				</c:when>
				<c:otherwise>
					<li > Invalid USPS Address <span class="icon-flag">&nbsp;</span></li>
				</c:otherwise>
			</c:choose>
			<c:if test="${!person.generalRole}" >
				<c:choose>
					<c:when test="${form_['assessmentComplete']}">
						<li > Assessments completed <span class="icon-ok">&nbsp;</span></li>
					</c:when>
					<c:otherwise>
						<li> Assessments not completed <span class="icon-flag">&nbsp;</span></li>
					</c:otherwise>
				</c:choose>
			</c:if>
			<c:if test="${form_['vacoWaiver'] && empty form_['appDelayApproval']}">
				<li > Requires VISN Application Delay Approval <span class="icon-flag">&nbsp; </span></li>
			</c:if>
			
			<li id="${TRACKER}termination" > No extended benefits, benefits terminate upon revocation <span class="icon-bell">&nbsp;</span></li>
			<li id="${TRACKER}benExtend" > Benefits extended <span id="${TRACKER}extendedDays"></span> days from revocation date <span class="icon-bullhorn">&nbsp;</span></li>
			
		</ul></div>
		
		
		<c:choose>
		   <c:when test="${form_['vacoWaiver'] && empty form_['appDelayApproval']}">
			<div class="waiver-section">
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
					<aui:select inlineField="true" label="waiver-reasons" name="${ndx}_waiverReason" id="${TRACKER}_waiverReason" >
						<aui:option value="" label="select-waiverReason-reason" />
						<c:forEach var="reason" items="${form_['waiverReasons']}">
							<aui:option value="${reason}" label="${reason}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
			 		<aui:input label="caret-waiver-note" name="${ndx}_waiverNote" size="35" type="textarea"  id="${TRACKER}_waiverNote" />
				</aui:field-wrapper>
			</div>
	<input type="hidden" name="MODE" value="4" >
		  </c:when>
		  <c:otherwise>
			
			
			
	<input type="hidden" name="MODE" value="1" >
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input" data="${form_['dispositionDateData']}" >
			<aui:input label="disposition-date" name="${ndx}_dispositionDate" cssClass="date-field not-max-date after-status-date" type="text" size="25" />
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
			<aui:select inlineField="true" disabled="${!empty disabled['dispositionChoice']}" label="disposition-choices" name="${ndx}_dispositionChoice" id="${TRACKER}_dispositionChoice" >
				<aui:option value="" label="select-disposition-choice" />
				<c:forEach var="reason" items="${form_['dispositionChoices']}">
					<aui:option value="${reason}" label="${reason}decision" selected="${reason eq form_['dispositionChoice']}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input"  >
			<aui:select inlineField="true" disabled="${!empty disabled['dispositionReason']}" label="disposition-reasons" name="${ndx}_dispositionReason" id="${TRACKER}_dispositionReason" >
				<aui:option value="" label="select-disposition-reason" />
				<c:forEach var="reason" items="${form_['dispositionReasons']}">
					<c:choose>
						<c:when test="${true eq reason.value}">
							<aui:option value="${reason.value}" label="${reason.key}" cssClass="section" disabled="true" />
						</c:when>
						<c:otherwise>
							<c:set var="reqComment" ><c:if test="${fn:contains(reason.value, '[*]')}" >require-comment</c:if></c:set>
							<aui:option value="${reason.value}" label="${reason.key}" cssClass="${reqComment}" />
						</c:otherwise>
					</c:choose>
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input" data="${form_['deceasedDateData']}" >
			<aui:input label="deceased-date" name="${ndx}_deceasedDate" id="${ndx}_deceasedDate" cssClass="date-field not-future after-status-date" type="text" size="25" />
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
			<c:set var="tier" value="tier${form_['tier']}" />
			<aui:select inlineField="true" disabled="${!empty disabled['tier']}" label="tier" name="${ndx}_tier" id="${TRACKER}_tier" >
				<aui:option value="" label="select-tier" />
				<c:forEach var="tierType" items="${form_['tierTypes']}" varStatus="loop" >
					<aui:option value="${loop.count}" label="${tierType}" selected="${tierType eq tier}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input" data="${form_['tierDateData']}" >
			<aui:input label="tier-effective-date" name="${ndx}_tierEffectiveDate" id="${TRACKER}_tierEffectiveDate" cssClass="date-field after-status-date" disabled="${!empty disabled['tierEffectiveDate']}"  type="text" size="25" value="${vcg.tierEffectiveDateStr}" />
		</aui:field-wrapper>
		
		<c:choose>
			<c:when test="${fn:startsWith(dispositionReason, 'disapproved-') }" >
				<c:set var="caretNote" >justification-note</c:set>
				<c:set var="DISAPPROVED" value="${true}" />
			</c:when>
			<c:otherwise>
				<c:set var="DISAPPROVED" value="${false}" />
				<c:set var="caretNote" >caret-note</c:set>
			</c:otherwise>
		</c:choose>
		
		
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
	 		<aui:input label="${caretNote}" name="${ndx}_note" size="35" type="textarea"  id="requiredNote" />
		</aui:field-wrapper>
		
		<c:if test="${form_['waiver']}">
			<div class="waiver-section">
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout required-input"  >
					<aui:select inlineField="true" label="waiver-reasons" name="${ndx}_waiverReason" id="${TRACKER}_waiverReason" >
						<aui:option value="" label="select-waiverReason-reason" />
						<c:forEach var="reason" items="${form_['waiverReasons']}">
							<aui:option value="${reason}" label="${reason}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input required-input"  >
			 		<aui:input label="caret-waiver-note" name="${ndx}_waiverNote" size="35" type="textarea"  id="${TRACKER}_waiverNote" />
				</aui:field-wrapper>
			</div>
		</c:if>
		
			</c:otherwise>
		</c:choose>

		<input type="hidden" id="csc-reminder" value='<liferay-ui:message key="disposition-change-occurred" />' ></input>
		
		<div id="_validationResult" ></div>
		
		
<aui:script use="aui-node" >

<c:if test="${not ( (true eq form_['vacoWaiver']) && empty form_['appDelayApproval']) }">

A.one('#<portlet:namespace/>${TRACKER}_dispositionChoice').on('change',
  	function(e) {
  		var selection = A.one('#<portlet:namespace/>${TRACKER}_dispositionChoice').val();
  		var dispReason = A.one('#<portlet:namespace/>${TRACKER}_dispositionReason').ancestor('.field-wrapper');
  		if ( selection == 'disapproved-' || selection == 'revoked-' ){
  			requireField( dispReason );
  		} else {
  			unrequireField( dispReason );
  		}
  	<c:if test="${ (role eq 'PRIMARY') and !DISAPPROVED }">	
  		var tierReason = A.one('#<portlet:namespace/>${TRACKER}_tier').ancestor('.field-wrapper');
  		if ( selection == 'disapproved-' || selection == 'revoked-' ){
  			unrequireField( tierReason );
  			unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
  		} else {
  			requireField( tierReason );
  			requireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
  		}
  	</c:if>
    }
);
</c:if>

<c:if test="${!empty dispositionDate}"><!-- they want note only... not UI smarts for "comment" -->
	A.one('#<portlet:namespace/>${TRACKER}_dispositionReason').on('change',
  		function( event ) {
		    	  	//var str = this._node.options[this._node.selectedIndex].getAttribute('class');
					//var requiredNote = A.one('#<portlet:namespace/>requiredNote').ancestor('.field-wrapper');
		    	  	//if ( str.indexOf('require-comment') > -1 ){ 		    	  		
					//	if ( !requiredNote.hasClass('required-input') ){
				  	//		requireField( requiredNote );
					//	}
					//} else {		    	  		
		    	  	//	if ( requiredNote.hasClass('required-input') ){
				  	//		unrequireField( requiredNote );
					//	}
					//}
					var selection = A.one(this._node.options[this._node.selectedIndex]).val();
					<c:if test="${!person.generalRole}">
					if ( selection.indexOf("[") > 0 ){
						if ( selection.indexOf("*") > 0 ){
							// console.log('show no days');
							A.one('#${TRACKER}benExtend').hide();
						} else {
							// console.log(selection.substring(selection.indexOf("[")+1, selection.indexOf("]")) );
							A.one('#${TRACKER}extendedDays').html( selection.substring(selection.indexOf("[")+1, selection.indexOf("]"))  );
							A.one('#${TRACKER}benExtend').show();
							A.one('#${TRACKER}termination').hide();
						}
					} else {
						A.one('#${TRACKER}termination').show();
						A.one('#${TRACKER}benExtend').hide();
					}
					</c:if>
					var requiredDeceasedDate = A.one('#<portlet:namespace/>${ndx}_deceasedDate').ancestor('.field-wrapper');
					if ( selection.indexOf ('deceased') > 0 ){
						requireField( requiredDeceasedDate );
					} else {
						unrequireField( requiredDeceasedDate );
					}
		     }
  	);
</c:if>

	var requireField = function( dispReason ){
		if (dispReason && !dispReason.hasClass('required-input') ){
             dispReason.addClass( 'required-input' );
        }
        dispReason.show();
        dispReason.attr('disabled', '');
	}
	
	var unrequireField = function( dispReason ){
		if (dispReason && dispReason.hasClass('required-input') ){
             dispReason.removeClass( 'required-input' );
        }
        dispReason.hide();
        dispReason.attr('disabled', 'true');
	}

<c:if test="${not ( (true eq form_['vacoWaiver']) && empty form_['appDelayApproval']) }">
	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_dispositionReason').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>${ndx}_deceasedDate').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tierEffectiveDate').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>${TRACKER}_tier').ancestor('.field-wrapper') );
</c:if>
	A.one('#${TRACKER}termination').hide();
	A.one('#${TRACKER}benExtend').hide();

</aui:script>




<div class="lfr-dynamic-uploader manage-layout">
				   <div class="lfr-upload-container fileUpload" id="<portlet:namespace />fileUpload">
				        &nbsp;
				    </div>
				<br/>
				</div>			
			
				<portlet:actionURL var="uploadFileURL1010cg">
					<portlet:param name="javax.portlet.action" value="doAction"/>
					<portlet:param name="action" value="uploadFile"/>
					<portlet:param name="type" value="1010cg"/>
				</portlet:actionURL>
				<aui:script  use="liferay-upload">
				
					var liferayUpload = new Liferay.Upload({
				         allowedFileTypes: "${form_['extensions']}",
				         container: '#<portlet:namespace />fileUpload',
				         maxFileSize: 0,
				         namespace:'<portlet:namespace />',
				         uploadFile: '${uploadFileURL1010cg}',        
				         tempFileRemoved: function(){},
				         'strings.dropFilesText': '<liferay-ui:message key="drag-and-drop-1010-file" />',
				         'strings.dropFileText': '<liferay-ui:message key="drag-and-drop-1010-file" />',
				         'strings.selectFileText': '<liferay-ui:message key="select-1010-file" />',
				         'strings.selectFilesText': '<liferay-ui:message key="select-1010-file" />',
				         'strings.fileCannotBeSavedText': 'File cannot be saved',
				         'strings.pendingFileText': 'Upload of file pending',
				         'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
				         multipleFiles: false
			
				     });
					 
				     A.on('domready', function( event ) {
					     	try {
					         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUpload");
					     	} catch (e){
					     		// console.log('appendTo... failed');
					     	}
					  });	
				     
				</aui:script>	
		