<%@ taglib uri="http://liferay.com/tld/ui" prefix="liferay-ui" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ include file="/jsp/init.jsp" %>	

<span id="startTimeDialog" name="startTimeDialog" style="visibility: hidden;">
      <div class="yui3-skin-sam">
          <div id="showStartTimeModal"></div>
      </div>
      

      <div id="showStartTimeDiv" class="yui3-skin-sam">
		<div id="showStartTimeTitle"></div>	  
		<div>
			<aui:field-wrapper inlineField="true" 
			                  inlineLabel="left" 
			                  first="false" 
			                  last="false" 
			                  cssClass="manage-layout ${cssClass['startTimeTimeWidget']}"  > 
			<aui:input disabled="${isDisabled}" 
			          label="start-date-time" 
			          name="startTimeTimeWidget" 
			          type="text" size="25" 
			          id="startTimeTimeWidget" 
			          value="${callStartDateTimestamp}" 
			          cssClass="date-time-field-full field-wrapper ${cssClass['startTimeTimeWidget']}" 
			          style="width: 160px;  "
			          />
			</aui:field-wrapper>
			
				<aui:field-wrapper 
					inlineField="true"
					inlineLabel="left"
					first="false" 
					last="false" 
					cssClass=""  >
					<aui:select 
						disabled="${isDisabled}" 
						label="time-zone" 
						id="startDateTimeZones"
						name="startDateTimeZones" >
						<aui:option value="" label="select-start-time-timezone" />
				        <c:set var="sessZone" value="${callStartDateZone}" />
						<c:forEach var="zone" items="${timeZones}" >	
							<c:set var="zoneParts" value="${fn:split(zone, '|')}" />
							<c:set var="iterZone" value="${zoneParts[1]}" />
							
							<aui:option value="${zoneParts[1]}" label="${zoneParts[0]}" selected="${sessZone eq iterZone}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>						
		</div>				

		<div class="clear-both">
			<span>
				<a href="javascript:" id="<portlet:namespace/>updateStartTimeJs" class="btn btn-primary" >
					<liferay-ui:message key="ok" />
				</a> 				
				<a href="javascript:" id="<portlet:namespace/>hideShowStartTimeJs"  class="btn btn-primary" >
					<liferay-ui:message key="cancel" />
				</a>  
			</span> 
		</div>
	</div>  	
</span>	
	
	
			<aui:field-wrapper inlineField="true" 
			                   inlineLabel="left" 
			                   first="false" 
			                   last="false" 
			                   cssClass="${cssClass['callCreationDate']} " >
				<div><aui:input 
							disabled="true" 
							label="call-start-date" 
							name="call_startDate" 
							cssClass="${cssClass['callCreationDate']}" 
							style="webkit-appearance: none; outline: none; border: 0; background-color: transparent; 
							width: 100px; "
							type="text"  
							id="call_startDate" 
							value="${callStartDateDisplay}" />
				</div>
			</aui:field-wrapper>
			<c:if test="${false eq isDisabledV }">
			<div style="left-margin: -20px;" class="clickShowSetStartTime icon-pencil " title='<liferay-ui:message key="edit-start-date" />'  >&nbsp;</div>	
			</c:if>
	
<aui:script use="aui-tooltip,aui-toggler,aui-tabview,aui-modal">
	
     var startTimeModal = new A.Modal({
          headerContent: '<h4><liferay-ui:message key="set-start-date" /></h4>',
          //headerContent: A.one("#showStartTimeTitle"),
          bodyContent: A.one("#showStartTimeDiv"),
          centered: true,
          destroyOnHide: false,
          modal: false,
          render: '#showStartTimeModal',
          resizable: {
            handles: 'b, r'
          },
          visible: false,
          width: 650
      });
      
    A.one('#<portlet:namespace/>hideShowStartTimeJs').on(
		'click',
		function ( e ){
		    if (startTimeModal) {
		    	startTimeModal.render();
				startTimeModal.hide();
			}
		}
    );  		
	
    A.one('#<portlet:namespace/>updateStartTimeJs').on(
		'click',
		function ( e ){
		    var inputValue=A.one("#<portlet:namespace />startTimeTimeWidget").get('value');
		    var inputValue2=A.one("#<portlet:namespace />startDateTimeZones").get('value');
		    var inputValue3=A.one('#<portlet:namespace/>callStartDateCallId').get("value");
			window.caretIo( 
				'<portlet:resourceURL><portlet:param name="action" value="setCallStartDate" /></portlet:resourceURL>', 
				'json', 
				{ inputText : inputValue, inputText2 : inputValue2, inputText3 : inputValue3 },
				function(data){
				    console.log("MHX response from setCallStartDate()................");
				    var v1 = data.callStartDateDisplay;
				    console.log("MHX response from setCallStartDate() v1: " + v1);
				    A.one("#<portlet:namespace />call_startDate").set('value', v1);
				    A.one("#<portlet:namespace />startTimeTimeWidget").set('value', data.callStartDateTimestamp);
				    A.one("#<portlet:namespace />startDateTimeZones").set('value', data.callStartDateZone);	
				    
				    A.one("#<portlet:namespace />callStartDateDisplay").set('value', data.callStartDateDisplay);
				    A.one("#<portlet:namespace />callStartDateTimestamp").set('value', data.callStartDateTimestamp);					    
				    A.one("#<portlet:namespace />callStartDateZone").set('value', data.callStartDateZone);		
				    				    		    
				    startTimeModal.hide();
				}
		    );
		}
    );	
     A.all('.clickShowSetStartTime').on(
		'click',
		function ( e ){
		    var e = document.getElementById('startTimeDialog');
		    if (e.style.visibility == 'hidden') {
		    	e.style.visibility = 'visible';
		    }
			startTimeModal.render();
			startTimeModal.show();
		}
    );   
	
</aui:script>		