<%@ include file="/jsp/init.jsp" %>

	<c:set var="ndx" value="secondaryPersn" />	
	<c:set var="searchCss" value="search-person-action icon-search" />
	<c:set var="cssClass" value="${form_['secondaryRequired']}" />
	
	<c:set var="isDisabled" value="${false}" />	
	<c:set var="caretCss" value="${cssClass}" /> 
	<%@include file="/jsp/internal/person.jsp" %>

	<c:set var="includeFacility" value="${false}" />
	<c:set var="isDisabled" value="${false}" />	
	<%@include file="/jsp/internal/editAddress.jsp" %>

	<br>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['phone']}"  >
		<aui:input label="phone1" cssClass="phone-field" id="${ndx}_phone"  name="${ndx}_phone" type="text" size="25" value="${person.phone}" />
	</aui:field-wrapper>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="phone2" cssClass="phone-field" id="${ndx}_phone2" name="${ndx}_phone2" type="text" size="25" value="${person.phone2}" />
	</aui:field-wrapper>
			
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="email" cssClass="email-field" name="${ndx}_email" id="${ndx}_email" max="75" type="text" size="25" value="${person.email}"  />
	</aui:field-wrapper>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['secondaryRelationship']}"   >
		<aui:select label="online-cg-relationship" name="vcgAn_secondaryRelationship" id="vcgAn_secondaryRelationship" >
			<aui:option label="select-relationship" value=""  selected="true"/>
			<aui:option label="family" cssClass="section" disabled="true" />
			<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
				<aui:option cssClass="family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryRelationship eq relationship}" />
			</c:forEach>
			<aui:option label="not-family" cssClass="section" disabled="true" />
			<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
				<aui:option cssClass="not-family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryRelationship eq relationship}" />
			</c:forEach>
		</aui:select>
	</aui:field-wrapper>


<aui:script use="aui-base">
	
	window.validateSecondaryFields = function( validateOtherCallback ){
		var submit = true;
		if(A.one('#<portlet:namespace/>${ndx}_primaryKey')!=null ){ 

			validateFields( function( message ){				
				
				if ( message.length > 0 ){
					modalDataValidation.render();
					modalDataValidation.show();
					
					var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields-secondary' /><ul>" + message +"</ul></div>";
					A.one ('#secondaryValidationResult').html(msg);
					submit = false;
				}else{
					A.one ('#secondaryValidationResult').html('');
				}				
				validateOtherCallback( submit );
			}, "secondary");
		}else{
			A.one ('#secondaryValidationResult').html('');
			validateOtherCallback( submit );			
		}
	}

	window.validateSecondaryAddress = function( validateOtherCallback ){
		var submit = true;

		if(A.one('#<portlet:namespace/>${ndx}_primaryKey')!=null ){ 
			validateAddress( function( message ){	
				if ( message.length > 0){
					modalAddressValidation.render();
					modalAddressValidation.show();			

					var msg = "<ul><li> Secondary Caregiver - " + message +"</li></ul>";
					var theDiv = document.getElementById('addressValidationResult');
					theDiv.innerHTML += msg;

					submit = false;				
				}		
				validateOtherCallback( submit );
			});
		}else{
			validateOtherCallback( submit );			
		}
	}

</aui:script>

	
	