							
		<%@ include file="/jsp/init.jsp" %>						
	
	
<c:set var="veteran" value="${workItem.veteran}" />
<c:set var="vcgSupport" value="${workItem.vcgSupport}" />
<c:set var="stipendPaymentConfig" value="${calcInfo.stipendPaymentConfig}" />
<fmt:formatDate value="${vcgSupport.primaryVcgAn.receivedDate}" var="appReceivedDate" type="date" pattern="MM/dd/yyyy"/>

<style>
.itemized-fract{
	font-size:1.5em;
}
</style>			   			
				    		
							<c:choose>
							   <c:when test="${workItem.workType eq 'REVOKED_DISPOSITION'}">
							   		<%@include file="/jsp/internal/autoCalcRevocation.jsp" %>
							   		<c:set var="i" value="5" />
							   </c:when>
							   <c:when test="${workItem.workType eq 'REINSTATED_DISPOSITION'}">
							   		<%@include file="/jsp/internal/autoCalcReinstate.jsp" %>
							   		<c:set var="i" value="3" />
							   </c:when>
							   <c:when test="${workItem.workType eq 'TIER_UPDATE'}">
									<%@include file="/jsp/internal/autoCalcTier.jsp" %>
							   		<c:set var="i" value="5" />
							   </c:when>
							   <c:when test="${workItem.workType eq 'ADDRESS_CHANGE' or ( workItem.workType eq 'V_INFO_CHANGE' and calcInfo.isCalculationChange() ) }">
									<%@include file="/jsp/internal/autoCalcAddress.jsp" %>
									<c:set var="i" value="3" />
							   </c:when>
							   <c:when test="${workItem.type eq 'RECOUPMENT'}" >
						    		<%@include file="/jsp/internal/autoRecoupment2.jsp" %>
								</c:when>
							   <c:when test="${stipendPaymentConfig.stipendType eq 'one-time' and empty stipendPaymentConfig.payment }">
									
									
									
												    			
								<div class="work-section manage-layout" >
									<div class="center-position">
										<div id="tier-info">
											<div class="selected-vcg">
										    		<div class="selected-info">
										    			<fmt:formatDate value="${calcInfo.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
										    		 <!-- 
										    		 	<div class="selected-vcg-row-header" ><div class="strong">General Information</div></div>
										    		  -->
									    				<div class="my-shim"></div>
										    		 
										    			<div class="selected-vcg-row">
										    	 			<div class="srow-label">Tier Level:</div><liferay-ui:message key="tier-level-${vcgSupport.tierLevel}" />
										    			</div>
									    				<div class="my-shim"></div>
									    								    			
										    			<div class="selected-vcg-row">
										    				<div class="srow-label">Application Received Date:</div>${appReceivedDate}
										    			</div>
										    			<div class="my-shim"></div>
										    			<div class="selected-vcg-row">
										    				<div class="srow-label">Application Approved Date:</div>${dispositionDate}
										    			</div>
										    			<div class="my-shim"></div>
										    			<div class="selected-vcg-row">
										    				<div class="srow-label">Payment Date:</div>${paymentDate}
										    			</div>
										    		</div>
									    	</div>
										</div>
									</div>
								</div>
									
									
									<div class="work-section" >	
										<div class="center-position">
											<div class="rate-info" id="update_primary">
												<div class="selected-vcg">
										    	 	<div class="selected-info">
										    	 		
											    	 	<ul>
											    	 		<li>
												    	 		One Time Manual Payment: <fmt:formatNumber value="${workItem.stiPtContext.oneTimePayment}" type="currency"/>
											    	 		</li>
														    	 	
											    	 		${workItem.manualInfo}
											    	 	
											    	 	
											    	 	</ul>
											    	 	
											    	 	
											    	 	
														
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<c:set var="i" value="0" />
							   </c:when>
				    		  <c:otherwise>
								 	<c:set var="i" value="3" />
				  
				    			
		<div class="work-section manage-layout" >
			<div class="center-position">
				<div id="tier-info">
					<div class="selected-vcg">
				    		<div class="selected-info">
				    			<fmt:formatDate value="${calcInfo.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
				    		 
				    		 	<div class="selected-vcg-row-header" ><div class="strong">Initial Application</div></div>
			    				<div class="my-shim"></div>
			    				
			    				<div class="selected-vcg-row">
					    	 		<div class="srow-label">Zip:</div>${veteran.zip} &nbsp;
					    	 	</div>
				    		 
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Tier Level:</div><liferay-ui:message key="tier-level-${vcgSupport.tierLevel}" />
				    			</div>
			    				<div class="my-shim"></div>
			    								    			
				    			
				    			<div class="my-shim"></div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Application Received Date:</div>${appReceivedDate}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Payment Date:</div>${paymentDate}
				    			</div>
				    		</div>
			    	</div>
				</div>
			</div>
		</div>
		
		<div class="work-section" >	
			<div class="center-position">
				<div class="rate-info" id="update_primary">
					<div class="selected-vcg">
			    	 	<div class="selected-info">
			    	 		<div class="selected-vcg-row">
				    	 		<div class="srow-label">Zip:</div>${veteran.zip} &nbsp;</div>
								
								<c:if test="${calcInfo.isBackPayDetected()}">${calcInfo.setBackpayConfig()}</c:if>
								
								<c:forEach var="stipendPaymentConfig" items="${calcInfo.lastRecurringConfigs}" varStatus="stipendPaymentConfigNdx" >
									<c:if test="${calcInfo.lastRecurringConfigs.size() gt 1}" >
										<c:set var="configContext" value="${stipendPaymentConfig.stipendStartDateStr} " />
									</c:if>
									
									<%@include file="/jsp/internal/autoRecurring.jsp" %>
									<c:set var="prorateFormula" value="${(0 eq stipendPaymentConfigNdx.index && calcInfo.lastRecurringConfigs.size() eq 1) || (0 ne stipendPaymentConfigNdx.index && calcInfo.lastRecurringConfigs.size() gt 1)}" />
									<c:set var="showBackPayAmount" value="${(calcInfo.lastRecurringConfigs.size()-1) eq stipendPaymentConfigNdx.index}" />
									<c:set var="calcInfoNdx" value="${stipendPaymentConfigNdx.index} " />
									<%@include file="/jsp/internal/autoBackpay.jsp" %>
								</c:forEach>
								
								<div class="selected-vcg-row">
			    	 				<div class="srow-label">Payment for ${calcInfo.paymentMonthStr}:</div><fmt:formatNumber value="${calcInfo.stipendPaymentConfig.payment}" type="currency"/> &nbsp;
			    				</div>
			    				<div class="selected-vcg-row">
			    	 				<div class="srow-label">Total Payment Amount:</div><fmt:formatNumber value="${calcInfo.finalAmount}" type="currency"/> &nbsp;
			    				</div>
				    		</div>
			    		</div>
					</div>
				</div>
			</div>
		 </c:otherwise>	
	</c:choose>
<aui:script use="node-event-simulate,aui-toggler,aui-tooltip">
	
	
	<c:choose>
		
		<c:when test="${workItem.queueId eq 500}">
			<c:set var="h" value="1" />
		</c:when>
		<c:when test="${workItem.type eq 'MANUAL_WORK'}">
			<c:set var="h" value="3" />
		</c:when>
		<c:otherwise>
			<c:set var="h" value="0" />
		</c:otherwise>	
	</c:choose>
	
	

	
	new A.TooltipDelegate( { trigger: '.has-tooltip' } );
	
</aui:script>