<%@page import="gov.va.caret.pm.util.PMCategories"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ include file="init.jsp"%>
<style>
.unreadRow,  .unreadRow a{
font-weight:bold;
}
</style>

<style type="text/css" media="print">

.print {
visibility:visible;
width: auto;
position: relative; 
top: -190px;
}

a[href]:after { content: none !important; }
a[href]:after { content: image visibility:visible !important; }
a[href]:after { content: span visibility:visible !important; }
</style>

<%
	int start = 0;
	if (request.getAttribute("start") != null) {
		start = (Integer) request.getAttribute("start");
	}
	int countPerPage = 2;
	List<PMMessage> messages = (List<PMMessage>) request.getAttribute(PMConstants.MESSAGES_LIST);
	//HashMap<Long, String> recipentMap = (HashMap<Long, String>) request.getAttribute(PMConstants.RECIPENTS_MAP);
	Map<Long, List<PMMessage>> childMessages = (HashMap<Long, List<PMMessage>>) request.getAttribute(PMConstants.MESSAGES_MAP);
	int totalCount = (Integer) request.getAttribute(PMConstants.TOTAL_COUNT);
	String prevIndex = "" + (start - countPerPage);
	String nextIndex = "" + (start + countPerPage);
	String pagingLabel = "";
	if(totalCount > 0) {
		pagingLabel = "Showing messages " + (start + 1) + " to " + (start + messages.size()) + " of " + totalCount;
	}
%>

<portlet:renderURL var="prevPageUrl">
	<portlet:param name="page" value="inbox"/>
	<portlet:param name="startIndex" value="<%=prevIndex%>"/>
</portlet:renderURL>
<portlet:renderURL var="nextPageUrl">
	<portlet:param name="page" value="inbox"/>
	<portlet:param name="startIndex" value="<%= nextIndex %>"/>
</portlet:renderURL>

<portlet:actionURL var="deleteActions">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="messageActions"/>
	<portlet:param name="messageAction" value="delete"/>
</portlet:actionURL>	

<portlet:actionURL var="openUrl">
		<portlet:param name="javax.portlet.action" value="doAction" />
</portlet:actionURL>

	<aui:script use="node" >
		A.all('.message-action').on(
	      'click',
	      function(e) {	
	    	    var messageAction = e.currentTarget.attr('id');
	    	    var messageId = e.currentTarget.attr('href');
	    	    if ( e.currentTarget.attr('name') == "Subject") {
	    	    	messageAction = "view-message";
	    	    	 A.one ('#<portlet:namespace/>messageId').val(messageId);
	    	    }
	    	    A.one ('#<portlet:namespace/>entry').val("INTERNAL_MESSAGE");
	       		A.one ('#<portlet:namespace/>messageAction').val(messageAction);
	       		document.forms["messageActions"].submit();
	      }
	    );
	</aui:script>

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<div id="mainTab">

 
<legend>
<div image="message" class="message"></div> My Messages
<span class="messageicon">
<liferay-ui:icon-menu>
		<liferay-ui:icon image="message" message="compose" url="javascript:composeGeneralMessage();"  />
		</liferay-ui:icon-menu>
</span>
</legend>
	<div class="pageContent">
		<div style="width:100%;">
			<c:if test="${! empty errorMessag}">
				<div class="portlet-msg-error" style="width:95%;">${errorMessage}</div><br/>
			</c:if>
			<c:if test="${! empty infoMessage}">
				<div id="infoMessage" class="portlet-msg-info" style="width:95%;">${infoMessage}</div><br/>
			</c:if>
		</div>	
		<div id="messages_count"><%=pagingLabel%></div>
		


		<div id="mailbox">
			<div>
				<br/>
				
				<script type="text/javascript">
					var messageIds = new Array();
					var userIds = new Array();
				</script>
				
				<fieldset id="sectionCollapse1">
				<!-- 
				<span class="deleteicon">
					<liferay-ui:icon-menu>
							<liferay-ui:icon image="trash" message="delete-messages" url="javascript:deleteMessage();"  />
					</liferay-ui:icon-menu>
				</span>
				<br>
				 -->
				<div id="_validationResult" ></div>
				<aui:form method="post" name="inboxActions" action="${deleteActions}" >
					<input type="hidden" id="type" name="type" value="delete" />
					<input type="hidden" id="ids" name="ids" value="" />
					
					<liferay-ui:search-container id="parentMessages"  curParam="parentMessages" emptyResultsMessage="no-messages">
					<!--  rowChecker="<%=new RowChecker(renderResponse)%>"--> 
					
					<liferay-ui:search-container-results results="<%=messages%>"  />
		
					<liferay-ui:search-container-row className="gov.va.caret.model.PMMessage" escapedModel="true" modelVar="message"
					 keyProperty="messageId" >
					 
					  <c:if test="${not fn:containsIgnoreCase(message.getReadRecepients(), userId)}">
				       <liferay-ui:search-container-row-parameter name="className" value="unreadRow" />
				    </c:if>
    
					<% 
						String sentTo = message.getRecepients();
						List<PMMessage> childMessagesList = childMessages.get(message.getMessageId());
						String responses = Integer.toString(childMessagesList.size()) + " Responses";
						SimpleDateFormat formatter=new SimpleDateFormat("MM/dd/yy HH:mm:ss a");
						String messageDate=formatter.format(message.getPostedDate());
						String embeddedUrl = openUrl + message.getUrl().replace("amp;", "");
					%>
						<c:choose>
						<c:when test="${fn:containsIgnoreCase(message.getReadRecepients(), userId)}">
					 		<liferay-ui:search-container-column-text name="Status" value="Read"/><!-- orderable="true" orderableProperty="type_" -->
						</c:when>
						<c:otherwise>
							<liferay-ui:search-container-column-text name="Status" value="Unread"/><!-- orderable="true" orderableProperty="type_" -->
						</c:otherwise>
						</c:choose>
						<liferay-ui:search-container-column-text name="From" value="<%= message.getOwnerName()%>"/><!-- orderable="true" orderableProperty="type_" -->
						<liferay-ui:search-container-column-text name="To" value="${recipentMap.get(message.getMessageId())}"/><!-- orderable="true" orderableProperty="type_" -->
						<liferay-ui:search-container-column-text name="Sent" cssClass="date" value="<%=messageDate%>" />
						<liferay-ui:search-container-column-text cssClass="messContent" name="Category" value="<%=message.getSubject()%>"/>
						<liferay-ui:search-container-column-text cssClass="messageActionMenu" name="Reponses" >
						<liferay-ui:icon-menu>
							<portlet:actionURL var="messageActions">
								<portlet:param name="javax.portlet.action" value="doAction"/>
								<portlet:param name="action" value="messageActions"/>
								<portlet:param name="messageAction" value="view_message"/>
								<portlet:param name="parentMessageId" value="${message.getMessageId()}"/>
							</portlet:actionURL>
									<liferay-ui:icon onClick="javascript:markAsRead(${message.getMessageId()});" image="view" message="<%=responses%>" url="${messageActions}" />
						</liferay-ui:icon-menu>
						</liferay-ui:search-container-column-text>
						<liferay-ui:search-container-column-text cssClass="messageActionMenu" name="Item link" >
							<liferay-ui:icon-menu>
							<c:choose>
							<c:when test="${not empty message.getUrl()}">
								<liferay-ui:icon message="Open-item" url="<%=embeddedUrl%>" /> 
							</c:when>
							<c:otherwise>
								<liferay-ui:icon message="" url="" />
							</c:otherwise>
							</c:choose>
							</liferay-ui:icon-menu>
						</liferay-ui:search-container-column-text>
						<liferay-ui:search-container-column-jsp cssClass="messageActionMenu" name="Actions" path="/jsp/im/messageActions.jsp"></liferay-ui:search-container-column-jsp>
						</liferay-ui:search-container-row>
					
					<liferay-ui:search-iterator />
					</liferay-ui:search-container>
					<input type="hidden" id="<portlet:namespace/>deleteIds" name="deleteIds" value="">
				</aui:form>	
					</fieldset>
			</div>
		</div>
	</div>
</div>


<aui:script use="liferay-util-list-fields">	
Liferay.provide(
		window,
		'deleteMessage',  // Name of the javascript function.
		function(cmd) {
		      var updateStatus = true;

		       var updateUserIds = Liferay.Util.listCheckedExcept(document.<portlet:namespace />inboxActions, "<portlet:namespace />allRowIds");  // Getting the checked checkboxes values , Here "fm" is the form name.
		       A.one ('#<portlet:namespace/>deleteIds').val(updateUserIds);
		       if(updateUserIds == "") {
		    	   var validationNotice = A.one ('#_validationResult');
		    	   var msg = "<div class='portlet-msg-error'><liferay-ui:message key='delete-min-select' /><ul></ul></div>";
	    		   validationNotice.html(msg);
		    	   return false;
		       }
		      
		       document.forms["<portlet:namespace />inboxActions"].submit();
		}
);

window.markAsRead = function(messageId) {
	
	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="updateMessageStatus" /></portlet:resourceURL>', 'json',
			{ 	
				messageId:  messageId
		  	},
			function( data ) {
		  		return true;
			} 
	);

 }
</aui:script>

<jsp:include page="/jsp/im/compose.jsp" />