<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>

<style>
<!--
.centered-ct, .centered-pu {
	clear: both;
	white-space: nowrap;
	margin: auto;
	margin-bottom: -21px;
}

.centered-ct legend {
    border-bottom-style: hidden !important;
}

.centered-ct td, .centered-pu td {
	text-align: right;
	border: none;
	padding:0px;
	padding-right: 20px;
	padding-left: 20px;
}

#occ-funds {
	border: 3px solid #2AAAE6;
}

#projected {
	padding: 6px;
	width: 79%;
	white-space: nowrap;
	margin: auto;
}

#budgeted {
	padding: 6px;
	width: 22%;
	white-space: nowrap;
	margin: auto;
}

.dashboard-top {
	margin-top: 0;
}
-->
</style>

	<aui:nav cssClass="caret-menu">

		<%@include file="/jsp/dashboard/fmsMenuActions.jsp" %>


			<c:forEach items="${CARET_MENU['createActions']}" var="action" >
		    	  <li id="<portlet:namespace/>${action.key}" class="dropdown caret-action" ><a href="javascript:"><div class="icon-plus">&nbsp;</div><liferay-ui:message key="${action.value}" /></a></li>
	    	</c:forEach>

	    	<c:set var="TrainingDocuments" value="${CARET_MENU['TrainingDocument']}" /> 
		    	<c:forEach items="${TrainingDocuments}" var="TrainingDocument" >
		    	  <li id="<portlet:namespace/>${TrainingDocument.key}" class="dropdown" ><a href="${TrainingDocument.value}" target="_blank"><div class="icon-book"></div> <liferay-ui:message key="User-Manual" /></a></li>
		    	</c:forEach>
		    	
 		<c:if test="${!empty CARET_MENU['toolsActions']}">
	    	 <c:forEach items="${CARET_MENU['toolsActions']}" var="action" >
	    	 	<c:choose>
	    	 		<c:when test="${action.key eq 'STIPEND_CALCULATOR'}">
	    	 			<li id="<portlet:namespace/>${action.key}" class="dropdown tools-action" ><a href="javascript:"><div class="icon-tablet">&nbsp;</div><liferay-ui:message key="${action.value}" /></a></li>
	    	 			<%@include file="/jsp/tools/stipendCalculator.jsp" %>
	    	 			</c:when>
	    	 		<c:otherwise>
	    	 	   	  <li id="<portlet:namespace/>${action.key}" class="dropdown caret-action" ><a href="javascript:"><div class="icon-tablet">&nbsp;</div><liferay-ui:message key="${action.value}" /></a></li>
	    	 		</c:otherwise>
	    	 	</c:choose>
		 	</c:forEach>
		</c:if>
	</aui:nav>

<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-1"><div class="icon-briefcase"></div> ${role} Dashboard</a></li>
    <li class="tab-click" ><a href="#tab-2"><div class="icon-search"></div> Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      				<div  class="centered-ct" >
						<fmt:setLocale value="en_US"/>
						<legend>
						<table class="centered-ct" id="occ-funds">
							<tr>
								<c:choose>
									<c:when test="${caretMap_['AVAILABLE'] lt caretMap_['THRESHOLD'] }" >
										<td>- Caregiver Stipend Annual Budget YTD:</td><td class="missing-required-input" ><fmt:formatNumber value="${caretMap_['AVAILABLE']}" type="currency"/></td>
									</c:when>
									<c:otherwise>
										<td>Caregiver Stipend Annual Budget YTD:</td><td><fmt:formatNumber value="${caretMap_['AVAILABLE']}" type="currency"/></td>
									</c:otherwise>
								</c:choose>
							</tr>
							<tr><td>Upcoming Estimated Monthly Stipend Payment:</td><td><fmt:formatNumber value="${caretMap_['SCHEDULED']}" type="currency"/></td></tr>
							<tr><td>FY18 Caregiver Stipend Purchase Order/Obligation Number:</td><td>CG8001</td></tr>
						</table>
						</legend>
					</div>
					
						<div>
							<div class="float-right" style="clear:right" >
								<a class="btn-link icon-time btn-primary" onclick="window.auditLog(${caretMap_['thid']});" title="<liferay-ui:message key="threshold-audit-tooltip" />" >&nbsp; Threshold Audit</a>
							</div>
						</div>
						<div>
							<div class="float-right" style="clear:right">
								<a class="btn-link icon-time btn-primary" onclick="window.auditLog(${caretMap_['avid']});" title="<liferay-ui:message key="funding-audit-tooltip" />" >&nbsp; Funding/Budget Audit</a>
							</div>
						</div>
					
      	<div class="next-line">
      		<fieldset id="sectionCollapseCbopc1" class="clear-both">
				<legend class="header"> Outgoing </legend>
				<div class="content toggler-header-expanded"  id="requestTabOuter" >
			   <div id="requestTab"  >
					<ul class="nav nav-tabs">
					    <li class="tab-click" ><a href="#occFmRequest">Last FMS Request (<span id='total_occFmRequest'>${total_['occFmRequest']}</span>)</a></li>
					    <li class="tab-click" ><a href="#occFmPayments">Staged Payments(<span id='total_occFmRequest'>${total_['occFmPayments']}</span>)</a></li>
					</ul>
					<div class="tab-content">
						<div id="occFmRequest" class="tab-pane"></div>
						<div id="occFmPayments" class="tab-pane"></div>
					</div>
				</div>
			</div>
		  </fieldset>
      	</div>
      	
      	<div class="next-line">
      	<fieldset id="sectionCollapseCbopc2" class="clear-both">
			<legend class="header"> Incoming </legend>
				<div class="content toggler-header-expanded"  id="responseTabOuter" >
			   <div id="responseTab"  >
					<ul class="nav nav-tabs">
					    <li class="tab-click" ><a href="#occFmResponse">Last Response (<span id='total_occFmResponse'>${total_['occFmResponse']}</span>)</a></li>
					</ul>
					<div class="tab-content">
						<div id="occFmResponse" class="tab-pane"></div>
					</div>
				</div>
			</div>
		  </fieldset>
      	</div>
      		
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapseCbopc3">
		      		<legend class="header"><div class="icon-comment"></div> My Comments/Notes </legend>
		      		<div class="content" id="myNotes" >
	      			</div>
      			</fieldset>
      		</div>
      	</div>
    </div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
	
	
  </div>

</div>




<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate,anim">
	
	for ( i = 1 ; i < 4; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapseCbopc' + i ,
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}
    
    var loadList = function(e, page) {
	  	if (!page){
	   		var href = e.currentTarget.getActiveTab().one('a').attr('href');
	  	   	page = href.substring(href.indexOf('#'));
		}
		var node = A.one( page );
	    if (!node || node.hasClass('loaded-pane')){
	    	return false;
	    }
	
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
			{ page: page },
			function( data ){
				overwrite( node, data );
			} 
		);
	}
    

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  new A.TabView({
      srcNode: '#requestTab',
      type: 'pills',
      on: {
            click: function(e){ loadList(e); }
          }
    }
  ).render();
  
   new A.TabView({
      srcNode: '#responseTab',
      type: 'pills',
      on: {
            click: function(e){ loadList(e); }
          }
    }
  ).render();
  
  A.on('domready', function( event ) {
   	try {
   		loadList(event,'#occFmRequest');
   		loadList(event,'#occFmResponse');
   		loadList(event,'#myNotes');
   		A.all('.tab-click').attr('tabindex',0);
   		if ("search" == "${caretMap_['tabContext']}" ){
   			window.careTmainTab.selectChild(1);
   			window.setTimeout(function(e){ A.one('#<portlet:namespace/>searchPerson').simulate('click'); }, 500);
			new A.Anim({
				duration: 0.5,
				easing: 'easeBoth',
				node: 'win',
				to: {
					scroll: [0, A.one("#searchContextPane").get('offsetTop')]
				}
			}).run();			
   		}
   	} catch (e){}
   });
   
   
  
</aui:script>

<%@include file="/jsp/internal/actionsSupport3.jsp" %>
