package gov.va.oit.oed.vaww.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.ApplicationWorkFlowException;


public class MessageHandler implements SOAPHandler<SOAPMessageContext> {
	
	private static Log _log = LogFactoryUtil.getLog(MessageHandler.class);
    
	@Override
	public boolean handleMessage(SOAPMessageContext context) {
		
		Boolean outBound = (Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		SOAPMessage message = context.getMessage();
		if (outBound.booleanValue()) {
			try {
				message.getSOAPPart().getEnvelope().getHeader().setPrefix("S");
				message.getSOAPPart().getEnvelope().removeNamespaceDeclaration("SOAP-ENV");
				
				
				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
				DocumentBuilder builder;  
				try {  
					//added for Fortify Scan
//					factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
				    builder = factory.newDocumentBuilder();  
				    Document document = builder.parse(new InputSource(new StringReader( com.liferay.portal.kernel.util.HtmlUtil.unescape(toString( (SOAPElement) message.getSOAPPart().getEnvelope().getBody().getFirstChild() )) )));
				    
				    Element originalDocumentElement = document.getDocumentElement();
				    Element newDocumentElement = document.createElementNS("http://DNS.URL         .      ", originalDocumentElement.getNodeName());
				    // Set the desired namespace and prefix
				    newDocumentElement.setPrefix("ps");
				    // Copy all children
				    NodeList list = originalDocumentElement.getChildNodes();
				    while(list.getLength()!=0) {
				        newDocumentElement.appendChild(list.item(0));
				    }
				    // Replace the original element
				    document.replaceChild(newDocumentElement, originalDocumentElement);
				    
				    ((SOAPElement) message.getSOAPPart().getEnvelope().getBody().getFirstChild()).detachNode();
				    message.getSOAPPart().getEnvelope().getBody().addDocument( document );
				    
				} catch (Exception e) {  
				    e.printStackTrace();  
				}
				
				((SOAPElement) message.getSOAPPart().getEnvelope().getBody().getFirstChild()).setAttribute("xmlns", "urn:hl7-org:v3");
				((SOAPElement) message.getSOAPPart().getEnvelope().getBody().getFirstChild()).removeNamespaceDeclaration("xsi");
				((SOAPElement) message.getSOAPPart().getEnvelope().getBody().getFirstChild()).setAttribute("ITSVersion", "XML_1.0");
				((SOAPElement) message.getSOAPPart().getEnvelope().getBody().getFirstChild()).removeAttribute("xsi:type");
				
				message.saveChanges();
			} catch (SOAPException | TransformerFactoryConfigurationError e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		
		if ( _log.isDebugEnabled() ) {
			_log.debug(outBound.booleanValue()? "OUTBOUND::::" : "INCOMING::::");
			OutputStream baos = new ByteArrayOutputStream();  
			try {
				message.writeTo(baos);
			} catch (SOAPException | IOException e) {
				e.printStackTrace();
			}  
			_log.debug( baos );
		}

		return true;
	}

	String toString(Node node) {
		StringWriter stringWriter = new StringWriter();
		try {
			TransformerFactory inst = TransformerFactory.newInstance();
			//added for Fortify Scan
//			inst.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", ""); //XMLConstants.ACCESS_EXTERNAL_DTD
			inst.newTransformer().transform(new DOMSource(node), new StreamResult(stringWriter));
		} catch (TransformerException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return stringWriter.toString();
	}
	
	@Override
	public boolean handleFault(SOAPMessageContext context) {
		return true;
	}

	@Override
	public void close(MessageContext context) {
	}

	@Override
	public Set<QName> getHeaders() {
		return null;
	}
}