package gov.va.caret.workflow;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WorkFlowTest {
	
	static Logger logger = LogManager.getLogger( WorkFlowTest.class );
	/*
	 * 
	 * Create: 
	 * 1) Held Payment Work
	 * 2) Reject Payment Work
	 * 3) Recoupment Work
	 * 4) Lost Check Work
	 */
	public static void main ( String[] args ){
		
		
		logger.info("testing workflow************** \n \n" );
		
		for ( OwnerQueue ownerQue: OwnerQueue.values() ){
			logger.info("---------- \n \n" );
			logger.info( "At Queue:" + ownerQue.name() + ", user can:");
			for ( QueAction queAction: ownerQue.queueAction ){
				logger.info( queAction + " a work item, which sends work to:" + OwnerQueue.valueOf( queAction.nextQueue ) + ( queAction.workMarkation == null? "": "(marked as " + queAction.workMarkation + ")" )  );
			}
			logger.info("---------- \n \n" );
		}
		
		for ( WorkName workName: WorkName.values() ){
			if ( workName.queue == null ) continue;
			logger.info("---------- \n \n" );
			logger.info( "Work of type:" + workName.name() + ", at Queue:" + workName.queue +  ", user can:");
			for ( QueAction queAction: workName.extraAction ){
				logger.info( queAction  + " a work item, which " + (workName.automatic? "(automatically)" : "") + " sends work to:" + OwnerQueue.valueOf( queAction.nextQueue ) + ( queAction.workMarkation == null? "": "(marked as " + queAction.workMarkation + ")" ) );
			}
			for ( QueAction queAction2: workName.queAction  ){
				logger.info( queAction2 + " a work item, which sends work to:" + OwnerQueue.valueOf( queAction2.nextQueue ) + ( queAction2.workMarkation == null? "": "(marked as " + queAction2.workMarkation + ")" ) );
			}
			logger.info("---------- \n \n" );
		}
		
	}
}
