package gov.va.caret.view;

import static com.liferay.portal.kernel.dao.search.SearchContainer.DEFAULT_CUR;
import static com.liferay.portal.kernel.dao.search.SearchContainer.DEFAULT_DELTA;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;

public class ResultMap {
	
	private static final String TOTAL = "total_";
	private static final String BASE_URL = "iteratorURL_";
	private static final String RESULTS = "results_";
	private static final String TYPE = "orderByType_";
	private static final String COLUMN = "orderByColumn_";
	private static final String CURRENT = "curParam_";
	private static final String DELTA = "delta_";
	public static final String CARET_MAP = "caretMap_";
	public static final String FORM = "form_";
	public static final String DESC = "desc";
	private static final String ROWCHECKER = "rowChecker_";
	
	@SuppressWarnings("unchecked")
	public static Map<String,Object> getCaretMap ( PortletRequest request ) {
		
		Map<String,Object> formField = (Map<String,Object>) request.getAttribute( CARET_MAP );
		
		if (  formField == null ){
			formField = new CaretMap<String, Object> ( Collections.EMPTY_MAP );
			request.setAttribute( CARET_MAP, formField );
		}
		return formField;
	}
	
	public static Map<String,Integer> getResultTotalMap ( PortletRequest request ) {
		return getIntegerMap(request, TOTAL, 0);
	}
	
	public static Map<String,Integer> getResultOrderDeltaMap ( PortletRequest request ) {
		return getIntegerMap(request, DELTA, SearchContainer.DEFAULT_DELTA);
	}
	
	public static Map<String,Integer> getResultCurrentMap ( PortletRequest request ) {
		return getIntegerMap(request, CURRENT, DEFAULT_CUR);
	}
	
	public static Map<String,String> getResultOrderColumnMap ( PortletRequest request ) {
		return getMap(request, COLUMN, CaretStrPool.CREATE_DATE );
	}
	
	public static Map<String,String> getResultOrderTypeMap ( PortletRequest request ) {
		return getMap(request, TYPE, "desc");
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String, RowChecker> getRowCheckerMap( PortletRequest request, MimeResponse response ) {
		
		Map<String,RowChecker> rcMap = (Map<String,RowChecker>) request.getAttribute( ROWCHECKER );
		
		if (  rcMap == null ){
			RowChecker rowChecker = new RowChecker(response);
			rowChecker.setFormName("rcForm");
			rowChecker.setAlign("left");
			rowChecker.setValign("middle");
			rowChecker.setAllRowIds("allRowIds");
			rowChecker.setRowIds("rowIds");
			rcMap = new CaretMap<String, RowChecker> ( rowChecker );
			request.setAttribute( ROWCHECKER, rcMap );
		}
		return rcMap;
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String,Integer> getIntegerMap ( PortletRequest request, String requestAttribute, Integer defaultValue ) {
		Map<String,Integer> integerMap = null;
		if ( request.getAttribute( requestAttribute ) != null ){
			integerMap = (Map<String, Integer>) request.getAttribute( requestAttribute );
		} else {
			integerMap = new CaretMap<String, Integer>( defaultValue );
			request.setAttribute(requestAttribute, integerMap);
		}
		
		return integerMap;
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String,Long> getLongMap ( PortletRequest request, String requestAttribute, Long defaultValue ) {
		Map<String,Long> integerMap = null;
		if ( request.getAttribute( requestAttribute ) != null ){
			integerMap = (Map<String, Long>) request.getAttribute( requestAttribute );
		} else {
			integerMap = new CaretMap<String, Long>( defaultValue );
			request.setAttribute(requestAttribute, integerMap);
		}
		
		return integerMap;
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String,Boolean> getBooleanMap ( PortletRequest request, String requestAttribute, Boolean defaultValue ) {
		Map<String,Boolean> map = null;
		if ( request.getAttribute( requestAttribute ) != null ){
			map = (Map<String, Boolean>) request.getAttribute( requestAttribute );
		} else {
			map = new CaretMap<String, Boolean>( defaultValue );
			request.setAttribute(requestAttribute, map);
		}
		return map;
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String,String> getMap ( PortletRequest request, String requestAttribute, String defaultValue ) {
		Map<String,String> map = null;
		if ( request.getAttribute( requestAttribute ) != null ){
			map = (Map<String, String>) request.getAttribute( requestAttribute );
		} else {
			map = new CaretMap<String, String>( defaultValue );
			request.setAttribute(requestAttribute, map);
		}
		return map;
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String,BaseURL> getResultUrlMap ( PortletRequest request, BaseURL baseUrl ){
		Map<String, BaseURL> baseUrlMap;
		if ( request.getAttribute(BASE_URL) != null ){
			baseUrlMap = (Map<String, BaseURL>) request.getAttribute(BASE_URL);
		} else {
			baseUrlMap = new CaretMap<String,BaseURL>( baseUrl );
			request.setAttribute(BASE_URL, baseUrlMap);
		}
		return baseUrlMap;
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String,List<?>> getResultListMap ( PortletRequest request ){
		Map<String, List<?>> result;
		if ( request.getAttribute(RESULTS) != null ){
			result = (Map<String, List<?>>) request.getAttribute(RESULTS);
		} else {
			result = new CaretMap<String,List<?>>( Collections.emptyList() );
			request.setAttribute(RESULTS, result);
		}
		return result;
	}

	@SuppressWarnings("unchecked")
	public static Map<String, Object> getForm(PortletRequest request) {
		Map<String, Object> caretMap = ResultMap.getCaretMap( request );
		
		if ( caretMap.get( ResultMap.FORM ) != Collections.EMPTY_MAP ){
		
			return (Map<String, Object>) caretMap.get( ResultMap.FORM );
		
		} else {
			
			Map<String, Object> form = new HashMap<String, Object> ( );
			caretMap.put( ResultMap.FORM, form );
			return form;
		
		}
	}

	public static Map<String, String> getResultFilteredMap(PortletRequest request) {
		return getMap(request, "FILTERED", StringPool.BLANK);
	}

}
