package gov.va.caret.view;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;

import org.apache.commons.collections.CollectionUtils;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Junction;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.bean.AssmtAuditBean;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.model.Apeal;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.BlsAe;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.Call;
import gov.va.caret.model.Crypto;
import gov.va.caret.model.Docum;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.Persn;
import gov.va.caret.model.SearchParms;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.ApealImpl;
import gov.va.caret.model.impl.AudLgImpl;
import gov.va.caret.model.impl.BlsReImpl;
import gov.va.caret.model.impl.CallImpl;
import gov.va.caret.model.impl.PayLgImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.SearchParmsImpl;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.support.AssmtSupport;
import gov.va.caret.model.support.AuditLogSupport;
import gov.va.caret.model.support.CallSupport;
import gov.va.caret.model.support.DocumentSupport;
import gov.va.caret.model.support.PaymentLog;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.Vendor;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.pdf.FileType;
import gov.va.caret.portlet.resource.CaretResourceCommand;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.service.ApealLocalServiceUtil;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.AudLgLocalServiceUtil;
import gov.va.caret.service.BlsAeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.CallLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.CryptoLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PayLgLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.SearchParmsLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.soc.SocCachedReportUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

public class CachedReport extends GenericReport {

	public CachedReport(String reportName) {
		super(reportName);
	}
	
	//TODO: make this flexible for any search
	public void run ( PortletRequest request0, boolean loadFromParams, int start, int end ){
		
		PortletRequest request;
		if ( ParamUtil.getBoolean(request0, "useCache") ) {
			request = new CachedReportRequest( request0 );
		} else {
			request = request0;
		}
		List report = Collections.emptyList();
		boolean setSize = true;
		try {
			if ( "searchCompletedSocs".equals( getName( )) ){
				if ( CAction.canDoCaret(request, CaretCan.VIEW_FUNCTION ) ){
					cacheSearchForm( request );
				}
				report = getCompletedSocList ( request, start, end );
				setSize = false;
			} else if ( "searchSocs".equals( getName( )) ){
				if ( CAction.canDoCaret(request, CaretCan.VIEW_FUNCTION ) ){
					cacheSearchForm( request );
				}
				report = getPendingSocList ( request, start, end );
				setSize = false;
			}  else if ( "appeals".equals( getName( )) ){
				report = getAppealList ( request, start, end );
				setSize = false;
			}  else if ( "vcgs".equals( getName( )) ){
				if ( CAction.canDoCaret(request, CaretCan.VIEW_FUNCTION ) ){
					cacheSearchForm( request );
				}
				report = getVcgList ( request, start, end );
				setSize = false;
			} else if ( "vcgAssociatedCalls".equals( getName() ) ){
				String context = request.getParameter("context");
				if ( "dashboard".equals( context ) ){
					cacheSearchForm( request );
				}
				report = getAssociatedCallsList(request, start, end);
				setSize = false;							
			} else if ( "workItems".equals( getName() ) || "vcgOpenWork".equals( getName() ) ||
					"vcgClosedWork".equals( getName() ) ||
//					"vcgAssociatedCalls".equals( getName() )  ||
					"vcgOpenRefs".equals( getName() )  ||
					"vcgClosedRefs".equals( getName() ) ){

				String context = request.getParameter("context");
				ResultMap.getCaretMap(request).put("context", context);
				if ( "dashboard".equals( context ) || ( "workItems".equals( getName() ) && CAction.canDoCaret(request, CaretCan.VIEW_FUNCTION ) ) ){
					cacheSearchForm( request );
				}
				report = getWorkItemList(request, start, end);
				setSize = false;
			} else if ( "assmtAudit".equals( getName() ) ){
				report = getAssmtAudit ( request, start, end );
			} else if ( "assmtAuditAll".equals( getName() ) ){
				report = getAssmtAuditAll ( request, start, end, CaretStrPool.ASSMT_INITIAL);
			} else if ( "assmtAuditPeriodicAll".equals( getName() ) ){ 
				report = getAssmtAuditAll ( request, start, end, CaretStrPool.ASSMT_PERIODIC);
			} else if ( "periodicAssessmentsAll".equals( getName() ) ){ 
				report = getPeriodicAssessmentsAll(request, start, end);
			}else if ( "workAudit".equals( getName() ) ||
					"persnAudit".equals( getName() ) ||
					"vcgAudit".equals( getName() )  ||
					"callAudit".equals( getName() ) ||
					"blsAudit".equals( getName() ) ){
				report = getAudit ( request, start -1, end );
				setSize = false;
			} else if ( CaretStrPool.CALLS.equals( getName() ) || CaretStrPool.REFFERALS.equals( getName() ) ){
				report = getCallList(request, start, end);
				setSize = false;
			} else 	if ( "incompleteReferrals".equals( getName( )) ){
				report = getIncompleteReferrals(request, start, end);
				setSize = false;				
			} else if("blsRates".equals(getName())){
				report = getBlsRatesWithArea ( request, start, end );
				setSize = false;
			} else if("payments".equals(getName())){
				String context = request.getParameter("context");
				ResultMap.getCaretMap(request).put("context", context);
				if ( "dashboard".equals( context ) || CAction.canDoCaret(request, CaretCan.VIEW_FUNCTION ) ){
					cacheSearchForm( request );
				}
				report = getPayments ( request, start, end );
				setSize = false;
			} else if("paymentConfig".equals(getName())){
				String context = request.getParameter("context");
				ResultMap.getCaretMap(request).put("context", context);
				if ( "dashboard".equals( context ) || CAction.canDoCaret(request, CaretCan.VIEW_FUNCTION ) ){
					cacheSearchForm( request );
				}
				report = getPaymentConfigs ( request, start, end );
				setSize = false;
			} else if("vendors".equals(getName())){
				String context = request.getParameter("context");
				ResultMap.getCaretMap(request).put("context", context);
				if ( "dashboard".equals( context ) || CAction.canDoCaret(request, CaretCan.VIEW_FUNCTION ) ){
					cacheSearchForm( request );
				}
				report = getVendors ( request, start, end );
				setSize = false;
			}else if("vcgSupportingDocsAll".equals(getName())){
				report = getVcgSupportingDocsAll ( request, start, end );
			}else if("vcgDocsHistoryAll".equals(getName())){
				report = getVcgDocsHistoryAll(request, start, end);
			} else if("letterDocs".equals(getName())){
				report = getLettersList(request, start, end);
				setSize = false;
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		String listNdx = ParamUtil.get(request, "listNdx", StringPool.BLANK);
	 	ResultMap.getResultListMap( request ).put( getName() + listNdx, report );
	 	if ( setSize ){
	 		ResultMap.getResultTotalMap( request ).put( getName() + listNdx, report.size() );
	 	}

		ResultMap.getResultOrderDeltaMap( request ).put(getName() + listNdx, end == 0 ? SearchContainer.DEFAULT_DELTA : start-end );
	}
	
	private List getAppealList(PortletRequest request, int start, int end) throws SystemException {

		long primaryKey = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
		
		DynamicQuery[] dq = getDqPair(ApealImpl.class);
		List report = new ArrayList();
		
		DynamicQuery persnQuery = DynamicQueryFactoryUtil.forClass(PersnImpl.class, 
				PortletClassLoaderUtil.getClassLoader());
		boolean[] persnBool = new boolean[]{ false };
		List<Persn> persns = setPerson ( persnQuery, request, false, persnBool );

		Collection personList = new ArrayList<Long>();
		if ( !persns.isEmpty() ) {
			for ( Persn persn : persns ){
				personList.add(persn.getPersnId());
			}
			if ( ! personList.isEmpty() ){
				for ( DynamicQuery dynQry : dq ){
					dynQry.add(PropertyFactoryUtil.forName("ownerId").in( personList ) );
				}
			}
		}
		
		for ( Apeal vcg : (List<Apeal>)ApealLocalServiceUtil.dynamicQuery(dq[0], start, end) ){
			report.add( new gov.va.caret.model.support.AppealSupport(vcg) );
		}
		ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( ApealLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
		return report;
	}
	
	private List<Docum> getLettersList(PortletRequest request, int start, int end) throws SystemException {
		List<Docum> report = new ArrayList();
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long vcgId = ParamUtil.getLong( request, CaretStrPool.VCGID );
		if ( vcgId == 0 ) {
			vcgId = (Long) request.getAttribute(CaretStrPool.VCGID);
		}
		try {
			Boolean fromOcc = ParamUtil.getBoolean(request, "fromOcc");
			VcgAn vcgAn =  VcgAnLocalServiceUtil.getRecent(vcgId);
			Long vcgAnId = vcgAn.getVcgAnId();
			request.setAttribute(CaretStrPool.WORK_ID, worImId);
			request.setAttribute(CaretStrPool.VCGID, vcgId);
			String orderByCol = request.getParameter(SearchContainer.DEFAULT_ORDER_BY_COL_PARAM);
			String byType = request.getParameter(SearchContainer.DEFAULT_ORDER_BY_TYPE_PARAM);
			
			//List<Letter> allLetters = new ArrayList<Letter>();
			//allLetters.addAll();
			DynamicQuery letterDocumsDynamicQuery = DynamicQueryFactoryUtil.forClass(Docum.class, PortletClassLoaderUtil.getClassLoader())
					.add(PropertyFactoryUtil.forName(CaretStrPool.CLASS_PK).eq(vcgAnId))
					.add(PropertyFactoryUtil.forName(CaretStrPool.CLASS_ID).eq(PortalUtil.getClassNameId(VcgAn.class)))
					.add(PropertyFactoryUtil.forName("deleted").eq(false))
					.add(PropertyFactoryUtil.forName(CaretStrPool.TYPE).eq(fromOcc?FileType.OCC_Letter.name():FileType.CSC_Letter.name()));
			if (orderByCol != null) {
				if ("asc".equals(byType)) {
					setDesc(false);
					letterDocumsDynamicQuery.addOrder(OrderFactoryUtil.asc(orderByCol));
				} else {
					setDesc(true);
					letterDocumsDynamicQuery.addOrder(OrderFactoryUtil.desc(orderByCol));
				}
			} else {
				letterDocumsDynamicQuery.addOrder(OrderFactoryUtil.desc("documId"));
			}
			report = DocumLocalServiceUtil.dynamicQuery(letterDocumsDynamicQuery, start, end);//.getByClass(vcgAnId, PortalUtil.getClassNameId(VcgAn.class), fromOcc?FileType.OCC_Letter.name():FileType.CSC_Letter.name(), start, end);
			int totalLettersCount = DocumLocalServiceUtil.dynamicQuery(letterDocumsDynamicQuery).size();
			ResultMap.getResultTotalMap( request ).put( getName(), totalLettersCount );
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return report;
	}

	private List<? extends Vendr> getVendors(PortletRequest request, int start, int end) {

 		long primaryKey = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		List report = new ArrayList();

		boolean[] persnSet = new boolean[]{false};
		
		List<Persn> persnList = setPerson ( dynamicQuery, request, false, persnSet ); //TODO: use some method of verifying...
		
		DynamicQuery[] dq = getDqPair(VendrImpl.class);
		try {
			if ( primaryKey > 0 ) {
				Vendr vendr = VendrLocalServiceUtil.fetchVendr(primaryKey);
				if ( vendr != null ) {
					return Collections.singletonList( new Vendor(vendr) );
				}

				List<Vendr> inList = new ArrayList<Vendr>();
				Set<Long> unique = new HashSet<Long>();
				for ( StiPt c : StiPtLocalServiceUtil.findByVcg( primaryKey, start, end, null) ) {
					vendr = VendrLocalServiceUtil.fetchVendr( c.getVendrId() );
					if ( vendr != null && unique.add( vendr.getVendrId() ) ){
						inList.add( new Vendor( vendr ) );
					}
				}
				return inList;
			}
			
			if ( !persnList.isEmpty() || persnSet[0] ) {
				Collection inList = new HashSet<Long>();
				for ( Persn p: persnList ){
					inList.add(p.getPersnId());
				}
				if ( ! inList.isEmpty() ){
					for ( DynamicQuery dynQry : dq ){
						dynQry.add(PropertyFactoryUtil.forName("persnId").in( inList ) );
					}
				}
			}
			
			if ( persnSet[0] ){
				for ( Vendr vcg : (List<Vendr>)VendrLocalServiceUtil.dynamicQuery( dq[0], start, end ) ){
					report.add( new gov.va.caret.model.support.Vendor(vcg) );
				}
				ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( VendrLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
				
				return report;
			} else {

//				for ( Vendr vcg : VendrLocalServiceUtil.getVendrs(start, end) ){
//					report.add( new gov.va.caret.model.support.Vendor(vcg) );
//				}
//				ResultMap.getResultTotalMap( request ).put( getName(), VendrLocalServiceUtil.getVendrsCount() );
//				return report;
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}

		return Collections.emptyList(); 
	}
	
	private List<BlsRe> getBlsRatesWithArea(PortletRequest request, int start, int end) throws SystemException {
		//
		//return BlsReLocalServiceUtil.getBlsRes(start, end);
		
		String zip = request.getParameter("zip");
		String county = request.getParameter("county");
		String state = request.getParameter("state");
		String areaNumber = request.getParameter("areaNumber");
		String areaName = request.getParameter("areaName");
		
		List<BlsRe> blsReList = null;
		List<BlsAe> blsAeList = null;
		Map<Long, BlsAe> blsAeMap = new HashMap<Long, BlsAe>();
		try {
			//String year = CaretUtil.getBlsYear();
			//Calendar c = Calendar.getInstance();
			//String year = String.valueOf(c.get(Calendar.YEAR));

			Calendar currentYear = Calendar.getInstance();
		    //currentYear.set(Calendar.YEAR, Integer.parseInt(year));
		    
		    DynamicQuery[] dq = getDqPair(BlsReImpl.class);
			
			DynamicQuery blsAreaDynamicQuery = DynamicQueryFactoryUtil.forClass(BlsAe.class, PortletClassLoaderUtil.getClassLoader());
			for ( DynamicQuery dynQry : dq ){
				dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.YEAR).eq(currentYear.get(Calendar.YEAR)));
				if ( !Toolbox.isEmpty( zip) ) {
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.ZIP).eq(zip));
				}
				if ( !Toolbox.isEmpty( county) ) {
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.COUNTY).eq(county));
				}
				if ( !Toolbox.isEmpty( state) ) {
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.STATE).eq(state));
				}
			}
						
			if ( !Toolbox.isEmpty( areaNumber) || !Toolbox.isEmpty( areaName)) {
				if ( !Toolbox.isEmpty( areaNumber)) {
					blsAreaDynamicQuery.add(PropertyFactoryUtil.forName("areaNumber").eq(Integer.parseInt(areaNumber)));
				}
				if ( !Toolbox.isEmpty( areaName)) {
					blsAreaDynamicQuery.add(PropertyFactoryUtil.forName("areaName").like('%'+areaName.trim()+'%'));
				}
				blsAeList = BlsAeLocalServiceUtil.dynamicQuery(blsAreaDynamicQuery);
				
				if ( !blsAeList.isEmpty() ) {
					 Set inList = new HashSet<Long>();
					 for ( BlsAe blsAe: blsAeList ){
						 inList.add(blsAe.getBlsAeId());
					 }				
					 if ( !inList.isEmpty() ) {
						 for ( DynamicQuery dynQry : dq ){
							 dynQry.add( PropertyFactoryUtil.forName("blsAeId").in(inList));
						 }
						 blsReList = BlsReLocalServiceUtil.dynamicQuery(dq[0], start, end);
						 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( BlsReLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
							
					 }					
					 for ( BlsAe blsAe: blsAeList ) {
						 blsAeMap.put(blsAe.getBlsAeId(), blsAe);
					 }
				}
				
			} else {
				blsReList = BlsReLocalServiceUtil.dynamicQuery(dq[0], start, end);	
				ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( BlsReLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
				
				 if ( !blsReList.isEmpty() ) {
					 Set inList = new HashSet<Long>();
					 for ( BlsRe blsRe: blsReList ) {
						 inList.add(blsRe.getBlsAeId());
					 }				
					 blsAeList = BlsAeLocalServiceUtil.dynamicQuery( DynamicQueryFactoryUtil.forClass( BlsAe.class, PortletClassLoaderUtil.getClassLoader() ));					
					 for ( BlsAe blsAe: blsAeList ) {
						 blsAeMap.put(blsAe.getBlsAeId(), blsAe);
					 }
				}
			}
			
			
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
			return Collections.emptyList();
		}
		
		ResultMap.getCaretMap(request).put("blsAeMap", blsAeMap);
		
		return blsReList;
	}
	
	private List<BlsRe> getBlsRates(PortletRequest request, int start, int end) throws SystemException {
		//
		//return BlsReLocalServiceUtil.getBlsRes(start, end);
		
		String zip = request.getParameter("zip");
		String county = request.getParameter("county");
		String state = request.getParameter("state");
		String rateChange = request.getParameter("rateChange");
		
		List<BlsRe> blsReList = null;
		
		try {
			Calendar prevYear = Calendar.getInstance();
			Calendar currentYear = Calendar.getInstance();
		    prevYear.add(Calendar.YEAR, -2);
		    currentYear.add(Calendar.YEAR, -1);

			DynamicQuery blsReListPastYearDynamicQuery = DynamicQueryFactoryUtil.forClass(BlsRe.class, "BlsRePastYearEntry")
					.add(PropertyFactoryUtil.forName(CaretStrPool.YEAR).eq(prevYear.get(Calendar.YEAR)));
			DynamicQuery blsReListCurrentYearDynamicQuery = DynamicQueryFactoryUtil.forClass(BlsRe.class, "BlsReCurrentYearEntry")
					.add(PropertyFactoryUtil.forName(CaretStrPool.YEAR).eq(currentYear.get(Calendar.YEAR)));
					//.setProjection(ProjectionFactoryUtil.property("zip"));
			DynamicQuery blsReListALLDynamicQuery = DynamicQueryFactoryUtil.forClass(BlsRe.class, "BlsReAllEntry");
			
			if ( !Toolbox.isEmpty( zip) ) {
				blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ZIP).eq(zip));
				blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ZIP).eq(zip));
				blsReListALLDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ZIP).eq(zip));
			}
			if ( !Toolbox.isEmpty( county) ) {
				blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.COUNTY).eq(county));
				blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.COUNTY).eq(county));
				blsReListALLDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.COUNTY).eq(county));
			}
			if ( !Toolbox.isEmpty( state) ) {
				blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.STATE).eq(state));
				blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.STATE).eq(state));
				blsReListALLDynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.STATE).eq(state));
			}
			if ( !Toolbox.isEmpty( rateChange) && rateChange.equalsIgnoreCase("rateUp")) {
				blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName("BlsReCurrentYearEntry.h75").gtProperty("BlsRePastYearEntry.h75"))
												.add(PropertyFactoryUtil.forName("BlsReCurrentYearEntry.zip").eqProperty("BlsRePastYearEntry.zip"));
				blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName("zip").in(
						blsReListCurrentYearDynamicQuery.setProjection(ProjectionFactoryUtil.property("zip"))));	
				blsReList = BlsReLocalServiceUtil.dynamicQuery(blsReListPastYearDynamicQuery, start, end);
				ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( BlsReLocalServiceUtil.dynamicQueryCount( blsReListPastYearDynamicQuery ) ).intValue() );
			} else	if (  !Toolbox.isEmpty( rateChange) && rateChange.equalsIgnoreCase("rateDown") ) {
				blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName("BlsReCurrentYearEntry.h75").ltProperty("BlsRePastYearEntry.h75"))
												.add(PropertyFactoryUtil.forName("BlsReCurrentYearEntry.zip").eqProperty("BlsRePastYearEntry.zip"));
				blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName("zip").in(
						blsReListCurrentYearDynamicQuery.setProjection(ProjectionFactoryUtil.property("zip"))));	
				blsReList = BlsReLocalServiceUtil.dynamicQuery(blsReListPastYearDynamicQuery, start, end);
				ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( BlsReLocalServiceUtil.dynamicQueryCount( blsReListPastYearDynamicQuery ) ).intValue() );
			} else if ( !Toolbox.isEmpty( rateChange) && (rateChange.equalsIgnoreCase("missingRate")  || rateChange.equalsIgnoreCase("newZip") )) {
				if ( rateChange.equalsIgnoreCase("missingRate")  ) {
					blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName("zip").notIn(
							blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName("BlsReCurrentYearEntry.zip").eqProperty("BlsRePastYearEntry.zip"))
							.setProjection(ProjectionFactoryUtil.property("zip"))));
					blsReList = BlsReLocalServiceUtil.dynamicQuery(blsReListPastYearDynamicQuery, start, end);
					ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( BlsReLocalServiceUtil.dynamicQueryCount( blsReListPastYearDynamicQuery ) ).intValue() );
				} else if ( rateChange.equalsIgnoreCase("newZip")) {
					blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName("zip").notIn(
							blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName("BlsRePastYearEntry.zip").eqProperty("BlsReCurrentYearEntry.zip"))
							.setProjection(ProjectionFactoryUtil.property("zip"))));
					blsReList = BlsReLocalServiceUtil.dynamicQuery(blsReListCurrentYearDynamicQuery, start, end);
					ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( BlsReLocalServiceUtil.dynamicQueryCount( blsReListCurrentYearDynamicQuery ) ).intValue() );
				} 
			}
			else {
				blsReListPastYearDynamicQuery.add(PropertyFactoryUtil.forName("zip").in(
						blsReListCurrentYearDynamicQuery.add(PropertyFactoryUtil.forName("BlsReCurrentYearEntry.zip").eqProperty("BlsRePastYearEntry.zip"))
				));
				blsReList = BlsReLocalServiceUtil.dynamicQuery(blsReListALLDynamicQuery, start, end);
				ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( BlsReLocalServiceUtil.dynamicQueryCount( blsReListALLDynamicQuery ) ).intValue() );
			}
			
			
			
			 if ( !blsReList.isEmpty() ) {
				 Collection inList = new HashSet<Long>();
				 for ( BlsRe blsRe: blsReList ){
					 inList.add(blsRe.getZip());
				 }
			
				 if ( !inList.isEmpty() ) {
					 List<BlsRe> blsReFinalList = BlsReLocalServiceUtil.dynamicQuery( DynamicQueryFactoryUtil.forClass( BlsRe.class, PortletClassLoaderUtil.getClassLoader() )
							 .add( PropertyFactoryUtil.forName("zip").in(inList)) );
					 return blsReFinalList;
				 	}
				 }
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
			return Collections.emptyList();
		}
		return blsReList;
	}
	
	private List<StipendConfig> getPaymentConfigs(PortletRequest request, int start, int end) throws SystemException, ApplicationWorkFlowException {
		
		String fname = request.getParameter("firstName");
		String lname = request.getParameter("lastName");
		String taxid = request.getParameter("ssn");
		String address = request.getParameter("address");
		String city = request.getParameter("city");
		String zip = request.getParameter("zip");
		long primaryKey = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
		
		Date beginDate = Toolbox.parseDate( request.getParameter("beginDate") );
		Date endDate = Toolbox.parseDate( request.getParameter("endDate") );
		List<StipendConfig> report = new ArrayList<StipendConfig>();

		boolean[] persnSet = new boolean[]{false};
		
		DynamicQuery[] dq = getDqPair(StiPtImpl.class);

		if ( primaryKey > 0 ) {
			StiPt stiPt = StiPtLocalServiceUtil.fetchStiPt(primaryKey);
			if ( stiPt != null ) {
				return Collections.singletonList(new StipendConfig(stiPt)) ;
			}
			for ( DynamicQuery dynQry : dq ){
				dynQry.add(  PropertyFactoryUtil.forName("vcgId").eq( primaryKey ) );
			}
			persnSet[0] = true;
		}
		
		List<Vendr> vendrList = searchVendor(fname, lname, taxid, address, city, zip, persnSet, start, end);
		
		String status = request.getParameter("status");
		String stipendType = request.getParameter("workType");
		if ( WorkType.MANUAL_PAYMENT.name().equals(stipendType) ) {
			stipendType = "one-time";
			if ( StipendConfig.STAGED_PAYMENT.equals( status )  ) {
				
				//TODO:...
			} else if ( CAction.canDoCaret(request, CAction.CaretCan.MANUAL_PAYMENT) && StipendConfig.PAYMENT_FINANCE.equals( status ) ) {
				request.setAttribute ( "staging_", true );
				request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
				ResultMap.getCaretMap(request).put("tabContext", "search" );
				ResultMap.getCaretMap(request).put("lastSearch", request.getPortletSession().getAttribute("lastSearch"));
			} 
		}
		
		boolean vendrSet = false;
		if ( persnSet[0] ){
			Collection<Long> inList = new HashSet<Long>();
			for ( Vendr p: vendrList ){
				inList.add(p.getVendrId());
			}
			if ( ! inList.isEmpty() ){
				for ( DynamicQuery dynQry : dq ){
					dynQry.add(PropertyFactoryUtil.forName("vendrId").in( inList ) );
				}
				vendrSet = true;
			}
		}

		if ( !Toolbox.isEmpty( status ) ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add( PropertyFactoryUtil.forName("stipendStatus").eq(status) ); 
			}
//			persnSet[0] = true;
		}
		
		if ( !Toolbox.isEmpty( stipendType ) ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add( PropertyFactoryUtil.forName("stipendType").eq(stipendType) ); 
				dynQry.add( PropertyFactoryUtil.forName("payment").isNull() ); 
			}
//			persnSet[0] = true;
		}
		
		if ( beginDate != null ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add( PropertyFactoryUtil.forName("stipendStartDate").gt(beginDate) ); 
			}
//			persnSet[0] = true;
		}
		
		if ( endDate != null ) {
			for ( DynamicQuery dynQry : dq ){
				Junction conjunction1 = RestrictionsFactoryUtil.conjunction();
				conjunction1.add( PropertyFactoryUtil.forName("payslipDate").isNull() )
					.add( PropertyFactoryUtil.forName("stipendType").eq(StipendConfig.ONE_TIME) );

				Junction conjunction2 = RestrictionsFactoryUtil.conjunction();
				conjunction2.add( PropertyFactoryUtil.forName("stipendType").ne(StipendConfig.ONE_TIME) )
					.add( PropertyFactoryUtil.forName("stipendStatus").eq( StipendConfig.PAYMENT_FINANCE ) );
				
				Junction disjunction = RestrictionsFactoryUtil.disjunction();
				disjunction.add( conjunction2 ).add( conjunction1 );
				dynQry.add( disjunction );
			}
//			persnSet[0] = true;
		}
		
//		List<Persn> persnList = setPerson ( DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() ), request, true, persnSet );
//		 if ( persnSet[0] && !persnList.isEmpty() ){
//			 //TODO: there is a missing business rule as to tying ACTIVE_VCG with unverified identities coming in from CSC-APPS
//			 // dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(CaretStrPool.ACTIVE_VCG) );
////			 dynamicQuery.setProjection( PropertyFactoryUtil.forName("persnId") );
////			 try {
////				inList = PersnLocalServiceUtil.dynamicQuery(dynamicQuery);
////			} catch (SystemException e) {
////				ApplicationWorkFlowException.handleException(e);
////			}
//			 Collection inList = new HashSet<Long>();
//			 for ( Persn p: persnList ){
//				 inList.add(p.getPersnId());
//			 }
//		
//			 if ( !inList.isEmpty() ) {
//				 List<Long> vcgIds = PersnLocalServiceUtil.dynamicQuery( DynamicQueryFactoryUtil.forClass( VcgImpl.class, PortletClassLoaderUtil.getClassLoader() )
//						 .setProjection( PropertyFactoryUtil.forName( CaretStrPool.VCGID ) )
//						 .add( PropertyFactoryUtil.forName("primaryId").in(inList)) );
//				 for ( DynamicQuery dynQry : dq ){
//						dynQry.add(PropertyFactoryUtil.forName("vcgId").in( vcgIds ) );
//					}
//			 	}
//			 }
		if ( !persnSet[0] || !vendrSet ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add(PropertyFactoryUtil.forName("vendrId").ne( new Long(0) ) );
			}
		}
		
//		if ( !persnSet[0] ){
//			 try {
//				for ( StiPt stiPt : StiPtLocalServiceUtil.getStiPts(start, end) ){
//					report.add( new StipendConfig (stiPt) );
//				}
//			} catch (SystemException e) {
//				ApplicationWorkFlowException.handleException(e);
//			}
//			 ResultMap.getResultTotalMap( request ).put( getName(), StiPtLocalServiceUtil.getStiPtsCount() );
//		 } else {
			 for ( StiPt stiPt : (List<StiPt>)StiPtLocalServiceUtil.dynamicQuery( dq[0], start, end) ){
				report.add( new StipendConfig (stiPt) );
			}
			 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( StiPtLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
//		 }
		 
		 return report;
	}
	private List<? extends PayLg> getPayments(PortletRequest request, int start, int end) throws SystemException, ApplicationWorkFlowException {

		String fname = request.getParameter("firstName");
		String lname = request.getParameter("lastName");
		String taxid = request.getParameter("ssn");
		String address = request.getParameter("address");
		String city = request.getParameter("city");
		String zip = request.getParameter("zip");
		Date beginDate = Toolbox.parseDate( request.getParameter("beginDate") );
		Date endDate = Toolbox.parseDate( request.getParameter("endDate") );
		long vendrId = ParamUtil.getLong(request, "classPk");
		long stipPtId = ParamUtil.getLong(request, "defId");
		long primaryKey = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);

		
		List<PaymentLog> report = new ArrayList<PaymentLog>();
		if ( stipPtId > 0 ) {
			for(PayLg payLg: PayLgLocalServiceUtil.findByConfig(stipPtId, start, end)) {
				report.add(new PaymentLog(payLg));
			}
			return report;
		}
		
		if ( vendrId > 0 ) {
			for(PayLg payLg: PayLgLocalServiceUtil.findByVendor(vendrId, start, end)) {
				report.add(new PaymentLog(payLg));
			}
			return report;
		}
		
		boolean[] persnSet = new boolean[]{false};
		
		DynamicQuery[] dq = getDqPair(PayLgImpl.class);
		

		if ( primaryKey > 0 ) {
			PayLg payLg = PayLgLocalServiceUtil.fetchPayLg(primaryKey);
			if ( payLg != null ) {
				return Collections.singletonList(new PaymentLog(payLg)) ;
			}
			Collection<Long> inList = new HashSet<Long>();
			for ( StiPt c : StiPtLocalServiceUtil.findByVcg( primaryKey, -1, -1, null) ) {
				inList.add( c.getStiPtId() );
			}
			for ( DynamicQuery dynQry : dq ){
				dynQry.add(  PropertyFactoryUtil.forName("stiPtId").in( inList ) );
			}
			persnSet[0] = true;
		}
		
		List<Vendr> persnList = searchVendor(fname, lname, taxid, address, city, zip, persnSet, start, end);
		
		if ( persnSet[0] ){
			Collection<Long> inList = new HashSet<Long>();
			for ( Vendr p: persnList ){
				inList.add(p.getVendrId());
//				for ( StiPt c : StiPtLocalServiceUtil.findByVendorId( p.getVendrId(), start, end ) ) {
//					inList.add( c.getStiPtId() );
//				}
			}
			if ( ! inList.isEmpty() ){
				for ( DynamicQuery dynQry : dq ){
					dynQry.add(PropertyFactoryUtil.forName("vendrId").in( inList ) );
				}
			}
		}
		
		if ( beginDate != null ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add( PropertyFactoryUtil.forName("creationDate").gt(beginDate) ); 
			}
			persnSet[0] = true;
		}
		
		if ( endDate != null ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add( PropertyFactoryUtil.forName("creationDate").lt(endDate) ); 
			}
			persnSet[0] = true;
		}

		long cycleId = ParamUtil.getLong(request, "cycleId");//639812
		if ( cycleId > 0 ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add( PropertyFactoryUtil.forName("cycleId").eq(cycleId) ); 
			}
			persnSet[0] = true;
		}
		
		 
		String status = request.getParameter("status");
		if ( !Toolbox.isEmpty( status ) ) {
			for ( DynamicQuery dynQry : dq ){
				dynQry.add( PropertyFactoryUtil.forName("status").eq(status) ); 
			}
			persnSet[0] = true;
		}
		
		 if ( !persnSet[0] ){
			 try {
				for ( PayLg vcg : PayLgLocalServiceUtil.getPayLgs(start, end) ){
					report.add( new PaymentLog (vcg) );
				}
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			 ResultMap.getResultTotalMap( request ).put( getName(), PayLgLocalServiceUtil.getPayLgsCount() );
		 } else {
			 for ( PayLg vcg : (List<PayLg>)PayLgLocalServiceUtil.dynamicQuery( dq[0], start, end) ){
				report.add( new PaymentLog (vcg) );
			}
			 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( PayLgLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
		 }
		 
		 return report;
	}
	
	private void cacheSearchForm(PortletRequest request) {
		Map<String,Object> form = ResultMap.getForm (request);
		Person person = new Person( new PersnImpl() );
		if ( !Toolbox.isEmpty(request.getParameter("birthDate") ) ) {
			person.setBirthDateStr( request.getParameter("birthDate") );
		}
		person.setSsn( request.getParameter("ssn") );
		person.setFirstName(request.getParameter("firstName") );
		person.setLastName( request.getParameter("lastName") );
		person.setPhone( request.getParameter("phone") );
		form.put("searchPerson", person);
		form.put("userOrgId", request.getParameter("userOrgIds") );
		form.put(CaretStrPool.PRIMARY_KEY, request.getParameter(CaretStrPool.PRIMARY_KEY) );
		form.put("roleId", request.getParameter("roleId") );
		form.put("status", request.getParameter("status") );
		form.put("workType", request.getParameter("workType") );
		form.put("searchContext", request.getParameter("page") );
		request.getPortletSession().setAttribute("searchForm", form);
	}

	public void cacheSearchForm0(PortletRequest request) {
		Map<String,Object> form = new HashMap<String,Object>();
		for ( Enumeration<String> enume = request.getParameterNames(); enume.hasMoreElements(); ) {
			String name = enume.nextElement();
			form.put( name, request.getParameter(name) );
		}
		request.getPortletSession().setAttribute("cacheSearchForm", form);
	}

	private List<AudLg> getAudit(PortletRequest request, int start, int end ) {
		DynamicQuery[] dq = getDqPair(AudLgImpl.class);
		dq[0].add( PropertyFactoryUtil.forName( "classPk" ).eq( ParamUtil.getLong(request, "classPk" ) ) ).addOrder( OrderFactoryUtil.desc("modifiedDate") );
		dq[1].add( PropertyFactoryUtil.forName( "classPk" ).eq( ParamUtil.getLong(request, "classPk" ) ) );
		
		if ( !Toolbox.isEmpty( request.getParameter( "modifiedDate" ) ) ){
			dq[0].add( PropertyFactoryUtil.forName( "modifiedDate" ).eq( request.getParameter( "modifiedDate" ) ) );
			dq[1].add( PropertyFactoryUtil.forName( "modifiedDate" ).eq( request.getParameter( "modifiedDate" ) ) );
		}
		List<AudLg> report = new ArrayList<AudLg>();
		try {
			@SuppressWarnings("unchecked")
			List<AudLg> list = (List<AudLg>) AudLgLocalServiceUtil.dynamicQuery( dq[0], start, end );
			for ( AudLg audLg:  list ){
				report.add( new AuditLogSupport(audLg) );
			}
			ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( AudLgLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return report;
	}

	
	private List getAssmtAudit(PortletRequest request, int start, int end) {
		
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( AudLgImpl.class, PortletClassLoaderUtil.getClassLoader() );
		dynamicQuery.add( PropertyFactoryUtil.forName( "classPk" ).eq( ParamUtil.getLong(request, CaretStrPool.ASSMT_ID ) ) )
		.addOrder( OrderFactoryUtil.desc("modifiedDate") );

		List report = new ArrayList();
		try {
			List<AudLg> list = (List<AudLg>) AudLgLocalServiceUtil.dynamicQuery( dynamicQuery, start, end );

			for ( AudLg audLg:  list ){

			    if(audLg.getAttribute().equals("completionDate"))
			    {
					try {
						//EEE MMM dd HH:mm:ss z yyyy
						if(audLg.getOldValue()!= null && !audLg.getOldValue().equals("null")){
							Date oldValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(audLg.getOldValue());
							audLg.setOldValue(Toolbox.getDateFormatCprs().format(oldValue));
						}else if(audLg.getOldValue()!= null && audLg.getOldValue().equals("null")){
							audLg.setOldValue("");
						}
	
				    	Date newValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(audLg.getNewValue());
				    	audLg.setNewValue(Toolbox.getDateFormatCprs().format(newValue));
					} catch (ParseException e) {
						ApplicationWorkFlowException.handleException(e);
					}
			    }
				
				report.add( new AuditLogSupport(audLg) );
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return report;
	}

	private List getAssmtAuditAll(PortletRequest request, int start, int end, String category)
	{
		List<AssmtAuditBean> allHistory = new ArrayList<AssmtAuditBean>();
		
		try 
		{	
			long vcgId = ParamUtil.getLong(request, "vcgId", 0);

			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("vcgId", Long.toString(vcgId));	
			
			String assmtTypes = "";
			if(category.equals(CaretStrPool.ASSMT_INITIAL)){
				assmtTypes = "'"+CaretStrPool.PRIMARY_ASSESSMENT+"','"+CaretStrPool.PRIMARY_CLINICAL+"','"+CaretStrPool.PRIMARY_TRAINING+"','"+CaretStrPool.PRIMARY_IN_HOME
						+"','"+CaretStrPool.SECONDARY_ASSESSMENT+"','"+CaretStrPool.SECONDARY_CLINICAL+"','"+CaretStrPool.SECONDARY_TRAINING
						+"','"+CaretStrPool.SECONDARY_TWO_ASSESSMENT+"','"+CaretStrPool.SECONDARY_TWO_ASSESSMENT+"','"+CaretStrPool.SECONDARY_TWO_ASSESSMENT+"'";
			}else{
				assmtTypes = "'"+CaretStrPool.QUARTER1+"','"+CaretStrPool.QUARTER2+"','"+CaretStrPool.QUARTER3+"','"+CaretStrPool.ANNUAL+"'";
			}
			
			paramMap.put("assmtTypes", assmtTypes);	
			
			List<Map<String, Object>> list = CaretLocalServiceUtil.getReport("assmtHistoryAll", paramMap, start, end);
			
			AssmtAuditBean oneHistory;
			for (Map<String, Object> map : list) {
				oneHistory = new AssmtAuditBean();

			    for (Map.Entry<String, Object> entry : map.entrySet()) {
			        String key = entry.getKey();
			        String value = entry.getValue().toString();
			        
			        //_log.info("key/value pair is :"+key+"/"+value);
			        //For reference
			        //ndx0 - audlgid - audit id	//ndx1 - classpk - assmt id	//ndx2 - attribute	//ndx3 - oldvalue	//ndx4 - newvalue	//ndx5 - modifiedbyid
			        //ndx6 - modifieddate	//ndx7 - (prsn.lastname ||', '|| prsn.firstname)	//ndx8 - assmt.TYPE_	
			        	
			        if(key.equals("ndx1")){
			        	oneHistory.setAuditLogId(value);
			        }else if(key.equals("ndx3")){
			        	oneHistory.setAttribute(value);
			        }if(key.equals("ndx4")){
			        	oneHistory.setOldValue(value);
			        }else if(key.equals("ndx5")){
			        	oneHistory.setNewValue(value);
			        }else if(key.equals("ndx7")){
			        	oneHistory.setModifiedDate(value);
			        }else if(key.equals("ndx8")){
			        	oneHistory.setModifiedByName(value);
			        }else if(key.equals("ndx9")){
			        	oneHistory.setAssmtType(value);
			        }else if(category.equals(CaretStrPool.ASSMT_PERIODIC) && key.equals("ndx10")){
			        	oneHistory.setScheduleDate(value);
			        }		        
			    }

			    if(oneHistory.getAttribute().equals("completionDate")){
			    	
					try 
					{
						//EEE MMM dd HH:mm:ss z yyyy
						if(oneHistory.getOldValue()!= null && !oneHistory.getOldValue().equals("null")){
							Date oldValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(oneHistory.getOldValue());
					    	oneHistory.setOldValue(Toolbox.getDateFormatCprs().format(oldValue));
						}else if(oneHistory.getOldValue()!= null && oneHistory.getOldValue().equals("null")){
							oneHistory.setOldValue("");
						}
	
				    	Date newValue = (Date) Toolbox.getDateTimeFormatExpanded().parseObject(oneHistory.getNewValue());
				    	oneHistory.setNewValue(Toolbox.getDateFormatCprs().format(newValue));
					} catch (ParseException e) {
						ApplicationWorkFlowException.handleException(e);
					}
			    }

			    allHistory.add(oneHistory);
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
		return allHistory;
	}
	

	private List getPeriodicAssessmentsAll(PortletRequest request, int start, int end)
	{
		List<AssmtSupport> periodicAssessmentList = new ArrayList<AssmtSupport>();
		try 
		{	
			long vcgId = ParamUtil.getLong(request, "vcgId", 0);
			long primaryId = ParamUtil.getLong(request, "primaryId", 0);
						
			List<Assmt> assessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:assessmentList)
			{
				if(assessment.isActive() && assessment.getCaregiverId()==primaryId
						&& (assessment.getType().equals(CaretStrPool.QUARTER1)||assessment.getType().equals(CaretStrPool.QUARTER2)||assessment.getType().equals(CaretStrPool.QUARTER3)||assessment.getType().equals(CaretStrPool.ANNUAL)))
				{
					AssmtSupport assmtSupport = new AssmtSupport(assessment);
					
					String scheduleDateStr = Toolbox.formatDateCprs(assessment.getScheduleDate());				
					String completionDateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());
										
					assmtSupport.setFormattedScheduleDate(scheduleDateStr);					
					assmtSupport.setFormattedcompletionDate(completionDateStr);		
					periodicAssessmentList.add(assmtSupport);
				}
			}	

		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
		return periodicAssessmentList;
	}


	private List<DocumentSupport> getVcgSupportingDocsAll(PortletRequest request, int start, int end)
	{
		List<DocumentSupport> allDocsTemp = new ArrayList<DocumentSupport>();
		List<DocumentSupport> allDocs = new ArrayList<DocumentSupport>();
	
		VcgSupport vcgSupport = null;
		long vcgId = ParamUtil.getLong(request, "vcgId", 0);

		if(vcgId!=0){
			vcgSupport = VcgSupport.getVcgSupport(vcgId);
			vcgSupport.getSupportingDocData();
			allDocsTemp = vcgSupport.getVcgDocsAll();
			
			boolean hasDocumentAccess = false;
			boolean hasDeleteAccess = false;
			if (CAction.canDoCaret(request, CaretCan.VIEW_DELETED_DOCS.name())){
				hasDocumentAccess = true;
			}
			if (CAction.canDoCaret(request, CaretCan.UPLOAD_VCG_FILE.name())){
				hasDeleteAccess = true;
			}
			
			for(DocumentSupport oneDocument:allDocsTemp){
				oneDocument.setHasDocumentAccess(hasDocumentAccess);
				oneDocument.setHasDeleteAccess(hasDeleteAccess);
				allDocs.add(oneDocument);
			}
		}

		return allDocs;
	}
	
	
	private List<AuditLogSupport> getVcgDocsHistoryAll(PortletRequest request, int start, int end)
	{
		List<AuditLogSupport> allHistory = new ArrayList<AuditLogSupport>();
		
		try 
		{	
			long vcgId = ParamUtil.getLong(request, "vcgId", 0);
			//_log.info("getVcgDocsHistoryAll : vcgid is : "+vcgId);

			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("vcgId", Long.toString(vcgId));					
			
			List<Map<String, Object>> list = CaretLocalServiceUtil.getReport("vcgDocsHistoryAll", paramMap, start, end);		
			
			AuditLogSupport oneHistory;
			for (Map<String, Object> map : list) {
				oneHistory = new AuditLogSupport(new AudLgImpl());

			    for (Map.Entry<String, Object> entry : map.entrySet()) {
			        String key = entry.getKey();
			        String value = entry.getValue().toString();
			        
			        //For reference
			        //ndx1 - audlgid - audit id	//ndx2 - classpk - document id	//ndx3 - attribute- Document //ndx4 - oldvalue	//ndx5 - newvalue	//ndx6 - modifiedbyid
			        //ndx7 - modifieddate	//ndx8 - (prsn.lastname ||', '|| prsn.firstname)	//ndx9 - note - doc note //ndx10 - name - doc name	
			        if(value!=null && !value.equals("")){
				        //_log.info("key/value pair is :"+key+"/"+value);
				        if(key.equals("ndx1")){
				        	oneHistory.setAudLgId(Long.valueOf(value).longValue());
				        }else if(key.equals("ndx3")){
				        	oneHistory.setAttribute(value);
				        }if(key.equals("ndx4")){
				        	oneHistory.setOldValue(value);
				        }else if(key.equals("ndx5")){
				        	oneHistory.setNewValue(value);
				        	//if(!value.equals("DELETED")){
				        	//	oneHistory.setDocDeleteComment("");
				        	//}
				        }else if(key.equals("ndx7")){
				        	oneHistory.setModifiedDateStr(value);
				        }else if(key.equals("ndx8")){
				        	oneHistory.setModifiedByFullName(value);
				        }else if(key.equals("ndx10")){
					        oneHistory.setDocumentName(value);				        						        		
				        }	       			        	
			        }
			    }
			    
			    for (Map.Entry<String, Object> entry : map.entrySet()) {
			        String key = entry.getKey();
			        String value = entry.getValue().toString();

			        if(value!=null && !value.equals("")){
			        	if(key.equals("ndx9")){
				        	if((oneHistory.getNewValue()!=null && oneHistory.getNewValue().equals("DELETED"))){
				        		oneHistory.setDocDeleteComment(value);				        		
				        	}
				        }
			        }
			    }

			    if(oneHistory.getAudLgId()!=0){
				    allHistory.add(oneHistory);			    	
			    }			    
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
		return allHistory;
	}
	
	public List<? extends Vcg> getVcgList ( PortletRequest request, int start, int end ) throws SystemException {
		
		String roleName = request.getParameter("roleName");
		
		int roleId = ParamUtil.getInteger(request, "roleId", 0);
		if ( Toolbox.isEmpty( roleName ) && request.getParameter("roleId") != null ){
			switch(roleId){
			case 1: roleName = "veteran"; break;
			case 2: roleName = "primary"; break;
			case 3: roleName = "secondary"; break;
			case 4: roleName = "secondaryTwo"; break;
			case 5: roleName = "general"; break;
			default:				
			}
		}
		long primaryKey = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
		
		if ( primaryKey > 0 ) {
			Vcg vcg = VcgLocalServiceUtil.fetchVcg(primaryKey);
			if ( vcg != null ) {
				VcgSupport vcgSupport = new VcgSupport(vcg);
				vcgSupport.setViewable(request);
				return Collections.singletonList( vcgSupport ) ;
			}
		}
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 
//		 Collection inList = Collections.emptyList();
		 List report = new ArrayList();
		 boolean useAll = false;
		 boolean[] persnSet = new boolean[]{false};
		 List<Persn> persnList = setPerson ( dynamicQuery, request, true, persnSet );
		 Set<Long> groups = getGroups(request);
		 if ( (persnSet[0] && !persnList.isEmpty() ) || !groups.isEmpty() ){
			 
			 DynamicQuery[] dq = getDqPair(VcgImpl.class);
			 Collection inList = new HashSet<Long>();
			 if ( ! persnList.isEmpty() ){
				 for ( Persn p: persnList ){
					 inList.add(p.getPersnId());
				 }
			}
			if ( ! persnList.isEmpty() ){
				for ( DynamicQuery dynQry : dq ){
					dynQry.add(PropertyFactoryUtil.forName(roleName + "Id").in( inList) );
				}
			}

			if ( !groups.isEmpty() ) {
				for ( DynamicQuery dynQry : dq ){
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.GROUP_ID).in(groups));
				}
			}

				try {
					 for ( Vcg vcg : (List<Vcg>)VcgLocalServiceUtil.dynamicQuery( dq[0], start, end ) ){
						 VcgSupport vcgSupport = new VcgSupport(vcg);
						 vcgSupport.setViewable(request);
						 report.add( vcgSupport );
					 }
					 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( VcgLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
					 
					 return report;
				 } catch (SystemException e) {
					 ApplicationWorkFlowException.handleException(e);
				 }
			 
		 } 
		 if ( useAll ){
			 try {
				for ( Vcg vcg : VcgLocalServiceUtil.getVcgs(start, end) ){
					VcgSupport vcgSupport = new VcgSupport(vcg);
					vcgSupport.setViewable(request);
					report.add( vcgSupport );
				}
				ResultMap.getResultTotalMap( request ).put( getName(), VcgLocalServiceUtil.getVcgsCount() );
				return report;
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		 }
		 
		 return Collections.emptyList(); 
	}
	
	private List<Persn> setPerson(DynamicQuery dynamicQuery, PortletRequest request, boolean verified, boolean[] persnSet ) {
		String fname = request.getParameter("firstName");
		String lname = request.getParameter("lastName");
		String ssn = request.getParameter("ssn");
		String birthDate = request.getParameter("birthDate");
		String phone = request.getParameter("phone");
		String phone2 = null;
		
		return searchPerson(fname, lname, null, ssn, phone, phone2, null, null, null, null, null, Toolbox.parseDate(birthDate), verified, persnSet);
//		if ( !Toolbox.isEmpty(firstName) ){
//			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).eq(firstName) );
//			 persnSet = true;
//		 }
//		 
//		 if ( !Toolbox.isEmpty(lastName) ){
//			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(lastName) );
//			 persnSet = true;
//		 }
//		 
//		 if ( !Toolbox.isEmpty(phone) && !Person.PHONE_FORMAT.equals( phone ) ){
//			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.PHONE).eq( phone ) );
//			 persnSet = true;
//		 }
//		 Toolbox.subtractFromNow(.5);
////		 if ( !Toolbox.isEmpty(phone) ){ //&& roleId > 0 
////			persnSet = true;
////			Junction junction = RestrictionsFactoryUtil.disjunction();
////			junction.add( PropertyFactoryUtil.forName("phone").eq(phone) );
////			junction.add( PropertyFactoryUtil.forName("phone2").eq(phone) );
////			dynamicQuery.add( junction );
////		}
//		 
//		 Date birthDay = Toolbox.parseDate(birthDate);
//		 if ( birthDay != null ){ // && roleId > 0 
//			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(birthDate) );
//			persnSet = true;
//		}
//		 
//		 if ( !Toolbox.isEmpty(ssn) && !Person.SSN_FORMAT.equals(ssn) ){
//		 dynamicQuery.add( PropertyFactoryUtil.forName("persnId").in( DynamicQueryFactoryUtil.forClass( gov.va.caret.model.impl.CryptoImpl.class, PortletClassLoaderUtil.getClassLoader() )
//				 .setProjection(com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil.property( "ownerId" ) )
//				 .add(PropertyFactoryUtil.forName("value").eq(ssn) ) ) );
//		 persnSet = true;
//	 }
		 
	}
	
	private List<Long> setPersonIds(DynamicQuery dynamicQuery, PortletRequest request, boolean verified, boolean[] persnSet ) {
		String fname = request.getParameter("firstName");
		String lname = request.getParameter("lastName");
		String ssn = request.getParameter("ssn");
		String birthDate = request.getParameter("birthDate");
		String phone = request.getParameter("phone");
		String phone2 = null;
		
		List<Long> persons = searchPersonIds(fname, lname, null, ssn, phone, phone2, null, null, null, null, null, Toolbox.parseDate(birthDate), verified, persnSet);

		String personsSize = CollectionUtils.isNotEmpty(persons) ? persons.size() + "" : "EMPTY";
		//_log.info("CachedReport.getCallList.setPersonIds: persons size: " + personsSize);
		return persons;
	}	


	public List<Map<String,Object>> getPendingSocList ( PortletRequest request, int start, int end ) throws SystemException {
		return getSocList(request, start, end, true);
	}
	public List<Map<String,Object>> getCompletedSocList ( PortletRequest request, int start, int end ) throws SystemException {
		return getSocList(request, start, end, false);
	}
	private List<Map<String,Object>> getSocList ( PortletRequest request, int start, int end, boolean isPending) throws SystemException {
		(LogFactoryUtil.getLog( CachedReport.class)).info("getSocList: start: " + start + " end: " + end + " pending: " + isPending);
		//
		SearchParms searchUtil = getSearchUtil(request);
		if (Toolbox.isEmpty(searchUtil.getRoleName())) {
			DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( SearchParms.class, PortletClassLoaderUtil.getClassLoader());;
			dynamicQuery.add( PropertyFactoryUtil.forName("userId").eq(PortalUtil.getUserId(request)) );
			try {
			@SuppressWarnings("unchecked")
			List<SearchParms> list = (List<SearchParms>) SearchParmsLocalServiceUtil.dynamicQuery( dynamicQuery);
			searchUtil = list.get(0);
			} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
			} 
		}
		
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( SearchParms.class, PortletClassLoaderUtil.getClassLoader());;
		dynamicQuery.add( PropertyFactoryUtil.forName("userId").eq(PortalUtil.getUserId(request)) );
		try {
		@SuppressWarnings("unchecked")
		List<SearchParms> list = (List<SearchParms>) SearchParmsLocalServiceUtil.dynamicQuery( dynamicQuery);
			for(SearchParms su: list) {
				SearchParmsLocalServiceUtil.deleteSearchParms(su);
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		 
		//insert is slower than reports............something to keep track of..........
		// maybe use an Oracle View instead /evaluate and maybe replace later...........
		//
		SearchParmsLocalServiceUtil.updateSearchParms(searchUtil);
		GenericReport gReport = 
		isPending ?
				SocCachedReportUtil.getPendingSOCRecords(request,start,end) :
				SocCachedReportUtil.getCompletedSOCRecords(request,start,end);
		Object o = ResultMap.getResultListMap( request ).get(gReport.getName());
		//pass a parameter (boolean) to turn on or off header sorting 
		if (o != null) {
			List<Map<String,Object>> ret = (List<Map<String,Object>>) o;
			//if (ret.size() > 0) {
				//Map<String,Object> map = ret.get(0);
				//long sessionSearchUtilId = ((BigDecimal) map.get("ndx19")).longValue();
				//(LogFactoryUtil.getLog( CachedReport.class)).info("CachedReport.getSocList: sessionSearchUtilId: " + sessionSearchUtilId);
			//}
			return ret;
		}
		return Collections.emptyList(); 
		}

	

	public List<Call> getCallList ( PortletRequest request, int start, int end ) {
//		String firstName = request.getParameter("firstName");
//		String lastName = request.getParameter("lastName");
//		String ssn = request.getParameter("ssn");
//		String birthDateStr = request.getParameter("birthDate");
		
		//
		String beginDateStr = request.getParameter("beginDate");
		String endDateStr = request.getParameter("endDate");
		String roleName = request.getParameter("roleName");
//		String phone = request.getParameter("phone");
		String dateType = request.getParameter("dateType");
		String status = request.getParameter("status");
		String callCategory = request.getParameter("callCategory");
		Long responder = ParamUtil.getLong(request, "responder");
		Long primaryKey = ParamUtil.getLong(request, "primaryKey");
		if (primaryKey != null && primaryKey.longValue() > 0) {
			Call call = null;
			try {
				call = CallLocalServiceUtil.fetchCall(primaryKey.longValue());
			}
			catch(Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
			if (call != null) {
				return Arrays.asList(new Call[]{new CallSupport(call)});
			}
		}

		int roleId = ParamUtil.getInteger(request, "roleId", 0);
		if ( roleName == null && request.getParameter("roleId") != null ){
			switch(roleId){
			case 1: roleName = "veteranPersnId"; break;
			case 2: case 3:
			case 4: roleName = "callerPersnId"; break;
			default:				
			}
		}
		
		boolean persnSet = false;
		List<Long> persnIds = null;
		
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 
		 if ( roleId == 3 ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(CaretStrPool.UNKNOWN_IDENTITY) );
			 persnSet = true;
		 } else {
			 boolean[] persnBool = new boolean[]{ false };
			 persnIds = setPersonIds ( dynamicQuery, request, false, persnBool );
			 persnSet = persnBool[0];
			 
			 if ( roleId == 1 ){
				 Set<Long> groups = getGroups(request);
				 if ( !groups.isEmpty() ){
					 dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.GROUP_ID).in(groups));
					 persnSet = true;
				}
			 }
		 }

		 List<Call> report = new ArrayList<Call>();
		 @SuppressWarnings("unchecked")
		 List<Criterion> criteria = new ArrayList<Criterion>();
//		 Criterion c = CaretStrPool.REFFERALS.equals( getName() )? 
//				 PropertyFactoryUtil.forName("workPrimaryKey").gt( 0l ) :
//			     PropertyFactoryUtil.forName("workPrimaryKey").eq( 0l );
//				 //PropertyFactoryUtil.forName("workPrimaryKey").eq( 0 );
//		criteria.add(c);
		
		String[] callStateForReferrals = new String[]{"CREATE_REFERRAL","send-referral","call-attempt1","call-attempt2","completed-referral-with-contact","completed-referral-without-contact","complete"};	 
		Criterion c = null;
		if ( CaretStrPool.REFFERALS.equals( getName() ) ){
			
			//this works well
			c = PropertyFactoryUtil.forName("workPrimaryKey").gt( 0l );
			criteria.add(c);
			criteria.add( PropertyFactoryUtil.forName("callState").in(callStateForReferrals));
		}
				
		Date beginDate = Toolbox.parseDate(beginDateStr);
		if ( beginDate != null ){
			criteria.add( PropertyFactoryUtil.forName(dateType).gt( beginDate ) );
		}
		Date endDate = Toolbox.parseDate(endDateStr);
		if ( endDate != null ){
			criteria.add( PropertyFactoryUtil.forName(dateType).lt( Toolbox.adjustDate(1, endDate, true) ) );
		}
		
		if ( !Toolbox.isEmpty(status) ){
			criteria.add( PropertyFactoryUtil.forName("callState").eq( status ) );
		}
		
		if ( !Toolbox.isEmpty(callCategory) ){
			criteria.add( PropertyFactoryUtil.forName("callType").eq( callCategory ) );
		}
		
//		if ( persnSet ){
//			 dynamicQuery.setProjection( PropertyFactoryUtil.forName( CaretStrPool.PERSN_ID ) );
//			 try {
//				 Collection<Persn> inList = PersnLocalServiceUtil.dynamicQuery(dynamicQuery);
//				if ( ! inList.isEmpty() ){
//					criteria.add( PropertyFactoryUtil.forName(roleName).in( inList) );
//				} else {
//					criteria.add( PropertyFactoryUtil.forName(roleName).eq( 0l ) );
//				}
//			} catch (SystemException e) {
//				ApplicationWorkFlowException.handleException(e);
//			}
//		 }
		if ( persnSet ){
			if (CollectionUtils.isNotEmpty(persnIds)) {
				criteria.add( PropertyFactoryUtil.forName(roleName).in( persnIds ) );
			}	
			else {
				criteria.add( PropertyFactoryUtil.forName(roleName).eq( 0l ) );
			}
		}
		
		DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
		long roleIds[] = new long[]{ dashConfig.getRoleId() };
		if ( "CSL_SUP".equals( CodifiedRole.getCode( dashConfig.getRole() ) ) ){
			try {
				roleIds = new long[]{ dashConfig.getRoleId(), RoleLocalServiceUtil.getRole(PortalUtil.getCompanyId(request), CodifiedRole.getRoleName("CSL_GEN") ).getRoleId() };
			} catch (PortalException | SystemException e) {
				e.printStackTrace();
			}
		}
		criteria.add(PropertyFactoryUtil.forName("createGroupId").in( roleIds ) );
		if ( responder > 0 ){
			criteria.add(PropertyFactoryUtil.forName("userId").eq( responder ) );
		}
		String resultIds = "";		 
		 DynamicQuery[] dq = getDqPair(CallImpl.class, criteria);

			 try {
				 for ( Call call : (List<Call>)CallLocalServiceUtil.dynamicQuery( dq[0], start, end ) ){
					 resultIds += call.getCallId() + " ";
					 report.add( new gov.va.caret.model.support.CallSupport(call) );
				 }
				 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( CallLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
			 } catch (SystemException e) {
				 ApplicationWorkFlowException.handleException(e);
			 }
//		 }
		 return report;
	}
	
	public List<Call> getIncompleteReferrals ( PortletRequest request, int start, int end ) {
		
//		String firstName = request.getParameter("firstName");
//		String lastName = request.getParameter("lastName");
////		String ssn = request.getParameter("ssn");
//		String birthDateStr = request.getParameter("birthDate");
		
		String beginDateStr = request.getParameter("beginDate");
		String endDateStr = request.getParameter("endDate");
		String roleName = request.getParameter("roleName");
		String phone = request.getParameter("phone");
		String dateType = request.getParameter("dateType");
		String status = request.getParameter("status");
		//String callCategory = request.getParameter("callCategory");
		String callCategory = "Referral";
		Long responder = ParamUtil.getLong(request, "responder");

		int roleId = ParamUtil.getInteger(request, "roleId", 0);
		if ( roleName == null && request.getParameter("roleId") != null ){
			switch(roleId){
			case 1: roleName = "veteranPersnId"; break;
			case 2: 
			case 3:
			case 4: roleName = "callerPersnId"; break;
			default:				
			}
		}

		boolean persnSet = false;
		
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 
		 if ( roleId == 3 ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(CaretStrPool.UNKNOWN_IDENTITY) );
			 persnSet = true;
		 } else {
			 boolean[] persnBool = new boolean[]{ false };
			 setPerson ( dynamicQuery, request, false, persnBool );
			 persnSet = persnBool[0];
			 
			 if ( roleId == 1 ){
				 Set<Long> groups = getGroups(request);
				 if ( !groups.isEmpty() ){
					 dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.GROUP_ID).in(groups));
					 persnSet = true;
				}
			 }
		 }
		 
		 List<Call> report = new ArrayList<Call>();

	    List<Criterion> criteria = new ArrayList<Criterion>();
	    Criterion c = PropertyFactoryUtil.forName("workPrimaryKey").gt( 0l );
		criteria.add(c);		 
		
		Date beginDate = Toolbox.parseDate(beginDateStr);
		if ( beginDate != null ){
			criteria.add( PropertyFactoryUtil.forName(dateType).gt( beginDate ) );
		}
		Date endDate = Toolbox.parseDate(endDateStr);
		if ( endDate != null ){
			criteria.add( PropertyFactoryUtil.forName(dateType).lt( Toolbox.adjustDate(1, endDate, true) ) );
		}
		
		if ( !Toolbox.isEmpty(status) && 
			 Arrays.asList("completed-referral-with-contact","completed-referral-without-contact","complete","completed").contains(status)) {
			 criteria.add( PropertyFactoryUtil.forName("callState").eq( status ) );			
		}
		else { 
			criteria.add( PropertyFactoryUtil.forName("callState").ne("completed-referral-with-contact"));
			criteria.add( PropertyFactoryUtil.forName("callState").ne("completed-referral-without-contact"));
			criteria.add( PropertyFactoryUtil.forName("callState").ne("complete"));
			criteria.add( PropertyFactoryUtil.forName("callState").ne("completed"));
			if ( !Toolbox.isEmpty(status) ) {
				criteria.add( PropertyFactoryUtil.forName("callState").eq( status ) );
			}
		}
		
		Long hecRoleId = new Long(0);
		try {
			hecRoleId = RoleLocalServiceUtil.getRole(PortalUtil.getCompanyId(request), CodifiedRole.getRoleName("HEC_GEN")).getRoleId();
		}
		catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}		
		criteria.add(PropertyFactoryUtil.forName("createGroupId").eq(hecRoleId));
		
		
		if ( !Toolbox.isEmpty(callCategory) ){
			criteria.add( PropertyFactoryUtil.forName("callType").eq( callCategory ) );
		}
		
		if ( persnSet ){
			 dynamicQuery.setProjection( PropertyFactoryUtil.forName( CaretStrPool.PERSN_ID ) );
			 try {
				 Collection<Persn> inList = PersnLocalServiceUtil.dynamicQuery(dynamicQuery);
				if ( ! inList.isEmpty() ){
					criteria.add( PropertyFactoryUtil.forName(roleName).in( inList) );
				} else {
					criteria.add( PropertyFactoryUtil.forName(roleName).eq( 0l ) );
				}
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		 }
			
		if ( responder > 0 ){
			criteria.add(PropertyFactoryUtil.forName("userId").eq( responder ) );
		}
				 
		 DynamicQuery[] dq = getDqPair(CallImpl.class, criteria);

			 try {
				 for ( Call call : (List<Call>)CallLocalServiceUtil.dynamicQuery( dq[0], start, end ) ){
					 report.add( new gov.va.caret.model.support.CallSupport(call) );
				 }
				 ResultMap.getResultTotalMap( request ).put( getName(), Long.valueOf( CallLocalServiceUtil.dynamicQueryCount( dq[1] ) ).intValue() );
			 } catch (SystemException e) {
				 ApplicationWorkFlowException.handleException(e);
			 }
//		 }
		 return report;
	}	
	
	private static Map<String,Set<Long>> groupIdMap = new HashMap<String,Set<Long>>();

	public List<? extends WorIm> getWorkItemList(PortletRequest request, int start, int end) throws SystemException {

		String firstName = request.getParameter("firstName");
		String lastName = request.getParameter("lastName");

		String status = request.getParameter(CaretStrPool.STATUS);
		String workType = request.getParameter("workType");
		String roleName = request.getParameter("roleName");
		long primaryKey = ParamUtil.getLong(request, CaretStrPool.CLASS_PK);
		if ( primaryKey == 0 ){
			primaryKey = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
		}
		String openClose = request.getParameter("openClose");

		DashboardConfig dashboardConfig = (DashboardConfig) request.getPortletSession()
				.getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		List<WorIm> report = new ArrayList<WorIm>();

		DynamicQuery persnQuery = DynamicQueryFactoryUtil.forClass(PersnImpl.class, 
				PortletClassLoaderUtil.getClassLoader());
		
		boolean[] persnBool = new boolean[]{ false };
		List<Persn> persns = setPerson ( persnQuery, request, false, persnBool );
		
		boolean persnSet = persnBool[0];

		Collection personList = new ArrayList<Long>();
		for ( Persn persn : persns ){
			personList.add(persn.getPersnId());
		}
		
		
		DynamicQuery[] dq = getDqPair(WorImImpl.class);
		
		int paramCount = 0;
		
		if ( primaryKey > 0 ) {
			WorIm worIm = WorImLocalServiceUtil.fetchWorIm(primaryKey);
			if ( worIm != null ) {
				WorkItemSupport workItem = new WorkItemSupport(worIm);
				workItem.setViewable(request);
				return Collections.singletonList( workItem ) ;
			}
			for ( DynamicQuery dynQry : dq ){
				paramCount++;
				dynQry.add(  PropertyFactoryUtil.forName("vcgId").eq( primaryKey ) );
			}
		}
		
		try {
			if ( persnSet && !persns.isEmpty() ) {
				if (roleName == null && request.getParameter("roleId") != null) {
					int roleId = ParamUtil.getInteger(request, "roleId", 0);
					switch (roleId) {
					case 1:
						roleName = "persnId";
						break;
					case 2:
					case 3:
					case 4:
						roleName = "caregiverId";
						break;
					default:
					}
				}
			}
			
			for ( DynamicQuery dynQry : dq ){
				if ( persnSet ) {
					paramCount++;
					if ( !persns.isEmpty() ) {
						dynQry.add(PropertyFactoryUtil.forName(roleName).in(personList));
					} else {
						return Collections.emptyList();
					}
				}
				if (!Toolbox.isEmpty(workType)) {
					paramCount++;
					if ( "calls".equals(workType) ){
						dynQry.add(PropertyFactoryUtil.forName("classId").eq(ClassNameLocalServiceUtil.getClassNameId(Call.class)));
					} else if ( "notCalls".equals(workType) ){
						dynQry.add(PropertyFactoryUtil.forName("classId").ne(ClassNameLocalServiceUtil.getClassNameId(Call.class)));
					} else {
						dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.TYPE).eq(workType));
					}
//				} else {
//					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.TYPE).in(dashboardConfig.workItemTypes()));
				}
				if ( !Toolbox.isEmpty(openClose) ){
					paramCount++;
					if ( "close".equals(openClose) ){
						dynQry.add(PropertyFactoryUtil.forName("completionDate").isNotNull());
					} else if ( "open".equals(openClose) ){
						dynQry.add(PropertyFactoryUtil.forName("completionDate").isNull());
					}
				} else if (!Toolbox.isEmpty(status)) {
					paramCount++;
					if ( status.startsWith( StringPool.EXCLAMATION ) ){
						dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.STATUS).ne(status.substring(1)));
					} else {
						dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(status));
					}
				}
				Set<Long> groups = getGroups( request );
				if (!groups.isEmpty()) {
					paramCount++;
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.GROUP_ID).in(groups));
				}
				if ( primaryKey > 0 ){
					paramCount++;
					dynQry.add(PropertyFactoryUtil.forName(CaretStrPool.VCGID).eq(primaryKey));
				}
			}
			if ( paramCount > 0 ) {
				for (WorIm worIm : (List<WorIm>) WorImLocalServiceUtil.dynamicQuery(dq[0], start, end)) {
					String workTypeExclude = request.getParameter("workTypeExclude");
					String workTypeOnly = request.getParameter("workTypeOnly");
					if (workTypeExclude != null && workTypeExclude.equals(worIm.getType())) {
						_log.info(getName() + " report:" + worIm.getWorImId() +
								" will be excluded because of TYPE: " + workTypeExclude);
						continue;
					}
					else if (workTypeOnly != null && !workTypeOnly.equals(worIm.getType())) {
						_log.info(getName() + " report:" + worIm.getWorImId() +
								" will be excluded because DOES NOT MATCH TYPE: " + workTypeOnly);
						continue;					
					}				
					WorkItemSupport workItem = new WorkItemSupport(worIm);
					workItem.setViewable(request);
					report.add( workItem );
				}
				ResultMap.getResultTotalMap( request ).put( getName(), 
						Long.valueOf( WorImLocalServiceUtil.dynamicQueryCount(dq[1])).intValue() );	
			} else {
				ResultMap.getResultTotalMap( request ).put( getName(), 0);
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		return report;
	}
	
	public List<? extends Call> getAssociatedCallsList(PortletRequest request, int start, int end) throws SystemException {
		List<CallSupport> retList = new ArrayList<CallSupport>();
		List<? extends WorIm> workItemList = getWorkItemList(request, start, end);
		
		//CallUtil.fetchByWorkPrimaryKey_First(workPrimaryKey, orderByComparator)
		Collection<Long> inList = new HashSet<Long>();
		for(WorIm worIm : workItemList) {
			inList.add(new Long(worIm.getPrimaryKey()));
		}
		_log.info("CachedReport.getAssociatedCallsList workItemList size: " + inList.size());
		if (CollectionUtils.isNotEmpty(inList)) {
			DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( CallImpl.class, PortletClassLoaderUtil.getClassLoader() );
			dynamicQuery.add(PropertyFactoryUtil.forName("workPrimaryKey").in( inList ) );
			
			try {
				@SuppressWarnings("unchecked")
				List<Call> list = (List<Call>) CallLocalServiceUtil.dynamicQuery(dynamicQuery, start, end);
				for(Call call : list) {
					CallSupport callSupport = new CallSupport(call);
					retList.add(callSupport);
				}			
			} 
			catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 		
		}
		return retList;
	}		
	
	public static List<Persn> searchPerson( String fname, String lname, String mname, String ssn, String phone, String phone2, String gender, String address, String city, String zip, String email, Date birthdate, boolean identity ){
		return searchPerson(fname, lname, mname, ssn, phone, phone2, gender, address, city, zip, email, birthdate, identity, new boolean[]{false});
	}
	
	public static List<Persn> searchPerson( String fname, String lname, String mname, String ssn, String phone, String phone2, String gender, String address, String city, String zip, String email, Date birthdate, boolean identity, boolean[] persnSet ){
		return searchPerson(fname, lname, mname, ssn, phone, phone2, gender, address, city, null, zip, email, birthdate, identity, persnSet);
	}	
	public static List<Persn> searchPerson( String fname, String lname, String mname, String ssn, String phone, String phone2, String gender, String address, String city, String state, String zip, String email, Date birthdate, boolean identity, boolean[] persnSet ){
		if (CaretResourceCommand.searchPersonDebugOn) {_log.info("CR.searchPerson: identity: " + identity);}
		ssn = Toolbox.formatSsn( ssn );
		Set<Long> vlist = new HashSet<Long>();
		if ( !Toolbox.isEmpty( ssn ) ){
			try {
				for ( Crypto c : CryptoLocalServiceUtil.findByCryptoValue(CaretStrPool.CRYPTO_NSS, ssn) ) {
					vlist.add( c.getOwnerId() );
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(PersnImpl.class,
				PortletClassLoaderUtil.getClassLoader());
		if ( !Toolbox.isEmpty( fname) ) {
			dynamicQuery.add(RestrictionsFactoryUtil.ilike(CaretStrPool.FIRSTNAME, fname + "%"));
			persnSet[0] = true;
		}
		
		if ( !Toolbox.isEmpty( lname) ) {
			dynamicQuery.add(RestrictionsFactoryUtil.ilike(CaretStrPool.LASTNAME, lname + "%"));
			persnSet[0] = true;
		}
		
		if ( !Toolbox.isEmpty( mname ) ) {
			dynamicQuery.add(RestrictionsFactoryUtil.ilike("middleName", mname + "%"));
			persnSet[0] = true;
		}
		
		if ( !Toolbox.isEmpty( phone ) && !Person.PHONE_FORMAT.equals(phone) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.PHONE).eq(phone));
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( phone2 ) && !Person.PHONE_FORMAT.equals(phone2) ){
			dynamicQuery.add(PropertyFactoryUtil.forName("phone2").eq(phone2));
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( gender ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName("gender").eq(gender));
			persnSet[0] = true;
		} 
		
		if ( birthdate != null ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.BIRTHDATE).eq(birthdate));
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( city ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.CITY).eq(city) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( address ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ADDRESS).eq(address) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( state ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.STATE).eq(state) );
			persnSet[0] = true;
		} 		
		
		if ( !Toolbox.isEmpty( zip ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ZIP).eq(zip) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( Toolbox.parseEmail(email) ) && !Person.EMAIL_FORMAT.equals(email) ){
			dynamicQuery.add(PropertyFactoryUtil.forName("email").eq(email));
			persnSet[0] = true;
		}
		
		if ( identity ) {
			Junction junction = RestrictionsFactoryUtil.disjunction();
			junction.add(PropertyFactoryUtil.forName(CaretStrPool.ICN).isNotNull());
			junction.add(PropertyFactoryUtil.forName(CaretStrPool.PERSN_USER_ID).gt(Long.valueOf(0)));
			junction.add( PropertyFactoryUtil.forName(CaretStrPool.STATUS).eq(CaretStrPool.ACTIVE_VCG) );
			dynamicQuery.add(junction);
		}
		try {
			if ( !vlist.isEmpty() ) {
				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.PERSN_ID).in(vlist));
				persnSet[0] = true;
			}
			
			if (CaretResourceCommand.searchPersonDebugOn) {_log.info("CR.searchPerson: persnSet0 = " + persnSet[0]);}
			if ( persnSet[0] ) {
				
				//Map<String, String> checkMap = new HashMap<String, String>();
				List<Persn> persnList = PersnLocalServiceUtil.dynamicQuery(dynamicQuery, 0, 50);
				if (CaretResourceCommand.searchPersonDebugOn) {_log.info("CR.searchPerson: persnList size = " + persnList.size());}
				List<Persn> personList = new ArrayList<Persn>();
				for ( Persn persn : persnList ) {
					
					String ssnVal = new Person(persn).getSsn();
					if (CaretResourceCommand.searchPersonDebugOn) {
					_log.info("-------------------------------------");
					_log.info("CR.searchPerson: _iter: " + 
							persn.getPersnId() + " " + 
							persn.getLastName() + ", " + 
							persn.getFirstName() + 
							" ICN:" + persn.getICN() + 
							" status: " + persn.getStatus() + 
							" puserid: " + persn.getPersnUserId() + 
							" ssnVal: " + ssnVal
							);
					}
					//if ( !checkMap.containsKey( persn.getLastName() ) || !checkMap.get(persn.getLastName() ).equals( ssnVal ) ){
					//	checkMap.put( persn.getLastName(), ssnVal );
						if (CaretResourceCommand.searchPersonDebugOn) {_log.info("CR.searchPerson _iter adding persnId: " + persn.getPersnId() + " to resultSet"); }
						personList.add(persn);
					//}
				}
				return personList;
			}
			
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return Collections.emptyList();
	}	
	public static List<Long> searchPersonIds( String fname, String lname, String mname, String ssn, String phone, String phone2, String gender, String address, String city, String zip, String email, Date birthdate, boolean identity, boolean[] persnSet ){
		ssn = Toolbox.formatSsn( ssn );
		Set<Long> vlist = new HashSet<Long>();
		Set<Long> vlist2 = new HashSet<Long>();
		List<Long> persnSsnIds = null;
		//
		if ( !Toolbox.isEmpty( ssn ) ){
			try {
				for ( Crypto c : CryptoLocalServiceUtil.findByCryptoValue(CaretStrPool.CRYPTO_NSS, ssn) ) {
					vlist.add( c.getOwnerId() );
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		if ( identity ) {
			DynamicQuery dynamicQuerySsn = DynamicQueryFactoryUtil.forClass(PersnImpl.class, PortletClassLoaderUtil.getClassLoader());
			Junction junctionSsn = RestrictionsFactoryUtil.disjunction();
			junctionSsn.add(PropertyFactoryUtil.forName(CaretStrPool.ICN).isNotNull());
			junctionSsn.add(PropertyFactoryUtil.forName(CaretStrPool.PERSN_USER_ID).gt(Long.valueOf(0)));
			dynamicQuerySsn.add(junctionSsn);
			dynamicQuerySsn.add(PropertyFactoryUtil.forName(CaretStrPool.PERSN_ID).in(vlist));
			try {
				dynamicQuerySsn.setProjection( PropertyFactoryUtil.forName( CaretStrPool.PERSN_ID ) );
				persnSsnIds = PersnLocalServiceUtil.dynamicQuery(dynamicQuerySsn);
			} catch (SystemException e) {
				e.printStackTrace();
			}
			if (CollectionUtils.isNotEmpty(persnSsnIds)) {
				vlist2 = new HashSet<Long>(persnSsnIds);
			}
		}
		else {
			vlist2 = vlist;
		}
		if (CollectionUtils.isNotEmpty(vlist2)) {
			persnSet[0] = true;
		}
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(PersnImpl.class,
				PortletClassLoaderUtil.getClassLoader());

		if ( !Toolbox.isEmpty( fname) ) {
			dynamicQuery.add(RestrictionsFactoryUtil.ilike(CaretStrPool.FIRSTNAME, fname + "%"));
//			if ( fname.endsWith("*") ){			
//				dynamicQuery.add(RestrictionsFactoryUtil.ilike(CaretStrPool.FIRSTNAME, "%" + fname.substring(0, fname.length()-1) + "%"));
//			} else {
//				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).eq(fname));
//			}
			persnSet[0] = true;
		}

		if ( !Toolbox.isEmpty( lname) ) {
			dynamicQuery.add(RestrictionsFactoryUtil.ilike(CaretStrPool.LASTNAME, lname + "%"));
//			if ( lname.endsWith("*") ){			
//				dynamicQuery.add(RestrictionsFactoryUtil.ilike(CaretStrPool.LASTNAME, "%" + lname.substring(0, lname.length()-1) + "%"));
//			} else {
//				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(lname));
//			}
			persnSet[0] = true;
		}
		
		if ( !Toolbox.isEmpty( mname ) ) {
			dynamicQuery.add(RestrictionsFactoryUtil.ilike("middleName", mname + "%"));
			persnSet[0] = true;
		}		
		
		if ( !Toolbox.isEmpty( phone ) && !Person.PHONE_FORMAT.equals(phone) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.PHONE).eq(phone));
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( phone2 ) && !Person.PHONE_FORMAT.equals(phone2) ){
			dynamicQuery.add(PropertyFactoryUtil.forName("phone2").eq(phone2));
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( gender ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName("gender").eq(gender));
			persnSet[0] = true;
		} 
		
		if ( birthdate != null ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.BIRTHDATE).eq(birthdate));
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( city ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.CITY).eq(city) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( address ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ADDRESS).eq(address) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( zip ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ZIP).eq(zip) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( Toolbox.parseEmail(email) ) && !Person.EMAIL_FORMAT.equals(email) ){
			dynamicQuery.add(PropertyFactoryUtil.forName("email").eq(email));
			persnSet[0] = true;
		}
				
		if ( identity ) {
			Junction junction = RestrictionsFactoryUtil.disjunction();
			junction.add(PropertyFactoryUtil.forName(CaretStrPool.ICN).isNotNull());
			junction.add(PropertyFactoryUtil.forName(CaretStrPool.PERSN_USER_ID).gt(Long.valueOf(0)));
			dynamicQuery.add(junction);
		}
		try {
			if (CollectionUtils.isNotEmpty(vlist2)) {
				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.PERSN_ID).in(vlist2));
			}
			dynamicQuery.setProjection( PropertyFactoryUtil.forName( CaretStrPool.PERSN_ID ) );
			List<Long> persnIds = PersnLocalServiceUtil.dynamicQuery(dynamicQuery);
			return persnIds;
		} catch (SystemException e) {
			return Collections.emptyList();
		}
	}			
	
	public static List<Vendr> searchVendor( String fname, String lname, String taxid, String address, String city, String zip, boolean[] persnSet, int start, int end ){

		taxid = Toolbox.formatSsn( taxid );
		if ( !Toolbox.isEmpty( taxid ) ){
			try {
				List<Vendr> vlist = new ArrayList<Vendr>();
				for ( Crypto c : CryptoLocalServiceUtil.findByCryptoValue(Vendor.TAXID, taxid) ) {
					vlist.add( VendrLocalServiceUtil.fetchVendr(c.getOwnerId() ) );
				}
				persnSet[0] = true;
				return vlist;
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}

		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(VendrImpl.class,
				PortletClassLoaderUtil.getClassLoader());
		if ( !Toolbox.isEmpty( fname) ) {
			if ( fname.endsWith("*") ){			
				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).like(fname.substring(0, fname.length()-1)));
			} else {
				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).eq(fname));
			}
			persnSet[0] = true;
		}

		if ( !Toolbox.isEmpty( lname) ) {
			if ( lname.endsWith("*") ){			
				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).like(lname.substring(0, lname.length()-1)));
			} else {
				dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(lname));
			}
			persnSet[0] = true;
		}
		
		if ( !Toolbox.isEmpty( city ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.CITY).eq(city) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( address ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ADDRESS).eq(address) );
			persnSet[0] = true;
		} 
		
		if ( !Toolbox.isEmpty( zip ) ){
			dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.ZIP).eq(zip) );
			persnSet[0] = true;
		} 
		

		try {
			return VendrLocalServiceUtil.dynamicQuery(dynamicQuery, start, end);
		} catch (SystemException e) {
			return Collections.emptyList();
		}
	}
	
	private Set<Long> getGroups(PortletRequest request) {
		 Set<Long> groups;
		 String groupId = request.getParameter("userOrgIds");
		 if ( !Toolbox.isEmpty( groupId ) ){
			 if ( ParamUtil.getLong(request, "userOrgIds") > 0 || '[' == groupId.charAt(0) ) {
				 groups = getGroups( request.getParameter("userOrgIds"), request );
			 } else {
				 groups = Collections.EMPTY_SET; //singleton(0l);
			 }
		 } else {
			 groups = Collections.EMPTY_SET;
		 }
		 return groups;
	}

	boolean isDistrict( String[] groupIdStr ){
		int digits = 0;
		String temp = null;
		for ( int i = 0; i < groupIdStr[0].length(); i++ ){
			if ( Character.isDigit( groupIdStr[0].charAt(i) ) ){
				temp = String.valueOf( groupIdStr[0].charAt(i) );
				digits++;
			}
			if ( Character.isLetter( groupIdStr[0].charAt(i) ) ){
				groupIdStr[0] = temp;
				break;
			}
		}
		return digits == 1;
	}
	private Set<Long> getGroups(String groupIdStr, PortletRequest request ) {
		Set<Long> groups = Collections.emptySet();
		if ( !Toolbox.isEmpty(groupIdStr) ) {
			String[] groupStr = new String[]{ groupIdStr };
			if (groupIdStr.length() > 1 && isDistrict(groupStr) ) {
				if (groupIdMap.containsKey(groupStr[0])) {
					groups = groupIdMap.get(groupStr[0]);
				} else {
					groups = new HashSet<Long>();
					Organization district;
					try {
						district = OrganizationLocalServiceUtil.fetchOrganization( PortalUtil.getCompanyId( request ), groupIdStr );
						for ( Organization visn: district.getDescendants() ){
							for ( Organization desc: visn.getDescendants() ){
								groups.add(desc.getOrganizationId());
							}
						}
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
					groupIdMap.put(groupStr[0],groups);
				}
			} else if ('[' == groupIdStr.charAt(0)) {
				groups = new HashSet<Long>();
				for (String s : groupIdStr.substring(1, groupIdStr.length() - 1).split(StringPool.COMMA_AND_SPACE)) {
					groups.add(Long.valueOf(s));
				}
			} else {
				groups = Collections.singleton(Long.valueOf(groupIdStr));
			}
		}
		return groups;
	}

	private SearchParms getSearchUtil(PortletRequest request) {
		String facilIdStr = request.getParameter("userOrgIds");
		String firstName = request.getParameter("firstName");
		String lastName = request.getParameter("lastName");
		String ssn = request.getParameter("ssn");
		String birthDateStr = request.getParameter("birthDate");
		String beginDateStr = request.getParameter("beginDate");
		String endDateStr = request.getParameter("endDate");
		String roleName = request.getParameter("roleName");
		String phone = request.getParameter("phone");
		String dateType = request.getParameter("dateType");
		String status = request.getParameter("status");
		String callCategory = request.getParameter("callCategory");
		Long responder = ParamUtil.getLong(request, "responder");

		int facilId = Toolbox.isEmpty(facilIdStr) ? 0 : Integer.parseInt(facilIdStr);
		int roleId = ParamUtil.getInteger(request, "roleId", 0);
		if ( roleName == null && request.getParameter("roleId") != null ){
		switch(roleId){
			case 1: roleName = "veteranPersnId"; break;
			case 2: case 3:
			case 4: roleName = "callerPersnId"; break;
			default:  
			}
		}
		Date birthDate = Toolbox.parseDate(birthDateStr);
		phone = Toolbox.parsePhone(phone);
		//ssn = Toolbox.parseSSN(ssn);
		Date beginDate = Toolbox.parseDate(beginDateStr);
		Date endDate = Toolbox.parseDate(endDateStr);
		//
		Long userId= PortalUtil.getUserId(request);
		int socDueDays = CaretParam.getSocDueDays();
		//
		SearchParms searchUtil = new SearchParmsImpl();
		//searchUtil.setSearchUtilId(searchUtilId);
		searchUtil.setFacilId(facilId);
		searchUtil.setRoleName(roleName);
		searchUtil.setFirstName(firstName);
		searchUtil.setLastName(lastName);
		searchUtil.setSsn(ssn);
		searchUtil.setBirthDate(birthDate);
		searchUtil.setPhone(phone);
		searchUtil.setResponder(responder);
		searchUtil.setBeginDate(beginDate);
		searchUtil.setEndDate(endDate);
		searchUtil.setDateType(dateType);
		searchUtil.setCallCategory(callCategory);
		searchUtil.setStatus(status);
		searchUtil.setUserId(userId);
		searchUtil.setSocDueDays(socDueDays);
		//
		return searchUtil;
	}
	

	private DynamicQuery[] getDqPair( Class<? extends BaseModelImpl<?>> clazz ){
		DynamicQuery[] dq = new DynamicQuery[2];
		for ( int i = 0; i < dq.length; i++ ){
			dq[i] = DynamicQueryFactoryUtil.forClass( clazz, PortletClassLoaderUtil.getClassLoader() );
		 }
		return dq;
	}
	
	private DynamicQuery[] getDqPair( Class<? extends BaseModelImpl<?>> clazz, List<Criterion>[] criteria ){
		DynamicQuery[] dq = new DynamicQuery[2];
		for ( int i = 0; i < dq.length; i++ ){
			dq[i] = DynamicQueryFactoryUtil.forClass( clazz, PortletClassLoaderUtil.getClassLoader() );
			for ( Criterion c: criteria[i] ){
				dq[i].add(c);
			}
		 }
		return dq;
	}
	
	private DynamicQuery[] getDqPair( Class<? extends BaseModelImpl<?>> clazz, List<Criterion> criteria ){
		DynamicQuery[] dq = new DynamicQuery[2];
		for ( int i = 0; i < dq.length; i++ ){
			dq[i] = DynamicQueryFactoryUtil.forClass( clazz, PortletClassLoaderUtil.getClassLoader() );
			for ( Criterion c: criteria ){
				dq[i].add(c);
			}
		 }
		return dq;
	}

	@Override
	public boolean isLazy(){
		return true;
	}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	protected class CachedReportRequest extends PortletRequestWrapper{
		public CachedReportRequest(PortletRequest request) {
			super(request);
		} 
		
		@SuppressWarnings("unchecked")
		public java.lang.String getParameter(java.lang.String name){
			Map<String,Object> cacheSearchForm = (Map<String,Object> )getPortletSession().getAttribute( "cacheSearchForm" );
			if ( cacheSearchForm != null && cacheSearchForm.containsKey(name) ) {
				return cacheSearchForm.get(name).toString();
			}
			return super.getParameter(name);
		}
		
	}
	
	private static Log _log = LogFactoryUtil.getLog( CachedReport.class );
	
}
