package gov.va.caret.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import javax.portlet.PortletContext;

import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.DuplicateGroupException;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutConstants;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.ListTypeConstants;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.OrganizationConstants;
import com.liferay.portal.model.OrganizationSoap;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BlsAe;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.Facil;
import gov.va.caret.model.FacilSoap;
import gov.va.caret.model.ZipFy;
import gov.va.caret.model.impl.BlsAeImpl;
import gov.va.caret.model.impl.BlsReImpl;
import gov.va.caret.model.impl.FacilImpl;
import gov.va.caret.model.impl.ZipFyImpl;
import gov.va.caret.portlet.OnlinePortlet;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.service.BlsAeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.ZipFyLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;

public class BootStrapUtil {  
	
	private static Log _log = LogFactoryUtil.getLog(BootStrapUtil.class);
	
	final static int DISTRICT = 1;
	final static int VISN = 2;
	final static int VAMC = 3;
//  OLD PROTO-TYPE DEMO METADATA METHODS...
//	public static List<Map<String,Object>> getCbopcWork(){
//		List<Map<String,Object>> cbopcWork = new ArrayList<Map<String,Object>> ();
//		cbopcWork.add( Toolbox.getMap( "1","00064","New Application(O)","03/30/2015","07:31","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00065","New Application(O)","03/30/2015","08:31","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00066","New Application(H)","03/30/2015","09:51","Waiting for VA Enrollment","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00068","New Application(H)","03/30/2015","10:22","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00069","CBOPC Correction","03/30/2015","12:31","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00070","New Application(O)","03/30/2015","12:09","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00071","New Application(O)","03/30/2015","14:39","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00072","New Application(L)","03/30/2015","14:41","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00073","CBOPC Correction","03/30/2015","14:55","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00074","New Application(O)","03/30/2015","15:21","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00076","New Application(L)","03/30/2015","16:32","Open","7" ) );
//		   
//		return cbopcWork;
//	}
//	
//	public static List<Map<String,Object>> getReferrals(){
//		List<Map<String,Object>> referral = new ArrayList<Map<String,Object>> ();
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "In-Process") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Call Attempt #2") );
//		referral.add( Toolbox.getMap( "##-###-######", "HRC", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Call Attempt #1") );
//		referral.add( Toolbox.getMap( "##-###-######", "HRC", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "In-Process") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") );
//		referral.add( Toolbox.getMap( "##-###-######", "HEC", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") )
//		;return referral;
//	}
//
//	public static List<Map<String,Object>> getPersonSearchResult(){
//		List<Map<String,Object>> person = new ArrayList<Map<String,Object>> ();
//		person.add( Toolbox.getMap( "64", "999-99-9991", "WALKER, JOHN","M", "YES","695" ) );
//		person.add( Toolbox.getMap( "64", "999-99-9992", "WALKER, JOHNIE","M", "YES","695" ) );
//		person.add( Toolbox.getMap( "64", "999-99-9992", "WALKER, JOHNY","M", "YES","695" ) );
//		return person;
//	}
//	
//	public static List<Map<String,Object>> getCaregiverResult(){
//		List<Map<String,Object>> cgResult = new ArrayList<Map<String,Object>> ();
//		cgResult.add( Toolbox.getMap("SMITH, STEVE", "##/##/####", "##/##/####" ) );
//		cgResult.add( Toolbox.getMap("SMITH, STEVE", "##/##/####", "##/##/####" ) ); 
//		cgResult.add( Toolbox.getMap("WALKER, NANCY", "##/##/####", "##/##/####" ) );
//		cgResult.add( Toolbox.getMap("GOMEZ, EDUARDO", "##/##/####", "##/##/####" ) );
//		cgResult.add( Toolbox.getMap("BROOKS, PHILLIP", "##/##/####", "##/##/####" ) );
//		return cgResult;
//	}
//	
//	
//	public static List<Map<String,Object>> getApplicationList(){
//		List<Map<String,Object>> application = new ArrayList<Map<String,Object>> ();
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, SILVIA", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Dallas (982)" ) );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Waco (981)" ) );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Jacksonville (345)") );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Dallas (982)" ) );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Dallas (982), Waco (981)" ));
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "-", "CG APPROVED", "Jacksonville (345)" ) );
//		return application;
//	}
//	
	public static void bootstrapPersonTable () throws ApplicationWorkFlowException{
		
		try {
			for ( User user: UserLocalServiceUtil.getUsers(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ){
				Object o = PersnLocalServiceUtil.getByUser( user.getUserId() );
				if ( o == null ){
//					_log.error("PERSON NOT IN SCHEMA... BOOTSTRAP OF PERSON DISABLED... MONITORING FOR DUPLICATION:" + user.getLastName());
					PersnLocalServiceUtil.addPersn(user, false);
				}
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
	}
	
	
//	public static void bootstrapOccWork (ServiceContext sc) throws ApplicationWorkFlowException{
//		try {
//			for ( WorIm worIm: WorImLocalServiceUtil.getWorIms(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ){
//				if (  worIm.getQueueId() == OwnerQueue.VERIFIED_COMPLETED_Q.getQueueId() ){
//					if ( WorkType.APPROVED_DISPOSITION.name().equals( worIm.getType() ) ) {
//						Person persn = new Person ( PersnLocalServiceUtil.getPersn(worIm.getCaregiverId()) );
//						if ( !Toolbox.isEmpty( Toolbox.formatSsn( persn.getSsn() ) ) ) {
//							Vendr vendr = VendrLocalServiceUtil.findByTaxId(persn.getSsn() );
//							if ( vendr == null ) {
//								Vendor vendor = new Vendor(new VendrImpl());
//								vendor.setModelAttributes(persn.getModelAttributes()); 
//								vendor.setTaxId( persn.getSsn() );
////								vendr = (Vendr)CaretLocalServiceUtil.save(vendor);
//							}
//							
//							StiPt stiPt = StiPtLocalServiceUtil.findByWorIm( worIm.getWorImId() );
//							if ( stiPt == null ) {
//								StipendConfig config = new StipendConfig ( new StiPtImpl() );
//								VcgSupport vcg = new VcgSupport ( VcgLocalServiceUtil.getVcg(worIm.getVcgId()) );
//								
//								config = new StipendConfig ( new StiPtImpl() );
//								config.setVendrId( vendr.getVendrId() );
//								config.setFields( vcg.getTierEffectiveDate(), vcg, new WorkItemSupport( worIm ), sc, String.valueOf(vcg.getTierLevelPreviously()), String.valueOf(vcg.getTierLevel()) );
//								config.setStipendStatus(StipendConfig.PAYMENT_FINANCE);
//								config.setStipendApprovedDate(new java.util.Date());
////								CaretLocalServiceUtil.save(config);
//							}
//						}
//					}
//				}
//			}
//		} catch (SystemException e) {
//			throw new ApplicationWorkFlowException(e);
//		} catch (PortalException e) {
//			ApplicationWorkFlowException.handleException(e);
//		}
//	}
	
	public static void bootstrapFacZip( PortletContext portletContext, String[] realPath ) throws ApplicationWorkFlowException, SystemException   {
		
		
		final String path = portletContext.getRealPath(realPath[0] + "/vmacLocations_0328.csv");
		_log.info("1 File is=" + path);
		_log.info("Final File is=" + realPath[0] + "/vmacLocations_0328.csv");
		File csvFile = new File ( realPath[0] + "/vmacLocations_0328.csv" );
		boolean exists = FileUtil.exists(csvFile);
		_log.info("File exists=" + exists );
		
		BufferedReader br = null;
		String line = "";

		try {
			NumberFormat nf = NumberFormat.getInstance();
			br = new BufferedReader(new FileReader(csvFile));
			int added = 0;
			int unfoundzips = 0;
			while ((line = br.readLine()) != null) {
				String[] zipFac = line.split(";");
				String zip = zipFac[0];
				String[] facMiles = zipFac[1].split("!");
				for ( String facMile : facMiles ){
					String[] rec = facMile.split(":");
					if ( rec.length == 2 ){
						
						while (zip.length() < 5){
							zip = "0"+ zip;
						}
						_log.debug( "zip:" + zip + ", facilityNumber:" + rec[0] + ", Distance:" + nf.parse(rec[1]) );
						
						String v = rec[0].trim();
						StringBuilder sb = new StringBuilder();
						for ( int index = 0; index < v.length(); index++ ){
							if ( Character.isLetterOrDigit( v.charAt(index) ) ){
								sb.append( v.charAt(index) );
							}
						}
						
						Facil facil = CaretLocalServiceUtil.getFacilityByNumber( sb.toString() );
						if ( facil != null ){
							ZipFy facilityZip = new ZipFyImpl();
							facilityZip.setFacilZip( zip.trim() );
							facilityZip.setFacilId( facil.getFacilId() );
							facilityZip.setDistance( nf.parse(rec[1]).doubleValue() );
							ZipFyLocalServiceUtil.updateZipFy(facilityZip);
							added++;
						} else {
							unfoundzips++;
						}
					}
				}
			}
			_log.info("added " + added + " bls rates, total zips not found: " + unfoundzips);
		} catch (FileNotFoundException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException(e);
		} finally {
			if (br != null) {
				try {
					br.close();
				} catch (IOException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		
		
	}
	
	public static void loadBlsRate( PortletContext portletContext, String[] realPath ) throws ApplicationWorkFlowException, SystemException {
		loadBlsRateCsv( portletContext, realPath );
	}

	public static void loadBlsRateXls( PortletContext portletContext, String[] realPath ) throws ApplicationWorkFlowException, SystemException {
		final String path = portletContext.getRealPath(realPath[0] + "/BLS_table_with_zip_codes.xlsx");
				_log.info("loadBlsRe()");
				_log.info("2 File is=" + path);
				_log.info("Final File is=" + realPath[0] + "/BLS_table_with_zip_codes.xlsx");
				File file = new File ( realPath[0] + "/BLS_table_with_zip_codes.xlsx" );
				boolean exists = FileUtil.exists(file);
				_log.info("File is " + file.getName() + ", exists=" + exists );
				if ( exists ){
					
					for ( BlsRe blsRe:  BlsReLocalServiceUtil.getBlsRes(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ) {
						BlsReLocalServiceUtil.deleteBlsRe( blsRe );
					}
					for ( BlsAe blsAe : BlsAeLocalServiceUtil.getBlsAes(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ){
						BlsAeLocalServiceUtil.deleteBlsAe(blsAe);
					}
					
					
					try {
						Workbook workbook = WorkbookFactory.create(file);
						Sheet sheet = workbook.getSheetAt(0);
//						Row headerRow = sheet.getRow(0);
//						for ( Cell cell: headerRow ){
//							String cellValue = cell.getStringCellValue();
//							_log.info("cellValue=" + cellValue );
//						}
						int added = 0;
						_log.info("CareT importing BLS Rate for Zip... this aspect can take up to 15 minutes..." );
						for ( Row row: sheet ){
							BlsRe bls = new BlsReImpl();
							int i = 0;
							Cell cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							if ( "Zipcode".equals(cell.toString().trim()) ) continue;
							bls.setZip( cell.getStringCellValue() );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							Integer areaNumber = Integer.valueOf( cell.getStringCellValue().trim() );
							
							BlsAe area = null;
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							String areaName = cell.getStringCellValue().trim();
							
							int areaCount = BlsAeLocalServiceUtil.countByAreaNumber( areaNumber );
							if ( areaCount  == 0 ){
								area = new BlsAeImpl();
								area.setAreaNumber( areaNumber );
								area.setAreaName( areaName );
								BlsAeLocalServiceUtil.updateBlsAe(area);
							} else {
								area = BlsAeLocalServiceUtil.findByAreaNumber( areaNumber );
							}
							bls.setBlsAeId( area.getBlsAeId() );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							bls.setState( cell.getStringCellValue().trim()  );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							bls.setH75( Double.valueOf( cell.getStringCellValue().trim() ) );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							String location = cell.getStringCellValue().trim();
							bls.setCity( location.substring( 0, location.lastIndexOf(StringPool.COMMA) ) );
							
							cell = row.getCell(i++);
							if ( cell != null ){
								cell.setCellType(Cell.CELL_TYPE_STRING);
								bls.setCounty( cell.getStringCellValue().trim() );
							}
							int year = 2016;
							try{
								year = Integer.valueOf( PortletProps.get("bls-spreadsheet-year").trim() );
							} catch (NumberFormatException nfe){}
							bls.setYear(year);
							BlsReLocalServiceUtil.addBlsRe(bls);
							added++;
						}
						_log.info("added " + added + " bls rates ");
					} catch (InvalidFormatException e) {
						ApplicationWorkFlowException.handleException(e);
					} catch (IOException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
	}


	private static void loadBlsRateCsv(PortletContext portletContext, String[] realPath) {
		// TODO Auto-generated method stub
		final String path = portletContext.getRealPath(realPath[0] + "/BLS_table_with_zip_codes.csv");
		_log.info("loadBlsRe()");
		_log.info("2 File is=" + path);
		_log.info("Final File is=" + realPath[0] + "/BLS_table_with_zip_codes.csv");
		File file = new File ( realPath[0] + "/BLS_table_with_zip_codes.csv" );
		boolean exists = FileUtil.exists(file);
		_log.info("File is " + file.getName() + ", exists=" + exists );
		if ( exists ){
			FileReader fr = null;
			BufferedReader br = null;
			try{
				

				for ( BlsRe blsRe:  BlsReLocalServiceUtil.getBlsRes(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ) {
					BlsReLocalServiceUtil.deleteBlsRe( blsRe );
				}
				for ( BlsAe blsAe : BlsAeLocalServiceUtil.getBlsAes(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ){
					BlsAeLocalServiceUtil.deleteBlsAe(blsAe);
				}
				
				fr = new FileReader(file);
				br = new BufferedReader(fr);
				
				String line = "";
				int added = 0;
				
				while ((line = br.readLine()) != null) {
						String[] row = line.split(";");
						
						
						BlsRe bls = new BlsReImpl();
						int i = 0;
						if ( i >= row.length ) continue;
						String cell = row[i++];
						if ( "Zipcode".equals(cell.toString().trim()) ) continue;
						bls.setZip( cell.trim() );
						
						if ( i >= row.length ) continue;
						cell = row[i++];
						Integer areaNumber = Integer.valueOf( cell.trim() );
						
						BlsAe area = null;
						
						if ( i >= row.length ) continue;
						cell = row[i++];
						String areaName = cell.trim();
						
						int areaCount = BlsAeLocalServiceUtil.countByAreaNumber( areaNumber );
						if ( areaCount  == 0 ){
							area = new BlsAeImpl();
							area.setAreaNumber( areaNumber );
							area.setAreaName( areaName );
							BlsAeLocalServiceUtil.updateBlsAe(area);
						} else {
							area = BlsAeLocalServiceUtil.findByAreaNumber( areaNumber );
						}
						bls.setBlsAeId( area.getBlsAeId() );
						
						cell = row[i++];
						bls.setState( cell.trim()  );
						
						cell = row[i++];
						bls.setH75( Double.valueOf( cell.trim() ) );
						
						cell = row[i++];
						String location = cell.trim();
						bls.setCity( location.substring( 0, location.lastIndexOf(StringPool.COMMA) ) );
						
						cell = row[i++];
						if ( cell != null ){
							bls.setCounty( cell.trim() );
						}
						int year = 2016;
						try{
							year = Integer.valueOf( PortletProps.get("bls-spreadsheet-year").trim() );
						} catch (NumberFormatException nfe){}
						bls.setYear(year);
						BlsReLocalServiceUtil.addBlsRe(bls);
						added++;
						
				}
				_log.info("added " + added + " bls rates ");
			} catch (IOException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			} finally {
				try {
					if ( fr != null ) {
						fr.close();
					} 
					if ( br!= null ) {
						br.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	
	public static void bootstrapOrgs(PortletContext portletContext, String[] realPath) throws SystemException, PortalException {
		bootstrapOrgsCsv(portletContext, realPath);
	}

	public static void bootstrapOrgsXlsx(PortletContext portletContext, String[] realPath) throws SystemException, PortalException {

		String name = PortletProps.get(CaretStrPool.HEAD_ORG_NAME);
		
		Company company = CompanyLocalServiceUtil.getCompany( PortalUtil.getDefaultCompanyId() );
		Organization org = null;
		long caretOrganizationId = 0;
		ServiceContext serviceContext = new ServiceContext();
		serviceContext.setAddGuestPermissions(false);
		long userId = company.getDefaultUser().getUserId();
		try {
			org = OrganizationLocalServiceUtil.getOrganization( company.getCompanyId(), name );
		} catch ( com.liferay.portal.NoSuchOrganizationException nsoe ){
			ApplicationWorkFlowException.handleException( "Creating Parent Facility Org: " + name );
			org = OrganizationLocalServiceUtil.addOrganization( userId, 0, name,
					OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0,
					0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, StringPool.BLANK, false, serviceContext);
			
		}
		caretOrganizationId = org.getOrganizationId();
		
		int count = OrganizationLocalServiceUtil.getOrganizationsCount();
		if ( count > 20 ){
			_log.info("count is:" + count);
			return;
		}
		
		
		String path = portletContext.getRealPath( realPath[0] + "/facilities.xlsx");
		_log.info("3 File is=" + path);
		_log.info("Final File is=" + realPath[0] + "/facilities.xlsx");
		File file = new File ( realPath[0] + "/facilities.xlsx" );
		
		//File file = new File ( path );
		boolean exists = FileUtil.exists(file);
		_log.info("File is " + file.getName() + ", exists=" + exists );
		if ( exists ){
			try {
				long districtOrgId = 0;
				long visnOrgId = 0;
				int added = 0;
				int addedF = 0;

				Workbook workbook = WorkbookFactory.create(file);
				Sheet sheet = workbook.getSheetAt(0);
				for ( Row row: sheet ){
					
					name = null;
					int context = 0;
					int i = 0;
					
					Cell cell = row.getCell(i);
					String[] vals = new String[5];
					if ( cell != null ){
						cell.setCellType(Cell.CELL_TYPE_STRING);
						vals[0] = cell.getStringCellValue().trim();
						if ( vals[i] != null && !vals[i].isEmpty() ){
							context = DISTRICT;
						}
					}
					cell = row.getCell(++i);
					if ( cell != null ){
						cell.setCellType(Cell.CELL_TYPE_STRING);
						vals[i] = cell.getStringCellValue().trim();
					}
					if ( context != DISTRICT ){
						cell = row.getCell(++i);
						if ( cell != null ){
							cell.setCellType(Cell.CELL_TYPE_STRING);
							vals[i] = cell.getStringCellValue().trim();
						}
						cell = row.getCell(++i);
						if ( cell != null ){
							cell.setCellType(Cell.CELL_TYPE_STRING);
							vals[i] = cell.getStringCellValue().trim() ;
						}
						cell = row.getCell(++i);
						if ( cell != null ){
							cell.setCellType(Cell.CELL_TYPE_STRING);
							vals[i] = cell.getStringCellValue().trim() ;
							if ( "Location".equals( vals[i] ) ){
								context = VISN;
							} else if ( vals[i] != null && !vals[i].isEmpty() ){
								context = VAMC;
							}
						}
					}
//					_log.info("context:" + context + ", 0:" + vals[0]+ ",1:" + vals[1]+ ",2:" + vals[2]+ ",3:" + vals[3]+ ",4:" + vals[4]);
					
					switch(context){
						case DISTRICT:
							name = vals[0] + StringPool.SPACE + vals[1];
							org = OrganizationLocalServiceUtil.addOrganization(userId, caretOrganizationId, name, 
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[0], false, serviceContext);
							districtOrgId = org.getOrganizationId();
							added++;
							break;
						case VISN:
							name = vals[1];
							org = OrganizationLocalServiceUtil.addOrganization(userId, districtOrgId, name,
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[2], false, serviceContext);
							visnOrgId = org.getOrganizationId();
							added++;
							break;
						case VAMC:
							name = vals[2];
							org = OrganizationLocalServiceUtil.addOrganization( userId, visnOrgId, name,
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, StringPool.BLANK, false, serviceContext);
							added++;
							Facil facility = new FacilImpl();
							String v = vals[3].trim();
							StringBuilder sb = new StringBuilder();
							for ( int index = 0; index < v.length(); index++ ){
								if ( Character.isLetterOrDigit( v.charAt(index) ) ){
									sb.append( v.charAt(index) );
								}
							}
							
							facility.setFacilityNumber(sb.toString());
							facility.setLocation(vals[4]);
							facility.setGroupId( org.getOrganizationId() );
							FacilLocalServiceUtil.addFacil(facility);
							addedF++;
					}
				}
				_log.info("added " + added + " orgs and " + addedF + " facilities...");
			} catch (InvalidFormatException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (IOException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	
	public static void bootstrapOrgsCsv(PortletContext portletContext, String[] realPath) throws PortalException, SystemException {
		
		String name = PortletProps.get(CaretStrPool.HEAD_ORG_NAME);
		
		Company company = CompanyLocalServiceUtil.getCompany( PortalUtil.getDefaultCompanyId() );
		Organization org = null;
		long caretOrganizationId = 0;
		ServiceContext serviceContext = new ServiceContext();
		serviceContext.setAddGuestPermissions(false);
		long userId = company.getDefaultUser().getUserId();
		try {
			org = OrganizationLocalServiceUtil.getOrganization( company.getCompanyId(), name );
		} catch ( com.liferay.portal.NoSuchOrganizationException nsoe ){
			ApplicationWorkFlowException.handleException( "Creating Parent Facility Org: " + name );
			org = OrganizationLocalServiceUtil.addOrganization( userId, 0, name,
					OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0,
					0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, StringPool.BLANK, false, serviceContext);
			
		}
		caretOrganizationId = org.getOrganizationId();
		
		int count = OrganizationLocalServiceUtil.getOrganizationsCount();
		if ( count > 20 ){
			_log.info("count is:" + count);
			return;
		}
		
		String path = portletContext.getRealPath( realPath[0] + "/facilities.csv");
		_log.info("3 File is=" + path);
		_log.info("Final File is=" + realPath[0] + "/facilities.csv");
		File file = new File ( realPath[0] + "/facilities.csv" );
		
		boolean exists = FileUtil.exists(file);
		
		if ( exists ){
			FileReader fr = null;
			BufferedReader br = null;
			try {
				long districtOrgId = 0;
				long visnOrgId = 0;
				int added = 0;
				int addedF = 0;
				
				fr = new FileReader(file);
				br = new BufferedReader(fr);
				String line = "";
				while ((line = br.readLine()) != null) {
						String[] zipFac = line.split(",");
						
					name = null;
					int context = 0;
					int i = 0;
					
					if ( i >= zipFac.length ) continue;
					String cell = zipFac[i];
					String[] vals = new String[5];
					if ( cell != null ){
						vals[0] = cell.trim();
						if ( vals[i] != null && !vals[i].isEmpty() ){
							context = DISTRICT;
						}
					}
					if ( i+1 >= zipFac.length ) continue;
					cell = zipFac[++i];
					if ( cell != null ){
						vals[i] = cell.trim();
					}
					if ( context != DISTRICT ){
						if ( i+1 >= zipFac.length ) continue;
						cell = zipFac[++i];
						if ( cell != null ){
							vals[i] = cell.trim();
						}
						if ( i+1 >= zipFac.length ) continue;
						cell = zipFac[++i];
						if ( cell != null ){
							vals[i] = cell.trim();
						}
						if ( i+1 >= zipFac.length ) continue;
						cell = zipFac[++i];
						vals[i] = cell.trim();
						if ( cell != null ){
							vals[i] = cell.trim();
							if ( "Location".equals( vals[i] ) ){
								context = VISN;
							} else if ( vals[i] != null && !vals[i].isEmpty() ){
								context = VAMC;
							}
						}
					}
					switch(context){
						case DISTRICT:
							name = vals[0] + StringPool.SPACE + vals[1];
							org = OrganizationLocalServiceUtil.addOrganization(userId, caretOrganizationId, name, 
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[0], false, serviceContext);
							districtOrgId = org.getOrganizationId();
							added++;
							break;
						case VISN:
							name = vals[1];
							org = OrganizationLocalServiceUtil.addOrganization(userId, districtOrgId, name,
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[2], false, serviceContext);
							visnOrgId = org.getOrganizationId();
							added++;
							break;
						case VAMC:
							name = vals[2];
							org = OrganizationLocalServiceUtil.addOrganization( userId, visnOrgId, name,
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, StringPool.BLANK, false, serviceContext);
							added++;
							Facil facility = new FacilImpl();
							String v = vals[3].trim();
							StringBuilder sb = new StringBuilder();
							for ( int index = 0; index < v.length(); index++ ){
								if ( Character.isLetterOrDigit( v.charAt(index) ) ){
									sb.append( v.charAt(index) );
								}
							}
							
							facility.setFacilityNumber(sb.toString());
							facility.setLocation(vals[4]);
							facility.setGroupId( org.getOrganizationId() );
							FacilLocalServiceUtil.addFacil(facility);
							addedF++;
					}
				}
				_log.info("added " + added + " orgs and " + addedF + " facilities...");
			} catch (IOException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			} finally {
				try {
					if ( fr != null ) {
						fr.close();
					} 
					if ( br!= null ) {
						br.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			
			
		}
	}
	
	public static void main ( String test[] ){
		
		
	}
	
	public static void main0 ( String test[] ){
		
		long caretOrganizationId = 100;
		long userId = -1;
		
		OrganizationSoap org;
		
		File file = new File ( BootStrapUtil.class.getClassLoader().getResource("spreadsheet/facilities.csv").getPath() );
		String name;
		
		//File file = new File ( path );
		boolean exists = file.exists();
		_log.info("File is " + file.getName() + ", exists=" + exists );
		if ( exists ){
			List<FacilSoap> facilLocalServiceUtilList = new ArrayList<FacilSoap>();
			List<OrganizationSoap> orgSoapList = new ArrayList<OrganizationSoap>();
			
			BufferedReader br = null;
			FileReader fr = null;
			try {
				long districtOrgId = 0;
				long visnOrgId = 0;
				int added = 0;
				int addedF = 0;

//				Workbook workbook = WorkbookFactory.create(file);
//				Sheet sheet = workbook.getSheetAt(0);
//				for ( Row row: sheet ){
				fr = new FileReader(file);
				br = new BufferedReader(fr);
				String line = "";
				while ((line = br.readLine()) != null) {
						String[] zipFac = line.split(",");
					
				  
						
					name = null;
					int context = 0;
					int i = 0;
					
					if ( i >= zipFac.length ) continue;
					String cell = zipFac[i];
					String[] vals = new String[5];
					if ( cell != null ){
//						cell.setCellType(Cell.CELL_TYPE_STRING);
						vals[0] = cell.trim(); //cell.getStringCellValue().trim();
						if ( vals[i] != null && !vals[i].isEmpty() ){
							context = DISTRICT;
						}
					}
					if ( i+1 >= zipFac.length ) continue;
					cell = zipFac[++i];
					if ( cell != null ){
						vals[i] = cell.trim(); //cell.setCellType(Cell.CELL_TYPE_STRING);
//						vals[i] = cell.getStringCellValue().trim();
					}
					if ( context != DISTRICT ){
//						cell = row.getCell(++i);
						if ( i+1 >= zipFac.length ) continue;
						cell = zipFac[++i];
						if ( cell != null ){
							vals[i] = cell.trim(); // cell.setCellType(Cell.CELL_TYPE_STRING);
//							vals[i] = cell.getStringCellValue().trim();
						}
//						cell = row.getCell(++i);
						if ( i+1 >= zipFac.length ) continue;
						cell = zipFac[++i];
						if ( cell != null ){
							vals[i] = cell.trim();
//							cell.setCellType(Cell.CELL_TYPE_STRING);
//							vals[i] = cell.getStringCellValue().trim() ;
						}
//						cell = row.getCell(++i);
						if ( i+1 >= zipFac.length ) continue;
						cell = zipFac[++i];
						vals[i] = cell.trim();
						if ( cell != null ){
							vals[i] = cell.trim();
//							cell.setCellType(Cell.CELL_TYPE_STRING);
//							vals[i] = cell.getStringCellValue().trim() ;
							if ( "Location".equals( vals[i] ) ){
								context = VISN;
							} else if ( vals[i] != null && !vals[i].isEmpty() ){
								context = VAMC;
							}
						}
					}
//					_log.info("context:" + context + ", 0:" + vals[0]+ ",1:" + vals[1]+ ",2:" + vals[2]+ ",3:" + vals[3]+ ",4:" + vals[4]);
					
					switch(context){
						case DISTRICT:
							name = vals[0] + StringPool.SPACE + vals[1];
							org = new OrganizationSoapLocal();
							org.setUserId(userId);
							org.setName(name);
							org.setComments(vals[0]);
							org.setParentOrganizationId(caretOrganizationId);
							orgSoapList.add(org);
//							org = OrganizationLocalServiceUtil.addOrganization(userId, caretOrganizationId, name, 
//									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[0], false, serviceContext);
							districtOrgId = org.getOrganizationId();
							added++;
							break;
						case VISN:
							name = vals[1];
							org = new OrganizationSoapLocal();
							org.setUserId(userId);
							org.setName(name);
							org.setComments(vals[2]);
							org.setParentOrganizationId(districtOrgId);
							orgSoapList.add(org);
//							org = OrganizationLocalServiceUtil.addOrganization(userId, districtOrgId, name,
//									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[2], false, serviceContext);
							visnOrgId = org.getOrganizationId();
							added++;
							break;
						case VAMC:
							name = vals[2];
							
							org = new OrganizationSoapLocal();
							org.setUserId(userId);
							org.setName(name);
							org.setComments(StringPool.BLANK);
							org.setParentOrganizationId(visnOrgId);
							orgSoapList.add(org);
//							org = OrganizationLocalServiceUtil.addOrganization( userId, visnOrgId, name,
//									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, StringPool.BLANK, false, serviceContext);
							added++;
							FacilSoap facility = new FacilSoap();
							String v = vals[3].trim();
							StringBuilder sb = new StringBuilder();
							for ( int index = 0; index < v.length(); index++ ){
								if ( Character.isLetterOrDigit( v.charAt(index) ) ){
									sb.append( v.charAt(index) );
								}
							}
							
							facility.setFacilityNumber(sb.toString());
							facility.setLocation(vals[4]);
							facility.setGroupId( org.getOrganizationId() );
							facilLocalServiceUtilList.add( facility );
//							FacilLocalServiceUtil.addFacil(facility);
							addedF++;
					}
				}
				_log.info("added " + added + " orgs and " + addedF + " facilities...");
			} catch (IOException e) {
				ApplicationWorkFlowException.handleException(e);
			} finally {
				try {
					if ( fr != null ) {
						fr.close();
					} 
					if ( br!= null ) {
						br.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			
			for ( FacilSoap facilSoap: facilLocalServiceUtilList ){
				_log.info( facilSoap );
			}
		}
	}
	
	static long id = 1000l;
	
	static class OrganizationSoapLocal extends OrganizationSoap{
		
		long orgId;
		
		public OrganizationSoapLocal(){
			orgId = id++;
		}
		public long getOrganizationId(){
			return orgId;
		}
	}
	
	public static void setup ( ServiceContext serviceContext) throws PortalException, SystemException {
		
		_log.info("begin setup()...");
		String clinicalSite = CaretUtil.getClinicSite();
		Group group;
		try{
			group = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), clinicalSite );
		} catch ( com.liferay.portal.NoSuchGroupException e ){ 
			group = null;
		}
		
		if ( group == null ){
			_log.info("adding Clinic site...");
			group = addSite(clinicalSite, "Autogenerated CareT Clinical Site for workflow", serviceContext);
			_log.info("adding Clinic portlet...");
			addPortlet( serviceContext, group.getGroupId(), CAction.CARET_PORTLET );
		}
		
		String onlineSite = CaretUtil.getOnlineSite();
		try{
			group = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), onlineSite );
		} catch ( com.liferay.portal.NoSuchGroupException e ){ 
			group = null;
		}
		if ( group == null ){
			_log.info("adding Online site...");
			group = addSite(onlineSite, "Autogenerated CareT Online Site for workflow", serviceContext);
			_log.info("adding Online portlet...");
			addPortlet( serviceContext, group.getGroupId(), OnlinePortlet.PLID );
		}
		String roleName = CodifiedRole.getRoleName("VETERAN");
		_log.info("An Online role is " + roleName );
	}
	
	private static Group addSite(String name, String description, ServiceContext serviceContext) {
		int type = GroupConstants.TYPE_SITE_PRIVATE;
		Group group = null;
		try {
			String friendlyUrl = "/" + name.toLowerCase().replace(' ', '-');
			
			serviceContext.setAddGroupPermissions(true);
			long classPK = CounterLocalServiceUtil.increment( Group.class.getName() );
			group = GroupLocalServiceUtil.addGroup(serviceContext.getUserId(), 0, Group.class.getName(), classPK,
					0, name, description, type, false, 0,
					friendlyUrl, true, true, serviceContext);
			
		} catch (DuplicateGroupException e) {
			e.printStackTrace();
		} catch (PortalException e1) {
			e1.printStackTrace();
		} catch (com.liferay.portal.kernel.exception.SystemException e1) {
			e1.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return group;
	}

	private static void addPortlet( ServiceContext serviceContext, long groupId, String plid ) throws PortalException, SystemException {
		
		LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet( groupId, true );
		if ( layoutSet != null ){
			int count = layoutSet.getPageCount();
			if ( count == 0 ){
				String name = PropsUtil.get( "layout.page.name" );
				Layout layout = LayoutLocalServiceUtil.addLayout(serviceContext.getUserId(), groupId, true, 
		                0, name, name, "CareT Landing Page",
		                LayoutConstants.TYPE_PORTLET, true, "/"+name.toLowerCase().replace(' ', '_'), serviceContext);
				
				LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();

				layoutTypePortlet.addPortletId(serviceContext.getUserId(), plid, "column-1", -1, false);
				
				PermissionChecker permissionChecker;
				try {
					permissionChecker = PermissionCheckerFactoryUtil.create( UserLocalServiceUtil.getDefaultUser(serviceContext.getCompanyId()) );
					PermissionThreadLocal.setPermissionChecker( permissionChecker );
				} catch (Exception e) {
					e.printStackTrace();
				}
				
				UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
				typeSettingsProperties.setProperty("layout-template-id", "1_column");
				
				layout.setTypeSettingsProperties(typeSettingsProperties);
				layout = LayoutLocalServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
				
				layoutSet = LayoutSetLocalServiceUtil.updateLogo( groupId, true, true, BootStrapUtil.class.getClassLoader().getResourceAsStream("caretLogo.png") );

			}
		}
	}


	static class UserImport {
		public UserImport(long roleId, long orgId, String emailAddress, String screenName, String first,
				String last, String password, boolean isOnline) {
			super();
			this.roleId = roleId;
			this.emailAddress = emailAddress;
			this.screenName = screenName;
			if ( orgId > 0 ){
				this.orgId = new long[]{orgId};
			}
			this.password = password;
			this.first = first;
			this.last = last;
			this.isOnline = isOnline;
		}
	
		public String emailAddress, screenName, password, first, last;
		public long roleId;
		public long[] orgId = null;
		boolean isOnline = false;
	}

	public static void addUsers( ServiceContext serviceContext ) throws ApplicationWorkFlowException, SystemException   {
		
		File csvFile = new File ( PropsUtil.get("spreadsheet.location") + "/users.csv" );
		boolean exists = FileUtil.exists(csvFile);
		if ( !exists ){
			_log.error("could not find "+ PropsUtil.get("spreadsheet.location") + "/users.csv");
			return;
		}
		
		long caretId = 0;
		String clinicSite = CaretUtil.getClinicSite( );
		String onlineSite = CaretUtil.getOnlineSite( );
		
		try {
			caretId = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), clinicSite ).getGroupId();
		} catch (PortalException e1) {
			e1.printStackTrace();
			return;
		}
		BufferedReader br = null;
		String line = "";
		List<UserImport> users = new ArrayList<UserImport>();
	
		try {
			br = new BufferedReader(new FileReader(csvFile));
			while ((line = br.readLine()) != null) { //parse and validate...
				String[] userRow = line.split(",");
				String roleName = userRow[0];
				if ( "ROLE".equals(roleName) ) {
					continue;
				}
				long orgId = 0;
				Role role = RoleLocalServiceUtil.fetchRole( serviceContext.getCompanyId(), roleName );
				if ( role == null ) {
					continue;
				}
				boolean isOnline = role.getSubtype().isEmpty();
				long roleId = role.getRoleId();
				User user = null;
				try {// validation...
					if ( userRow.length > 5 ){
						orgId = OrganizationLocalServiceUtil.getOrganization( serviceContext.getCompanyId(), userRow[5] ).getOrganizationId();
					}
					user = UserLocalServiceUtil.getUserByScreenName( serviceContext.getCompanyId(), userRow[1] );
					if ( user == null ){
						user = UserLocalServiceUtil.getUserByEmailAddress( serviceContext.getCompanyId(), userRow[1]+"@caret.gov" );
					}
				} catch (PortalException e) { //ignoring exception thrown when the user does not exist... 
				}
				
				if ( user == null ){
					users.add( new UserImport(roleId, orgId, userRow[1]+"@caret.gov", userRow[1], 
												userRow[2], userRow[3], userRow[4], isOnline) );
				}
			}
			
			for ( UserImport userImport: users ){
				long[] roleId = userImport.isOnline? new long[]{} : new long[]{userImport.roleId};
				long[] groupId = userImport.isOnline? new long[]{} : new long[]{caretId};
				boolean autoPassword = true;
				boolean isMale = true;
				int bdayMonth = 10;
				int bdayDay = 15;
				int bdayYear = 1980;
				
				
				User user = UserLocalServiceUtil.addUser(serviceContext.getUserId(), serviceContext.getCompanyId(), autoPassword, userImport.password,
					userImport.password, false, userImport.screenName, userImport.emailAddress, 
					0, StringPool.BLANK, LocaleUtil.getDefault(), userImport.first, "Middle", userImport.last, 0, 0, isMale, bdayMonth, bdayDay, bdayYear, "CareT User", 
					groupId, userImport.orgId, roleId, new long[]{}, false, serviceContext);
				if ( userImport.isOnline ){
					Group online = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), onlineSite );
					// UserGroupRoleLocalServiceUtil.deleteUserGroupRoles( user.getUserId(), new long[]{online.getGroupId()} );
					UserGroupRoleLocalServiceUtil.addUserGroupRoles( new long[]{user.getUserId()}, online.getGroupId(),
							userImport.roleId);
				}
			}
			
		} catch (FileNotFoundException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			e.printStackTrace();
		} finally {
			if (br != null) {
				try {
					br.close();
				} catch (IOException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
	}
	
}
