package gov.va.caret.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.regex.Pattern;

import org.apache.commons.beanutils.Converter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.BaseModel;
import com.liferay.util.portlet.PortletProps;

import freemarker.template.utility.StringUtil;
import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Call;
import gov.va.caret.model.Note;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.CallImpl;
import gov.va.caret.model.support.CallSupport;
import gov.va.caret.model.support.Person;



public class Toolbox {

	static final String CARET_DATE_FORMAT = "MM/dd/yy";
	static final String CARET_DATE_ORIENT = "yyyyMMdd";
	static final String CARET_DATE_ORIENT_FMS = "yyMMdd";
	static final String CARET_DATETIME_ORIENT = "yyyyMMddHHmmss";
	static final String CARET_DATE_FORMAT_PDF = "MM-dd-yyyy";
	static final String CARET_DATE_FORMAT_CPRS = "MM/dd/yyyy";
	public static final String CARET_DATE_FORMAT_UI = "MM/DD/YYYY";
	static final String CARET_DATETIME_FORMAT = "MM/dd/yy hh:mm a";
	static final String CARET_DATETIME_METADATA_FORMAT = "MM/dd/yyyy hh:mm:ss a z";
	public static final String CARET_DATETIME_FORMAT_UI_FULL = "MM/dd/yyyy hh:mm a z";
	static final String CARET_DATETIME_FORMAT_EXPANDED = "EEE MMM dd HH:mm:ss z yyyy";
	static final String PHONE_REGEX = "(\\d{3})(\\d{3})(\\d+)";
	
	private static Format currencyInstance = null;
	private static Format dateFormat = null;
	private static Format dateFormatPdf = null;
	private static Format dateFormatCprs = null;
	private static Format dateTimeFormat = null;
	private static Format dateMetadata = null;
	private static Format dateFormatOrient = null;
	private static Format dateFormatOrientShort = null;
	private static Format dateTimeFormatOrient = null;
	private static Format dateTimeFormatExpanded = null;
	private static Format vaafiDateFormat = null;
	
	public static final String FOUR = "0000";
	public static final String THREE = "000";
	private static final String TWO = "00";
	private static final String ONE = "0";
	public static final int DEFAULT_MAX = 75;
	public static final String[] MONTHS = DateFormatSymbols.getInstance().getMonths();
	
	public static Pattern partialPhoneFormat = null;
	public static Pattern fullPhoneFormat = null;
	public static Pattern systemCallNotePattern = null;
	public static Pattern facilityPattern_alpha = null;
	public static Pattern facilityPattern_numer = null;		

	public static Map<String, Object> registerInputValue = null;
	public static Map<String, String> phoneReplacementChars = null;
	static {
		phoneReplacementChars = new HashMap<String,String>();
		phoneReplacementChars.put(" ","");
		phoneReplacementChars.put("-","");
		phoneReplacementChars.put("(","");
		phoneReplacementChars.put(")","");
		//
		partialPhoneFormat = Pattern.compile("\\(?([0-9]{1,3})[\\)]?[- ]?([0-9]{0,3})[- ]?([0-9]{0,4})");
		fullPhoneFormat = Pattern.compile("\\(([0-9]{3})[\\)][ ]{1}([0-9]{3})[-]{1}([0-9]{4})");
		systemCallNotePattern = Pattern.compile("([a-zA-Z0-9'-_ ]*)\\Wcreated([a-zA-Z0-9'-_ ]*)\\Was\\W(.*)");
		facilityPattern_alpha = Pattern.compile("([a-zA-Z'-\\. ]*)");
		facilityPattern_numer = Pattern.compile("([0-9]{1,5}).*");			
		//
		registerInputValue = new HashMap<String,Object>();
	}
	
	
	public static class DateConverter implements Converter {
		@SuppressWarnings("rawtypes")
		public Object convert(Class type, Object value ){
			if ( value == null ){
				return null;
			}
			if ( value instanceof Date ){
				return value;
			} else {
				try {
					return parseDate( value.toString() );
				} catch ( Exception e ){
					_log.error("converter failed..." , e);
				}
			}
			return null;
		}
	}
	
	public static Format getDateFormat(){
		if ( dateFormat == null ){
			dateFormat = new DateFormatThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormat;
	}
	
	public static Format getDateFormatVaafi(){
		if ( vaafiDateFormat == null ){
			vaafiDateFormat = new DateFormatVaafiThreadLocal<SimpleDateFormat>().get();
		}
		return vaafiDateFormat;
	}
	
	public static Format getDateFormatPdf(){
		if ( dateFormatPdf == null ){
			dateFormatPdf = new DateFormatPdfThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatPdf;
	}
	
	public static Format getDateFormatOrient(){
		if ( dateFormatOrient == null ){
			dateFormatOrient = new DateFormatOrientThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatOrient;
	}
	
	public static Format getDateFormatOrientShort(){
		if ( dateFormatOrientShort == null ){
			dateFormatOrientShort = new DateFormatOrientShortThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatOrientShort;
	}
	
	public static Format getDateTimeFormatOrient(){
		if ( dateTimeFormatOrient == null ){
			dateTimeFormatOrient = new DateTimeFormatOrientThreadLocal<SimpleDateFormat>().get();
		}
		return dateTimeFormatOrient;
	}
	
	public static Format getDateFormatCprs(){
		if ( dateFormatCprs == null ){
			dateFormatCprs = new DateFormatCprsThreadLocal<SimpleDateFormat>().get();
		}
		return dateFormatCprs;
	}

	public static Format getDateTimeFormatExpanded(){
		if ( dateTimeFormatExpanded == null ){
			dateTimeFormatExpanded = new DateTimeFormatExpandedThreadLocal<SimpleDateFormat>().get();
		}
		return dateTimeFormatExpanded;
	}

	public static Format getDateTimeFormat() {
		if ( dateTimeFormat == null ){
			dateTimeFormat  = new DateTimeFormatThreadLocal<SimpleDateFormat>().get();
		}
		return dateTimeFormat;
	}
	
	public static Format getDateMetadataFormat() {
		if ( dateMetadata == null ){
			dateMetadata  = new DateFormatMetadataThreadLocal<SimpleDateFormat>().get();
		}
		return dateMetadata;
	}

	public static String currencyFormat ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		if ( currencyInstance == null ){
			currencyInstance = new ThreadLocal<NumberFormat>().get();
		}
		return currencyInstance.format( value );
	}
	
	public static String formatDate ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormat().format( value );
	}
	
	public static String formatDatePdf ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatPdf().format( value );
	}
	
	public static String formatDateOrient ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatOrient().format( value );
	}
	
	public static String formatDateCprs ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateFormatCprs().format( value );
	}
	
	public static String formatDateTimeMetadata ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateMetadataFormat().format( value );
	}
	
	public static String formatDateTime ( Object value ){
		if ( value == null ) {
			return StringPool.BLANK;
		}
		return getDateTimeFormat().format( value );
	}
	
	public static String formatZip ( Object value ){
		if ( !isEmpty((String)value) ) {
			int length = value.toString().length();
			if (length > 5) {
				return value.toString().trim().substring(0, Math.min(value.toString().length(), 5));
			}
			if ( length > 4 ) return value.toString();
			
			switch(length){
				case 4: return ONE + value; 
				case 3: return TWO + value; 
				case 2: return THREE + value; 
				case 1: return FOUR + value; 
			}
		}
		return StringPool.BLANK;
	}
	
	public static String formatBigZip ( String nineZip ) {
		if ( !isEmpty(nineZip) ) {
			return formatZip( nineZip.trim().substring(0, Math.min(nineZip.length(), 5)) );
		}
		return StringPool.BLANK;
	}
	
	public static String formatSsn ( String value ){
		if ( !isEmpty(value) ) {
			if ( Person.SSN_FORMAT.equals(value) ) {
				return StringPool.BLANK;
			}
			if ( value.length() == 9 ) {
				return new StringBuilder(value).insert(5, '-').insert(3, '-').toString();
			} 
			if ( value.length() == 11 ) {
				return value;
			}
			ApplicationWorkFlowException.handleException("Invalid PII data provided " + value.length() );
		}
		return StringPool.BLANK;
	}
	
	public static Date parseDate ( String dateStr ){
		if ( isEmpty(dateStr) || CARET_DATE_FORMAT_UI.equals(dateStr) ) return null;
		try {
			return (Date) getDateFormat().parseObject( dateStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 1 " + dateStr);
		}
		return null;
	}
		
	public static Date parseMetadataTime ( String dateTimeStr ){
		if ( isEmpty(dateTimeStr) ) return null;
		try {
			return (Date) getDateMetadataFormat().parseObject( dateTimeStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 2 " + dateTimeStr);
		}
		return null;
	}
	
	public static Date parseDateTime ( String dateTimeStr ){
		if ( isEmpty(dateTimeStr) ) return null;
		try {
			return (Date) getDateTimeFormat().parseObject( dateTimeStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 3 " + dateTimeStr);
			return parseDate( dateTimeStr );
		}
//		return null;
	}
	
	public static Date parseOrientDate ( String dateStr ){
		if ( isEmpty(dateStr) ) return null;
		try {
			return (Date) getDateFormatOrient().parseObject( dateStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 4 " + dateStr );
		}
		return null;
	}
	
	public static Date parseHeaderDate ( String dateStr ){
		if ( isEmpty(dateStr) ) return null;
		try {
			return (Date) getDateFormatVaafi().parseObject( dateStr );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException("Invalid date format provided 4 " + dateStr );
		}
		return null;
	}
	
	public static int getInteger ( Map<String,Object> map, String key ){
		return ( (java.math.BigDecimal) map.get(key) ).intValue();
	}
	
	public static long getLong ( Map<String,Object> map, String key ){
		return ( (java.math.BigDecimal) map.get(key) ).longValue();
	}
	
	public static boolean getBoolean ( String key, Map<String,String> map ){
		return GetterUtil.getBoolean( map.get(key) );
	}
	
	public static String fromBoolToYesNo(boolean b) {
		return b ? "Yes" : "No";
	}
	
	public static long getLong ( String key, Map<String,String> map ){
		return GetterUtil.getLong( map.get(key) );
	}
	
	
	public static Map<String, Object> getMap(Object... appId){
		Map<String, Object> map = new HashMap<String, Object>();
		for ( int i = 0; i < appId.length; i++ ){
			map.put( CaretStrPool.NDX +i, appId[i]);
		}
		return map;
	}
	
	public static Collection<String> getCollection(Object... appId){
		Collection<String> collection = new ArrayList<String>();
		for ( int i = 0; i < appId.length; i++ ){
			collection.add( appId[i].toString() );
		}
		return collection;
	}
	
	
	public static boolean isEmpty( String entry ) {
		return entry == null || entry.trim().length() == 0;
	}
	
	public static String nullSafe( Object entry ) {
		return entry == null? StringPool.BLANK : entry.toString();
	}
	
	@SuppressWarnings({ "rawtypes" })
	public static String chomp(Class c, BaseModel baseModel, String attribute,
			String value) {
		if ( modelConfig == null ){
			setModelConfig();
		}
		
		Class[] interfaces = c.getInterfaces();
		Class use = interfaces.length > 0? interfaces[0] : c;
		
		if ( value != null && modelConfig.containsKey( use ) ){
			Map<String,Integer> rules = modelConfig.get( use ) ;
			int rule = rules.get( attribute );
			return value.substring(0, Math.min( value.length(), rule ) );
		}
		
		return value.substring(0, Math.min( value.length(), DEFAULT_MAX ) );
	}

	@SuppressWarnings("rawtypes")
	private static void setModelConfig() {
		modelConfig = new HashMap<Class,Map<String,Integer>>();
		
		Map<String,Integer> configMap = new CaretMap<String,Integer>(75);
		configMap.put("comment", 400); 
		modelConfig.put( VcgAn.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("value", 400); 
		modelConfig.put( Note.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("cbopcNotes", 400);
		configMap.put("cscNotes", 400);
		modelConfig.put( Vcg.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("label", 255);
		modelConfig.put( BoxGp.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("transferRemarks", CallSupport.getExtendedFieldLength());
		configMap.put("summary", CallSupport.getExtendedFieldLength());
		configMap.put("message", CallSupport.getExtendedFieldLength());
		modelConfig.put( Call.class, configMap );
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("transferRemarks", CallSupport.getExtendedFieldLength());
		configMap.put("summary", CallSupport.getExtendedFieldLength());
		configMap.put("message", CallSupport.getExtendedFieldLength());
		modelConfig.put( CallImpl.class, configMap );	
		
		configMap = new CaretMap<String,Integer>(75);
		configMap.put("transferRemarks", CallSupport.getExtendedFieldLength());
		configMap.put("summary", CallSupport.getExtendedFieldLength());
		configMap.put("message", CallSupport.getExtendedFieldLength());
		modelConfig.put( CallSupport.class, configMap );			

	}
	
	public static Date subtractFromNow ( double doubleValue ) {
		double flooredValue = Math.floor( doubleValue );
		double percentDay = doubleValue - flooredValue;
		
		Calendar calendar = Calendar.getInstance();
		if ( percentDay > 0 ){
			int minutesInt = Double.valueOf(percentDay * 24 * 60).intValue();
			if ( _log.isInfoEnabled() ){
				_log.info("subtracting minutes " + minutesInt );
			}
			calendar.add(Calendar.MINUTE, -minutesInt);
		}
		if ( percentDay >= 1){
			if ( _log.isInfoEnabled() ){
				_log.info("subtracting days for date..." + Double.valueOf(doubleValue).intValue() );
			}
			calendar.add(Calendar.DAY_OF_YEAR, -Double.valueOf(doubleValue).intValue() );
		}
		return calendar.getTime();
//		return adjustDate(doubleValue, new Date(), false);
	}
	
	public static Date adjustDate ( double doubleValue, Date date, boolean up ) {
		double days = Math.floor( doubleValue );
		double remainderPercentDay = doubleValue - days;
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		if ( remainderPercentDay > 0 ){
			int minutesInt = Double.valueOf(remainderPercentDay * 24 * 60).intValue();
			if ( _log.isInfoEnabled() ){
				_log.info( (up? " increasing ": "subtracting ") + "minutes by " + minutesInt );
			}
			calendar.add(Calendar.MINUTE, up? minutesInt : -minutesInt);
		}
		if ( days >= 1){
			if ( _log.isInfoEnabled() ){
				_log.info( (up?"increasing ": "subtracting ") + "days by " + days );
			}
			calendar.add(Calendar.DAY_OF_YEAR, up? (int)days: (int)-days );
		}
		if ( _log.isDebugEnabled() ){
			_log.debug( "now.compareTo(rollDate): " + new Date().compareTo( calendar.getTime() ) );
		}
		return calendar.getTime();
	}
	
	
	public static Date adjustBusinessDate( double days, Date startDate, boolean up ) 
	{		
	    Calendar calendar = Calendar.getInstance();
	    calendar.setTime(startDate);
    
	    for(int i=0;i<=days;)
	    {
			calendar.add(Calendar.DAY_OF_YEAR, up? 1: -1 );

	        if(!BusinessDayUtil.isWeekend(calendar) && !BusinessDayUtil.isHoliday(calendar))
	        {
	            i++;
	        }
	    }  
	    if ( _log.isDebugEnabled() ){
	    	_log.debug("due date is : "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
	    }
		return calendar.getTime();
	}
	
	public static String getWeekRange ( Date weekDate ) {
		
		Calendar calendar = new GregorianCalendar();
		calendar.setTime( weekDate );     
		while ( calendar.get(Calendar.DAY_OF_WEEK) > Calendar.SUNDAY ) {
			calendar.roll(Calendar.DAY_OF_YEAR, false);
		}
		Date sunday = calendar.getTime();
		calendar.add(Calendar.DAY_OF_YEAR, 6);
		
		return "Week " + calendar.get(Calendar.WEEK_OF_YEAR) + ", " + Toolbox.formatDate( sunday ) + " - " +  Toolbox.formatDate( calendar.getTime() ) ;
	}

	@SuppressWarnings("rawtypes")
	private static Map<Class,Map<String,Integer>> modelConfig = null;
	private static Log _log = LogFactoryUtil.getLog( Toolbox.class );
	
	public static boolean toBoolYesNo(String label) {
		return CaretStrPool.YES.equals(label);
	}

	public static Collection<String> getAddressCollection() {
		return Toolbox.getCollection("city","state","zip","validAddress");
	}
	
	public static String parsePhone(String phone) {
		if ( Person.PHONE_FORMAT.equals( phone ) || Toolbox.isEmpty(phone) ){
			return StringPool.BLANK;
		}//TODO: Investigate if POSSIBLE DEFECT parsing here...
		return phone.replace(StringPool.OPEN_PARENTHESIS, StringPool.BLANK).
				replace(StringPool.CLOSE_PARENTHESIS, StringPool.BLANK).
				replace(StringPool.DASH, StringPool.BLANK).
				replaceFirst ( PHONE_REGEX, "($1) $2-$3");
	}
	
	public static String parseEmail(String email) {
		if ( Person.EMAIL_FORMAT.equals( email ) ){
			return StringPool.BLANK;
		}
		return email;
	}
	
	public static String decode ( String string, boolean recapitalize ){
		if ( isEmpty(string) || string.toUpperCase().contains(CaretStrPool.NOT_FOUND) ){
			return StringPool.BLANK;
		}
		try {
			String decoded = URLDecoder.decode( string, StringPool.UTF8 );
			return recapitalize? StringUtil.capitalize(decoded.toLowerCase()) : decoded;
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return string;
	}
	
	//https://stackoverflow.com/questions/13592236/parse-a-uri-string-into-name-value-collection
	public static Map<String, String> getUrlQuery(String query) throws UnsupportedEncodingException {
		if ( Toolbox.isEmpty(query) ) return Collections.emptyMap();
	    Map<String, String> query_pairs = new LinkedHashMap<String, String>();
	    String[] pairs = query.split(StringPool.AMPERSAND);
	    for (String pair : pairs) {
	        int idx = pair.indexOf(StringPool.EQUAL);
	        query_pairs.put(URLDecoder.decode(pair.substring(0, idx), StringPool.UTF8), URLDecoder.decode(pair.substring(idx + 1), StringPool.UTF8));
	    }
	    return query_pairs;
	}
	public static String replaceFromMap(String string,
	        Map<String, String> replacements) {
	    StringBuilder sb = new StringBuilder(string);
	    for (Entry<String, String> entry : replacements.entrySet()) {
	        String key = entry.getKey();
	        String value = entry.getValue();

	        int start = sb.indexOf(key, 0);
	        while (start > -1) {
	            int end = start + key.length();
	            int nextSearchStart = start + value.length();
	            sb.replace(start, end, value);
	            start = sb.indexOf(key, nextSearchStart);
	        }
	    }
	    return sb.toString();
	} 
	public static String formatPartialPhoneFromStripped(String in) {
		char[] chars = in.toCharArray();
		StringBuilder sb = new StringBuilder(15);
		switch(chars.length) {
		case 10: sb.append(chars[9]);
		case 9: sb.append(chars[8]);
		case 8: sb.append(chars[7]);
		case 7: sb.append(chars[6]);
		case 6: sb.append('-');
		        sb.append(chars[5]);
		case 5: sb.append(chars[4]);
		case 4: sb.append(chars[3]);
		case 3: sb.append(' ');
		        sb.append(')');
		        sb.append(chars[2]);
		case 2: sb.append(chars[1]);
		case 1: sb.append(chars[0]);
		        sb.append('(');
		}
		return (sb.reverse()).toString();
	}
	public static Object getRegisteredValue(String key) {
		return Toolbox.registerInputValue != null && Toolbox.registerInputValue.size() > 0 ? Toolbox.registerInputValue.get(key) : null;
	}
	public static void removeRegisteredValue(String key) {
		if (Toolbox.registerInputValue != null && Toolbox.registerInputValue.size() > 0) {
			Toolbox.registerInputValue.remove(key);
		}
	}
	public static long getBgLaeDay() {
		return (System.currentTimeMillis()/86400000 + 200000);
	}
	public static String toString(String[] in) {
		if (ArrayUtil.isEmpty(in)) {return "";}
		//
		StringBuilder builder = new StringBuilder();
		for(String s : in) {
			builder.append(s);
		}
		return builder.toString();
	}	
	public static String[] sortWithInsertionSort(String[] inputArray) {
		  int i,j;
		  String key;
		  for (j = 1; j < inputArray.length; j++) { 
		    key = inputArray[j];
		    i = j - 1;
		    while (i >= 0) {
		      if (key.compareTo(inputArray[i]) > 0) {
		        break;
		      }
		      inputArray[i + 1] = inputArray[i];
		      i--;
		    }
		    inputArray[i + 1] = key;
		  }
		  return inputArray;
	}	
	public static boolean isSameDay(Date date1, Date date2) {
		Calendar cal1 = Calendar.getInstance();
		Calendar cal2 = Calendar.getInstance();
		cal1.setTime(date1);
		cal2.setTime(date2);
		return cal1.get(Calendar.DAY_OF_YEAR) == cal2.get(Calendar.DAY_OF_YEAR) && cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR);		
	}

	public static boolean isUspsCity( String[] string ) {
		String[] parts = string[0].split(StringPool.SPACE);
		boolean changed = false;
		StringBuilder sb = new StringBuilder();
		for (String city: parts ) {
			String cityAbbr = PortletProps.get( "city." + city );
			if ( !Toolbox.isEmpty( cityAbbr ) ) {
				changed = true;
			}
			sb.append( changed? cityAbbr : city ).append(StringPool.SPACE);
		}
		if ( changed ) {
			string[0] = sb.toString().trim();
			return false;
		}
		return true;
	}	
	public static boolean isNumericInt(String in) {
		try {
			int i = Integer.parseInt(in);
		}
		catch(NumberFormatException nfe) {
			return false;
		}
		return true;
	}
}
