package gov.va.caret.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import freemarker.cache.ClassTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

public class TemplateHandler {

	private static Log _log = LogFactoryUtil.getLog( TemplateHandler.class );
	//TODO: scalable test
	public String loadTemplate( Map<String,Object> templateParams, String templatePath, String templateName ) throws IOException {
		Configuration cfg = new Configuration();
		cfg.setDefaultEncoding("UTF-8");
		Template template;
		try {
			cfg.setTemplateLoader( new ClassTemplateLoader(getClass(), templatePath ) );
			template = cfg.getTemplate(templateName);
		} catch (Exception e){
			e.printStackTrace();
			return null;
		}
		String loadedTemplate = null;
		StringWriter out = new StringWriter();
		try {
			template.process(templateParams, out);
		} catch (TemplateException e) {
			e.printStackTrace();
		}
		loadedTemplate = out.getBuffer().toString();
		out.flush();
		if ( _log.isDebugEnabled() ){
			_log.debug(loadedTemplate);
		}
		return loadedTemplate;
	}
	
}
