package gov.va.caret.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.User;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Persn;
import gov.va.caret.model.support.AssmtSupport;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.view.CachedReport;
import gov.va.iam.IamService;

public class PersonSearches  {
	public static List<Persn> getExistingPersonsByCallerCriteria(Persn caller) {
		List<Persn> persnSearch = new ArrayList<Persn>();
		if (caller != null) {
			String callerLastName = caller.getLastName();
			String callerFirstName = caller.getFirstName();
			String callerMiddleName = caller.getMiddleName();
			String callerSuffix = caller.getSuffix();
			String callerPhone = caller.getPhone();
			String callerEmail = caller.getEmail();
			String callerState = caller.getState();
			//_log.info("MINT: lastName: " + callerLastName);
			//_log.info("MINT: firstName: " + callerFirstName);
			//_log.info("MINT: middleName: " + callerMiddleName);
			//_log.info("MINT: phone: " + callerPhone);
			//_log.info("MINT: email: " + callerEmail);
			//_log.info("MINT: state: " + callerState);
									
			persnSearch = CachedReport.searchPerson(
				Toolbox.isEmpty(callerFirstName) ? null : callerFirstName, //1
				Toolbox.isEmpty(callerLastName) ? null : callerLastName,   //2
				Toolbox.isEmpty(callerMiddleName) ? null : callerMiddleName, //3 
				null,  //4
				Toolbox.isEmpty(callerPhone) ? null : callerPhone, //5  
				null,  //6
				null, //7
				null, //8
				null, //9
				Toolbox.isEmpty(callerState) ? null : callerState, //10
				null, //11
				Toolbox.isEmpty(callerEmail) ? null : callerEmail, //12 
				null, //13
				false, //14
				new boolean[1]); //15
		}
		return persnSearch;
	}
	public static List<Persn> getExistingPersonsByVeteranCriteria(Persn persn) {
		Veteran veteran = (Veteran) persn;
		List<Persn> persnSearch = new ArrayList<Persn>();
		if (veteran != null) {
			String veteranSsn = veteran.getSsn();
			String veteranLastName = veteran.getLastName();
			String veteranFirstName = veteran.getFirstName();
			String veteranMiddleName = veteran.getMiddleName();
			String veteranSuffix = veteran.getSuffix();
			Date veteranBirthDate = veteran.getBirthDate();
			String veteranCountry = veteran.getCountry();
			String veteranAddress = veteran.getAddress();
			String veteranAddress2 = veteran.getAddress2();
			String veteranCity = veteran.getCity();
			String veteranState = veteran.getState();
			String veteranZip = veteran.getZip();
			String veteranPhone = veteran.getPhone();
			String veteranEmail = veteran.getEmail();
			String veteranGender = veteran.getGender();
			String veteranFacility = veteran.getFacilityName();

			persnSearch = CachedReport.searchPerson(
				Toolbox.isEmpty(veteranFirstName) ? null : veteranFirstName, //1
				Toolbox.isEmpty(veteranLastName) ? null : veteranLastName,   //2
				Toolbox.isEmpty(veteranMiddleName) ? null : veteranMiddleName, //3 
				Toolbox.isEmpty(veteranSsn) ? null : veteranSsn,  //4
				Toolbox.isEmpty(veteranPhone) ? null : veteranPhone, //5  
				null,  //6
				Toolbox.isEmpty(veteranGender) ? null : veteranGender,  //7
				Toolbox.isEmpty(veteranAddress) ? null : veteranAddress, //8
				Toolbox.isEmpty(veteranCity) ? null : veteranCity, //9
				Toolbox.isEmpty(veteranState) ? null : veteranState, //10
				Toolbox.isEmpty(veteranZip) ? null : veteranZip, //11
				Toolbox.isEmpty(veteranEmail) ? null : veteranEmail, //12 
				veteranBirthDate == null ? null : veteranBirthDate, //13
				false, //14
				new boolean[1]); //15
			
//			if (CollectionUtils.isEmpty(persnSearch)) {
//				persnSearch = CachedReport.searchPerson(
//						Toolbox.isEmpty(veteranFirstName) ? null : veteranFirstName, //1
//						Toolbox.isEmpty(veteranLastName) ? null : veteranLastName,   //2
//						null , //3 
//						Toolbox.isEmpty(veteranSsn) ? null : veteranSsn,  //4
//						null ,  //5  
//						null,  //6
//						null ,   //7
//						null ,  //8
//						null ,  //9
//						null ,  //10
//						null ,  //11
//						null ,  //12 
//						null ,  //13
//						false, //14
//						new boolean[1]); //15			
//			}			
		}
		return persnSearch;
	}	
	public static Map<Long,List<Persn>> getExistingPersonsMapByLastNamePhoneNumberBirthDate(Set<Long> caregivers) {
		Map<Long,List<Persn>> existingPersonsMap = new HashMap<Long,List<Persn>>();
		try {
			for(Long caregiverId : caregivers) {
				existingPersonsMap.put(caregiverId, getExistingPersonsByLastNamePhoneNumberBirthDate(caregiverId));
			}
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return existingPersonsMap;
	}
	public static List<Persn> getExistingPersonsByLastNamePhoneNumberBirthDate(Long caregiverId) {
		List<Persn> persnSearch = new ArrayList<Persn>();
		if (caregiverId != null && caregiverId > 0) {
			try {
				Persn caregiverMain = PersnLocalServiceUtil.getPersn(caregiverId);
				if (caregiverMain != null) {
					String cgMainLastName = caregiverMain.getLastName();
					String cgMainPhone = caregiverMain.getPhone();
					Date cgMainBirthdate = caregiverMain.getBirthDate();
					(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCPQ.Q.meth5: lastName: " + cgMainLastName);
					(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCPQ.Q.meth5: phone: " + cgMainPhone);
					(LogFactoryUtil.getLog(AssmtSupport.class)).info("MCPQ.Q.meth5: date: " + cgMainBirthdate);
					if (!Toolbox.isEmpty(cgMainLastName) && !Toolbox.isEmpty(cgMainPhone) && cgMainBirthdate != null) {
						persnSearch = CachedReport.searchPerson(null, cgMainLastName, null, null, cgMainPhone, null, null, null, null, null, null, cgMainBirthdate, false, new boolean[1]);
						//TODO: persnSearch that returns a report WITH the ssn!
					}
				}
			}
			catch(Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return persnSearch;
	}			
	public static Map<Long,List<Persn>> getExistingPersonsMapByLastNameSSNBirthDateGender(User user, Set<Long> caregivers) {
		Map<Long,List<Persn>> existingPersonsMap = new HashMap<Long,List<Persn>>();
		try {
			for(Long caregiverId : caregivers) {
				existingPersonsMap.put(caregiverId, getExistingPersonsMapByLastNameSSNBirthDateGender(user, caregiverId));
			}
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return existingPersonsMap;
	}
	public static List<Persn> getExistingPersonsMapByLastNameSSNBirthDateGender(User user, Long caregiverId) {
		List<Persn> persnSearch = new ArrayList<Persn>();
		if (caregiverId != null && caregiverId > 0) {
			try {
				Persn caregiverMain = PersnLocalServiceUtil.getPersn(caregiverId);
				if (caregiverMain != null) {
					
					String lname = caregiverMain.getLastName();					
					String fname = caregiverMain.getFirstName();
					String mname = caregiverMain.getMiddleName();
					String suffix = caregiverMain.getSuffix(); 
					String gender = caregiverMain.getGender();
					String city = caregiverMain.getCity();
					String zip = caregiverMain.getZip();
					String email = caregiverMain.getEmail();
					String address = caregiverMain.getAddress();
					String birthdate = Toolbox.formatDateCprs(caregiverMain.getBirthDate());
					String phone = caregiverMain.getPhone();
					String phone2 = caregiverMain.getPhone2();	
					
					//JSONArray vcgsOne = PersonSearches.searchVcg(user, fname, lname, mname, suffix, gender, "", city, zip, email, address, birthdate, phone, phone2, CaretStrPool.ACTIVE_VCG);
//					JSONArray vcgsOne = PersonSearches.searchVcg(user, fname, lname, mname, "", gender, "", "", "", "", "", birthdate, "(###) ###-####", "", CaretStrPool.ACTIVE_VCG);
					JSONArray vcgsOne = PersonSearches.searchVcg(user, fname, lname, mname, "", gender, "", "", "", "", "", birthdate, "(###) ###-####", "", CaretStrPool.ACTIVE_VCG);

					
					String ssn = parseVcgsForSSN(vcgsOne);
					_log.info("Search::: ssn_lname_bdate_gender...................3: ssn: " + ssn);
					JSONArray vcgsResults = PersonSearches.searchVcg(user, "", lname, "", "", gender, ssn, "", "", "", "", birthdate, "", "", CaretStrPool.ACTIVE_VCG);
					_log.info("Search::: ssn_lname_bdate_gender...................4: results: ");
					_log.info("Search::: " + vcgsResults);
					
					List<Long> primaryKeys = parseVcgsForPrimaryKey(vcgsResults);
					for(Long primaryKey : primaryKeys) {
						Persn caregiver = PersnLocalServiceUtil.getPersn(primaryKey);
						persnSearch.add(caregiver);
					}
				}
			}
			catch(Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return persnSearch;
	}	
	public static JSONArray searchVcg ( 
			User user,
			String fname, String lname, String mname, String suffix, 
			String gender, 
			String ssn, 
			String city, String zip, String email, String address, 
			String birthdate, String phone, String phone2, String searchType ) {

		boolean restricted = false; 
		if (Toolbox.isEmpty(searchType)) {searchType = CaretStrPool.ACTIVE_VCG;}
		
//		_log.info("[searchVcg] restricted=" + restricted);
//		_log.info("[searchVcg] fname=" + fname);
//		_log.info("[searchVcg] lname=" + lname);
//		_log.info("[searchVcg] mname=" + mname);
//		_log.info("[searchVcg] gender=" + gender);
//		_log.info("[searchVcg] ssn=" + ssn);
//		_log.info("[searchVcg] city=" + city);
//		_log.info("[searchVcg] zip=" + zip);
//		_log.info("[searchVcg] email=" + email);
//		_log.info("[searchVcg] address=" + address);
//		_log.info("[searchVcg] birthdate=" + birthdate);
//		_log.info("[searchVcg] phone=" + phone);
//		_log.info("[searchVcg] phone2=" + phone2);
//		_log.info("[searchVcg] searchType=" + searchType);		

		boolean uniqueFactor = false;	

		JSONObject vcg, json = JSONFactoryUtil.createJSONObject();
		JSONArray vcgs = JSONFactoryUtil.createJSONArray();

		boolean skipSearch = lname.isEmpty();
		List<Person> list = Collections.emptyList();
		int size = 0;
		if (!skipSearch) {

			List<Persn> listLocal = CachedReport.searchPerson( fname, lname, mname, ssn, phone, phone2, gender, address, city, zip, email, Toolbox.parseDate( birthdate ), uniqueFactor);			
			
			if (listLocal.isEmpty() && CaretUtil.isMviEnabled()) {
				try {
					Map<String, Object> map = new CaretMap<String, Object>(StringPool.BLANK);
					map.put("searchLastName", lname);
					map.put("searchFirstName", fname);
					map.put("searchBirthday", Person.mviFormat( Person.DOB, birthdate ) );
					map.put("searchSsn", Person.mviFormat( Person.SSN, ssn ) );
					map.put("searchMiddleName", mname);
					map.put("suffix", suffix);
					map.put("searchPhone", Person.mviFormat( Person.PHONE, phone) );
					map.put("searchStreet", address);
					map.put("searchCity", city);
					map.put("searchZip", zip);
					map.put("searchGender", Person.mviFormat( Person.GENDER, gender ) );
					
					map.put("processingCode", CaretUtil.getMviProcessingCode() );
					map.put("creationTime", Toolbox.getDateTimeFormatOrient().format( new Date() ) );
					map.put("senderOid", PortletProps.get("mvi.senderOid") );
					map.put("senderId", IamService.appId);
					try {
						map.put("senderFirstName", user.getFirstName());
						map.put("senderLastName", user.getLastName());
					} catch (Exception e) {
						e.printStackTrace();
					}
					List<Map<String, Object>> resultList = IamService.searchAttended(map);
					
					//Map<String, Object> resultList2 = IamService.searchUnattended(map);				
					
					if ( resultList == null ){
						json.put("msg", "error");
						json.put("size", -1 );
						return vcgs;
					} 

				} catch (Exception e) {
					e.printStackTrace();
					return vcgs;
				}
			} else {
				list = new ArrayList<Person>();
				for (Persn persn : listLocal) {
					list.add(new Person(persn));
				}
			}

			size = list.size();
			_log.info("user size vcgs.. " + size);
			json.put("size", size);
		}

		Set<String> temp = new LinkedHashSet<String>();

		if (skipSearch || list.size() == 0) {

		} else {
			for (Person p : list) {
				if (!uniqueFactor && temp.contains(p.toSearchString()) ) {
					continue;
				}
				temp.add(p.toSearchString());
				vcg = p.getJsonObject( );

				vcg.put(CaretStrPool.GROUP_ID, p.getGroupId());
				if (CaretStrPool.ACTIVE_VCG.equals(searchType) || CaretStrPool.VCG_CREATION.equals(searchType)) {
					vcg.put(CaretStrPool.FACILITY_NAME, p.getFacilityName());
					Veteran v = new Veteran(p);
					Object[] actives;
					if (CaretStrPool.ACTIVE_VCG.equals(searchType)) {
						actives = v.getActives();
					} else {
						actives = v.getVcgActives();
					}
					vcg.put(Veteran.VA_HEALTH_ENROLLED_ATTRIBUTE, v.getVaHealthEnrolled());
					vcg.put(CaretStrPool.ACTIVE_VCG, !"0".equals(String.valueOf(actives[0])));
					vcg.put("linked", !"0".equals(String.valueOf(actives[0])));
					
					vcg.put("iCN", Toolbox.nullSafe(p.getICN()));
					vcg.put("vcgId", String.valueOf(actives[0]));
					vcg.put("fullName",
							p.getFullName() + ("0".equals(String.valueOf(actives[0])) ? "(New VCG)" : "(Update VCG)"));
				} else {
					vcg.put("fullName", p.getFullName());
					vcg.put("iCN", Toolbox.nullSafe(p.getICN()));
				}
				vcgs.put(vcg);
			}
		}
		parseVcgs(vcgs);
		return vcgs;
	}	
		
	public static void parseVcgs(JSONArray vcgs) {
		for(int i = 0; i < 100; i++) {
			JSONObject jsonObject = vcgs.getJSONObject(i);
			if (jsonObject != null) {
				_log.info("Search.parse] jsonObject: " + jsonObject);
			}
		}
	}		
	public static String parseVcgsForSSN(JSONArray vcgs) {
		String ssn = "";
		JSONObject jsonObject = vcgs.getJSONObject(0);
		if (jsonObject != null) {
			ssn = jsonObject.getString("ssn");
		}
		return ssn;
	}
	public static List<Long> parseVcgsForPrimaryKey(JSONArray vcgs) {
		List<Long> primaryKeys = new ArrayList<Long>();
		for(int i = 0; i < 100; i++) {
			JSONObject jsonObject = vcgs.getJSONObject(i);
			if (jsonObject != null) {
				primaryKeys.add(jsonObject.getLong("primaryKey"));
			}
		}
		return primaryKeys;
	}	
	private static Log _log = LogFactoryUtil.getLog( PersonSearches.class );

}
