 package gov.va.caret.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletRequest;

import org.apache.commons.collections.CollectionUtils;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.impl.ZipFyImpl;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.FacilSupport;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.NoteLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.ZipFyLocalServiceUtil;

public class OnlineUtil {
    //
	private static Map<Long,Map<String,String>> autoCompFacilMap;
	private static Map<String,Long> autoCompZipMap;
	private static Map<String,List<Long>> autoCompStateMap;
	private static Map<String,List<Long>> autoCompStateFullMap;
	private static Map<String,List<Long>> autoCompCityMap;
	private static Map<String,List<Long>> autoCompNameMap;
	private static Map<Long,Long> autoCompGroupIdMap;
    //
	private static Log _log = LogFactoryUtil.getLog( OnlineUtil.class );
	//
	static {
		//temporary solution until db script can be run...
		//test for 0.0 distance record from VA center in zip data
		//if not there, insert missing rows...
		try {
			List<ZipFyImpl> zips = null;
			DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( ZipFyImpl.class, PortletClassLoaderUtil.getClassLoader() );
			dynamicQuery.add( PropertyFactoryUtil.forName("facilZip").eq("04330") );
			dynamicQuery.add( PropertyFactoryUtil.forName("distance").eq(new Double(0.00)) );
			try {
				zips = NoteLocalServiceUtil.dynamicQuery(dynamicQuery);
			}
			catch(Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
			//
			if (CollectionUtils.isNotEmpty(zips)) {
				_log.info("OnlineUtil: missing zip records exist in DB - no action: " + zips.size());
			}
			else {
				ZipFyImpl zip = null;
				zip = new ZipFyImpl(); zip.setFacilId(1);	zip.setFacilZip("04330"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(6);	zip.setFacilZip("01053"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(63);	zip.setFacilZip("44106"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(65);	zip.setFacilZip("43219"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(89);	zip.setFacilZip("57741"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(98);	zip.setFacilZip("72703"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(101);	zip.setFacilZip("72114"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(104);	zip.setFacilZip("75216"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(105);	zip.setFacilZip("78228"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(107);	zip.setFacilZip("78550"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(113);	zip.setFacilZip("80045"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(125);	zip.setFacilZip("97239"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);
				zip = new ZipFyImpl(); zip.setFacilId(140);	zip.setFacilZip("92161"); zip.setDistance(0.00); ZipFyLocalServiceUtil.addZipFy(zip);	
				_log.info("OnlineUtil: missing zip records were inserted");
			}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	//
	public static String getFacilDisplayByGroupId(String groupId) {
		return getFacilDisplaypByGroupId(Long.parseLong(groupId));
	}	
	public static String getFacilDisplaypByGroupId(long groupId) {
		Map<String,String> facil = getFacilMapByGroupId(groupId);
		String label = facil.get("name") + " - " + facil.get("city") + ", " + facil.get("state");
		label += "|" + facil.get("id");
		label += "|" + facil.get("facilDisplayName");
		label += "|" + facil.get("groupId");
		return label;		
	}
	public static Map<String,String> getFacilMapByGroupId(long groupId) {
		Long index = autoCompGroupIdMap.get(groupId);
		return index != null && index.longValue() > 0 ? autoCompFacilMap.get(index) : new HashMap<String,String>();
	}	
	public static String[] getAutoCompFacilNumerResponse(String inputText) {
		List<String> responseList = new ArrayList<String>();
		Set<Long> matchingIds = new HashSet<Long>();
		for (String key : autoCompZipMap.keySet()) {
			if (key.startsWith(inputText)) {
				matchingIds.add(autoCompZipMap.get(key));
			}	
		}
		String label = "";
		for(Long id : matchingIds) {
			Map<String,String> facil = autoCompFacilMap.get(id);
			label = facil.get("zip") + " " + facil.get("city") + ", " + facil.get("state") + " - " + facil.get("name");
			label += "|" + id;
			//label += "|" + facil.get("facilityNumber");
			label += "|" + facil.get("facilDisplayName");
			label += "|" + facil.get("groupId");
			responseList.add(label);
		}
		return CollectionUtils.isNotEmpty(responseList) ?
				Toolbox.sortWithInsertionSort(responseList.toArray(new String[responseList.size()])) : new String[]{};		
	}
	public static String[] getAutoCompFacilAlphaResponse(String inputText) {
		List<String> responseList = new ArrayList<String>();
		if (autoCompStateMap.containsKey(inputText.toUpperCase())) {
			List<Long> ids = autoCompStateMap.get(inputText.toUpperCase());
			String label = "";
			for(Long id : ids) {
				Map<String,String> facil = autoCompFacilMap.get(id);
				label = facil.get("state") + ", " + facil.get("city") + " - " + facil.get("name");
				label += "|" + id;
				//label += "|" + facil.get("facilityNumber");
				label += "|" + facil.get("facilDisplayName");
				label += "|" + facil.get("groupId");
				responseList.add(label);
			}
		}
		else if (autoCompStateFullMap.containsKey(inputText.toUpperCase())) {
			List<Long> ids = autoCompStateFullMap.get(inputText.toUpperCase());
			String label = "";
			for(Long id : ids) {
				Map<String,String> facil = autoCompFacilMap.get(id);
				label = facil.get("stateFull") + ", " + facil.get("city") + " - " + facil.get("name");
				label += "|" + id;
				//label += "|" + facil.get("facilityNumber");
				label += "|" + facil.get("facilDisplayName");
				label += "|" + facil.get("groupId");
				responseList.add(label);
			}
		}
		else if (autoCompCityMap.containsKey(inputText.toUpperCase())) {
			List<Long> ids = autoCompCityMap.get(inputText.toUpperCase());
			String label = "";
			for(Long id : ids) {
				Map<String,String> facil = autoCompFacilMap.get(id);
				label = facil.get("city") + ", " + facil.get("state") + " - " + facil.get("name");
				label += "|" + id;
				//label += "|" + facil.get("facilityNumber");
				label += "|" + facil.get("facilDisplayName");
				label += "|" + facil.get("groupId");
				responseList.add(label);
			}
		}
		else if (autoCompNameMap.containsKey(inputText.toUpperCase())) {
			List<Long> ids = autoCompNameMap.get(inputText.toUpperCase());
			String label = "";
			for(Long id : ids) {
				Map<String,String> facil = autoCompFacilMap.get(id);
				label = facil.get("name") + " - " + facil.get("city") + ", " + facil.get("state");
				label += "|" + id;
				//label += "|" + facil.get("facilityNumber");
				label += "|" + facil.get("facilDisplayName");
				label += "|" + facil.get("groupId");
				responseList.add(label);
			}
		}		
		else {
			Set<Long> matchingIds = new HashSet<Long>();
			for (String key : autoCompStateMap.keySet()) {
				if (key.startsWith(inputText.toUpperCase())) {
					matchingIds.addAll(autoCompStateMap.get(key));
				}	
			}
			for (String key : autoCompStateFullMap.keySet()) {
				if (key.startsWith(inputText.toUpperCase())) {
					matchingIds.addAll(autoCompStateFullMap.get(key));
				}	
			}
			for (String key : autoCompCityMap.keySet()) {
				if (key.startsWith(inputText.toUpperCase())) {
					matchingIds.addAll(autoCompCityMap.get(key));
				}	
			}
			for (String key : autoCompNameMap.keySet()) {
				if (key.startsWith(inputText.toUpperCase())) {
					matchingIds.addAll(autoCompNameMap.get(key));
				}	
			}			
			String label = "";
			for(Long id : matchingIds) {
				Map<String,String> facil = autoCompFacilMap.get(id);
				label = facil.get("state") + ", " + facil.get("city") + " - " + facil.get("name");
				label += "|" + id;
				//label += "|" + facil.get("facilityNumber");
				label += "|" + facil.get("facilDisplayName");
				label += "|" + facil.get("groupId");
				responseList.add(label);
			}				
		}
		return CollectionUtils.isNotEmpty(responseList) ?
			Toolbox.sortWithInsertionSort(responseList.toArray(new String[responseList.size()])) : new String[]{};
	}
	public static void setAutoCompFacilMap() {
		if (autoCompFacilMap != null) {return;}
		//		
		Map<String,String> statesAbbrFull = new HashMap<String,String>();
		String[] states = {"AL|Alabama","AK|Alaska","AZ|Arizona","AR|Arkansas","CA|California","CZ|Canal Zone","CO|Colorado","CT|Connecticut","DE|Delaware","D.C.|District of Columbia","DC|District of Columbia","FL|Florida","GA|Georgia","GU|Guam","HI|Hawaii","ID|Idaho","IL|Illinois","IN|Indiana","IA|Iowa","KS|Kansas","KY|Kentucky","LA|Louisiana","ME|Maine","MD|Maryland","MA|Massachusetts","MI|Michigan","MN|Minnesota","MS|Mississippi","MO|Missouri","MT|Montana","NE|Nebraska","NV|Nevada","NH|New Hampshire","NJ|New Jersey","NM|New Mexico","NY|New York","NC|North Carolina","ND|North Dakota","OH|Ohio","OK|Oklahoma","OR|Oregon","PA|Pennsylvania","PR|Puerto Rico","RI|Rhode Island","SC|South Carolina","SD|South Dakota","TN|Tennessee","TX|Texas","UT|Utah","VT|Vermont","VI|Virgin Islands","VA|Virginia","WA|Washington","WV|West Virginia","WI|Wisconsin","WY|Wyoming"};
		//with DC but without D.C.  // need to check out...
		//String[] states = {"AL|Alabama","AK|Alaska","AZ|Arizona","AR|Arkansas","CA|California","CZ|Canal Zone","CO|Colorado","CT|Connecticut","DE|Delaware","DC|District of Columbia","FL|Florida","GA|Georgia","GU|Guam","HI|Hawaii","ID|Idaho","IL|Illinois","IN|Indiana","IA|Iowa","KS|Kansas","KY|Kentucky","LA|Louisiana","ME|Maine","MD|Maryland","MA|Massachusetts","MI|Michigan","MN|Minnesota","MS|Mississippi","MO|Missouri","MT|Montana","NE|Nebraska","NV|Nevada","NH|New Hampshire","NJ|New Jersey","NM|New Mexico","NY|New York","NC|North Carolina","ND|North Dakota","OH|Ohio","OK|Oklahoma","OR|Oregon","PA|Pennsylvania","PR|Puerto Rico","RI|Rhode Island","SC|South Carolina","SD|South Dakota","TN|Tennessee","TX|Texas","UT|Utah","VT|Vermont","VI|Virgin Islands","VA|Virginia","WA|Washington","WV|West Virginia","WI|Wisconsin","WY|Wyoming"};
		for(String s : states) {
			String[] parts = s.split("\\|");
			statesAbbrFull.put(parts[0], parts[1]);
		}
		List<Facil> facils = null;
		autoCompFacilMap = new HashMap<Long,Map<String,String>>();
		autoCompZipMap = new HashMap<String,Long>();
		autoCompStateMap = new HashMap<String,List<Long>>();
		autoCompStateFullMap = new HashMap<String,List<Long>>();
		autoCompCityMap = new HashMap<String,List<Long>>();
		autoCompNameMap = new HashMap<String,List<Long>>();
		autoCompGroupIdMap = new HashMap<Long,Long>();
		try {
			facils = FacilLocalServiceUtil.getFacils(0, FacilLocalServiceUtil.getFacilsCount());
			_log.info("facils "+ facils); 
		}
		catch(Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		//
		if (CollectionUtils.isNotEmpty(facils)) {
			for(Facil facil : facils) {
				Long facilId = facil.getFacilId(); // yes - not facilityNumber
				String facilLocation = facil.getLocation();
				String facilCity = "";
				String facilState = "";		
				if (facilLocation.indexOf(',') > 0) {
					facilCity = facilLocation.substring(0, facilLocation.indexOf(','));
					facilState = facilLocation.substring(facilLocation.indexOf(',') + 2);	
				} else {
					facilCity = facilLocation;
					facilState = "";
				}
				String facilStateFull = statesAbbrFull.get(facilState);
				Long facilGroupId = facil.getGroupId();
				String facilityNumber = facil.getFacilityNumber();
				String facilName = "";
				//
				try {
					Organization org = OrganizationLocalServiceUtil.getOrganization(facilGroupId);
					if (org != null) {facilName = org.getName();}
				}
				catch(Exception e) {
					ApplicationWorkFlowException.handleException(e);
				}				
				//
				Map<String,String> facilMap = new HashMap<String,String>();
				facilMap.put("id", facilId.longValue() + "");
				//facilMap.put("label", facilName + " " + facilLocation);
				facilMap.put("name", facilName);
				facilMap.put("state", facilState);
				facilMap.put("stateFull", facilStateFull);
				facilMap.put("city", facilCity);
				facilMap.put("facilityNumber", facilityNumber);
				facilMap.put("facilName", facilName);
				facilMap.put("facilDisplayName", FacilSupport.getFacilDisplayName(facilName, facilLocation));
				facilMap.put("groupId", facilGroupId + "");
				
				// [probably replace this code with a new field in CARET_FACILITY (INFOZIP) ...
				List<ZipFyImpl> zips = null;
				DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( ZipFyImpl.class, PortletClassLoaderUtil.getClassLoader() );
				dynamicQuery.add( PropertyFactoryUtil.forName("facilId").eq(facilId) );
				dynamicQuery.add( PropertyFactoryUtil.forName("distance").eq(new Double(0.00)) );
				try {
					zips = NoteLocalServiceUtil.dynamicQuery(dynamicQuery);
				}
				catch(Exception e) {
					ApplicationWorkFlowException.handleException(e);
				}
				// ...] continued....
				
				//there should only be one.............[but SD,HI...]
				for(ZipFyImpl zip : zips) {
					//_log.info("[[[ " + facilId + " " + facilName + " " + facilState + " " + facilStateFull + " " + facilCity + " " + zip.getFacilZip() + " " + zip.getDistance());
					facilMap.put("zip", zip.getFacilZip());
					break;
				}
				//
				autoCompFacilMap.put(facilId, facilMap);
			}
			//
			for(Long id : autoCompFacilMap.keySet()) {
				Map<String,String> facilMap = autoCompFacilMap.get(id);
				//
				autoCompZipMap.put(facilMap.get("zip"), id);
				//
				String state = facilMap.get("state");
				if (autoCompStateMap.containsKey(state)) {
					List<Long> stateFacilsList = autoCompStateMap.get(state);
					stateFacilsList.add(id);
					autoCompStateMap.put(state, stateFacilsList);
				}
				else {
					List<Long> stateFacilsList = new ArrayList<Long>();
					stateFacilsList.add(id);
					autoCompStateMap.put(state, stateFacilsList);							
				}
				//
				String stateFull = facilMap.get("stateFull");
				if (Toolbox.isEmpty(stateFull)) {
					_log.info("EMPTY STATE FULL " + facilMap.get("state"));
				}
				if (autoCompStateFullMap.containsKey(stateFull.toUpperCase())) {
					List<Long> stateFullFacilsList = autoCompStateFullMap.get(stateFull.toUpperCase());
					stateFullFacilsList.add(id);
					autoCompStateFullMap.put(stateFull.toUpperCase(), stateFullFacilsList);
				}
				else {
					List<Long> stateFullFacilsList = new ArrayList<Long>();
					stateFullFacilsList.add(id);
					autoCompStateFullMap.put(stateFull.toUpperCase(), stateFullFacilsList);						
				}
				//
				String city = facilMap.get("city");
				if (autoCompCityMap.containsKey(city.toUpperCase())) {
					List<Long> cityFacilsList = autoCompCityMap.get(city.toUpperCase());
					cityFacilsList.add(id);
					autoCompCityMap.put(city.toUpperCase(), cityFacilsList);
				}
				else {
					List<Long> cityFacilsList = new ArrayList<Long>();
					cityFacilsList.add(id);
					autoCompCityMap.put(city.toUpperCase(), cityFacilsList);						
				}
				//
				String name = facilMap.get("name");
				if (autoCompNameMap.containsKey(name.toUpperCase())) {
					List<Long> nameFacilsList = autoCompNameMap.get(name.toUpperCase());
					nameFacilsList.add(id);
					autoCompNameMap.put(name.toUpperCase(), nameFacilsList);
				}
				else {
					List<Long> nameFacilsList = new ArrayList<Long>();
					nameFacilsList.add(id);
					autoCompNameMap.put(name.toUpperCase(), nameFacilsList);						
				}
				//
				autoCompGroupIdMap.put(new Long(facilMap.get("groupId") + ""), id);
			}
		}
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List myCaregivers ( List<Map<String, Object>> applications, PortletRequest request ) throws ApplicationWorkFlowException {
		
		if ( applications.isEmpty() ){
			return Collections.EMPTY_LIST;
		}
		List returnList = new ArrayList<Map>();
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
		for ( Map<String, Object> appFields : applications ){
			BigDecimal vcgAnId = (BigDecimal) appFields.get( CaretStrPool.NDX0 );
			VcgApplication vcgApp = null;
			VcgSupport vcg = null;
			try {
				vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( vcgAnId.longValue() ));
				if ( vcgApp.getVcgId() > 0 ){
					vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( vcgApp.getVcgId() ) );
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			if ( CaretStrPool.INVALID.equals( appFields.get(CaretStrPool.NDX4) ) || CaretStrPool.DUPLICATE_APPLICATION.equals( appFields.get(CaretStrPool.NDX4) ) ) {
				continue;
			}
			long primaryId = Toolbox.getLong(appFields,CaretStrPool.NDX11);
			if ( primaryId > 0 ){
				Object primarySignDate;
				String primarySigned = StringPool.BLANK;
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					primarySigned = ApplicationStatus.CANCELLED.name();
					primarySignDate = StringPool.BLANK;
				} else if ( appFields.get(CaretStrPool.NDX8) == StringPool.BLANK && Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() )){
					primarySigned =  LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.NEED_SIGNATURE.name() );;
					primarySignDate = StringPool.BLANK;
				} else {
				if ( vcgApp.isInvalidPrimary() || ( vcg != null && vcg.getPrimaryInitDispDate() != null ) ){
						primarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
					} else if ( vcg != null ){
						primarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() ); 
					} else if (  Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) || !Toolbox.isEmpty( String.valueOf(appFields.get(CaretStrPool.NDX8)) ) ) {
						primarySigned = CaretStrPool.SIGNED;
					}
					
					primarySignDate = appFields.get(CaretStrPool.NDX8);
				}
				
				
				returnList.add( Toolbox.getMap( CaretStrPool.PRIMARY, appFields.get(CaretStrPool.NDX1),
						primarySigned, primarySignDate, vcgAnId ) );
			}
			
			long secondaryId = Toolbox.getLong(appFields,CaretStrPool.NDX12);
			if ( secondaryId > 0 ){
				Object secondarySignDate;
				String secondarySigned = StringPool.BLANK;
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					secondarySigned = ApplicationStatus.CANCELLED.name();
					secondarySignDate = StringPool.BLANK;
				} else if ( appFields.get(CaretStrPool.NDX9) == StringPool.BLANK && Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) ){
					secondarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.NEED_SIGNATURE.name() );;
					secondarySignDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondary() || ( vcg != null && vcg.getSecondaryInitDispDate() != null ) ){
						secondarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
					} else if ( vcg != null ){
						secondarySigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() ); 
					} else if ( Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) || !Toolbox.isEmpty( String.valueOf(appFields.get(CaretStrPool.NDX9)) ) ) {
						secondarySigned = CaretStrPool.SIGNED;
					}
					
					secondarySignDate = appFields.get(CaretStrPool.NDX9);
				}
				returnList.add( Toolbox.getMap( CaretStrPool.SECONDARY, appFields.get(CaretStrPool.NDX2),
						secondarySigned, secondarySignDate, vcgAnId ) );
			}
			
			long secondaryTwoId = Toolbox.getLong(appFields,CaretStrPool.NDX13);
			if ( secondaryTwoId > 0 ){ 
				Object secondaryTwoSignDate;
				String secondaryTwoSigned = StringPool.BLANK;
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					secondaryTwoSigned = ApplicationStatus.CANCELLED.name();
					secondaryTwoSignDate = StringPool.BLANK;
				} else if ( appFields.get(CaretStrPool.NDX10) == StringPool.BLANK && Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) ){
					secondaryTwoSigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.NEED_SIGNATURE.name() );;
					secondaryTwoSignDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondaryTwo() || ( vcg != null && vcg.getSecondaryTwoInitDispDate() != null ) ){
						secondaryTwoSigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
					} else if ( vcg != null ){
						secondaryTwoSigned = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() ); 
					} else if (  Toolbox.isEmpty( appFields.get(CaretStrPool.NDX19).toString() ) || !Toolbox.isEmpty( String.valueOf(appFields.get(CaretStrPool.NDX10)) ) ){
						secondaryTwoSigned = CaretStrPool.SIGNED;
					}
					
					secondaryTwoSignDate = appFields.get(CaretStrPool.NDX10);
				}
				returnList.add( Toolbox.getMap( CaretStrPool.SECONDARYTWO, appFields.get(CaretStrPool.NDX3),
						secondaryTwoSigned, secondaryTwoSignDate, vcgAnId ) );
			}
		}
		return returnList;
	}
	

	public static boolean isRevision(Person formPerson, Person vcgPerson) {
		boolean isRevision = false;
		if ( !formPerson.getLastName().equals( vcgPerson.getLastName() ) ||
				!formPerson.getFirstName().equals( vcgPerson.getFirstName() ) ){
			_log.info("Last name change");
			isRevision = true;
		}
		if ( !Toolbox.isEmpty( formPerson.getMiddleName() ) &&  !formPerson.getMiddleName().equals( vcgPerson.getMiddleName() ) ) {
			_log.info("Updates to Person Middle Name");
			isRevision = true;
		}
		if ( ( ! formPerson.getAddress().equals( vcgPerson.getAddress() ) || !formPerson.getCity().equals( vcgPerson.getCity() ) ||
				! formPerson.getZip().equals( vcgPerson.getZip() ) || ! formPerson.getState().equals( vcgPerson.getState() ) ) ){
			_log.info("Updates to Person Address");
			isRevision = true;
		}
		if ( !Toolbox.isEmpty( formPerson.getSsn() ) && !formPerson.getSsn().equals( vcgPerson.getSsn() ) ) {
			_log.info("Updates to Person SSN");
			isRevision = true;
		}
		if ( formPerson.getBirthDate() != null && !formPerson.getBirthDate().equals( vcgPerson.getBirthDate() ) ) {
			 _log.info("Updates to Person Birthdate");
			 isRevision = true;
		}
		if ( formPerson.getRole() == Person.Role.VETERAN && formPerson.getGroupId() != vcgPerson.getGroupId() ) {
			_log.info("Veteran Facility Change");
			isRevision = true;
		}

		if ( !Toolbox.isEmpty( formPerson.getGender() ) && ! formPerson.getGender().equals( vcgPerson.getGender() ) ) {
			_log.info("Updates to Person Gender");
			isRevision = true;
		}
		
		if ( formPerson.getRole() == Person.Role.PRIMARY ){
			if ( !formPerson.getOtherHealthInsurance().equals( vcgPerson.getOtherHealthInsurance() ) ) {
				_log.info("Updates to Person Medicare/Medicaid enrollment");
				isRevision = true;
			} 
		}

		if ( !isRevision ){
			vcgPerson.setPhone( formPerson.getPhone() );
			vcgPerson.setPhone2( formPerson.getPhone2() );
			vcgPerson.setEmail( formPerson.getEmail() );
		} else {
			formPerson.setStatus( CaretStrPool.ONLINE_REVISION );
			formPerson.setUserId( vcgPerson.getRootUserId() );
			formPerson.setVistaId( vcgPerson.getVistaId() );
			formPerson.setEeId( vcgPerson.getEeId() );
			formPerson.setICN( vcgPerson.getICN() );
			formPerson.setExternalId( vcgPerson.getExternalId() );
		}
		return isRevision;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static List myVeterans(List<Long> persnRevisionIds, List<Map<String, Object>>[] listArr, PortletRequest request ) throws ApplicationWorkFlowException {
		List<Map<String, Object>> list = listArr[0];
		List<Map<String, Object>> update = new ArrayList<Map<String, Object>>();
		if ( list.isEmpty() ){
			return Collections.EMPTY_LIST;
		}
		List returnList = new ArrayList<Map>();
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
		for ( Map<String, Object> map : list ){
			VcgApplication vcgApp = null;
			VcgSupport vcg = null;
			try {
				vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( Toolbox.getLong(map,CaretStrPool.NDX0) ));
				if ( vcgApp.getVcgId() > 0 ){
					vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( vcgApp.getVcgId() ) );
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			String status = StringPool.BLANK;
			Object signDate;
			// Primary Cg
			if ( map.get(CaretStrPool.NDX11) != StringPool.BLANK  && persnRevisionIds.contains( Toolbox.getLong(map,CaretStrPool.NDX11) ) ){
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					status = ApplicationStatus.CANCELLED.name();
					signDate = StringPool.BLANK;
				} else if ( map.get(CaretStrPool.NDX8) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidPrimary() || ( vcg != null && vcg.getPrimaryDispositionDate() != null ) ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
						try {
							if ( PortalUtil.getUserId(request) == new Person ( PersnLocalServiceUtil.getPersn( vcgApp.getPrimaryId() ) ).getRootUserId() ){
								map.put(CaretStrPool.NDX4, status);
							}
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					} else if ( vcg != null ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() );
					} else {
						status = CaretStrPool.SIGNED;
					}
					
					signDate = map.get(CaretStrPool.NDX8);
				}
				returnList.add( Toolbox.getMap( CaretStrPool.PRIMARY,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			
			//Secondary Cg
			} else if ( map.get(CaretStrPool.NDX12) != StringPool.BLANK && persnRevisionIds.contains( Toolbox.getLong(map,CaretStrPool.NDX12) ) ){
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					status = ApplicationStatus.CANCELLED.name();
					signDate = StringPool.BLANK;
				} else if ( map.get(CaretStrPool.NDX9) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondary() || ( vcg != null && vcg.getSecondaryDispositionDate() != null ) ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
						try {
							if ( PortalUtil.getUserId(request) == new Person ( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryId() ) ).getRootUserId() ){
								map.put(CaretStrPool.NDX4, status);
							}
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					} else if ( vcg != null ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() );
					} else {
						status = CaretStrPool.SIGNED;
					}
					signDate = map.get(CaretStrPool.NDX9);
				}
				returnList.add( 
						Toolbox.getMap( CaretStrPool.SECONDARY,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			
				//Secondary II
			} else if ( map.get(CaretStrPool.NDX13) != StringPool.BLANK && persnRevisionIds.contains( Toolbox.getLong(map,CaretStrPool.NDX13) ) ){
				if ( ApplicationStatus.CANCELLED.name().equals( vcgApp.getStatus() ) ){
					status = ApplicationStatus.CANCELLED.name();
					signDate = StringPool.BLANK;
				} else if ( map.get(CaretStrPool.NDX10) == StringPool.BLANK ){
					status = CaretStrPool.NOT_SIGNED;
					signDate = StringPool.BLANK;
				} else {
					if ( vcgApp.isInvalidSecondaryTwo() || ( vcg != null && vcg.getSecondaryTwoDispositionDate() != null ) ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.DECISION_MADE.name() );
						try {
							if ( PortalUtil.getUserId(request) == new Person ( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryTwoId() ) ).getRootUserId() ){
								map.put(CaretStrPool.NDX4, status);
							}
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					} else if ( vcg != null ){
						status = LanguageUtil.get(themeDisplay.getLocale(), ApplicationStatus.IN_REVIEW.name() );
					} else {
						status = CaretStrPool.SIGNED;
					}
					signDate = map.get(CaretStrPool.NDX10);
				}
				returnList.add( Toolbox.getMap( 
											CaretStrPool.SECONDARYTWO,
											map.get(CaretStrPool.NDX14),
											status, signDate,
											map.get(CaretStrPool.NDX0) ) );
			}
			update.add(map);
		}
		listArr[0] = update;
		return returnList;
	}
	
	public static Map<Long,String> getCaregivers ( long siteId, long caregiverRoleId ) throws SystemException, PortalException {
		List<UserGroupRole> caregivers = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole( siteId, caregiverRoleId );
		Map<Long,String> caregiverNames = new HashMap<Long,String>();
		for ( UserGroupRole userGroupRole: caregivers ){
			User u = UserLocalServiceUtil.getUser( userGroupRole.getUserId() );
			caregiverNames.put( userGroupRole.getUserId(), u.getFullName() + StringPool.COMMA_AND_SPACE + u.getEmailAddress() );
		}
		return caregiverNames;
	}
	
}
