package gov.va.caret.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.model.Persn;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.support.Person;
import gov.va.caret.service.PersnLocalServiceUtil;

public class CslHecIdentityParam {
	public final static int CALL_VETERAN = 0;
	public final static int CALL_CALLER = 1;
	//public final static int HEC_VETERAN = 2;
	//public final static int HEC_REFERRER = 3;
	//
	public static Person checkForExistingIdentity(int type, Person callerPerson) {
		List<Persn> list = null;
		switch (type) {
			case CALL_CALLER:
				list = PersonSearches.getExistingPersonsByCallerCriteria(callerPerson);
				break;
			case CALL_VETERAN:
				list = PersonSearches.getExistingPersonsByVeteranCriteria(callerPerson);
				break;
			default: 
				return null;
		}		
		if (CollectionUtils.isNotEmpty(list)) {
			if (list.size() == 1) {
				return new Person((PersnImpl) list.get(0));
			}
			else {
				List<Person> plist = new ArrayList<Person>();
				Person person = null;
				for(Persn persn : list) {
					person = new Person((PersnImpl) persn);
					plist.add(person);
				}
//				for(Person p : plist) {
//					_log.info("[[ before compare" 
//							+ p.getPersnId() + " "
//							+ p.getLastName() + " "
//							+ p.getFirstName() + " "
//							+ p.getSsn() + " "
//							+ p.getStatus() + " "
//							+ p.getPersnUserId() + " "
//					);
//				}
				Collections.sort(plist, new Comparator<Person>(){
					public int compare(Person one, Person two) {
						int comp = 0;
						String oneS = one.getStatus() == null ? "" : one.getStatus();
						String twoS = two.getStatus() == null ? "" : two.getStatus();
						if (oneS.equals("ACTIVE_VCG")) {return -1;}
						else if (twoS.equals("ACTIVE_VCG")) {return 1;}
						else {
							oneS = one.getIcn() == null ? "" : one.getIcn();
							twoS = two.getIcn() == null ? "" : two.getIcn();
							comp = twoS.compareTo(oneS);
							if (comp != 0) {return comp;}
							else {
								oneS = one.getSsn() == null ? "" : one.getSsn();
								twoS = two.getSsn() == null ? "" : two.getSsn();
								oneS = oneS.replaceAll("[-]", "");
								twoS = twoS.replaceAll("[-]", "");
								comp = twoS.compareTo(oneS);
								if (comp != 0) {return comp;}
								else {
									comp = new Long(two.getPersnUserId()).compareTo(new Long(one.getPersnUserId()));
									if (comp != 0) {return comp;}
									else {
										return new Long(two.getPersnId()).compareTo(new Long(one.getPersnId()));
									}
								}
							}
						}				
					}
				});		
//				for(Person p : plist) {
//					_log.info("[[ after compare" 
//							+ p.getPersnId() + " "
//							+ p.getLastName() + " "
//							+ p.getFirstName() + " "
//							+ p.getSsn() + " "
//							+ p.getStatus() + " "
//							+ p.getPersnUserId() + " "
//					);
//				}				
				return plist.get(0);
			}
		}
		return null;
	}		
	public static Collection<String> getIdentityProperties(int identity) {
		switch(identity) {
			case CALL_VETERAN:
				String val = PortletProps.get( "call.veteran" );
				String[] tokens = val.split(",");
				return new HashSet<String>(Arrays.asList(tokens));			
			case CALL_CALLER:
				val = PortletProps.get( "call.caller" );
				tokens = val.split(",");
				return new HashSet<String>(Arrays.asList(tokens));
			default: return Collections.EMPTY_SET;
		}
	}		
    public static boolean callIdentityIsVerifiedPerson(Person callPerson, boolean callPersonIsVeteran) {    	
    	if (callPerson != null) {
	    	Person verifiedIdentity = null;
	    	try {
	    		verifiedIdentity = new Person( PersnLocalServiceUtil.getPersn( callPerson.getPersnId() ) );
	    	}
	    	catch(Exception e) {
	    		
	    	}
	    	return verifiedIdentityEqualsEditedIdentity(
	    		verifiedIdentity,
	    		callPerson,
	    		callPersonIsVeteran ? CALL_VETERAN : CALL_CALLER);
    	}
    	return false;
    }
  //TODO: write following 3 methods using reflection and portlet.properties list of selected[caller,veteran] modelAttributes 
    public static boolean verifiedIdentityEqualsEditedIdentity(Person verifiedIdentity, Person editedIdentity, int editedIdentityRole) {
    	switch(editedIdentityRole) {
    		case CALL_VETERAN:
    			return verifiedIdentityEqualsEditedIdentity_callVeteran(verifiedIdentity, editedIdentity);
    		case CALL_CALLER:
    			return verifiedIdentityEqualsEditedIdentity_callCaller(verifiedIdentity, editedIdentity);
    	}
    	return false;
    }
    public static boolean verifiedIdentityEqualsEditedIdentity_callVeteran(Person verifiedIdentity, Person editedIdentity) {
    	boolean b = false;
    	b = verifiedIdentity.getLastName().equalsIgnoreCase(editedIdentity.getLastName());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getLastName() + ", " + editedIdentity.getLastName() + " - " + b); return b;}
    	b = verifiedIdentity.getFirstName().equalsIgnoreCase(editedIdentity.getFirstName());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getFirstName() + ", " + editedIdentity.getFirstName() + " - " + b); return b;}
    	b = verifiedIdentity.getMiddleName().equalsIgnoreCase(editedIdentity.getMiddleName());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getMiddleName() + ", " + editedIdentity.getMiddleName() + " - " + b); return b;}
    	b = verifiedIdentity.getSuffix().equalsIgnoreCase(editedIdentity.getSuffix());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getSuffix() + ", " + editedIdentity.getSuffix() + " - " + b); return b;}
    	b = verifiedIdentity.getSsn().equals(editedIdentity.getSsn());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getSsn() + ", " + editedIdentity.getSsn() + " - " + b); return b;}
    	b = verifiedIdentity.getBirthDate().equals(editedIdentity.getBirthDate());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getBirthDate() + ", " + editedIdentity.getBirthDate() + " - " + b); return b;}
    	b = verifiedIdentity.getCountry().equalsIgnoreCase(editedIdentity.getCountry());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getCountry() + ", " + editedIdentity.getCountry() + " - " + b); return b;}
    	b = verifiedIdentity.getAddress().equalsIgnoreCase(editedIdentity.getAddress());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getAddress() + ", " + editedIdentity.getAddress() + " - " + b); return b;}
    	b = verifiedIdentity.getAddress2().equalsIgnoreCase(editedIdentity.getAddress2());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getAddress2() + ", " + editedIdentity.getAddress2() + " - " + b); return b;}
    	b = verifiedIdentity.getState().equalsIgnoreCase(editedIdentity.getState());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getState() + ", " + editedIdentity.getState() + " - " + b); return b;}
    	b = verifiedIdentity.getCity().equalsIgnoreCase(editedIdentity.getCity());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getCity() + ", " + editedIdentity.getCity() + " - " + b); return b;}
    	b = verifiedIdentity.getZip().equals(editedIdentity.getZip());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getZip() + ", " + editedIdentity.getZip() + " - " + b); return b;}
    	b = verifiedIdentity.getGender().equals(editedIdentity.getGender());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getGender() + ", " + editedIdentity.getGender() + " - " + b); return b;}
    	b = verifiedIdentity.getPhone().equals(editedIdentity.getPhone());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getPhone() + ", " + editedIdentity.getPhone() + " - " + b); return b;}
    	b = verifiedIdentity.getEmail().equals(editedIdentity.getEmail());
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getEmail() + ", " + editedIdentity.getEmail() + " - " + b); return b;}    	
    	b = verifiedIdentity.getGroupId() == editedIdentity.getGroupId();
    	if (!b) {_log.info("verified does not match edited veteran: " + verifiedIdentity.getGroupId() + ", " + editedIdentity.getGroupId() + " - " + b); return b;}    	
    	
    	return true;
    }
    public static boolean verifiedIdentityEqualsEditedIdentity_callCaller(Person verifiedIdentity, Person editedIdentity) {
    	boolean b = false;
    	b = verifiedIdentity.getLastName().equalsIgnoreCase(editedIdentity.getLastName());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getLastName() + ", " + editedIdentity.getLastName() + " - " + b); return b;}
    	b = verifiedIdentity.getFirstName().equalsIgnoreCase(editedIdentity.getFirstName());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getFirstName() + ", " + editedIdentity.getFirstName() + " - " + b); return b;}
    	b = verifiedIdentity.getMiddleName().equalsIgnoreCase(editedIdentity.getMiddleName());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getMiddleName() + ", " + editedIdentity.getMiddleName() + " - " + b); return b;}
    	b = verifiedIdentity.getSuffix().equalsIgnoreCase(editedIdentity.getSuffix());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getSuffix() + ", " + editedIdentity.getSuffix() + " - " + b); return b;}
    	b = verifiedIdentity.getPhone().equals(editedIdentity.getPhone());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getPhone() + ", " + editedIdentity.getPhone() + " - " + b); return b;}
    	b = verifiedIdentity.getPhone2().equals(editedIdentity.getPhone2());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getPhone2() + ", " + editedIdentity.getPhone2() + " - " + b); return b;}
    	b = verifiedIdentity.getEmail().equals(editedIdentity.getEmail());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getEmail() + ", " + editedIdentity.getEmail() + " - " + b); return b;}
    	b = verifiedIdentity.getState().equalsIgnoreCase(editedIdentity.getState());
    	if (!b) {_log.info("verified does not match edited caller: " + verifiedIdentity.getState() + ", " + editedIdentity.getState() + " - " + b); return b;}
    	return true;
    }
	private static Log _log = LogFactoryUtil.getLog( CslHecIdentityParam.class );
}