package gov.va.caret.util;

import java.util.HashMap;

public class CaretMap<T1, T2> extends HashMap<T1, T2> {
	private static final long serialVersionUID = 1L;
	private T2 handle;
	
	public CaretMap(T2 handle){
		super();
		setHandle( handle );
	}
	
	public T2 get(Object key) {
		T2 ndxValue = super.get(key);
		if ( ndxValue == null ){
			return handle;
		}
		return ndxValue;
    }
	
	public boolean containsKey(Object key) {
        return handle != null || super.containsKey(key);
    }

	public Object getHandle() {
		return handle;
	}

	public void setHandle(T2 handle) {
		this.handle = handle;
	}
}
