package gov.va.caret.util;

import java.math.BigDecimal;
import java.text.NumberFormat;

import com.liferay.portal.kernel.util.PropsUtil;

public class CBigDecimal extends BigDecimal {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static int decimalDigits = 2;
	private static int roundingMethod = ROUND_HALF_EVEN;
	private static NumberFormat format = null;
	
	static {
		String temp = PropsUtil.get("decimal.scale");
		if ( temp != null && !temp.isEmpty() ){
			decimalDigits = Integer.valueOf(String.valueOf(temp));
		}
		temp = PropsUtil.get("decimal.rounding");
		if ( temp != null && !temp.isEmpty() ){
			roundingMethod = Integer.valueOf(String.valueOf(temp));
		}
	}

	public CBigDecimal( String val ) {
		super(val);
		setScale(decimalDigits, roundingMethod);  
	}
	
//	public String toString(){
//		if ( format == null ){
//			format = NumberFormat.getCurrencyInstance(Locale.US);
//		}
//		return format.format(super.toString());
//	}
	
	public BigDecimal testAdd ( BigDecimal balance, BigDecimal transaction ){
		return balance.add(transaction);
	}
	
	public BigDecimal testSubtract ( BigDecimal balance, BigDecimal transaction ){
		return balance.subtract(transaction); 
	}
	
	public Double getDouble (){
		return new Double( doubleValue() );
	}
}
