package gov.va.caret.soc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

import javax.portlet.PortletRequest;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.SearchParms;
import gov.va.caret.model.impl.SearchParmsImpl;
import gov.va.caret.service.SearchParmsLocalServiceUtil;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.GenericReport;

public class SocCachedReportUtil {

	public static boolean isCallbackPrefEmpty(String s) {
		boolean b = s == null || s.equals("") || s.startsWith("MM") ? true : false;
		return b;
	}
	private static Date getCallbackDefaultDate() {
		Calendar c = Calendar.getInstance();
		c.set(Calendar.DAY_OF_MONTH, c.get(Calendar.DAY_OF_MONTH) + 10);
		return c.getTime();
	}
	public static String getCallbackPref_12HourFormat(String in) {
		if (isCallbackPrefEmpty(in)) {return "";}
		//
		DateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm", Locale.ENGLISH);
		try {
			Date d = !isCallbackPrefEmpty(in) ? df.parse(in) : getCallbackDefaultDate();
			Calendar c = Calendar.getInstance(TimeZone.getDefault());
			c.setTime(d);
			if (c.get(Calendar.HOUR_OF_DAY) > 12) {
			c.set(Calendar.HOUR_OF_DAY, c.get(Calendar.HOUR_OF_DAY) - 12);
			}
			return df.format(c.getTime());
		}
		catch(Exception e) {}
		//
		return "";
	}
	public static String getCallbackPref_24HourFormat(String in) {
		if (isCallbackPrefEmpty(in)) {return "";}
		//
		DateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm", Locale.ENGLISH);
		DateFormat df24 = new SimpleDateFormat("MM/dd/yyyy HH:mm", Locale.ENGLISH);
		try {
			Date d = !isCallbackPrefEmpty(in) ? df.parse(in) : getCallbackDefaultDate();
			Calendar c = Calendar.getInstance(TimeZone.getDefault());
			c.setTime(d);
			if (c.get(Calendar.HOUR_OF_DAY) >= 1  && c.get(Calendar.HOUR_OF_DAY) <= 6) {
				c.set(Calendar.HOUR_OF_DAY, c.get(Calendar.HOUR_OF_DAY) + 12);
			}
			return df24.format(c.getTime());
		}
		catch(Exception e) {}
		//
		return "";
	}  
	//
	public static GenericReport getPendingSOCRecords(PortletRequest request, int start, int end) {
		GenericReport gReport = new GenericReport("searchSocs");
		gReport.run(request, false, start, end);
		return gReport;
	}
	public static GenericReport getCompletedSOCRecords(PortletRequest request, int start, int end) {
		GenericReport gReport = new GenericReport("searchCompletedSocs");
		gReport.run(request, false, start, end);
		return gReport;
	}
	public static void updateSearchUtilGenericUser() {
		SearchParms searchUtil = null;
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( SearchParms.class, PortletClassLoaderUtil.getClassLoader());;
		dynamicQuery.add( PropertyFactoryUtil.forName("userId").eq(new Long(0)) );
		try {
			@SuppressWarnings("unchecked")
			List<SearchParms> list = (List<SearchParms>) SearchParmsLocalServiceUtil.dynamicQuery( dynamicQuery);
			if (list != null && !Collections.emptyList().equals(list)) {
				searchUtil = list.get(0);
			}
		} catch (com.liferay.portal.kernel.exception.SystemException se) {
			ApplicationWorkFlowException.handleException(se);
		}
		catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		//
		if (searchUtil == null) {searchUtil = new SearchParmsImpl();}
			searchUtil.setSocDueDays(CaretParam.getSocDueDays());
		try {
			SearchParmsLocalServiceUtil.updateSearchParms(searchUtil);
		}
		catch(Exception e){
			ApplicationWorkFlowException.handleException(e);
			(LogFactoryUtil.getLog( SocCachedReportUtil.class )).info("SocCachedReportUtil.updateGeneric exception: " + e.getMessage());
		}
	}
	
}

