package gov.va.caret.service.vetscanner;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretUtil;

public class VetScanner implements MessageListener {

	final long COMPANY_ID = PortalUtil.getDefaultCompanyId();
	public static Log log = LogFactoryUtil.getLog( VetScanner.class );
	
	@Override
	public void receive(Message arg0) throws MessageListenerException {

		log.info("VetScanner--->VETERAN SCANNER BEGIN " + new Date().toString());
		try {
			//get all verteran users that are NOT deceased.
			ExecutorService exec = Executors.newFixedThreadPool(15);
			ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
			if ( sc == null ){
				sc = new ServiceContext();
			}
			
			Group group = GroupLocalServiceUtil.getGroup( PortalUtil.getDefaultCompanyId(), CaretUtil.getOnlineSite());
			Role role = RoleLocalServiceUtil.fetchRole( PortalUtil.getDefaultCompanyId(), "Veteran" );
			List<UserGroupRole>  userGroupRoleList = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole(group.getGroupId(), role.getRoleId() ); 
			List <VcgAn> vcgAnList = VcgAnLocalServiceUtil.getVcgAns(com.liferay.portal.kernel.dao.orm.QueryUtil.ALL_POS, com.liferay.portal.kernel.dao.orm.QueryUtil.ALL_POS);
			for (ListIterator<VcgAn> iter = vcgAnList.listIterator(); iter.hasNext();)
			{
				VcgAn vcgAn = iter.next();
				VcgApplication vcgApplication = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAn.getVcgAnId()) ); 
				Veteran caret_person = new Veteran ( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
				//UserGroupRole userGroupRole = userGroupRoleIterator.next();
				//Veteran caret_person = new Veteran (PersnLocalServiceUtil.getLatest(userGroupRole.getUserId()));
				if (caret_person.getICN() != null && caret_person.getDeceasedDate() == null ) { 
					if (!caret_person.isPrimaryAvailable()) {
						log.info("VetScanner--->Veteran (persnid:" + caret_person.getPersnId() + ",userid:" + caret_person.getUserId() + ") queued for processing");
						VetScanWorker vsw = new VetScanWorker(caret_person);
						exec.submit(vsw);
					}
					
				}
				
			}
			exec.shutdown();
			try {
				exec.awaitTermination(240, TimeUnit.MINUTES);//give it 4 hours to finish doing what it is doing
			} catch (InterruptedException e) {
			  
			}
			
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}

		log.info("VETERAN SCANNER END " + new Date().toString());

		
	}

	public long getRoleIdByName(String roleName) throws Exception {
	    if (roleName != null && !roleName.isEmpty()) {
	        for (Role role : RoleLocalServiceUtil.getRoles(0, RoleLocalServiceUtil.getRolesCount())) {
	            if (role.getName().equals(roleName)) {
	                return role.getRoleId();
	            }
	        }
	    }
	    return -1;
	}
	
}
