package gov.va.caret.service.vetscanner;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.NoteSupport;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkStatus;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.portlet.resource.CaretResourceCommand;
import gov.va.caret.portlet.resource.ResourceCommand;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.ctssh.ServiceFacade;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.WorkName;
import gov.va.ee.EeSummary;
import gov.va.ee.GetEESummaryRequest;
import gov.va.ee.GetEESummaryResponse;
import gov.va.ee.service.EeService;

public class VetScanWorker implements Runnable {

	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
	private Veteran _caret_person;
	DateFormat format = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
	
	
	public VetScanWorker(Veteran caret_person) {
		_caret_person = caret_person;
	}
	
	protected Veteran getPerson()
	{
		return _caret_person;
	}
	
	public void run()
	{
		try {
			//do E&E Service call
			GetEESummaryRequest getEESummaryRequest = new GetEESummaryRequest();
			getEESummaryRequest.setKey(this._caret_person.getICN());
			getEESummaryRequest.setKeyType("VPID");
			getEESummaryRequest.setRequestName("CaregiverData");
			GetEESummaryResponse eeSummaryResponse = EeService.getEESummary(getEESummaryRequest);
			EeSummary eeSummary = eeSummaryResponse.getSummary();
			ServiceContext sc = new ServiceContext();
			if (eeSummary != null && eeSummary.getDeathRecond() != null) {
				Date dod = format.parse(eeSummary.getDeathRecond().getDeathDate());
				System.out.println("VetScanner--->DOD returned for Veteran (persnid:" + _caret_person.getPersnId() + ",userid:" + ", icn:" + _caret_person.getICN() + ((Veteran)this._caret_person).getPrimaryId()+ ", deceased date:"+dod + ")");	
				this._caret_person.setDeceasedDate(dod);
				PersnLocalServiceUtil.updatePersn(this._caret_person);
				
				//create a work item in the Tech queueu
				WorIm workItem = CaretUtil.createWorkItem(sc, this._caret_person.getGroupId(), this._caret_person, WorkType.DEATH_NOTIFICATION, this._caret_person.getPersnId(), ((Veteran)this._caret_person).getPrimaryId() );
				CaretLocalServiceUtil.save( workItem );
				workItem = new WorkItemSupport(workItem);
				((WorkItemSupport)workItem).useNote("veteranDeceased", CaretUtil.createNote(sc.getCreateDate(), workItem.getWorImId(), NoteSupport.NoteGroup.PROFILE_UPDATE.groupId(), sc.getUserId(), "Veteran Deceased"));
				CaretLocalServiceUtil.save( workItem );
				System.out.println("VetScanner--->Processing for Veteran (persnid:" + _caret_person.getPersnId() + ",userid:" + _caret_person.getUserId() + ", icn:" + _caret_person.getICN()+ ") complete");				
			}
			
		} catch(Exception er) {
			System.out.println("Error VetScanner--->Processing for Veteran (persnid:" + _caret_person.getPersnId() + ",userid:" + _caret_person.getUserId() + ", icn:" + _caret_person.getICN()+ " Errored");
			ApplicationWorkFlowException.handleException(er);
		}
	
	}
	
}
