package gov.va.caret.service.tiu;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import javax.portlet.ActionRequest;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;

import gov.va.caret.model.Docum;
import gov.va.caret.model.Persn;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.med.via.service.CloseNote;
import gov.va.med.via.service.CloseNoteResponse;
import gov.va.med.via.service.CprsLaunch;
import gov.va.med.via.service.CprsLaunchResponse;
import gov.va.med.via.service.EmrServiceImplService;
import gov.va.med.via.service.GetNoteTitles;
import gov.va.med.via.service.GetNoteTitlesResponse;
import gov.va.med.via.service.LoginVIA;
import gov.va.med.via.service.LoginVIAResponse;
import gov.va.med.via.service.Patient;
import gov.va.med.via.service.Provider;
import gov.va.med.via.service.QueryBean;
import gov.va.med.via.service.TaggedText;
import gov.va.med.via.service.TextTO;
import gov.va.med.via.service.ValidationException_Exception;
import gov.va.med.via.service.WriteNote;
import gov.va.med.via.service.WriteNoteResponse;

public class TiuService {
	
	private static final Log _log = LogFactoryUtil.getLog( TiuService.class );
	public final static String appId = "200CARE";
	final static String reason = "Approve";
	final static String fileName = "10-10CG.pdf";
	
	private TiuService(){}
	
	public static TextTO WriteTIUNote(VcgSupport vcg, ActionRequest request, String noteTitle, String noteBody, String icn) {
		
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		Persn cscUser = null;
		String cscVistaJson = "";
		String veteranVistaJson = "";
		try {
			WorIm worIm = WorImLocalServiceUtil.getWorIm(worImId);
			cscUser = PersnLocalServiceUtil.getByUser(worIm.getUserId());
			cscVistaJson = cscUser.getVistaId();
			veteranVistaJson = vcg.getVeteran().getVistaId();
			_log.info("Vista info for CSC" + cscVistaJson);
			_log.info("Vista info for Veteran" + veteranVistaJson);
		} catch (PortalException e1) {
			e1.printStackTrace();
		} catch (SystemException e1) {
			e1.printStackTrace();
		}
		EmrServiceImplService emrServiceImplService = new EmrServiceImplService();
		QueryBean queryBean = new QueryBean();
		queryBean.setRequestingApp( PropsUtil.get("tiu.consuming.app.name") );
		queryBean.setConsumingAppToken( PropsUtil.get("tiu.consuming.app.token") );
		queryBean.setConsumingAppPassword( PropsUtil.get("tiu.consuming.app.pass") );
		queryBean.setCriteria(request.getAttribute("STSResponseXML").toString());
		LoginVIAResponse loginVIAResponse = null;
		StringTokenizer veteranVistas = new StringTokenizer(veteranVistaJson, ",");
		while (veteranVistas.hasMoreElements()) {
			try {
				String veteranVista[] = veteranVistas.nextToken().split(":");
				Patient patient = new Patient();
				patient.setLocalPid(veteranVista[1].replace("\"", ""));
				patient.setLocalSiteId(veteranVista[0].replace("\"", "")); //Update this with siteid's from db
				queryBean.setPatient(patient);
				
				String cscVista[] = cscVistaJson.split(":");
				Provider provider = new Provider();
				provider.setLoginSiteCode(cscVista[0].replace("\"", ""));
				provider.setUserId(cscVista[1].replace("\"", "")); //
				provider.setName(cscUser.getFirstName() + " " + cscUser.getLastName());
				queryBean.setProvider(provider);
				
				CprsLaunch cprsLaunch = new CprsLaunch();
				cprsLaunch.setQueryBean(queryBean);
				CprsLaunchResponse cprsLaunchResponse = emrServiceImplService.getEmrServiceImplPort().cprsLaunch(cprsLaunch);
				if (cprsLaunchResponse.getPersonsTO().getFault() != null) {
					_log.error("Error calling CprsLaunchResponse " + cprsLaunchResponse.getPersonsTO().getFault().getInnerMessage());
				} else {
					_log.info("CprsLaunchResponse User DUZ: " + cprsLaunchResponse.getPersonsTO().getUser().getDUZ());
				}
				LoginVIA loginVIA = new LoginVIA();
				loginVIA.setSiteCode(cprsLaunchResponse.getPersonsTO().getUser().getSiteId());
				provider.setUserId(cprsLaunchResponse.getPersonsTO().getUser().getDUZ());
				provider.setName(cprsLaunchResponse.getPersonsTO().getUser().getName());
				provider.setLoginSiteCode(cprsLaunchResponse.getPersonsTO().getUser().getSiteId());
				queryBean.setProvider(provider);
				loginVIA.setQueryBean(queryBean);
				loginVIAResponse =  emrServiceImplService.getEmrServiceImplPort().loginVIA(loginVIA);
				if (loginVIAResponse.getUserTO().getFault() != null) {
					_log.error("Error calling LoginVIAResponse " + loginVIAResponse.getUserTO().getFault().getInnerMessage());
				} else {
				_log.info("LoginVIAResponse User DUZ: " + loginVIAResponse.getUserTO().getDUZ());
				}
				GetNoteTitles getNoteTitles = new GetNoteTitles();
				queryBean.setTarget("SCI");
				getNoteTitles.setQueryBean(queryBean);
				GetNoteTitlesResponse getNoteTitlesResponse = emrServiceImplService.getEmrServiceImplPort().getNoteTitles(getNoteTitles);
				if (getNoteTitlesResponse.getTaggedTextArray().getFault() != null) {
					_log.error("Error calling GetNoteTitlesResponse " + getNoteTitlesResponse.getTaggedTextArray().getFault().getInnerMessage());
				} else {
				_log.info("GetNoteTitlesResponse: " + getNoteTitlesResponse.getTaggedTextArray());
				}
				Calendar prevYear = Calendar.getInstance();
			    prevYear.add(Calendar.YEAR, -1700);
				String encounterString = cscVista[0].replace("\"", "")+ ";" + new SimpleDateFormat("YYYMMdd.HHmmss").format(prevYear.getTime()) + ";E;";
				
				WriteNote writeNote = new WriteNote();
				writeNote.setAuthorDUZ(loginVIAResponse.getUserTO().getDUZ());
				writeNote.setEncounterString(encounterString);
				writeNote.setText(noteBody);
				
				writeNote.setQueryBean(queryBean);
				List<TaggedText> taggedTextList =  getNoteTitlesResponse.getTaggedTextArray().getResults().getTaggedText();
				for (Iterator<TaggedText> iter = taggedTextList.get(0).getTaggedResults().getTaggedText().iterator(); iter.hasNext();) {
					TaggedText taggedText = iter.next();
					for (Iterator<String> iter1 = taggedText.getTextArray().getTextArray().iterator(); iter1.hasNext();) {
						String taggedText1 = iter1.next();
						if (taggedText1.contains("CAREGIVER STATUS")) {
							writeNote.setTitleIEN(taggedText.getTag());
							break;
						}
					}
				}
				WriteNoteResponse writeNoteResponse = emrServiceImplService.getEmrServiceImplPort().writeNote(writeNote);
				if (writeNoteResponse.getNoteResultTO().getFault() != null) {
					_log.error("Error calling WriteNoteResponse " + writeNoteResponse.getNoteResultTO().getFault().getInnerMessage());
				} else {
				_log.info("WriteNoteResponse: " + writeNoteResponse.getNoteResultTO().getId());
				}
				CloseNote closeNote = new CloseNote();
				closeNote.setNoteIEN(writeNoteResponse.getNoteResultTO().getId());
				closeNote.setQueryBean(queryBean);
				CloseNoteResponse closeNoteResponse = emrServiceImplService.getEmrServiceImplPort().closeNote(closeNote);
				String result = closeNoteResponse.getTextTO().getText();
				if (closeNoteResponse.getTextTO().getFault() != null) {
					_log.error("Error calling CloseNoteResponse " + closeNoteResponse.getTextTO().getFault().getInnerMessage());
				} else {
				_log.info("CloseNoteResponse: " +result);
				}
			} catch (ValidationException_Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}

}
