package gov.va.caret.service.thread;

import java.util.HashMap;
import java.util.Map;


public class NonClusteredMonitor {
	
	private Map<Long,Long> monitor;
	private NonClusteredMonitor(){}
	
	private Map<Long,Long> getMonitorMap(){
		if ( this.monitor == null ){
			this.monitor = new HashMap<Long,Long>();
		}
		return this.monitor;
	}

	private static NonClusteredMonitor _instans;
	private static NonClusteredMonitor getInstance(){
		if ( _instans == null ){
			_instans = new NonClusteredMonitor();
		}
		return _instans;
	}
	
	public static void clear (){
		_instans = new NonClusteredMonitor();
	}
	
	public static long unlock ( Long objectId ){
		synchronized(NonClusteredMonitor.class){
			if ( getInstance().getMonitorMap().containsKey(objectId) ){
				return getInstance().getMonitorMap().remove(objectId);
			}
			return 0;
		}
	}

	public static long lock( long objectId, long def ) {
		synchronized(NonClusteredMonitor.class){
			if ( getInstance().getMonitorMap().containsKey(objectId) ){
				return getInstance().getMonitorMap().get(objectId);
			}
			getInstance().getMonitorMap().put( objectId, def );
			return def;
		}
	}
	
}
