package gov.va.caret.service.thread;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.impl.BgNumImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.service.BgNumLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;


public class ClusterCapableMonitor {
	
	private ClusterCapableMonitor(){}

	private static ClusterCapableMonitor _instans;
	private long boxGpId = 0l;

	private static ClusterCapableMonitor getInstance(){
		if ( _instans == null ){
			_instans = new ClusterCapableMonitor();
		}
		return _instans;
	}
	
	public static void clear (){
		_instans = new ClusterCapableMonitor();
	}
	
	private long getBoxGpId() {
		if ( boxGpId == 0 ) {
			try {
				init();
			} catch (ApplicationWorkFlowException | SystemException e) {
				e.printStackTrace();
			}
		}
		return boxGpId;
	}
	
	public static long unlock ( Long objectId ){
		
		if ( getInstance().containsKey(objectId) ){
			return getInstance().remove(objectId);
		}
		return 0;
	}

	public static long lock( long objectId, long def ) {
		if ( getInstance().containsKey(objectId) ){
			return getInstance().get(objectId);
		}
		getInstance().put( objectId, def );
		return def;
	}
	
	private boolean put(long objectId, long def) {
		List<BgNum> bgNum = BgNumLocalServiceUtil.findByAll( objectId, getBoxGpId() );
		if ( !bgNum.isEmpty() ) {
			bgNum.get(0).setValue(def);
			try {
				BgNumLocalServiceUtil.updateBgNum( bgNum.get(0) );
				return true;
			} catch (SystemException e) {
				e.printStackTrace();
			}
		} else {
			BgNum bgNum0 = new BgNumImpl();
			bgNum0.setBoxGpId(getBoxGpId());
			bgNum0.setValue(def);
			bgNum0.setOwnerId(objectId);
			try {
				BgNumLocalServiceUtil.addBgNum(bgNum0);
				return true;
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		return false;
	}

	private long get(long objectId) {
		List<BgNum> bgNum = BgNumLocalServiceUtil.findByAll( objectId, getBoxGpId() );
		if ( !bgNum.isEmpty() ) {
			return (long) bgNum.get(0).getValue();
		}
		return 0;
	}

	private boolean containsKey( Long objectId ) {
		List<BgNum> bgNum = BgNumLocalServiceUtil.findByAll( objectId, getBoxGpId() );
		if ( !bgNum.isEmpty() ) {
			return bgNum.get(0).getValue() > 0;
		}
		return false;
	}
	
	private long remove( Long objectId ) {
		List<BgNum> bgNum = BgNumLocalServiceUtil.findByAll( objectId, getBoxGpId() );
		if ( !bgNum.isEmpty() ) {
			long temp = (long)bgNum.get(0).getValue();
			bgNum.get(0).setValue(0);
			try {
				BgNumLocalServiceUtil.updateBgNum( bgNum.get(0) );
				return temp;
			} catch (SystemException e) {
				e.printStackTrace();
			}
		}
		return 0l;
	}
	
	private void init() throws SystemException, ApplicationWorkFlowException {
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups( "gov.va.caret.service.thread.Monitor", "ClusterCapableMonitor" );
		if ( !groups.isEmpty() ) {
			boxGpId = groups.get(0).getBoxGpId();
		} else {
			BoxGp grp = new BoxGpImpl();
			grp.setBoxGroup( "gov.va.caret.service.thread.Monitor" );
			grp.setLabel( "gov.va.caret.service.thread.Monitor" );
			grp.setBoxSubGroup( "ClusterCapableMonitor" );
			boxGpId = BoxGpLocalServiceUtil.addBoxGp(grp).getBoxGpId();
		}
	}
	
}
