package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchEERatedDisabilityException;
import gov.va.caret.model.EERatedDisability;
import gov.va.caret.model.impl.EERatedDisabilityImpl;
import gov.va.caret.model.impl.EERatedDisabilityModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the e e rated disability service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see EERatedDisabilityPersistence
 * @see EERatedDisabilityUtil
 * @generated
 */
public class EERatedDisabilityPersistenceImpl extends BasePersistenceImpl<EERatedDisability>
    implements EERatedDisabilityPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link EERatedDisabilityUtil} to access the e e rated disability persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = EERatedDisabilityImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityModelImpl.FINDER_CACHE_ENABLED,
            EERatedDisabilityImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityModelImpl.FINDER_CACHE_ENABLED,
            EERatedDisabilityImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_EELGID = new FinderPath(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityModelImpl.FINDER_CACHE_ENABLED,
            EERatedDisabilityImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByeeLgId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID =
        new FinderPath(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityModelImpl.FINDER_CACHE_ENABLED,
            EERatedDisabilityImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByeeLgId",
            new String[] { Long.class.getName() },
            EERatedDisabilityModelImpl.EELGID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_EELGID = new FinderPath(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByeeLgId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_EELGID_EELGID_2 = "eeRatedDisability.eeLgId = ?";
    private static final String _SQL_SELECT_EERATEDDISABILITY = "SELECT eeRatedDisability FROM EERatedDisability eeRatedDisability";
    private static final String _SQL_SELECT_EERATEDDISABILITY_WHERE = "SELECT eeRatedDisability FROM EERatedDisability eeRatedDisability WHERE ";
    private static final String _SQL_COUNT_EERATEDDISABILITY = "SELECT COUNT(eeRatedDisability) FROM EERatedDisability eeRatedDisability";
    private static final String _SQL_COUNT_EERATEDDISABILITY_WHERE = "SELECT COUNT(eeRatedDisability) FROM EERatedDisability eeRatedDisability WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "eeRatedDisability.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No EERatedDisability exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No EERatedDisability exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(EERatedDisabilityPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "code"
            });
    private static EERatedDisability _nullEERatedDisability = new EERatedDisabilityImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<EERatedDisability> toCacheModel() {
                return _nullEERatedDisabilityCacheModel;
            }
        };

    private static CacheModel<EERatedDisability> _nullEERatedDisabilityCacheModel =
        new CacheModel<EERatedDisability>() {
            @Override
            public EERatedDisability toEntityModel() {
                return _nullEERatedDisability;
            }
        };

    public EERatedDisabilityPersistenceImpl() {
        setModelClass(EERatedDisability.class);
    }

    /**
     * Returns all the e e rated disabilities where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @return the matching e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EERatedDisability> findByeeLgId(long eeLgId)
        throws SystemException {
        return findByeeLgId(eeLgId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e rated disabilities where eeLgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param eeLgId the ee lg ID
     * @param start the lower bound of the range of e e rated disabilities
     * @param end the upper bound of the range of e e rated disabilities (not inclusive)
     * @return the range of matching e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EERatedDisability> findByeeLgId(long eeLgId, int start, int end)
        throws SystemException {
        return findByeeLgId(eeLgId, start, end, null);
    }

    /**
     * Returns an ordered range of all the e e rated disabilities where eeLgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param eeLgId the ee lg ID
     * @param start the lower bound of the range of e e rated disabilities
     * @param end the upper bound of the range of e e rated disabilities (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EERatedDisability> findByeeLgId(long eeLgId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID;
            finderArgs = new Object[] { eeLgId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_EELGID;
            finderArgs = new Object[] { eeLgId, start, end, orderByComparator };
        }

        List<EERatedDisability> list = (List<EERatedDisability>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (EERatedDisability eeRatedDisability : list) {
                if ((eeLgId != eeRatedDisability.getEeLgId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_EERATEDDISABILITY_WHERE);

            query.append(_FINDER_COLUMN_EELGID_EELGID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(EERatedDisabilityModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(eeLgId);

                if (!pagination) {
                    list = (List<EERatedDisability>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EERatedDisability>(list);
                } else {
                    list = (List<EERatedDisability>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first e e rated disability in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e rated disability
     * @throws gov.va.caret.NoSuchEERatedDisabilityException if a matching e e rated disability could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability findByeeLgId_First(long eeLgId,
        OrderByComparator orderByComparator)
        throws NoSuchEERatedDisabilityException, SystemException {
        EERatedDisability eeRatedDisability = fetchByeeLgId_First(eeLgId,
                orderByComparator);

        if (eeRatedDisability != null) {
            return eeRatedDisability;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("eeLgId=");
        msg.append(eeLgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEERatedDisabilityException(msg.toString());
    }

    /**
     * Returns the first e e rated disability in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e rated disability, or <code>null</code> if a matching e e rated disability could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability fetchByeeLgId_First(long eeLgId,
        OrderByComparator orderByComparator) throws SystemException {
        List<EERatedDisability> list = findByeeLgId(eeLgId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last e e rated disability in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e rated disability
     * @throws gov.va.caret.NoSuchEERatedDisabilityException if a matching e e rated disability could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability findByeeLgId_Last(long eeLgId,
        OrderByComparator orderByComparator)
        throws NoSuchEERatedDisabilityException, SystemException {
        EERatedDisability eeRatedDisability = fetchByeeLgId_Last(eeLgId,
                orderByComparator);

        if (eeRatedDisability != null) {
            return eeRatedDisability;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("eeLgId=");
        msg.append(eeLgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEERatedDisabilityException(msg.toString());
    }

    /**
     * Returns the last e e rated disability in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e rated disability, or <code>null</code> if a matching e e rated disability could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability fetchByeeLgId_Last(long eeLgId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByeeLgId(eeLgId);

        if (count == 0) {
            return null;
        }

        List<EERatedDisability> list = findByeeLgId(eeLgId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the e e rated disabilities before and after the current e e rated disability in the ordered set where eeLgId = &#63;.
     *
     * @param eeRatedDisabId the primary key of the current e e rated disability
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next e e rated disability
     * @throws gov.va.caret.NoSuchEERatedDisabilityException if a e e rated disability with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability[] findByeeLgId_PrevAndNext(long eeRatedDisabId,
        long eeLgId, OrderByComparator orderByComparator)
        throws NoSuchEERatedDisabilityException, SystemException {
        EERatedDisability eeRatedDisability = findByPrimaryKey(eeRatedDisabId);

        Session session = null;

        try {
            session = openSession();

            EERatedDisability[] array = new EERatedDisabilityImpl[3];

            array[0] = getByeeLgId_PrevAndNext(session, eeRatedDisability,
                    eeLgId, orderByComparator, true);

            array[1] = eeRatedDisability;

            array[2] = getByeeLgId_PrevAndNext(session, eeRatedDisability,
                    eeLgId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected EERatedDisability getByeeLgId_PrevAndNext(Session session,
        EERatedDisability eeRatedDisability, long eeLgId,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_EERATEDDISABILITY_WHERE);

        query.append(_FINDER_COLUMN_EELGID_EELGID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(EERatedDisabilityModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(eeLgId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(eeRatedDisability);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<EERatedDisability> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the e e rated disabilities where eeLgId = &#63; from the database.
     *
     * @param eeLgId the ee lg ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByeeLgId(long eeLgId) throws SystemException {
        for (EERatedDisability eeRatedDisability : findByeeLgId(eeLgId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(eeRatedDisability);
        }
    }

    /**
     * Returns the number of e e rated disabilities where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @return the number of matching e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByeeLgId(long eeLgId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_EELGID;

        Object[] finderArgs = new Object[] { eeLgId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_EERATEDDISABILITY_WHERE);

            query.append(_FINDER_COLUMN_EELGID_EELGID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(eeLgId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the e e rated disability in the entity cache if it is enabled.
     *
     * @param eeRatedDisability the e e rated disability
     */
    @Override
    public void cacheResult(EERatedDisability eeRatedDisability) {
        EntityCacheUtil.putResult(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityImpl.class, eeRatedDisability.getPrimaryKey(),
            eeRatedDisability);

        eeRatedDisability.resetOriginalValues();
    }

    /**
     * Caches the e e rated disabilities in the entity cache if it is enabled.
     *
     * @param eeRatedDisabilities the e e rated disabilities
     */
    @Override
    public void cacheResult(List<EERatedDisability> eeRatedDisabilities) {
        for (EERatedDisability eeRatedDisability : eeRatedDisabilities) {
            if (EntityCacheUtil.getResult(
                        EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
                        EERatedDisabilityImpl.class,
                        eeRatedDisability.getPrimaryKey()) == null) {
                cacheResult(eeRatedDisability);
            } else {
                eeRatedDisability.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all e e rated disabilities.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(EERatedDisabilityImpl.class.getName());
        }

        EntityCacheUtil.clearCache(EERatedDisabilityImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the e e rated disability.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(EERatedDisability eeRatedDisability) {
        EntityCacheUtil.removeResult(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityImpl.class, eeRatedDisability.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<EERatedDisability> eeRatedDisabilities) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (EERatedDisability eeRatedDisability : eeRatedDisabilities) {
            EntityCacheUtil.removeResult(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
                EERatedDisabilityImpl.class, eeRatedDisability.getPrimaryKey());
        }
    }

    /**
     * Creates a new e e rated disability with the primary key. Does not add the e e rated disability to the database.
     *
     * @param eeRatedDisabId the primary key for the new e e rated disability
     * @return the new e e rated disability
     */
    @Override
    public EERatedDisability create(long eeRatedDisabId) {
        EERatedDisability eeRatedDisability = new EERatedDisabilityImpl();

        eeRatedDisability.setNew(true);
        eeRatedDisability.setPrimaryKey(eeRatedDisabId);

        return eeRatedDisability;
    }

    /**
     * Removes the e e rated disability with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param eeRatedDisabId the primary key of the e e rated disability
     * @return the e e rated disability that was removed
     * @throws gov.va.caret.NoSuchEERatedDisabilityException if a e e rated disability with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability remove(long eeRatedDisabId)
        throws NoSuchEERatedDisabilityException, SystemException {
        return remove((Serializable) eeRatedDisabId);
    }

    /**
     * Removes the e e rated disability with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the e e rated disability
     * @return the e e rated disability that was removed
     * @throws gov.va.caret.NoSuchEERatedDisabilityException if a e e rated disability with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability remove(Serializable primaryKey)
        throws NoSuchEERatedDisabilityException, SystemException {
        Session session = null;

        try {
            session = openSession();

            EERatedDisability eeRatedDisability = (EERatedDisability) session.get(EERatedDisabilityImpl.class,
                    primaryKey);

            if (eeRatedDisability == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchEERatedDisabilityException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(eeRatedDisability);
        } catch (NoSuchEERatedDisabilityException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected EERatedDisability removeImpl(EERatedDisability eeRatedDisability)
        throws SystemException {
        eeRatedDisability = toUnwrappedModel(eeRatedDisability);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(eeRatedDisability)) {
                eeRatedDisability = (EERatedDisability) session.get(EERatedDisabilityImpl.class,
                        eeRatedDisability.getPrimaryKeyObj());
            }

            if (eeRatedDisability != null) {
                session.delete(eeRatedDisability);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (eeRatedDisability != null) {
            clearCache(eeRatedDisability);
        }

        return eeRatedDisability;
    }

    @Override
    public EERatedDisability updateImpl(
        gov.va.caret.model.EERatedDisability eeRatedDisability)
        throws SystemException {
        eeRatedDisability = toUnwrappedModel(eeRatedDisability);

        boolean isNew = eeRatedDisability.isNew();

        EERatedDisabilityModelImpl eeRatedDisabilityModelImpl = (EERatedDisabilityModelImpl) eeRatedDisability;

        Session session = null;

        try {
            session = openSession();

            if (eeRatedDisability.isNew()) {
                session.save(eeRatedDisability);

                eeRatedDisability.setNew(false);
            } else {
                session.merge(eeRatedDisability);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !EERatedDisabilityModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((eeRatedDisabilityModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        eeRatedDisabilityModelImpl.getOriginalEeLgId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EELGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID,
                    args);

                args = new Object[] { eeRatedDisabilityModelImpl.getEeLgId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EELGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID,
                    args);
            }
        }

        EntityCacheUtil.putResult(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
            EERatedDisabilityImpl.class, eeRatedDisability.getPrimaryKey(),
            eeRatedDisability);

        return eeRatedDisability;
    }

    protected EERatedDisability toUnwrappedModel(
        EERatedDisability eeRatedDisability) {
        if (eeRatedDisability instanceof EERatedDisabilityImpl) {
            return eeRatedDisability;
        }

        EERatedDisabilityImpl eeRatedDisabilityImpl = new EERatedDisabilityImpl();

        eeRatedDisabilityImpl.setNew(eeRatedDisability.isNew());
        eeRatedDisabilityImpl.setPrimaryKey(eeRatedDisability.getPrimaryKey());

        eeRatedDisabilityImpl.setEeRatedDisabId(eeRatedDisability.getEeRatedDisabId());
        eeRatedDisabilityImpl.setEeLgId(eeRatedDisability.getEeLgId());
        eeRatedDisabilityImpl.setPercentage(eeRatedDisability.getPercentage());
        eeRatedDisabilityImpl.setCode(eeRatedDisability.getCode());
        eeRatedDisabilityImpl.setDescription(eeRatedDisability.getDescription());

        return eeRatedDisabilityImpl;
    }

    /**
     * Returns the e e rated disability with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the e e rated disability
     * @return the e e rated disability
     * @throws gov.va.caret.NoSuchEERatedDisabilityException if a e e rated disability with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability findByPrimaryKey(Serializable primaryKey)
        throws NoSuchEERatedDisabilityException, SystemException {
        EERatedDisability eeRatedDisability = fetchByPrimaryKey(primaryKey);

        if (eeRatedDisability == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchEERatedDisabilityException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return eeRatedDisability;
    }

    /**
     * Returns the e e rated disability with the primary key or throws a {@link gov.va.caret.NoSuchEERatedDisabilityException} if it could not be found.
     *
     * @param eeRatedDisabId the primary key of the e e rated disability
     * @return the e e rated disability
     * @throws gov.va.caret.NoSuchEERatedDisabilityException if a e e rated disability with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability findByPrimaryKey(long eeRatedDisabId)
        throws NoSuchEERatedDisabilityException, SystemException {
        return findByPrimaryKey((Serializable) eeRatedDisabId);
    }

    /**
     * Returns the e e rated disability with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the e e rated disability
     * @return the e e rated disability, or <code>null</code> if a e e rated disability with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        EERatedDisability eeRatedDisability = (EERatedDisability) EntityCacheUtil.getResult(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
                EERatedDisabilityImpl.class, primaryKey);

        if (eeRatedDisability == _nullEERatedDisability) {
            return null;
        }

        if (eeRatedDisability == null) {
            Session session = null;

            try {
                session = openSession();

                eeRatedDisability = (EERatedDisability) session.get(EERatedDisabilityImpl.class,
                        primaryKey);

                if (eeRatedDisability != null) {
                    cacheResult(eeRatedDisability);
                } else {
                    EntityCacheUtil.putResult(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
                        EERatedDisabilityImpl.class, primaryKey,
                        _nullEERatedDisability);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(EERatedDisabilityModelImpl.ENTITY_CACHE_ENABLED,
                    EERatedDisabilityImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return eeRatedDisability;
    }

    /**
     * Returns the e e rated disability with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param eeRatedDisabId the primary key of the e e rated disability
     * @return the e e rated disability, or <code>null</code> if a e e rated disability with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EERatedDisability fetchByPrimaryKey(long eeRatedDisabId)
        throws SystemException {
        return fetchByPrimaryKey((Serializable) eeRatedDisabId);
    }

    /**
     * Returns all the e e rated disabilities.
     *
     * @return the e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EERatedDisability> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e rated disabilities.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e rated disabilities
     * @param end the upper bound of the range of e e rated disabilities (not inclusive)
     * @return the range of e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EERatedDisability> findAll(int start, int end)
        throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the e e rated disabilities.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e rated disabilities
     * @param end the upper bound of the range of e e rated disabilities (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EERatedDisability> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<EERatedDisability> list = (List<EERatedDisability>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_EERATEDDISABILITY);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_EERATEDDISABILITY;

                if (pagination) {
                    sql = sql.concat(EERatedDisabilityModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<EERatedDisability>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EERatedDisability>(list);
                } else {
                    list = (List<EERatedDisability>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the e e rated disabilities from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (EERatedDisability eeRatedDisability : findAll()) {
            remove(eeRatedDisability);
        }
    }

    /**
     * Returns the number of e e rated disabilities.
     *
     * @return the number of e e rated disabilities
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_EERATEDDISABILITY);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the e e rated disability persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.EERatedDisability")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<EERatedDisability>> listenersList = new ArrayList<ModelListener<EERatedDisability>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<EERatedDisability>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(EERatedDisabilityImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
