package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchCryptoException;
import gov.va.caret.model.Crypto;
import gov.va.caret.model.impl.CryptoImpl;
import gov.va.caret.model.impl.CryptoModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the crypto service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CryptoPersistence
 * @see CryptoUtil
 * @generated
 */
public class CryptoPersistenceImpl extends BasePersistenceImpl<Crypto>
    implements CryptoPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link CryptoUtil} to access the crypto persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = CryptoImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoModelImpl.FINDER_CACHE_ENABLED, CryptoImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoModelImpl.FINDER_CACHE_ENABLED, CryptoImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_CRYPTOVALUE = new FinderPath(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoModelImpl.FINDER_CACHE_ENABLED, CryptoImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByCryptoValue",
            new String[] { String.class.getName(), Long.class.getName() },
            CryptoModelImpl.TYPE_COLUMN_BITMASK |
            CryptoModelImpl.OWNERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CRYPTOVALUE = new FinderPath(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCryptoValue",
            new String[] { String.class.getName(), Long.class.getName() });
    private static final String _FINDER_COLUMN_CRYPTOVALUE_TYPE_1 = "crypto.type IS NULL AND ";
    private static final String _FINDER_COLUMN_CRYPTOVALUE_TYPE_2 = "crypto.type = ? AND ";
    private static final String _FINDER_COLUMN_CRYPTOVALUE_TYPE_3 = "(crypto.type IS NULL OR crypto.type = '') AND ";
    private static final String _FINDER_COLUMN_CRYPTOVALUE_OWNERID_2 = "crypto.ownerId = ?";
    private static final String _SQL_SELECT_CRYPTO = "SELECT crypto FROM Crypto crypto";
    private static final String _SQL_SELECT_CRYPTO_WHERE = "SELECT crypto FROM Crypto crypto WHERE ";
    private static final String _SQL_COUNT_CRYPTO = "SELECT COUNT(crypto) FROM Crypto crypto";
    private static final String _SQL_COUNT_CRYPTO_WHERE = "SELECT COUNT(crypto) FROM Crypto crypto WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "crypto.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Crypto exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Crypto exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(CryptoPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "type"
            });
    private static Crypto _nullCrypto = new CryptoImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Crypto> toCacheModel() {
                return _nullCryptoCacheModel;
            }
        };

    private static CacheModel<Crypto> _nullCryptoCacheModel = new CacheModel<Crypto>() {
            @Override
            public Crypto toEntityModel() {
                return _nullCrypto;
            }
        };

    public CryptoPersistenceImpl() {
        setModelClass(Crypto.class);
    }

    /**
     * Returns the crypto where type = &#63; and ownerId = &#63; or throws a {@link gov.va.caret.NoSuchCryptoException} if it could not be found.
     *
     * @param type the type
     * @param ownerId the owner ID
     * @return the matching crypto
     * @throws gov.va.caret.NoSuchCryptoException if a matching crypto could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto findByCryptoValue(String type, long ownerId)
        throws NoSuchCryptoException, SystemException {
        Crypto crypto = fetchByCryptoValue(type, ownerId);

        if (crypto == null) {
            StringBundler msg = new StringBundler(6);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("type=");
            msg.append(type);

            msg.append(", ownerId=");
            msg.append(ownerId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchCryptoException(msg.toString());
        }

        return crypto;
    }

    /**
     * Returns the crypto where type = &#63; and ownerId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param type the type
     * @param ownerId the owner ID
     * @return the matching crypto, or <code>null</code> if a matching crypto could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto fetchByCryptoValue(String type, long ownerId)
        throws SystemException {
        return fetchByCryptoValue(type, ownerId, true);
    }

    /**
     * Returns the crypto where type = &#63; and ownerId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param type the type
     * @param ownerId the owner ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching crypto, or <code>null</code> if a matching crypto could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto fetchByCryptoValue(String type, long ownerId,
        boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[] { type, ownerId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE,
                    finderArgs, this);
        }

        if (result instanceof Crypto) {
            Crypto crypto = (Crypto) result;

            if (!Validator.equals(type, crypto.getType()) ||
                    (ownerId != crypto.getOwnerId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_SELECT_CRYPTO_WHERE);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_CRYPTOVALUE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_CRYPTOVALUE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_CRYPTOVALUE_TYPE_2);
            }

            query.append(_FINDER_COLUMN_CRYPTOVALUE_OWNERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindType) {
                    qPos.add(type);
                }

                qPos.add(ownerId);

                List<Crypto> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "CryptoPersistenceImpl.fetchByCryptoValue(String, long, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    Crypto crypto = list.get(0);

                    result = crypto;

                    cacheResult(crypto);

                    if ((crypto.getType() == null) ||
                            !crypto.getType().equals(type) ||
                            (crypto.getOwnerId() != ownerId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE,
                            finderArgs, crypto);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (Crypto) result;
        }
    }

    /**
     * Removes the crypto where type = &#63; and ownerId = &#63; from the database.
     *
     * @param type the type
     * @param ownerId the owner ID
     * @return the crypto that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto removeByCryptoValue(String type, long ownerId)
        throws NoSuchCryptoException, SystemException {
        Crypto crypto = findByCryptoValue(type, ownerId);

        return remove(crypto);
    }

    /**
     * Returns the number of cryptos where type = &#63; and ownerId = &#63;.
     *
     * @param type the type
     * @param ownerId the owner ID
     * @return the number of matching cryptos
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByCryptoValue(String type, long ownerId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CRYPTOVALUE;

        Object[] finderArgs = new Object[] { type, ownerId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_CRYPTO_WHERE);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_CRYPTOVALUE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_CRYPTOVALUE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_CRYPTOVALUE_TYPE_2);
            }

            query.append(_FINDER_COLUMN_CRYPTOVALUE_OWNERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindType) {
                    qPos.add(type);
                }

                qPos.add(ownerId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the crypto in the entity cache if it is enabled.
     *
     * @param crypto the crypto
     */
    @Override
    public void cacheResult(Crypto crypto) {
        EntityCacheUtil.putResult(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoImpl.class, crypto.getPrimaryKey(), crypto);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE,
            new Object[] { crypto.getType(), crypto.getOwnerId() }, crypto);

        crypto.resetOriginalValues();
    }

    /**
     * Caches the cryptos in the entity cache if it is enabled.
     *
     * @param cryptos the cryptos
     */
    @Override
    public void cacheResult(List<Crypto> cryptos) {
        for (Crypto crypto : cryptos) {
            if (EntityCacheUtil.getResult(
                        CryptoModelImpl.ENTITY_CACHE_ENABLED, CryptoImpl.class,
                        crypto.getPrimaryKey()) == null) {
                cacheResult(crypto);
            } else {
                crypto.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all cryptos.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(CryptoImpl.class.getName());
        }

        EntityCacheUtil.clearCache(CryptoImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the crypto.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Crypto crypto) {
        EntityCacheUtil.removeResult(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoImpl.class, crypto.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(crypto);
    }

    @Override
    public void clearCache(List<Crypto> cryptos) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Crypto crypto : cryptos) {
            EntityCacheUtil.removeResult(CryptoModelImpl.ENTITY_CACHE_ENABLED,
                CryptoImpl.class, crypto.getPrimaryKey());

            clearUniqueFindersCache(crypto);
        }
    }

    protected void cacheUniqueFindersCache(Crypto crypto) {
        if (crypto.isNew()) {
            Object[] args = new Object[] { crypto.getType(), crypto.getOwnerId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_CRYPTOVALUE, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE, args,
                crypto);
        } else {
            CryptoModelImpl cryptoModelImpl = (CryptoModelImpl) crypto;

            if ((cryptoModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_CRYPTOVALUE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        crypto.getType(), crypto.getOwnerId()
                    };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_CRYPTOVALUE,
                    args, Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE,
                    args, crypto);
            }
        }
    }

    protected void clearUniqueFindersCache(Crypto crypto) {
        CryptoModelImpl cryptoModelImpl = (CryptoModelImpl) crypto;

        Object[] args = new Object[] { crypto.getType(), crypto.getOwnerId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CRYPTOVALUE, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE, args);

        if ((cryptoModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_CRYPTOVALUE.getColumnBitmask()) != 0) {
            args = new Object[] {
                    cryptoModelImpl.getOriginalType(),
                    cryptoModelImpl.getOriginalOwnerId()
                };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CRYPTOVALUE, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_CRYPTOVALUE, args);
        }
    }

    /**
     * Creates a new crypto with the primary key. Does not add the crypto to the database.
     *
     * @param cryptoId the primary key for the new crypto
     * @return the new crypto
     */
    @Override
    public Crypto create(long cryptoId) {
        Crypto crypto = new CryptoImpl();

        crypto.setNew(true);
        crypto.setPrimaryKey(cryptoId);

        return crypto;
    }

    /**
     * Removes the crypto with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param cryptoId the primary key of the crypto
     * @return the crypto that was removed
     * @throws gov.va.caret.NoSuchCryptoException if a crypto with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto remove(long cryptoId)
        throws NoSuchCryptoException, SystemException {
        return remove((Serializable) cryptoId);
    }

    /**
     * Removes the crypto with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the crypto
     * @return the crypto that was removed
     * @throws gov.va.caret.NoSuchCryptoException if a crypto with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto remove(Serializable primaryKey)
        throws NoSuchCryptoException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Crypto crypto = (Crypto) session.get(CryptoImpl.class, primaryKey);

            if (crypto == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchCryptoException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(crypto);
        } catch (NoSuchCryptoException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Crypto removeImpl(Crypto crypto) throws SystemException {
        crypto = toUnwrappedModel(crypto);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(crypto)) {
                crypto = (Crypto) session.get(CryptoImpl.class,
                        crypto.getPrimaryKeyObj());
            }

            if (crypto != null) {
                session.delete(crypto);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (crypto != null) {
            clearCache(crypto);
        }

        return crypto;
    }

    @Override
    public Crypto updateImpl(gov.va.caret.model.Crypto crypto)
        throws SystemException {
        crypto = toUnwrappedModel(crypto);

        boolean isNew = crypto.isNew();

        Session session = null;

        try {
            session = openSession();

            if (crypto.isNew()) {
                session.save(crypto);

                crypto.setNew(false);
            } else {
                session.merge(crypto);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !CryptoModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(CryptoModelImpl.ENTITY_CACHE_ENABLED,
            CryptoImpl.class, crypto.getPrimaryKey(), crypto);

        clearUniqueFindersCache(crypto);
        cacheUniqueFindersCache(crypto);

        return crypto;
    }

    protected Crypto toUnwrappedModel(Crypto crypto) {
        if (crypto instanceof CryptoImpl) {
            return crypto;
        }

        CryptoImpl cryptoImpl = new CryptoImpl();

        cryptoImpl.setNew(crypto.isNew());
        cryptoImpl.setPrimaryKey(crypto.getPrimaryKey());

        cryptoImpl.setCryptoId(crypto.getCryptoId());
        cryptoImpl.setOwnerId(crypto.getOwnerId());
        cryptoImpl.setType(crypto.getType());
        cryptoImpl.setValue(crypto.getValue());
        cryptoImpl.setHcode(crypto.getHcode());

        return cryptoImpl;
    }

    /**
     * Returns the crypto with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the crypto
     * @return the crypto
     * @throws gov.va.caret.NoSuchCryptoException if a crypto with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto findByPrimaryKey(Serializable primaryKey)
        throws NoSuchCryptoException, SystemException {
        Crypto crypto = fetchByPrimaryKey(primaryKey);

        if (crypto == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchCryptoException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return crypto;
    }

    /**
     * Returns the crypto with the primary key or throws a {@link gov.va.caret.NoSuchCryptoException} if it could not be found.
     *
     * @param cryptoId the primary key of the crypto
     * @return the crypto
     * @throws gov.va.caret.NoSuchCryptoException if a crypto with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto findByPrimaryKey(long cryptoId)
        throws NoSuchCryptoException, SystemException {
        return findByPrimaryKey((Serializable) cryptoId);
    }

    /**
     * Returns the crypto with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the crypto
     * @return the crypto, or <code>null</code> if a crypto with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Crypto crypto = (Crypto) EntityCacheUtil.getResult(CryptoModelImpl.ENTITY_CACHE_ENABLED,
                CryptoImpl.class, primaryKey);

        if (crypto == _nullCrypto) {
            return null;
        }

        if (crypto == null) {
            Session session = null;

            try {
                session = openSession();

                crypto = (Crypto) session.get(CryptoImpl.class, primaryKey);

                if (crypto != null) {
                    cacheResult(crypto);
                } else {
                    EntityCacheUtil.putResult(CryptoModelImpl.ENTITY_CACHE_ENABLED,
                        CryptoImpl.class, primaryKey, _nullCrypto);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(CryptoModelImpl.ENTITY_CACHE_ENABLED,
                    CryptoImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return crypto;
    }

    /**
     * Returns the crypto with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param cryptoId the primary key of the crypto
     * @return the crypto, or <code>null</code> if a crypto with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Crypto fetchByPrimaryKey(long cryptoId) throws SystemException {
        return fetchByPrimaryKey((Serializable) cryptoId);
    }

    /**
     * Returns all the cryptos.
     *
     * @return the cryptos
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Crypto> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the cryptos.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CryptoModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cryptos
     * @param end the upper bound of the range of cryptos (not inclusive)
     * @return the range of cryptos
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Crypto> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the cryptos.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CryptoModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of cryptos
     * @param end the upper bound of the range of cryptos (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of cryptos
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Crypto> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Crypto> list = (List<Crypto>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_CRYPTO);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CRYPTO;

                if (pagination) {
                    sql = sql.concat(CryptoModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Crypto>) QueryUtil.list(q, getDialect(),
                            start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Crypto>(list);
                } else {
                    list = (List<Crypto>) QueryUtil.list(q, getDialect(),
                            start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the cryptos from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Crypto crypto : findAll()) {
            remove(crypto);
        }
    }

    /**
     * Returns the number of cryptos.
     *
     * @return the number of cryptos
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_CRYPTO);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the crypto persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Crypto")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Crypto>> listenersList = new ArrayList<ModelListener<Crypto>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Crypto>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(CryptoImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
