package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchBlsReException;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.impl.BlsReImpl;
import gov.va.caret.model.impl.BlsReModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the bls re service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BlsRePersistence
 * @see BlsReUtil
 * @generated
 */
public class BlsRePersistenceImpl extends BasePersistenceImpl<BlsRe>
    implements BlsRePersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link BlsReUtil} to access the bls re persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = BlsReImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, BlsReImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, BlsReImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_STATE = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, BlsReImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByState",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STATE = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, BlsReImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByState",
            new String[] { String.class.getName() },
            BlsReModelImpl.STATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_STATE = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByState",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_STATE_STATE_1 = "blsRe.state IS NULL";
    private static final String _FINDER_COLUMN_STATE_STATE_2 = "blsRe.state = ?";
    private static final String _FINDER_COLUMN_STATE_STATE_3 = "(blsRe.state IS NULL OR blsRe.state = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ZIP = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, BlsReImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByZip",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, BlsReImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByZip",
            new String[] { String.class.getName() },
            BlsReModelImpl.ZIP_COLUMN_BITMASK |
            BlsReModelImpl.STATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_ZIP = new FinderPath(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByZip",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_ZIP_ZIP_1 = "blsRe.zip IS NULL";
    private static final String _FINDER_COLUMN_ZIP_ZIP_2 = "blsRe.zip = ?";
    private static final String _FINDER_COLUMN_ZIP_ZIP_3 = "(blsRe.zip IS NULL OR blsRe.zip = '')";
    private static final String _SQL_SELECT_BLSRE = "SELECT blsRe FROM BlsRe blsRe";
    private static final String _SQL_SELECT_BLSRE_WHERE = "SELECT blsRe FROM BlsRe blsRe WHERE ";
    private static final String _SQL_COUNT_BLSRE = "SELECT COUNT(blsRe) FROM BlsRe blsRe";
    private static final String _SQL_COUNT_BLSRE_WHERE = "SELECT COUNT(blsRe) FROM BlsRe blsRe WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "blsRe.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No BlsRe exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No BlsRe exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(BlsRePersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "state"
            });
    private static BlsRe _nullBlsRe = new BlsReImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<BlsRe> toCacheModel() {
                return _nullBlsReCacheModel;
            }
        };

    private static CacheModel<BlsRe> _nullBlsReCacheModel = new CacheModel<BlsRe>() {
            @Override
            public BlsRe toEntityModel() {
                return _nullBlsRe;
            }
        };

    public BlsRePersistenceImpl() {
        setModelClass(BlsRe.class);
    }

    /**
     * Returns all the bls res where state = &#63;.
     *
     * @param state the state
     * @return the matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findByState(String state) throws SystemException {
        return findByState(state, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bls res where state = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param state the state
     * @param start the lower bound of the range of bls res
     * @param end the upper bound of the range of bls res (not inclusive)
     * @return the range of matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findByState(String state, int start, int end)
        throws SystemException {
        return findByState(state, start, end, null);
    }

    /**
     * Returns an ordered range of all the bls res where state = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param state the state
     * @param start the lower bound of the range of bls res
     * @param end the upper bound of the range of bls res (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findByState(String state, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STATE;
            finderArgs = new Object[] { state };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_STATE;
            finderArgs = new Object[] { state, start, end, orderByComparator };
        }

        List<BlsRe> list = (List<BlsRe>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BlsRe blsRe : list) {
                if (!Validator.equals(state, blsRe.getState())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_BLSRE_WHERE);

            boolean bindState = false;

            if (state == null) {
                query.append(_FINDER_COLUMN_STATE_STATE_1);
            } else if (state.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_STATE_STATE_3);
            } else {
                bindState = true;

                query.append(_FINDER_COLUMN_STATE_STATE_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BlsReModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindState) {
                    qPos.add(state);
                }

                if (!pagination) {
                    list = (List<BlsRe>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BlsRe>(list);
                } else {
                    list = (List<BlsRe>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first bls re in the ordered set where state = &#63;.
     *
     * @param state the state
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bls re
     * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe findByState_First(String state,
        OrderByComparator orderByComparator)
        throws NoSuchBlsReException, SystemException {
        BlsRe blsRe = fetchByState_First(state, orderByComparator);

        if (blsRe != null) {
            return blsRe;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("state=");
        msg.append(state);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBlsReException(msg.toString());
    }

    /**
     * Returns the first bls re in the ordered set where state = &#63;.
     *
     * @param state the state
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bls re, or <code>null</code> if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe fetchByState_First(String state,
        OrderByComparator orderByComparator) throws SystemException {
        List<BlsRe> list = findByState(state, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last bls re in the ordered set where state = &#63;.
     *
     * @param state the state
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bls re
     * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe findByState_Last(String state,
        OrderByComparator orderByComparator)
        throws NoSuchBlsReException, SystemException {
        BlsRe blsRe = fetchByState_Last(state, orderByComparator);

        if (blsRe != null) {
            return blsRe;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("state=");
        msg.append(state);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBlsReException(msg.toString());
    }

    /**
     * Returns the last bls re in the ordered set where state = &#63;.
     *
     * @param state the state
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bls re, or <code>null</code> if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe fetchByState_Last(String state,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByState(state);

        if (count == 0) {
            return null;
        }

        List<BlsRe> list = findByState(state, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the bls res before and after the current bls re in the ordered set where state = &#63;.
     *
     * @param blsReId the primary key of the current bls re
     * @param state the state
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next bls re
     * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe[] findByState_PrevAndNext(long blsReId, String state,
        OrderByComparator orderByComparator)
        throws NoSuchBlsReException, SystemException {
        BlsRe blsRe = findByPrimaryKey(blsReId);

        Session session = null;

        try {
            session = openSession();

            BlsRe[] array = new BlsReImpl[3];

            array[0] = getByState_PrevAndNext(session, blsRe, state,
                    orderByComparator, true);

            array[1] = blsRe;

            array[2] = getByState_PrevAndNext(session, blsRe, state,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BlsRe getByState_PrevAndNext(Session session, BlsRe blsRe,
        String state, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BLSRE_WHERE);

        boolean bindState = false;

        if (state == null) {
            query.append(_FINDER_COLUMN_STATE_STATE_1);
        } else if (state.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_STATE_STATE_3);
        } else {
            bindState = true;

            query.append(_FINDER_COLUMN_STATE_STATE_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BlsReModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindState) {
            qPos.add(state);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(blsRe);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BlsRe> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the bls res where state = &#63; from the database.
     *
     * @param state the state
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByState(String state) throws SystemException {
        for (BlsRe blsRe : findByState(state, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(blsRe);
        }
    }

    /**
     * Returns the number of bls res where state = &#63;.
     *
     * @param state the state
     * @return the number of matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByState(String state) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_STATE;

        Object[] finderArgs = new Object[] { state };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_BLSRE_WHERE);

            boolean bindState = false;

            if (state == null) {
                query.append(_FINDER_COLUMN_STATE_STATE_1);
            } else if (state.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_STATE_STATE_3);
            } else {
                bindState = true;

                query.append(_FINDER_COLUMN_STATE_STATE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindState) {
                    qPos.add(state);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the bls res where zip = &#63;.
     *
     * @param zip the zip
     * @return the matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findByZip(String zip) throws SystemException {
        return findByZip(zip, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bls res where zip = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param zip the zip
     * @param start the lower bound of the range of bls res
     * @param end the upper bound of the range of bls res (not inclusive)
     * @return the range of matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findByZip(String zip, int start, int end)
        throws SystemException {
        return findByZip(zip, start, end, null);
    }

    /**
     * Returns an ordered range of all the bls res where zip = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param zip the zip
     * @param start the lower bound of the range of bls res
     * @param end the upper bound of the range of bls res (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findByZip(String zip, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP;
            finderArgs = new Object[] { zip };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ZIP;
            finderArgs = new Object[] { zip, start, end, orderByComparator };
        }

        List<BlsRe> list = (List<BlsRe>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BlsRe blsRe : list) {
                if (!Validator.equals(zip, blsRe.getZip())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_BLSRE_WHERE);

            boolean bindZip = false;

            if (zip == null) {
                query.append(_FINDER_COLUMN_ZIP_ZIP_1);
            } else if (zip.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ZIP_ZIP_3);
            } else {
                bindZip = true;

                query.append(_FINDER_COLUMN_ZIP_ZIP_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BlsReModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindZip) {
                    qPos.add(zip);
                }

                if (!pagination) {
                    list = (List<BlsRe>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BlsRe>(list);
                } else {
                    list = (List<BlsRe>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first bls re in the ordered set where zip = &#63;.
     *
     * @param zip the zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bls re
     * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe findByZip_First(String zip, OrderByComparator orderByComparator)
        throws NoSuchBlsReException, SystemException {
        BlsRe blsRe = fetchByZip_First(zip, orderByComparator);

        if (blsRe != null) {
            return blsRe;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("zip=");
        msg.append(zip);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBlsReException(msg.toString());
    }

    /**
     * Returns the first bls re in the ordered set where zip = &#63;.
     *
     * @param zip the zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bls re, or <code>null</code> if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe fetchByZip_First(String zip,
        OrderByComparator orderByComparator) throws SystemException {
        List<BlsRe> list = findByZip(zip, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last bls re in the ordered set where zip = &#63;.
     *
     * @param zip the zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bls re
     * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe findByZip_Last(String zip, OrderByComparator orderByComparator)
        throws NoSuchBlsReException, SystemException {
        BlsRe blsRe = fetchByZip_Last(zip, orderByComparator);

        if (blsRe != null) {
            return blsRe;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("zip=");
        msg.append(zip);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBlsReException(msg.toString());
    }

    /**
     * Returns the last bls re in the ordered set where zip = &#63;.
     *
     * @param zip the zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bls re, or <code>null</code> if a matching bls re could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe fetchByZip_Last(String zip, OrderByComparator orderByComparator)
        throws SystemException {
        int count = countByZip(zip);

        if (count == 0) {
            return null;
        }

        List<BlsRe> list = findByZip(zip, count - 1, count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the bls res before and after the current bls re in the ordered set where zip = &#63;.
     *
     * @param blsReId the primary key of the current bls re
     * @param zip the zip
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next bls re
     * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe[] findByZip_PrevAndNext(long blsReId, String zip,
        OrderByComparator orderByComparator)
        throws NoSuchBlsReException, SystemException {
        BlsRe blsRe = findByPrimaryKey(blsReId);

        Session session = null;

        try {
            session = openSession();

            BlsRe[] array = new BlsReImpl[3];

            array[0] = getByZip_PrevAndNext(session, blsRe, zip,
                    orderByComparator, true);

            array[1] = blsRe;

            array[2] = getByZip_PrevAndNext(session, blsRe, zip,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BlsRe getByZip_PrevAndNext(Session session, BlsRe blsRe,
        String zip, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BLSRE_WHERE);

        boolean bindZip = false;

        if (zip == null) {
            query.append(_FINDER_COLUMN_ZIP_ZIP_1);
        } else if (zip.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_ZIP_ZIP_3);
        } else {
            bindZip = true;

            query.append(_FINDER_COLUMN_ZIP_ZIP_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BlsReModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindZip) {
            qPos.add(zip);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(blsRe);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BlsRe> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the bls res where zip = &#63; from the database.
     *
     * @param zip the zip
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByZip(String zip) throws SystemException {
        for (BlsRe blsRe : findByZip(zip, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
                null)) {
            remove(blsRe);
        }
    }

    /**
     * Returns the number of bls res where zip = &#63;.
     *
     * @param zip the zip
     * @return the number of matching bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByZip(String zip) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ZIP;

        Object[] finderArgs = new Object[] { zip };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_BLSRE_WHERE);

            boolean bindZip = false;

            if (zip == null) {
                query.append(_FINDER_COLUMN_ZIP_ZIP_1);
            } else if (zip.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ZIP_ZIP_3);
            } else {
                bindZip = true;

                query.append(_FINDER_COLUMN_ZIP_ZIP_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindZip) {
                    qPos.add(zip);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the bls re in the entity cache if it is enabled.
     *
     * @param blsRe the bls re
     */
    @Override
    public void cacheResult(BlsRe blsRe) {
        EntityCacheUtil.putResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReImpl.class, blsRe.getPrimaryKey(), blsRe);

        blsRe.resetOriginalValues();
    }

    /**
     * Caches the bls res in the entity cache if it is enabled.
     *
     * @param blsRes the bls res
     */
    @Override
    public void cacheResult(List<BlsRe> blsRes) {
        for (BlsRe blsRe : blsRes) {
            if (EntityCacheUtil.getResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
                        BlsReImpl.class, blsRe.getPrimaryKey()) == null) {
                cacheResult(blsRe);
            } else {
                blsRe.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all bls res.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(BlsReImpl.class.getName());
        }

        EntityCacheUtil.clearCache(BlsReImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the bls re.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(BlsRe blsRe) {
        EntityCacheUtil.removeResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReImpl.class, blsRe.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<BlsRe> blsRes) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (BlsRe blsRe : blsRes) {
            EntityCacheUtil.removeResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
                BlsReImpl.class, blsRe.getPrimaryKey());
        }
    }

    /**
     * Creates a new bls re with the primary key. Does not add the bls re to the database.
     *
     * @param blsReId the primary key for the new bls re
     * @return the new bls re
     */
    @Override
    public BlsRe create(long blsReId) {
        BlsRe blsRe = new BlsReImpl();

        blsRe.setNew(true);
        blsRe.setPrimaryKey(blsReId);

        return blsRe;
    }

    /**
     * Removes the bls re with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param blsReId the primary key of the bls re
     * @return the bls re that was removed
     * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe remove(long blsReId)
        throws NoSuchBlsReException, SystemException {
        return remove((Serializable) blsReId);
    }

    /**
     * Removes the bls re with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the bls re
     * @return the bls re that was removed
     * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe remove(Serializable primaryKey)
        throws NoSuchBlsReException, SystemException {
        Session session = null;

        try {
            session = openSession();

            BlsRe blsRe = (BlsRe) session.get(BlsReImpl.class, primaryKey);

            if (blsRe == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchBlsReException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(blsRe);
        } catch (NoSuchBlsReException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected BlsRe removeImpl(BlsRe blsRe) throws SystemException {
        blsRe = toUnwrappedModel(blsRe);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(blsRe)) {
                blsRe = (BlsRe) session.get(BlsReImpl.class,
                        blsRe.getPrimaryKeyObj());
            }

            if (blsRe != null) {
                session.delete(blsRe);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (blsRe != null) {
            clearCache(blsRe);
        }

        return blsRe;
    }

    @Override
    public BlsRe updateImpl(gov.va.caret.model.BlsRe blsRe)
        throws SystemException {
        blsRe = toUnwrappedModel(blsRe);

        boolean isNew = blsRe.isNew();

        BlsReModelImpl blsReModelImpl = (BlsReModelImpl) blsRe;

        Session session = null;

        try {
            session = openSession();

            if (blsRe.isNew()) {
                session.save(blsRe);

                blsRe.setNew(false);
            } else {
                session.merge(blsRe);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !BlsReModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((blsReModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STATE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { blsReModelImpl.getOriginalState() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STATE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STATE,
                    args);

                args = new Object[] { blsReModelImpl.getState() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STATE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STATE,
                    args);
            }

            if ((blsReModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { blsReModelImpl.getOriginalZip() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ZIP, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP,
                    args);

                args = new Object[] { blsReModelImpl.getZip() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ZIP, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ZIP,
                    args);
            }
        }

        EntityCacheUtil.putResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
            BlsReImpl.class, blsRe.getPrimaryKey(), blsRe);

        return blsRe;
    }

    protected BlsRe toUnwrappedModel(BlsRe blsRe) {
        if (blsRe instanceof BlsReImpl) {
            return blsRe;
        }

        BlsReImpl blsReImpl = new BlsReImpl();

        blsReImpl.setNew(blsRe.isNew());
        blsReImpl.setPrimaryKey(blsRe.getPrimaryKey());

        blsReImpl.setBlsReId(blsRe.getBlsReId());
        blsReImpl.setBlsAeId(blsRe.getBlsAeId());
        blsReImpl.setYear(blsRe.getYear());
        blsReImpl.setH75(blsRe.getH75());
        blsReImpl.setCity(blsRe.getCity());
        blsReImpl.setZip(blsRe.getZip());
        blsReImpl.setState(blsRe.getState());
        blsReImpl.setCounty(blsRe.getCounty());

        return blsReImpl;
    }

    /**
     * Returns the bls re with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the bls re
     * @return the bls re
     * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe findByPrimaryKey(Serializable primaryKey)
        throws NoSuchBlsReException, SystemException {
        BlsRe blsRe = fetchByPrimaryKey(primaryKey);

        if (blsRe == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchBlsReException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return blsRe;
    }

    /**
     * Returns the bls re with the primary key or throws a {@link gov.va.caret.NoSuchBlsReException} if it could not be found.
     *
     * @param blsReId the primary key of the bls re
     * @return the bls re
     * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe findByPrimaryKey(long blsReId)
        throws NoSuchBlsReException, SystemException {
        return findByPrimaryKey((Serializable) blsReId);
    }

    /**
     * Returns the bls re with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the bls re
     * @return the bls re, or <code>null</code> if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        BlsRe blsRe = (BlsRe) EntityCacheUtil.getResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
                BlsReImpl.class, primaryKey);

        if (blsRe == _nullBlsRe) {
            return null;
        }

        if (blsRe == null) {
            Session session = null;

            try {
                session = openSession();

                blsRe = (BlsRe) session.get(BlsReImpl.class, primaryKey);

                if (blsRe != null) {
                    cacheResult(blsRe);
                } else {
                    EntityCacheUtil.putResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
                        BlsReImpl.class, primaryKey, _nullBlsRe);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(BlsReModelImpl.ENTITY_CACHE_ENABLED,
                    BlsReImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return blsRe;
    }

    /**
     * Returns the bls re with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param blsReId the primary key of the bls re
     * @return the bls re, or <code>null</code> if a bls re with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsRe fetchByPrimaryKey(long blsReId) throws SystemException {
        return fetchByPrimaryKey((Serializable) blsReId);
    }

    /**
     * Returns all the bls res.
     *
     * @return the bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bls res.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bls res
     * @param end the upper bound of the range of bls res (not inclusive)
     * @return the range of bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the bls res.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bls res
     * @param end the upper bound of the range of bls res (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsRe> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<BlsRe> list = (List<BlsRe>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_BLSRE);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_BLSRE;

                if (pagination) {
                    sql = sql.concat(BlsReModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<BlsRe>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BlsRe>(list);
                } else {
                    list = (List<BlsRe>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the bls res from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (BlsRe blsRe : findAll()) {
            remove(blsRe);
        }
    }

    /**
     * Returns the number of bls res.
     *
     * @return the number of bls res
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_BLSRE);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the bls re persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.BlsRe")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<BlsRe>> listenersList = new ArrayList<ModelListener<BlsRe>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<BlsRe>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(BlsReImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
