package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchBgLaeException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BgLaeModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the bg lae service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgLaePersistence
 * @see BgLaeUtil
 * @generated
 */
public class BgLaePersistenceImpl extends BasePersistenceImpl<BgLae>
    implements BgLaePersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link BgLaeUtil} to access the bg lae persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = BgLaeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, BgLaeImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, BgLaeImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPCHARASSOCIATIONS =
        new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, BgLaeImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findByBoxGroupCharAssociations",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPCHARASSOCIATIONS =
        new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, BgLaeImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "findByBoxGroupCharAssociations",
            new String[] { Long.class.getName() },
            BgLaeModelImpl.OWNERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BOXGROUPCHARASSOCIATIONS =
        new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "countByBoxGroupCharAssociations",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_BOXGROUPCHARASSOCIATIONS_OWNERID_2 =
        "bgLae.ownerId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_BGCHARINST = new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, BgLaeImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByBgCharInst",
            new String[] { Long.class.getName(), Long.class.getName() },
            BgLaeModelImpl.OWNERID_COLUMN_BITMASK |
            BgLaeModelImpl.BOXGPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BGCHARINST = new FinderPath(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBgCharInst",
            new String[] { Long.class.getName(), Long.class.getName() });
    private static final String _FINDER_COLUMN_BGCHARINST_OWNERID_2 = "bgLae.ownerId = ? AND ";
    private static final String _FINDER_COLUMN_BGCHARINST_BOXGPID_2 = "bgLae.boxGpId = ?";
    private static final String _SQL_SELECT_BGLAE = "SELECT bgLae FROM BgLae bgLae";
    private static final String _SQL_SELECT_BGLAE_WHERE = "SELECT bgLae FROM BgLae bgLae WHERE ";
    private static final String _SQL_COUNT_BGLAE = "SELECT COUNT(bgLae) FROM BgLae bgLae";
    private static final String _SQL_COUNT_BGLAE_WHERE = "SELECT COUNT(bgLae) FROM BgLae bgLae WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "bgLae.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No BgLae exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No BgLae exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(BgLaePersistenceImpl.class);
    private static BgLae _nullBgLae = new BgLaeImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<BgLae> toCacheModel() {
                return _nullBgLaeCacheModel;
            }
        };

    private static CacheModel<BgLae> _nullBgLaeCacheModel = new CacheModel<BgLae>() {
            @Override
            public BgLae toEntityModel() {
                return _nullBgLae;
            }
        };

    public BgLaePersistenceImpl() {
        setModelClass(BgLae.class);
    }

    /**
     * Returns all the bg laes where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @return the matching bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgLae> findByBoxGroupCharAssociations(long ownerId)
        throws SystemException {
        return findByBoxGroupCharAssociations(ownerId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bg laes where ownerId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param start the lower bound of the range of bg laes
     * @param end the upper bound of the range of bg laes (not inclusive)
     * @return the range of matching bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgLae> findByBoxGroupCharAssociations(long ownerId, int start,
        int end) throws SystemException {
        return findByBoxGroupCharAssociations(ownerId, start, end, null);
    }

    /**
     * Returns an ordered range of all the bg laes where ownerId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param start the lower bound of the range of bg laes
     * @param end the upper bound of the range of bg laes (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgLae> findByBoxGroupCharAssociations(long ownerId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPCHARASSOCIATIONS;
            finderArgs = new Object[] { ownerId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPCHARASSOCIATIONS;
            finderArgs = new Object[] { ownerId, start, end, orderByComparator };
        }

        List<BgLae> list = (List<BgLae>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BgLae bgLae : list) {
                if ((ownerId != bgLae.getOwnerId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_BGLAE_WHERE);

            query.append(_FINDER_COLUMN_BOXGROUPCHARASSOCIATIONS_OWNERID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BgLaeModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                if (!pagination) {
                    list = (List<BgLae>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BgLae>(list);
                } else {
                    list = (List<BgLae>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first bg lae in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg lae
     * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae findByBoxGroupCharAssociations_First(long ownerId,
        OrderByComparator orderByComparator)
        throws NoSuchBgLaeException, SystemException {
        BgLae bgLae = fetchByBoxGroupCharAssociations_First(ownerId,
                orderByComparator);

        if (bgLae != null) {
            return bgLae;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgLaeException(msg.toString());
    }

    /**
     * Returns the first bg lae in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg lae, or <code>null</code> if a matching bg lae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae fetchByBoxGroupCharAssociations_First(long ownerId,
        OrderByComparator orderByComparator) throws SystemException {
        List<BgLae> list = findByBoxGroupCharAssociations(ownerId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last bg lae in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg lae
     * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae findByBoxGroupCharAssociations_Last(long ownerId,
        OrderByComparator orderByComparator)
        throws NoSuchBgLaeException, SystemException {
        BgLae bgLae = fetchByBoxGroupCharAssociations_Last(ownerId,
                orderByComparator);

        if (bgLae != null) {
            return bgLae;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgLaeException(msg.toString());
    }

    /**
     * Returns the last bg lae in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg lae, or <code>null</code> if a matching bg lae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae fetchByBoxGroupCharAssociations_Last(long ownerId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByBoxGroupCharAssociations(ownerId);

        if (count == 0) {
            return null;
        }

        List<BgLae> list = findByBoxGroupCharAssociations(ownerId, count - 1,
                count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the bg laes before and after the current bg lae in the ordered set where ownerId = &#63;.
     *
     * @param bgLaeId the primary key of the current bg lae
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next bg lae
     * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae[] findByBoxGroupCharAssociations_PrevAndNext(long bgLaeId,
        long ownerId, OrderByComparator orderByComparator)
        throws NoSuchBgLaeException, SystemException {
        BgLae bgLae = findByPrimaryKey(bgLaeId);

        Session session = null;

        try {
            session = openSession();

            BgLae[] array = new BgLaeImpl[3];

            array[0] = getByBoxGroupCharAssociations_PrevAndNext(session,
                    bgLae, ownerId, orderByComparator, true);

            array[1] = bgLae;

            array[2] = getByBoxGroupCharAssociations_PrevAndNext(session,
                    bgLae, ownerId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BgLae getByBoxGroupCharAssociations_PrevAndNext(Session session,
        BgLae bgLae, long ownerId, OrderByComparator orderByComparator,
        boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BGLAE_WHERE);

        query.append(_FINDER_COLUMN_BOXGROUPCHARASSOCIATIONS_OWNERID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BgLaeModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(ownerId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(bgLae);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BgLae> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the bg laes where ownerId = &#63; from the database.
     *
     * @param ownerId the owner ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByBoxGroupCharAssociations(long ownerId)
        throws SystemException {
        for (BgLae bgLae : findByBoxGroupCharAssociations(ownerId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(bgLae);
        }
    }

    /**
     * Returns the number of bg laes where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @return the number of matching bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBoxGroupCharAssociations(long ownerId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BOXGROUPCHARASSOCIATIONS;

        Object[] finderArgs = new Object[] { ownerId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_BGLAE_WHERE);

            query.append(_FINDER_COLUMN_BOXGROUPCHARASSOCIATIONS_OWNERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgLaeException} if it could not be found.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the matching bg lae
     * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae findByBgCharInst(long ownerId, long boxGpId)
        throws NoSuchBgLaeException, SystemException {
        BgLae bgLae = fetchByBgCharInst(ownerId, boxGpId);

        if (bgLae == null) {
            StringBundler msg = new StringBundler(6);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("ownerId=");
            msg.append(ownerId);

            msg.append(", boxGpId=");
            msg.append(boxGpId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchBgLaeException(msg.toString());
        }

        return bgLae;
    }

    /**
     * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the matching bg lae, or <code>null</code> if a matching bg lae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae fetchByBgCharInst(long ownerId, long boxGpId)
        throws SystemException {
        return fetchByBgCharInst(ownerId, boxGpId, true);
    }

    /**
     * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching bg lae, or <code>null</code> if a matching bg lae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae fetchByBgCharInst(long ownerId, long boxGpId,
        boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[] { ownerId, boxGpId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_BGCHARINST,
                    finderArgs, this);
        }

        if (result instanceof BgLae) {
            BgLae bgLae = (BgLae) result;

            if ((ownerId != bgLae.getOwnerId()) ||
                    (boxGpId != bgLae.getBoxGpId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_SELECT_BGLAE_WHERE);

            query.append(_FINDER_COLUMN_BGCHARINST_OWNERID_2);

            query.append(_FINDER_COLUMN_BGCHARINST_BOXGPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(boxGpId);

                List<BgLae> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGCHARINST,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "BgLaePersistenceImpl.fetchByBgCharInst(long, long, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    BgLae bgLae = list.get(0);

                    result = bgLae;

                    cacheResult(bgLae);

                    if ((bgLae.getOwnerId() != ownerId) ||
                            (bgLae.getBoxGpId() != boxGpId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGCHARINST,
                            finderArgs, bgLae);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGCHARINST,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (BgLae) result;
        }
    }

    /**
     * Removes the bg lae where ownerId = &#63; and boxGpId = &#63; from the database.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the bg lae that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae removeByBgCharInst(long ownerId, long boxGpId)
        throws NoSuchBgLaeException, SystemException {
        BgLae bgLae = findByBgCharInst(ownerId, boxGpId);

        return remove(bgLae);
    }

    /**
     * Returns the number of bg laes where ownerId = &#63; and boxGpId = &#63;.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the number of matching bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBgCharInst(long ownerId, long boxGpId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BGCHARINST;

        Object[] finderArgs = new Object[] { ownerId, boxGpId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_BGLAE_WHERE);

            query.append(_FINDER_COLUMN_BGCHARINST_OWNERID_2);

            query.append(_FINDER_COLUMN_BGCHARINST_BOXGPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(boxGpId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the bg lae in the entity cache if it is enabled.
     *
     * @param bgLae the bg lae
     */
    @Override
    public void cacheResult(BgLae bgLae) {
        EntityCacheUtil.putResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeImpl.class, bgLae.getPrimaryKey(), bgLae);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGCHARINST,
            new Object[] { bgLae.getOwnerId(), bgLae.getBoxGpId() }, bgLae);

        bgLae.resetOriginalValues();
    }

    /**
     * Caches the bg laes in the entity cache if it is enabled.
     *
     * @param bgLaes the bg laes
     */
    @Override
    public void cacheResult(List<BgLae> bgLaes) {
        for (BgLae bgLae : bgLaes) {
            if (EntityCacheUtil.getResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
                        BgLaeImpl.class, bgLae.getPrimaryKey()) == null) {
                cacheResult(bgLae);
            } else {
                bgLae.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all bg laes.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(BgLaeImpl.class.getName());
        }

        EntityCacheUtil.clearCache(BgLaeImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the bg lae.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(BgLae bgLae) {
        EntityCacheUtil.removeResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeImpl.class, bgLae.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(bgLae);
    }

    @Override
    public void clearCache(List<BgLae> bgLaes) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (BgLae bgLae : bgLaes) {
            EntityCacheUtil.removeResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
                BgLaeImpl.class, bgLae.getPrimaryKey());

            clearUniqueFindersCache(bgLae);
        }
    }

    protected void cacheUniqueFindersCache(BgLae bgLae) {
        if (bgLae.isNew()) {
            Object[] args = new Object[] { bgLae.getOwnerId(), bgLae.getBoxGpId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGCHARINST, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGCHARINST, args,
                bgLae);
        } else {
            BgLaeModelImpl bgLaeModelImpl = (BgLaeModelImpl) bgLae;

            if ((bgLaeModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_BGCHARINST.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        bgLae.getOwnerId(), bgLae.getBoxGpId()
                    };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGCHARINST,
                    args, Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGCHARINST,
                    args, bgLae);
            }
        }
    }

    protected void clearUniqueFindersCache(BgLae bgLae) {
        BgLaeModelImpl bgLaeModelImpl = (BgLaeModelImpl) bgLae;

        Object[] args = new Object[] { bgLae.getOwnerId(), bgLae.getBoxGpId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGCHARINST, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGCHARINST, args);

        if ((bgLaeModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_BGCHARINST.getColumnBitmask()) != 0) {
            args = new Object[] {
                    bgLaeModelImpl.getOriginalOwnerId(),
                    bgLaeModelImpl.getOriginalBoxGpId()
                };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGCHARINST, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGCHARINST, args);
        }
    }

    /**
     * Creates a new bg lae with the primary key. Does not add the bg lae to the database.
     *
     * @param bgLaeId the primary key for the new bg lae
     * @return the new bg lae
     */
    @Override
    public BgLae create(long bgLaeId) {
        BgLae bgLae = new BgLaeImpl();

        bgLae.setNew(true);
        bgLae.setPrimaryKey(bgLaeId);

        return bgLae;
    }

    /**
     * Removes the bg lae with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param bgLaeId the primary key of the bg lae
     * @return the bg lae that was removed
     * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae remove(long bgLaeId)
        throws NoSuchBgLaeException, SystemException {
        return remove((Serializable) bgLaeId);
    }

    /**
     * Removes the bg lae with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the bg lae
     * @return the bg lae that was removed
     * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae remove(Serializable primaryKey)
        throws NoSuchBgLaeException, SystemException {
        Session session = null;

        try {
            session = openSession();

            BgLae bgLae = (BgLae) session.get(BgLaeImpl.class, primaryKey);

            if (bgLae == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchBgLaeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(bgLae);
        } catch (NoSuchBgLaeException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected BgLae removeImpl(BgLae bgLae) throws SystemException {
        bgLae = toUnwrappedModel(bgLae);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(bgLae)) {
                bgLae = (BgLae) session.get(BgLaeImpl.class,
                        bgLae.getPrimaryKeyObj());
            }

            if (bgLae != null) {
                session.delete(bgLae);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (bgLae != null) {
            clearCache(bgLae);
        }

        return bgLae;
    }

    @Override
    public BgLae updateImpl(gov.va.caret.model.BgLae bgLae)
        throws SystemException {
        bgLae = toUnwrappedModel(bgLae);

        boolean isNew = bgLae.isNew();

        BgLaeModelImpl bgLaeModelImpl = (BgLaeModelImpl) bgLae;

        Session session = null;

        try {
            session = openSession();

            if (bgLae.isNew()) {
                session.save(bgLae);

                bgLae.setNew(false);
            } else {
                session.merge(bgLae);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !BgLaeModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((bgLaeModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPCHARASSOCIATIONS.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { bgLaeModelImpl.getOriginalOwnerId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPCHARASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPCHARASSOCIATIONS,
                    args);

                args = new Object[] { bgLaeModelImpl.getOwnerId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPCHARASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPCHARASSOCIATIONS,
                    args);
            }
        }

        EntityCacheUtil.putResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
            BgLaeImpl.class, bgLae.getPrimaryKey(), bgLae);

        clearUniqueFindersCache(bgLae);
        cacheUniqueFindersCache(bgLae);

        return bgLae;
    }

    protected BgLae toUnwrappedModel(BgLae bgLae) {
        if (bgLae instanceof BgLaeImpl) {
            return bgLae;
        }

        BgLaeImpl bgLaeImpl = new BgLaeImpl();

        bgLaeImpl.setNew(bgLae.isNew());
        bgLaeImpl.setPrimaryKey(bgLae.getPrimaryKey());

        bgLaeImpl.setBgLaeId(bgLae.getBgLaeId());
        bgLaeImpl.setOwnerId(bgLae.getOwnerId());
        bgLaeImpl.setBoxGpId(bgLae.getBoxGpId());
        bgLaeImpl.setLargeText(bgLae.getLargeText());

        return bgLaeImpl;
    }

    /**
     * Returns the bg lae with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the bg lae
     * @return the bg lae
     * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae findByPrimaryKey(Serializable primaryKey)
        throws NoSuchBgLaeException, SystemException {
        BgLae bgLae = fetchByPrimaryKey(primaryKey);

        if (bgLae == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchBgLaeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return bgLae;
    }

    /**
     * Returns the bg lae with the primary key or throws a {@link gov.va.caret.NoSuchBgLaeException} if it could not be found.
     *
     * @param bgLaeId the primary key of the bg lae
     * @return the bg lae
     * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae findByPrimaryKey(long bgLaeId)
        throws NoSuchBgLaeException, SystemException {
        return findByPrimaryKey((Serializable) bgLaeId);
    }

    /**
     * Returns the bg lae with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the bg lae
     * @return the bg lae, or <code>null</code> if a bg lae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        BgLae bgLae = (BgLae) EntityCacheUtil.getResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
                BgLaeImpl.class, primaryKey);

        if (bgLae == _nullBgLae) {
            return null;
        }

        if (bgLae == null) {
            Session session = null;

            try {
                session = openSession();

                bgLae = (BgLae) session.get(BgLaeImpl.class, primaryKey);

                if (bgLae != null) {
                    cacheResult(bgLae);
                } else {
                    EntityCacheUtil.putResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
                        BgLaeImpl.class, primaryKey, _nullBgLae);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(BgLaeModelImpl.ENTITY_CACHE_ENABLED,
                    BgLaeImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return bgLae;
    }

    /**
     * Returns the bg lae with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param bgLaeId the primary key of the bg lae
     * @return the bg lae, or <code>null</code> if a bg lae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgLae fetchByPrimaryKey(long bgLaeId) throws SystemException {
        return fetchByPrimaryKey((Serializable) bgLaeId);
    }

    /**
     * Returns all the bg laes.
     *
     * @return the bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgLae> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bg laes.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bg laes
     * @param end the upper bound of the range of bg laes (not inclusive)
     * @return the range of bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgLae> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the bg laes.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bg laes
     * @param end the upper bound of the range of bg laes (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgLae> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<BgLae> list = (List<BgLae>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_BGLAE);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_BGLAE;

                if (pagination) {
                    sql = sql.concat(BgLaeModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<BgLae>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BgLae>(list);
                } else {
                    list = (List<BgLae>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the bg laes from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (BgLae bgLae : findAll()) {
            remove(bgLae);
        }
    }

    /**
     * Returns the number of bg laes.
     *
     * @return the number of bg laes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_BGLAE);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the bg lae persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.BgLae")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<BgLae>> listenersList = new ArrayList<ModelListener<BgLae>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<BgLae>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(BgLaeImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
