package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchBgAsnException;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.BgAsnModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the bg asn service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgAsnPersistence
 * @see BgAsnUtil
 * @generated
 */
public class BgAsnPersistenceImpl extends BasePersistenceImpl<BgAsn>
    implements BgAsnPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link BgAsnUtil} to access the bg asn persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = BgAsnImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, BgAsnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, BgAsnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPASSOCIATIONS =
        new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, BgAsnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findByBoxGroupAssociations",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPASSOCIATIONS =
        new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, BgAsnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "findByBoxGroupAssociations",
            new String[] { Long.class.getName() },
            BgAsnModelImpl.OWNERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BOXGROUPASSOCIATIONS = new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "countByBoxGroupAssociations", new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_BOXGROUPASSOCIATIONS_OWNERID_2 = "bgAsn.ownerId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_SELECTEDBOXGROUPASSOCIATIONS =
        new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, BgAsnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION,
            "findBySelectedBoxGroupAssociations",
            new String[] {
                Long.class.getName(), Boolean.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SELECTEDBOXGROUPASSOCIATIONS =
        new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, BgAsnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "findBySelectedBoxGroupAssociations",
            new String[] { Long.class.getName(), Boolean.class.getName() },
            BgAsnModelImpl.OWNERID_COLUMN_BITMASK |
            BgAsnModelImpl.SELECTED_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_SELECTEDBOXGROUPASSOCIATIONS =
        new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION,
            "countBySelectedBoxGroupAssociations",
            new String[] { Long.class.getName(), Boolean.class.getName() });
    private static final String _FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_OWNERID_2 =
        "bgAsn.ownerId = ? AND ";
    private static final String _FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_SELECTED_2 =
        "bgAsn.selected = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_BGASNINST = new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, BgAsnImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByBgAsnInst",
            new String[] { Long.class.getName(), Long.class.getName() },
            BgAsnModelImpl.OWNERID_COLUMN_BITMASK |
            BgAsnModelImpl.BOXGPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BGASNINST = new FinderPath(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBgAsnInst",
            new String[] { Long.class.getName(), Long.class.getName() });
    private static final String _FINDER_COLUMN_BGASNINST_OWNERID_2 = "bgAsn.ownerId = ? AND ";
    private static final String _FINDER_COLUMN_BGASNINST_BOXGPID_2 = "bgAsn.boxGpId = ?";
    private static final String _SQL_SELECT_BGASN = "SELECT bgAsn FROM BgAsn bgAsn";
    private static final String _SQL_SELECT_BGASN_WHERE = "SELECT bgAsn FROM BgAsn bgAsn WHERE ";
    private static final String _SQL_COUNT_BGASN = "SELECT COUNT(bgAsn) FROM BgAsn bgAsn";
    private static final String _SQL_COUNT_BGASN_WHERE = "SELECT COUNT(bgAsn) FROM BgAsn bgAsn WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "bgAsn.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No BgAsn exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No BgAsn exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(BgAsnPersistenceImpl.class);
    private static BgAsn _nullBgAsn = new BgAsnImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<BgAsn> toCacheModel() {
                return _nullBgAsnCacheModel;
            }
        };

    private static CacheModel<BgAsn> _nullBgAsnCacheModel = new CacheModel<BgAsn>() {
            @Override
            public BgAsn toEntityModel() {
                return _nullBgAsn;
            }
        };

    public BgAsnPersistenceImpl() {
        setModelClass(BgAsn.class);
    }

    /**
     * Returns all the bg asns where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @return the matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findByBoxGroupAssociations(long ownerId)
        throws SystemException {
        return findByBoxGroupAssociations(ownerId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bg asns where ownerId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param start the lower bound of the range of bg asns
     * @param end the upper bound of the range of bg asns (not inclusive)
     * @return the range of matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findByBoxGroupAssociations(long ownerId, int start,
        int end) throws SystemException {
        return findByBoxGroupAssociations(ownerId, start, end, null);
    }

    /**
     * Returns an ordered range of all the bg asns where ownerId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param start the lower bound of the range of bg asns
     * @param end the upper bound of the range of bg asns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findByBoxGroupAssociations(long ownerId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPASSOCIATIONS;
            finderArgs = new Object[] { ownerId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUPASSOCIATIONS;
            finderArgs = new Object[] { ownerId, start, end, orderByComparator };
        }

        List<BgAsn> list = (List<BgAsn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BgAsn bgAsn : list) {
                if ((ownerId != bgAsn.getOwnerId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_BGASN_WHERE);

            query.append(_FINDER_COLUMN_BOXGROUPASSOCIATIONS_OWNERID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BgAsnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                if (!pagination) {
                    list = (List<BgAsn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BgAsn>(list);
                } else {
                    list = (List<BgAsn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first bg asn in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn findByBoxGroupAssociations_First(long ownerId,
        OrderByComparator orderByComparator)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = fetchByBoxGroupAssociations_First(ownerId,
                orderByComparator);

        if (bgAsn != null) {
            return bgAsn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgAsnException(msg.toString());
    }

    /**
     * Returns the first bg asn in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg asn, or <code>null</code> if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchByBoxGroupAssociations_First(long ownerId,
        OrderByComparator orderByComparator) throws SystemException {
        List<BgAsn> list = findByBoxGroupAssociations(ownerId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last bg asn in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn findByBoxGroupAssociations_Last(long ownerId,
        OrderByComparator orderByComparator)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = fetchByBoxGroupAssociations_Last(ownerId,
                orderByComparator);

        if (bgAsn != null) {
            return bgAsn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgAsnException(msg.toString());
    }

    /**
     * Returns the last bg asn in the ordered set where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg asn, or <code>null</code> if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchByBoxGroupAssociations_Last(long ownerId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByBoxGroupAssociations(ownerId);

        if (count == 0) {
            return null;
        }

        List<BgAsn> list = findByBoxGroupAssociations(ownerId, count - 1,
                count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the bg asns before and after the current bg asn in the ordered set where ownerId = &#63;.
     *
     * @param bgAsnId the primary key of the current bg asn
     * @param ownerId the owner ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn[] findByBoxGroupAssociations_PrevAndNext(long bgAsnId,
        long ownerId, OrderByComparator orderByComparator)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = findByPrimaryKey(bgAsnId);

        Session session = null;

        try {
            session = openSession();

            BgAsn[] array = new BgAsnImpl[3];

            array[0] = getByBoxGroupAssociations_PrevAndNext(session, bgAsn,
                    ownerId, orderByComparator, true);

            array[1] = bgAsn;

            array[2] = getByBoxGroupAssociations_PrevAndNext(session, bgAsn,
                    ownerId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BgAsn getByBoxGroupAssociations_PrevAndNext(Session session,
        BgAsn bgAsn, long ownerId, OrderByComparator orderByComparator,
        boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BGASN_WHERE);

        query.append(_FINDER_COLUMN_BOXGROUPASSOCIATIONS_OWNERID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BgAsnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(ownerId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(bgAsn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BgAsn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the bg asns where ownerId = &#63; from the database.
     *
     * @param ownerId the owner ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByBoxGroupAssociations(long ownerId)
        throws SystemException {
        for (BgAsn bgAsn : findByBoxGroupAssociations(ownerId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(bgAsn);
        }
    }

    /**
     * Returns the number of bg asns where ownerId = &#63;.
     *
     * @param ownerId the owner ID
     * @return the number of matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBoxGroupAssociations(long ownerId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BOXGROUPASSOCIATIONS;

        Object[] finderArgs = new Object[] { ownerId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_BGASN_WHERE);

            query.append(_FINDER_COLUMN_BOXGROUPASSOCIATIONS_OWNERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the bg asns where ownerId = &#63; and selected = &#63;.
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @return the matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findBySelectedBoxGroupAssociations(long ownerId,
        boolean selected) throws SystemException {
        return findBySelectedBoxGroupAssociations(ownerId, selected,
            QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bg asns where ownerId = &#63; and selected = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @param start the lower bound of the range of bg asns
     * @param end the upper bound of the range of bg asns (not inclusive)
     * @return the range of matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findBySelectedBoxGroupAssociations(long ownerId,
        boolean selected, int start, int end) throws SystemException {
        return findBySelectedBoxGroupAssociations(ownerId, selected, start,
            end, null);
    }

    /**
     * Returns an ordered range of all the bg asns where ownerId = &#63; and selected = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @param start the lower bound of the range of bg asns
     * @param end the upper bound of the range of bg asns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findBySelectedBoxGroupAssociations(long ownerId,
        boolean selected, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SELECTEDBOXGROUPASSOCIATIONS;
            finderArgs = new Object[] { ownerId, selected };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_SELECTEDBOXGROUPASSOCIATIONS;
            finderArgs = new Object[] {
                    ownerId, selected,
                    
                    start, end, orderByComparator
                };
        }

        List<BgAsn> list = (List<BgAsn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BgAsn bgAsn : list) {
                if ((ownerId != bgAsn.getOwnerId()) ||
                        (selected != bgAsn.getSelected())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(4 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(4);
            }

            query.append(_SQL_SELECT_BGASN_WHERE);

            query.append(_FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_OWNERID_2);

            query.append(_FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_SELECTED_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BgAsnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(selected);

                if (!pagination) {
                    list = (List<BgAsn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BgAsn>(list);
                } else {
                    list = (List<BgAsn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn findBySelectedBoxGroupAssociations_First(long ownerId,
        boolean selected, OrderByComparator orderByComparator)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = fetchBySelectedBoxGroupAssociations_First(ownerId,
                selected, orderByComparator);

        if (bgAsn != null) {
            return bgAsn;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(", selected=");
        msg.append(selected);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgAsnException(msg.toString());
    }

    /**
     * Returns the first bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching bg asn, or <code>null</code> if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchBySelectedBoxGroupAssociations_First(long ownerId,
        boolean selected, OrderByComparator orderByComparator)
        throws SystemException {
        List<BgAsn> list = findBySelectedBoxGroupAssociations(ownerId,
                selected, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn findBySelectedBoxGroupAssociations_Last(long ownerId,
        boolean selected, OrderByComparator orderByComparator)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = fetchBySelectedBoxGroupAssociations_Last(ownerId,
                selected, orderByComparator);

        if (bgAsn != null) {
            return bgAsn;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("ownerId=");
        msg.append(ownerId);

        msg.append(", selected=");
        msg.append(selected);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBgAsnException(msg.toString());
    }

    /**
     * Returns the last bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching bg asn, or <code>null</code> if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchBySelectedBoxGroupAssociations_Last(long ownerId,
        boolean selected, OrderByComparator orderByComparator)
        throws SystemException {
        int count = countBySelectedBoxGroupAssociations(ownerId, selected);

        if (count == 0) {
            return null;
        }

        List<BgAsn> list = findBySelectedBoxGroupAssociations(ownerId,
                selected, count - 1, count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the bg asns before and after the current bg asn in the ordered set where ownerId = &#63; and selected = &#63;.
     *
     * @param bgAsnId the primary key of the current bg asn
     * @param ownerId the owner ID
     * @param selected the selected
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn[] findBySelectedBoxGroupAssociations_PrevAndNext(
        long bgAsnId, long ownerId, boolean selected,
        OrderByComparator orderByComparator)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = findByPrimaryKey(bgAsnId);

        Session session = null;

        try {
            session = openSession();

            BgAsn[] array = new BgAsnImpl[3];

            array[0] = getBySelectedBoxGroupAssociations_PrevAndNext(session,
                    bgAsn, ownerId, selected, orderByComparator, true);

            array[1] = bgAsn;

            array[2] = getBySelectedBoxGroupAssociations_PrevAndNext(session,
                    bgAsn, ownerId, selected, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BgAsn getBySelectedBoxGroupAssociations_PrevAndNext(
        Session session, BgAsn bgAsn, long ownerId, boolean selected,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BGASN_WHERE);

        query.append(_FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_OWNERID_2);

        query.append(_FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_SELECTED_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BgAsnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(ownerId);

        qPos.add(selected);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(bgAsn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BgAsn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the bg asns where ownerId = &#63; and selected = &#63; from the database.
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeBySelectedBoxGroupAssociations(long ownerId,
        boolean selected) throws SystemException {
        for (BgAsn bgAsn : findBySelectedBoxGroupAssociations(ownerId,
                selected, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(bgAsn);
        }
    }

    /**
     * Returns the number of bg asns where ownerId = &#63; and selected = &#63;.
     *
     * @param ownerId the owner ID
     * @param selected the selected
     * @return the number of matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countBySelectedBoxGroupAssociations(long ownerId,
        boolean selected) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SELECTEDBOXGROUPASSOCIATIONS;

        Object[] finderArgs = new Object[] { ownerId, selected };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_BGASN_WHERE);

            query.append(_FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_OWNERID_2);

            query.append(_FINDER_COLUMN_SELECTEDBOXGROUPASSOCIATIONS_SELECTED_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(selected);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgAsnException} if it could not be found.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the matching bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn findByBgAsnInst(long ownerId, long boxGpId)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = fetchByBgAsnInst(ownerId, boxGpId);

        if (bgAsn == null) {
            StringBundler msg = new StringBundler(6);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("ownerId=");
            msg.append(ownerId);

            msg.append(", boxGpId=");
            msg.append(boxGpId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchBgAsnException(msg.toString());
        }

        return bgAsn;
    }

    /**
     * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the matching bg asn, or <code>null</code> if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchByBgAsnInst(long ownerId, long boxGpId)
        throws SystemException {
        return fetchByBgAsnInst(ownerId, boxGpId, true);
    }

    /**
     * Returns the bg asn where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching bg asn, or <code>null</code> if a matching bg asn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchByBgAsnInst(long ownerId, long boxGpId,
        boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[] { ownerId, boxGpId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_BGASNINST,
                    finderArgs, this);
        }

        if (result instanceof BgAsn) {
            BgAsn bgAsn = (BgAsn) result;

            if ((ownerId != bgAsn.getOwnerId()) ||
                    (boxGpId != bgAsn.getBoxGpId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_SELECT_BGASN_WHERE);

            query.append(_FINDER_COLUMN_BGASNINST_OWNERID_2);

            query.append(_FINDER_COLUMN_BGASNINST_BOXGPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(boxGpId);

                List<BgAsn> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGASNINST,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "BgAsnPersistenceImpl.fetchByBgAsnInst(long, long, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    BgAsn bgAsn = list.get(0);

                    result = bgAsn;

                    cacheResult(bgAsn);

                    if ((bgAsn.getOwnerId() != ownerId) ||
                            (bgAsn.getBoxGpId() != boxGpId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGASNINST,
                            finderArgs, bgAsn);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGASNINST,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (BgAsn) result;
        }
    }

    /**
     * Removes the bg asn where ownerId = &#63; and boxGpId = &#63; from the database.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the bg asn that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn removeByBgAsnInst(long ownerId, long boxGpId)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = findByBgAsnInst(ownerId, boxGpId);

        return remove(bgAsn);
    }

    /**
     * Returns the number of bg asns where ownerId = &#63; and boxGpId = &#63;.
     *
     * @param ownerId the owner ID
     * @param boxGpId the box gp ID
     * @return the number of matching bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBgAsnInst(long ownerId, long boxGpId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BGASNINST;

        Object[] finderArgs = new Object[] { ownerId, boxGpId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_BGASN_WHERE);

            query.append(_FINDER_COLUMN_BGASNINST_OWNERID_2);

            query.append(_FINDER_COLUMN_BGASNINST_BOXGPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(ownerId);

                qPos.add(boxGpId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the bg asn in the entity cache if it is enabled.
     *
     * @param bgAsn the bg asn
     */
    @Override
    public void cacheResult(BgAsn bgAsn) {
        EntityCacheUtil.putResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnImpl.class, bgAsn.getPrimaryKey(), bgAsn);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGASNINST,
            new Object[] { bgAsn.getOwnerId(), bgAsn.getBoxGpId() }, bgAsn);

        bgAsn.resetOriginalValues();
    }

    /**
     * Caches the bg asns in the entity cache if it is enabled.
     *
     * @param bgAsns the bg asns
     */
    @Override
    public void cacheResult(List<BgAsn> bgAsns) {
        for (BgAsn bgAsn : bgAsns) {
            if (EntityCacheUtil.getResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
                        BgAsnImpl.class, bgAsn.getPrimaryKey()) == null) {
                cacheResult(bgAsn);
            } else {
                bgAsn.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all bg asns.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(BgAsnImpl.class.getName());
        }

        EntityCacheUtil.clearCache(BgAsnImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the bg asn.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(BgAsn bgAsn) {
        EntityCacheUtil.removeResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnImpl.class, bgAsn.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(bgAsn);
    }

    @Override
    public void clearCache(List<BgAsn> bgAsns) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (BgAsn bgAsn : bgAsns) {
            EntityCacheUtil.removeResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
                BgAsnImpl.class, bgAsn.getPrimaryKey());

            clearUniqueFindersCache(bgAsn);
        }
    }

    protected void cacheUniqueFindersCache(BgAsn bgAsn) {
        if (bgAsn.isNew()) {
            Object[] args = new Object[] { bgAsn.getOwnerId(), bgAsn.getBoxGpId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGASNINST, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGASNINST, args,
                bgAsn);
        } else {
            BgAsnModelImpl bgAsnModelImpl = (BgAsnModelImpl) bgAsn;

            if ((bgAsnModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_BGASNINST.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        bgAsn.getOwnerId(), bgAsn.getBoxGpId()
                    };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_BGASNINST, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_BGASNINST, args,
                    bgAsn);
            }
        }
    }

    protected void clearUniqueFindersCache(BgAsn bgAsn) {
        BgAsnModelImpl bgAsnModelImpl = (BgAsnModelImpl) bgAsn;

        Object[] args = new Object[] { bgAsn.getOwnerId(), bgAsn.getBoxGpId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGASNINST, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGASNINST, args);

        if ((bgAsnModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_BGASNINST.getColumnBitmask()) != 0) {
            args = new Object[] {
                    bgAsnModelImpl.getOriginalOwnerId(),
                    bgAsnModelImpl.getOriginalBoxGpId()
                };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BGASNINST, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_BGASNINST, args);
        }
    }

    /**
     * Creates a new bg asn with the primary key. Does not add the bg asn to the database.
     *
     * @param bgAsnId the primary key for the new bg asn
     * @return the new bg asn
     */
    @Override
    public BgAsn create(long bgAsnId) {
        BgAsn bgAsn = new BgAsnImpl();

        bgAsn.setNew(true);
        bgAsn.setPrimaryKey(bgAsnId);

        return bgAsn;
    }

    /**
     * Removes the bg asn with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param bgAsnId the primary key of the bg asn
     * @return the bg asn that was removed
     * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn remove(long bgAsnId)
        throws NoSuchBgAsnException, SystemException {
        return remove((Serializable) bgAsnId);
    }

    /**
     * Removes the bg asn with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the bg asn
     * @return the bg asn that was removed
     * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn remove(Serializable primaryKey)
        throws NoSuchBgAsnException, SystemException {
        Session session = null;

        try {
            session = openSession();

            BgAsn bgAsn = (BgAsn) session.get(BgAsnImpl.class, primaryKey);

            if (bgAsn == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchBgAsnException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(bgAsn);
        } catch (NoSuchBgAsnException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected BgAsn removeImpl(BgAsn bgAsn) throws SystemException {
        bgAsn = toUnwrappedModel(bgAsn);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(bgAsn)) {
                bgAsn = (BgAsn) session.get(BgAsnImpl.class,
                        bgAsn.getPrimaryKeyObj());
            }

            if (bgAsn != null) {
                session.delete(bgAsn);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (bgAsn != null) {
            clearCache(bgAsn);
        }

        return bgAsn;
    }

    @Override
    public BgAsn updateImpl(gov.va.caret.model.BgAsn bgAsn)
        throws SystemException {
        bgAsn = toUnwrappedModel(bgAsn);

        boolean isNew = bgAsn.isNew();

        BgAsnModelImpl bgAsnModelImpl = (BgAsnModelImpl) bgAsn;

        Session session = null;

        try {
            session = openSession();

            if (bgAsn.isNew()) {
                session.save(bgAsn);

                bgAsn.setNew(false);
            } else {
                session.merge(bgAsn);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !BgAsnModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((bgAsnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPASSOCIATIONS.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { bgAsnModelImpl.getOriginalOwnerId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPASSOCIATIONS,
                    args);

                args = new Object[] { bgAsnModelImpl.getOwnerId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUPASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUPASSOCIATIONS,
                    args);
            }

            if ((bgAsnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SELECTEDBOXGROUPASSOCIATIONS.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        bgAsnModelImpl.getOriginalOwnerId(),
                        bgAsnModelImpl.getOriginalSelected()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_SELECTEDBOXGROUPASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SELECTEDBOXGROUPASSOCIATIONS,
                    args);

                args = new Object[] {
                        bgAsnModelImpl.getOwnerId(),
                        bgAsnModelImpl.getSelected()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_SELECTEDBOXGROUPASSOCIATIONS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SELECTEDBOXGROUPASSOCIATIONS,
                    args);
            }
        }

        EntityCacheUtil.putResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
            BgAsnImpl.class, bgAsn.getPrimaryKey(), bgAsn);

        clearUniqueFindersCache(bgAsn);
        cacheUniqueFindersCache(bgAsn);

        return bgAsn;
    }

    protected BgAsn toUnwrappedModel(BgAsn bgAsn) {
        if (bgAsn instanceof BgAsnImpl) {
            return bgAsn;
        }

        BgAsnImpl bgAsnImpl = new BgAsnImpl();

        bgAsnImpl.setNew(bgAsn.isNew());
        bgAsnImpl.setPrimaryKey(bgAsn.getPrimaryKey());

        bgAsnImpl.setBgAsnId(bgAsn.getBgAsnId());
        bgAsnImpl.setOwnerId(bgAsn.getOwnerId());
        bgAsnImpl.setBoxGpId(bgAsn.getBoxGpId());
        bgAsnImpl.setSelected(bgAsn.isSelected());

        return bgAsnImpl;
    }

    /**
     * Returns the bg asn with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the bg asn
     * @return the bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn findByPrimaryKey(Serializable primaryKey)
        throws NoSuchBgAsnException, SystemException {
        BgAsn bgAsn = fetchByPrimaryKey(primaryKey);

        if (bgAsn == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchBgAsnException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return bgAsn;
    }

    /**
     * Returns the bg asn with the primary key or throws a {@link gov.va.caret.NoSuchBgAsnException} if it could not be found.
     *
     * @param bgAsnId the primary key of the bg asn
     * @return the bg asn
     * @throws gov.va.caret.NoSuchBgAsnException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn findByPrimaryKey(long bgAsnId)
        throws NoSuchBgAsnException, SystemException {
        return findByPrimaryKey((Serializable) bgAsnId);
    }

    /**
     * Returns the bg asn with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the bg asn
     * @return the bg asn, or <code>null</code> if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        BgAsn bgAsn = (BgAsn) EntityCacheUtil.getResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
                BgAsnImpl.class, primaryKey);

        if (bgAsn == _nullBgAsn) {
            return null;
        }

        if (bgAsn == null) {
            Session session = null;

            try {
                session = openSession();

                bgAsn = (BgAsn) session.get(BgAsnImpl.class, primaryKey);

                if (bgAsn != null) {
                    cacheResult(bgAsn);
                } else {
                    EntityCacheUtil.putResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
                        BgAsnImpl.class, primaryKey, _nullBgAsn);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(BgAsnModelImpl.ENTITY_CACHE_ENABLED,
                    BgAsnImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return bgAsn;
    }

    /**
     * Returns the bg asn with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param bgAsnId the primary key of the bg asn
     * @return the bg asn, or <code>null</code> if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn fetchByPrimaryKey(long bgAsnId) throws SystemException {
        return fetchByPrimaryKey((Serializable) bgAsnId);
    }

    /**
     * Returns all the bg asns.
     *
     * @return the bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bg asns.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bg asns
     * @param end the upper bound of the range of bg asns (not inclusive)
     * @return the range of bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the bg asns.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bg asns
     * @param end the upper bound of the range of bg asns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<BgAsn> list = (List<BgAsn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_BGASN);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_BGASN;

                if (pagination) {
                    sql = sql.concat(BgAsnModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<BgAsn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BgAsn>(list);
                } else {
                    list = (List<BgAsn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the bg asns from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (BgAsn bgAsn : findAll()) {
            remove(bgAsn);
        }
    }

    /**
     * Returns the number of bg asns.
     *
     * @return the number of bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_BGASN);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the bg asn persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.BgAsn")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<BgAsn>> listenersList = new ArrayList<ModelListener<BgAsn>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<BgAsn>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(BgAsnImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
