package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchAudLgException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.impl.AudLgImpl;
import gov.va.caret.model.impl.AudLgModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the aud lg service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see AudLgPersistence
 * @see AudLgUtil
 * @generated
 */
public class AudLgPersistenceImpl extends BasePersistenceImpl<AudLg>
    implements AudLgPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link AudLgUtil} to access the aud lg persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = AudLgImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgModelImpl.FINDER_CACHE_ENABLED, AudLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgModelImpl.FINDER_CACHE_ENABLED, AudLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_ATTRIBUTE = new FinderPath(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgModelImpl.FINDER_CACHE_ENABLED, AudLgImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByAttribute",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            },
            AudLgModelImpl.CLASSID_COLUMN_BITMASK |
            AudLgModelImpl.CLASSPK_COLUMN_BITMASK |
            AudLgModelImpl.ATTRIBUTE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_ATTRIBUTE = new FinderPath(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAttribute",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            });
    private static final String _FINDER_COLUMN_ATTRIBUTE_CLASSID_2 = "audLg.classId = ? AND ";
    private static final String _FINDER_COLUMN_ATTRIBUTE_CLASSPK_2 = "audLg.classPk = ? AND ";
    private static final String _FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_1 = "audLg.attribute IS NULL";
    private static final String _FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_2 = "audLg.attribute = ?";
    private static final String _FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_3 = "(audLg.attribute IS NULL OR audLg.attribute = '')";
    private static final String _SQL_SELECT_AUDLG = "SELECT audLg FROM AudLg audLg";
    private static final String _SQL_SELECT_AUDLG_WHERE = "SELECT audLg FROM AudLg audLg WHERE ";
    private static final String _SQL_COUNT_AUDLG = "SELECT COUNT(audLg) FROM AudLg audLg";
    private static final String _SQL_COUNT_AUDLG_WHERE = "SELECT COUNT(audLg) FROM AudLg audLg WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "audLg.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AudLg exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AudLg exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(AudLgPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "sysDateTime"
            });
    private static AudLg _nullAudLg = new AudLgImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<AudLg> toCacheModel() {
                return _nullAudLgCacheModel;
            }
        };

    private static CacheModel<AudLg> _nullAudLgCacheModel = new CacheModel<AudLg>() {
            @Override
            public AudLg toEntityModel() {
                return _nullAudLg;
            }
        };

    public AudLgPersistenceImpl() {
        setModelClass(AudLg.class);
    }

    /**
     * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or throws a {@link gov.va.caret.NoSuchAudLgException} if it could not be found.
     *
     * @param classId the class ID
     * @param classPk the class pk
     * @param attribute the attribute
     * @return the matching aud lg
     * @throws gov.va.caret.NoSuchAudLgException if a matching aud lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg findByAttribute(long classId, long classPk, String attribute)
        throws NoSuchAudLgException, SystemException {
        AudLg audLg = fetchByAttribute(classId, classPk, attribute);

        if (audLg == null) {
            StringBundler msg = new StringBundler(8);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("classId=");
            msg.append(classId);

            msg.append(", classPk=");
            msg.append(classPk);

            msg.append(", attribute=");
            msg.append(attribute);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchAudLgException(msg.toString());
        }

        return audLg;
    }

    /**
     * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param classId the class ID
     * @param classPk the class pk
     * @param attribute the attribute
     * @return the matching aud lg, or <code>null</code> if a matching aud lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg fetchByAttribute(long classId, long classPk, String attribute)
        throws SystemException {
        return fetchByAttribute(classId, classPk, attribute, true);
    }

    /**
     * Returns the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param classId the class ID
     * @param classPk the class pk
     * @param attribute the attribute
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching aud lg, or <code>null</code> if a matching aud lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg fetchByAttribute(long classId, long classPk, String attribute,
        boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[] { classId, classPk, attribute };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_ATTRIBUTE,
                    finderArgs, this);
        }

        if (result instanceof AudLg) {
            AudLg audLg = (AudLg) result;

            if ((classId != audLg.getClassId()) ||
                    (classPk != audLg.getClassPk()) ||
                    !Validator.equals(attribute, audLg.getAttribute())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(5);

            query.append(_SQL_SELECT_AUDLG_WHERE);

            query.append(_FINDER_COLUMN_ATTRIBUTE_CLASSID_2);

            query.append(_FINDER_COLUMN_ATTRIBUTE_CLASSPK_2);

            boolean bindAttribute = false;

            if (attribute == null) {
                query.append(_FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_1);
            } else if (attribute.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_3);
            } else {
                bindAttribute = true;

                query.append(_FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classId);

                qPos.add(classPk);

                if (bindAttribute) {
                    qPos.add(attribute);
                }

                List<AudLg> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_ATTRIBUTE,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "AudLgPersistenceImpl.fetchByAttribute(long, long, String, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    AudLg audLg = list.get(0);

                    result = audLg;

                    cacheResult(audLg);

                    if ((audLg.getClassId() != classId) ||
                            (audLg.getClassPk() != classPk) ||
                            (audLg.getAttribute() == null) ||
                            !audLg.getAttribute().equals(attribute)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_ATTRIBUTE,
                            finderArgs, audLg);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_ATTRIBUTE,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (AudLg) result;
        }
    }

    /**
     * Removes the aud lg where classId = &#63; and classPk = &#63; and attribute = &#63; from the database.
     *
     * @param classId the class ID
     * @param classPk the class pk
     * @param attribute the attribute
     * @return the aud lg that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg removeByAttribute(long classId, long classPk, String attribute)
        throws NoSuchAudLgException, SystemException {
        AudLg audLg = findByAttribute(classId, classPk, attribute);

        return remove(audLg);
    }

    /**
     * Returns the number of aud lgs where classId = &#63; and classPk = &#63; and attribute = &#63;.
     *
     * @param classId the class ID
     * @param classPk the class pk
     * @param attribute the attribute
     * @return the number of matching aud lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByAttribute(long classId, long classPk, String attribute)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ATTRIBUTE;

        Object[] finderArgs = new Object[] { classId, classPk, attribute };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_COUNT_AUDLG_WHERE);

            query.append(_FINDER_COLUMN_ATTRIBUTE_CLASSID_2);

            query.append(_FINDER_COLUMN_ATTRIBUTE_CLASSPK_2);

            boolean bindAttribute = false;

            if (attribute == null) {
                query.append(_FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_1);
            } else if (attribute.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_3);
            } else {
                bindAttribute = true;

                query.append(_FINDER_COLUMN_ATTRIBUTE_ATTRIBUTE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classId);

                qPos.add(classPk);

                if (bindAttribute) {
                    qPos.add(attribute);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the aud lg in the entity cache if it is enabled.
     *
     * @param audLg the aud lg
     */
    @Override
    public void cacheResult(AudLg audLg) {
        EntityCacheUtil.putResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgImpl.class, audLg.getPrimaryKey(), audLg);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_ATTRIBUTE,
            new Object[] {
                audLg.getClassId(), audLg.getClassPk(), audLg.getAttribute()
            }, audLg);

        audLg.resetOriginalValues();
    }

    /**
     * Caches the aud lgs in the entity cache if it is enabled.
     *
     * @param audLgs the aud lgs
     */
    @Override
    public void cacheResult(List<AudLg> audLgs) {
        for (AudLg audLg : audLgs) {
            if (EntityCacheUtil.getResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
                        AudLgImpl.class, audLg.getPrimaryKey()) == null) {
                cacheResult(audLg);
            } else {
                audLg.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all aud lgs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(AudLgImpl.class.getName());
        }

        EntityCacheUtil.clearCache(AudLgImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the aud lg.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(AudLg audLg) {
        EntityCacheUtil.removeResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgImpl.class, audLg.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(audLg);
    }

    @Override
    public void clearCache(List<AudLg> audLgs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (AudLg audLg : audLgs) {
            EntityCacheUtil.removeResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
                AudLgImpl.class, audLg.getPrimaryKey());

            clearUniqueFindersCache(audLg);
        }
    }

    protected void cacheUniqueFindersCache(AudLg audLg) {
        if (audLg.isNew()) {
            Object[] args = new Object[] {
                    audLg.getClassId(), audLg.getClassPk(), audLg.getAttribute()
                };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_ATTRIBUTE, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_ATTRIBUTE, args,
                audLg);
        } else {
            AudLgModelImpl audLgModelImpl = (AudLgModelImpl) audLg;

            if ((audLgModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_ATTRIBUTE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        audLg.getClassId(), audLg.getClassPk(),
                        audLg.getAttribute()
                    };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_ATTRIBUTE, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_ATTRIBUTE, args,
                    audLg);
            }
        }
    }

    protected void clearUniqueFindersCache(AudLg audLg) {
        AudLgModelImpl audLgModelImpl = (AudLgModelImpl) audLg;

        Object[] args = new Object[] {
                audLg.getClassId(), audLg.getClassPk(), audLg.getAttribute()
            };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ATTRIBUTE, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_ATTRIBUTE, args);

        if ((audLgModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_ATTRIBUTE.getColumnBitmask()) != 0) {
            args = new Object[] {
                    audLgModelImpl.getOriginalClassId(),
                    audLgModelImpl.getOriginalClassPk(),
                    audLgModelImpl.getOriginalAttribute()
                };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_ATTRIBUTE, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_ATTRIBUTE, args);
        }
    }

    /**
     * Creates a new aud lg with the primary key. Does not add the aud lg to the database.
     *
     * @param audLgId the primary key for the new aud lg
     * @return the new aud lg
     */
    @Override
    public AudLg create(long audLgId) {
        AudLg audLg = new AudLgImpl();

        audLg.setNew(true);
        audLg.setPrimaryKey(audLgId);

        return audLg;
    }

    /**
     * Removes the aud lg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param audLgId the primary key of the aud lg
     * @return the aud lg that was removed
     * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg remove(long audLgId)
        throws NoSuchAudLgException, SystemException {
        return remove((Serializable) audLgId);
    }

    /**
     * Removes the aud lg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the aud lg
     * @return the aud lg that was removed
     * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg remove(Serializable primaryKey)
        throws NoSuchAudLgException, SystemException {
        Session session = null;

        try {
            session = openSession();

            AudLg audLg = (AudLg) session.get(AudLgImpl.class, primaryKey);

            if (audLg == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchAudLgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(audLg);
        } catch (NoSuchAudLgException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected AudLg removeImpl(AudLg audLg) throws SystemException {
        audLg = toUnwrappedModel(audLg);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(audLg)) {
                audLg = (AudLg) session.get(AudLgImpl.class,
                        audLg.getPrimaryKeyObj());
            }

            if (audLg != null) {
                session.delete(audLg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (audLg != null) {
            clearCache(audLg);
        }

        return audLg;
    }

    @Override
    public AudLg updateImpl(gov.va.caret.model.AudLg audLg)
        throws SystemException {
        audLg = toUnwrappedModel(audLg);

        boolean isNew = audLg.isNew();

        Session session = null;

        try {
            session = openSession();

            if (audLg.isNew()) {
                session.save(audLg);

                audLg.setNew(false);
            } else {
                session.merge(audLg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !AudLgModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
            AudLgImpl.class, audLg.getPrimaryKey(), audLg);

        clearUniqueFindersCache(audLg);
        cacheUniqueFindersCache(audLg);

        return audLg;
    }

    protected AudLg toUnwrappedModel(AudLg audLg) {
        if (audLg instanceof AudLgImpl) {
            return audLg;
        }

        AudLgImpl audLgImpl = new AudLgImpl();

        audLgImpl.setNew(audLg.isNew());
        audLgImpl.setPrimaryKey(audLg.getPrimaryKey());

        audLgImpl.setAudLgId(audLg.getAudLgId());
        audLgImpl.setClassPk(audLg.getClassPk());
        audLgImpl.setClassId(audLg.getClassId());
        audLgImpl.setAttribute(audLg.getAttribute());
        audLgImpl.setOldValue(audLg.getOldValue());
        audLgImpl.setNewValue(audLg.getNewValue());
        audLgImpl.setCoverUserId(audLg.getCoverUserId());
        audLgImpl.setModifiedById(audLg.getModifiedById());
        audLgImpl.setModifiedDate(audLg.getModifiedDate());
        audLgImpl.setGroupId(audLg.getGroupId());
        audLgImpl.setRoleName(audLg.getRoleName());
        audLgImpl.setSysDateTime(audLg.getSysDateTime());

        return audLgImpl;
    }

    /**
     * Returns the aud lg with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the aud lg
     * @return the aud lg
     * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg findByPrimaryKey(Serializable primaryKey)
        throws NoSuchAudLgException, SystemException {
        AudLg audLg = fetchByPrimaryKey(primaryKey);

        if (audLg == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchAudLgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return audLg;
    }

    /**
     * Returns the aud lg with the primary key or throws a {@link gov.va.caret.NoSuchAudLgException} if it could not be found.
     *
     * @param audLgId the primary key of the aud lg
     * @return the aud lg
     * @throws gov.va.caret.NoSuchAudLgException if a aud lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg findByPrimaryKey(long audLgId)
        throws NoSuchAudLgException, SystemException {
        return findByPrimaryKey((Serializable) audLgId);
    }

    /**
     * Returns the aud lg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the aud lg
     * @return the aud lg, or <code>null</code> if a aud lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        AudLg audLg = (AudLg) EntityCacheUtil.getResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
                AudLgImpl.class, primaryKey);

        if (audLg == _nullAudLg) {
            return null;
        }

        if (audLg == null) {
            Session session = null;

            try {
                session = openSession();

                audLg = (AudLg) session.get(AudLgImpl.class, primaryKey);

                if (audLg != null) {
                    cacheResult(audLg);
                } else {
                    EntityCacheUtil.putResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
                        AudLgImpl.class, primaryKey, _nullAudLg);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(AudLgModelImpl.ENTITY_CACHE_ENABLED,
                    AudLgImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return audLg;
    }

    /**
     * Returns the aud lg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param audLgId the primary key of the aud lg
     * @return the aud lg, or <code>null</code> if a aud lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public AudLg fetchByPrimaryKey(long audLgId) throws SystemException {
        return fetchByPrimaryKey((Serializable) audLgId);
    }

    /**
     * Returns all the aud lgs.
     *
     * @return the aud lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<AudLg> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the aud lgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of aud lgs
     * @param end the upper bound of the range of aud lgs (not inclusive)
     * @return the range of aud lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<AudLg> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the aud lgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AudLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of aud lgs
     * @param end the upper bound of the range of aud lgs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of aud lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<AudLg> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<AudLg> list = (List<AudLg>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_AUDLG);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_AUDLG;

                if (pagination) {
                    sql = sql.concat(AudLgModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<AudLg>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<AudLg>(list);
                } else {
                    list = (List<AudLg>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the aud lgs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (AudLg audLg : findAll()) {
            remove(audLg);
        }
    }

    /**
     * Returns the number of aud lgs.
     *
     * @return the number of aud lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_AUDLG);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the aud lg persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.AudLg")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<AudLg>> listenersList = new ArrayList<ModelListener<AudLg>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<AudLg>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(AudLgImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
