package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchAssmtException;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.impl.AssmtImpl;
import gov.va.caret.model.impl.AssmtModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the assmt service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see AssmtPersistence
 * @see AssmtUtil
 * @generated
 */
public class AssmtPersistenceImpl extends BasePersistenceImpl<Assmt>
    implements AssmtPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link AssmtUtil} to access the assmt persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = AssmtImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtModelImpl.FINDER_CACHE_ENABLED, AssmtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtModelImpl.FINDER_CACHE_ENABLED, AssmtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_VCGID = new FinderPath(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtModelImpl.FINDER_CACHE_ENABLED, AssmtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByVcgId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID = new FinderPath(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtModelImpl.FINDER_CACHE_ENABLED, AssmtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByVcgId",
            new String[] { Long.class.getName() },
            AssmtModelImpl.VCGID_COLUMN_BITMASK |
            AssmtModelImpl.SCHEDULEDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VCGID = new FinderPath(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVcgId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_VCGID_VCGID_2 = "assmt.vcgId = ?";
    private static final String _SQL_SELECT_ASSMT = "SELECT assmt FROM Assmt assmt";
    private static final String _SQL_SELECT_ASSMT_WHERE = "SELECT assmt FROM Assmt assmt WHERE ";
    private static final String _SQL_COUNT_ASSMT = "SELECT COUNT(assmt) FROM Assmt assmt";
    private static final String _SQL_COUNT_ASSMT_WHERE = "SELECT COUNT(assmt) FROM Assmt assmt WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "assmt.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Assmt exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Assmt exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(AssmtPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "type", "comment", "active"
            });
    private static Assmt _nullAssmt = new AssmtImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Assmt> toCacheModel() {
                return _nullAssmtCacheModel;
            }
        };

    private static CacheModel<Assmt> _nullAssmtCacheModel = new CacheModel<Assmt>() {
            @Override
            public Assmt toEntityModel() {
                return _nullAssmt;
            }
        };

    public AssmtPersistenceImpl() {
        setModelClass(Assmt.class);
    }

    /**
     * Returns all the assmts where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @return the matching assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Assmt> findByVcgId(long vcgId) throws SystemException {
        return findByVcgId(vcgId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the assmts where vcgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vcgId the vcg ID
     * @param start the lower bound of the range of assmts
     * @param end the upper bound of the range of assmts (not inclusive)
     * @return the range of matching assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Assmt> findByVcgId(long vcgId, int start, int end)
        throws SystemException {
        return findByVcgId(vcgId, start, end, null);
    }

    /**
     * Returns an ordered range of all the assmts where vcgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vcgId the vcg ID
     * @param start the lower bound of the range of assmts
     * @param end the upper bound of the range of assmts (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Assmt> findByVcgId(long vcgId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID;
            finderArgs = new Object[] { vcgId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_VCGID;
            finderArgs = new Object[] { vcgId, start, end, orderByComparator };
        }

        List<Assmt> list = (List<Assmt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Assmt assmt : list) {
                if ((vcgId != assmt.getVcgId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_ASSMT_WHERE);

            query.append(_FINDER_COLUMN_VCGID_VCGID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(AssmtModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgId);

                if (!pagination) {
                    list = (List<Assmt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Assmt>(list);
                } else {
                    list = (List<Assmt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first assmt in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching assmt
     * @throws gov.va.caret.NoSuchAssmtException if a matching assmt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt findByVcgId_First(long vcgId,
        OrderByComparator orderByComparator)
        throws NoSuchAssmtException, SystemException {
        Assmt assmt = fetchByVcgId_First(vcgId, orderByComparator);

        if (assmt != null) {
            return assmt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vcgId=");
        msg.append(vcgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchAssmtException(msg.toString());
    }

    /**
     * Returns the first assmt in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching assmt, or <code>null</code> if a matching assmt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt fetchByVcgId_First(long vcgId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Assmt> list = findByVcgId(vcgId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last assmt in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching assmt
     * @throws gov.va.caret.NoSuchAssmtException if a matching assmt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt findByVcgId_Last(long vcgId,
        OrderByComparator orderByComparator)
        throws NoSuchAssmtException, SystemException {
        Assmt assmt = fetchByVcgId_Last(vcgId, orderByComparator);

        if (assmt != null) {
            return assmt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vcgId=");
        msg.append(vcgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchAssmtException(msg.toString());
    }

    /**
     * Returns the last assmt in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching assmt, or <code>null</code> if a matching assmt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt fetchByVcgId_Last(long vcgId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByVcgId(vcgId);

        if (count == 0) {
            return null;
        }

        List<Assmt> list = findByVcgId(vcgId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the assmts before and after the current assmt in the ordered set where vcgId = &#63;.
     *
     * @param assmtId the primary key of the current assmt
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next assmt
     * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt[] findByVcgId_PrevAndNext(long assmtId, long vcgId,
        OrderByComparator orderByComparator)
        throws NoSuchAssmtException, SystemException {
        Assmt assmt = findByPrimaryKey(assmtId);

        Session session = null;

        try {
            session = openSession();

            Assmt[] array = new AssmtImpl[3];

            array[0] = getByVcgId_PrevAndNext(session, assmt, vcgId,
                    orderByComparator, true);

            array[1] = assmt;

            array[2] = getByVcgId_PrevAndNext(session, assmt, vcgId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Assmt getByVcgId_PrevAndNext(Session session, Assmt assmt,
        long vcgId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_ASSMT_WHERE);

        query.append(_FINDER_COLUMN_VCGID_VCGID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(AssmtModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(vcgId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(assmt);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Assmt> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the assmts where vcgId = &#63; from the database.
     *
     * @param vcgId the vcg ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByVcgId(long vcgId) throws SystemException {
        for (Assmt assmt : findByVcgId(vcgId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(assmt);
        }
    }

    /**
     * Returns the number of assmts where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @return the number of matching assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVcgId(long vcgId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VCGID;

        Object[] finderArgs = new Object[] { vcgId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_ASSMT_WHERE);

            query.append(_FINDER_COLUMN_VCGID_VCGID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the assmt in the entity cache if it is enabled.
     *
     * @param assmt the assmt
     */
    @Override
    public void cacheResult(Assmt assmt) {
        EntityCacheUtil.putResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtImpl.class, assmt.getPrimaryKey(), assmt);

        assmt.resetOriginalValues();
    }

    /**
     * Caches the assmts in the entity cache if it is enabled.
     *
     * @param assmts the assmts
     */
    @Override
    public void cacheResult(List<Assmt> assmts) {
        for (Assmt assmt : assmts) {
            if (EntityCacheUtil.getResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
                        AssmtImpl.class, assmt.getPrimaryKey()) == null) {
                cacheResult(assmt);
            } else {
                assmt.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all assmts.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(AssmtImpl.class.getName());
        }

        EntityCacheUtil.clearCache(AssmtImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the assmt.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Assmt assmt) {
        EntityCacheUtil.removeResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtImpl.class, assmt.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Assmt> assmts) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Assmt assmt : assmts) {
            EntityCacheUtil.removeResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
                AssmtImpl.class, assmt.getPrimaryKey());
        }
    }

    /**
     * Creates a new assmt with the primary key. Does not add the assmt to the database.
     *
     * @param assmtId the primary key for the new assmt
     * @return the new assmt
     */
    @Override
    public Assmt create(long assmtId) {
        Assmt assmt = new AssmtImpl();

        assmt.setNew(true);
        assmt.setPrimaryKey(assmtId);

        return assmt;
    }

    /**
     * Removes the assmt with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param assmtId the primary key of the assmt
     * @return the assmt that was removed
     * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt remove(long assmtId)
        throws NoSuchAssmtException, SystemException {
        return remove((Serializable) assmtId);
    }

    /**
     * Removes the assmt with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the assmt
     * @return the assmt that was removed
     * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt remove(Serializable primaryKey)
        throws NoSuchAssmtException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Assmt assmt = (Assmt) session.get(AssmtImpl.class, primaryKey);

            if (assmt == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchAssmtException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(assmt);
        } catch (NoSuchAssmtException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Assmt removeImpl(Assmt assmt) throws SystemException {
        assmt = toUnwrappedModel(assmt);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(assmt)) {
                assmt = (Assmt) session.get(AssmtImpl.class,
                        assmt.getPrimaryKeyObj());
            }

            if (assmt != null) {
                session.delete(assmt);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (assmt != null) {
            clearCache(assmt);
        }

        return assmt;
    }

    @Override
    public Assmt updateImpl(gov.va.caret.model.Assmt assmt)
        throws SystemException {
        assmt = toUnwrappedModel(assmt);

        boolean isNew = assmt.isNew();

        AssmtModelImpl assmtModelImpl = (AssmtModelImpl) assmt;

        Session session = null;

        try {
            session = openSession();

            if (assmt.isNew()) {
                session.save(assmt);

                assmt.setNew(false);
            } else {
                session.merge(assmt);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !AssmtModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((assmtModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { assmtModelImpl.getOriginalVcgId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID,
                    args);

                args = new Object[] { assmtModelImpl.getVcgId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID,
                    args);
            }
        }

        EntityCacheUtil.putResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
            AssmtImpl.class, assmt.getPrimaryKey(), assmt);

        return assmt;
    }

    protected Assmt toUnwrappedModel(Assmt assmt) {
        if (assmt instanceof AssmtImpl) {
            return assmt;
        }

        AssmtImpl assmtImpl = new AssmtImpl();

        assmtImpl.setNew(assmt.isNew());
        assmtImpl.setPrimaryKey(assmt.getPrimaryKey());

        assmtImpl.setAssmtId(assmt.getAssmtId());
        assmtImpl.setVcgId(assmt.getVcgId());
        assmtImpl.setNoteId(assmt.getNoteId());
        assmtImpl.setCompletionDate(assmt.getCompletionDate());
        assmtImpl.setType(assmt.getType());
        assmtImpl.setScheduleDate(assmt.getScheduleDate());
        assmtImpl.setUserId(assmt.getUserId());
        assmtImpl.setComment(assmt.getComment());
        assmtImpl.setActive(assmt.isActive());
        assmtImpl.setCaregiverId(assmt.getCaregiverId());

        return assmtImpl;
    }

    /**
     * Returns the assmt with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the assmt
     * @return the assmt
     * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt findByPrimaryKey(Serializable primaryKey)
        throws NoSuchAssmtException, SystemException {
        Assmt assmt = fetchByPrimaryKey(primaryKey);

        if (assmt == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchAssmtException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return assmt;
    }

    /**
     * Returns the assmt with the primary key or throws a {@link gov.va.caret.NoSuchAssmtException} if it could not be found.
     *
     * @param assmtId the primary key of the assmt
     * @return the assmt
     * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt findByPrimaryKey(long assmtId)
        throws NoSuchAssmtException, SystemException {
        return findByPrimaryKey((Serializable) assmtId);
    }

    /**
     * Returns the assmt with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the assmt
     * @return the assmt, or <code>null</code> if a assmt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Assmt assmt = (Assmt) EntityCacheUtil.getResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
                AssmtImpl.class, primaryKey);

        if (assmt == _nullAssmt) {
            return null;
        }

        if (assmt == null) {
            Session session = null;

            try {
                session = openSession();

                assmt = (Assmt) session.get(AssmtImpl.class, primaryKey);

                if (assmt != null) {
                    cacheResult(assmt);
                } else {
                    EntityCacheUtil.putResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
                        AssmtImpl.class, primaryKey, _nullAssmt);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(AssmtModelImpl.ENTITY_CACHE_ENABLED,
                    AssmtImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return assmt;
    }

    /**
     * Returns the assmt with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param assmtId the primary key of the assmt
     * @return the assmt, or <code>null</code> if a assmt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Assmt fetchByPrimaryKey(long assmtId) throws SystemException {
        return fetchByPrimaryKey((Serializable) assmtId);
    }

    /**
     * Returns all the assmts.
     *
     * @return the assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Assmt> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the assmts.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of assmts
     * @param end the upper bound of the range of assmts (not inclusive)
     * @return the range of assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Assmt> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the assmts.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of assmts
     * @param end the upper bound of the range of assmts (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Assmt> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Assmt> list = (List<Assmt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_ASSMT);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ASSMT;

                if (pagination) {
                    sql = sql.concat(AssmtModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Assmt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Assmt>(list);
                } else {
                    list = (List<Assmt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the assmts from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Assmt assmt : findAll()) {
            remove(assmt);
        }
    }

    /**
     * Returns the number of assmts.
     *
     * @return the number of assmts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_ASSMT);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the assmt persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Assmt")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Assmt>> listenersList = new ArrayList<ModelListener<Assmt>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Assmt>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(AssmtImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
