package gov.va.caret.service.paymentjobs;

import java.util.Calendar;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.service.impl.FmsOgSupport;

public class MonthlyPaymentJobWorker implements Runnable {

	public static Log log = LogFactoryUtil.getLog( MonthlyPaymentJobWorker.class );
	public MonthlyPaymentJobWorker() {
	}
	
	public void run()
	{
		try {
			log.info("Processing Monthly email notifications for payments");	
			
			FmsOgSupport.stageMonth( Calendar.getInstance() );
			
			log.info("Processing Monthly email notifications end");				
		} catch(Exception er) {
			log.error("Error Processing Monthly email notifications for payments");
			ApplicationWorkFlowException.handleException(er);
		}
	
	}
	
}
