/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchWorImException;
import gov.va.caret.model.WorIm;
import gov.va.caret.service.base.WorImLocalServiceBaseImpl;

/**
 * The implementation of the wor im local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.WorImLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.WorImLocalServiceBaseImpl
 * @see gov.va.caret.service.WorImLocalServiceUtil
 */
public class WorImLocalServiceImpl extends WorImLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.WorImLocalServiceUtil} to access the wor im local service.
	 */
	
	public WorIm findByVcgId(long vcgId, long caregiverId, String status, String type) throws ApplicationWorkFlowException {
		try 
		{
			return this.worImPersistence.findByCgStatus(vcgId, caregiverId, status, type);
		} catch (NoSuchWorImException e) {
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		return null;
	}
	
	public List<WorIm> findByCgWork(long vcgId, long caregiverId, String type) throws ApplicationWorkFlowException {
		try {
			return this.worImPersistence.findByCgWork(vcgId, caregiverId, type);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<WorIm> findByType(long veteranId, String type) throws ApplicationWorkFlowException {
		try {
			return this.worImPersistence.findByType(veteranId, type);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public WorIm findByCgWorkLast(long vcgId, long caregiverId, String type) throws ApplicationWorkFlowException {
		try {
			return this.worImPersistence.findByCgWork_Last(vcgId, caregiverId, type, null);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (NoSuchWorImException e) {}
		return null;
	}
	
	public List<WorIm> findByGroupTypes(long classPk, long classId, String[] types, long groupId) throws ApplicationWorkFlowException {
		try {
			return this.worImPersistence.findByGroupTypes(classPk, classId, types, groupId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public int countByCgWork(long vcgId, long caregiverId, String type) throws ApplicationWorkFlowException {
		try {
			return this.worImPersistence.countByCgWork(vcgId, caregiverId, type);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<WorIm> findByClassId(long vcgId, long classPk) throws ApplicationWorkFlowException {
		try { 
			return worImPersistence.findByClassVcgId(classPk, vcgId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<WorIm> findByVcgId(long vcgId) throws ApplicationWorkFlowException {
		try {
			return worImPersistence.findByVcgId(vcgId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<WorIm> findByOpenQueueIds(long[] queueIds, long vcgId) throws ApplicationWorkFlowException {
		try {
			return worImPersistence.findByOpenQueueIds(queueIds, vcgId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<WorIm> findByClassPk(long classPk) throws ApplicationWorkFlowException {
		try { 
			return worImPersistence.findByClassPk(classPk);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}	
	
	public WorIm getLastWork( long vcgId, String workType ) throws ApplicationWorkFlowException {
		try {
			return this.worImPersistence.findByVcgType_Last(vcgId, workType, null);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (NoSuchWorImException e) {}
		return null;
	}
	
	public WorIm getLastWork( long vcgId, String workType, long groupId ) throws ApplicationWorkFlowException {
		try {
			return this.worImPersistence.findByVcgTypeGroup_Last(vcgId, workType, groupId, null);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (NoSuchWorImException e) {}
		return null;
	}
}