/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Junction;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.service.base.VendrLocalServiceBaseImpl;

/**
 * The implementation of the vendr local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.VendrLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.VendrLocalServiceBaseImpl
 * @see gov.va.caret.service.VendrLocalServiceUtil
 */
public class VendrLocalServiceImpl extends VendrLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.VendrLocalServiceUtil} to access the vendr local service.
	 */
	public static Log _log = LogFactoryUtil.getLog( VendrLocalServiceImpl.class );
	
	
	public List<Vendr> findByName(String last, String first) throws ApplicationWorkFlowException {
		try 
		{
			return this.vendrPersistence.findByName(last, first);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public Vendr findByPersnId ( long persnId ) throws ApplicationWorkFlowException {
		try {
			List<Vendr> vendrs = vendrPersistence.findByPersnId(persnId);
			if ( !vendrs.isEmpty() ){
				if ( vendrs.size() > 1 ){
					_log.error("MULTIPLE VENDORS FOR THIS PERSON");
				}
				return vendrs.get(0);
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		return null;
	}
	
	public List<Vendr> findByNotPaymentMethod( String paymentMethod, int start, int end ) throws ApplicationWorkFlowException {
		try {
			DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(VendrImpl.class,
					PortletClassLoaderUtil.getClassLoader());
			
			Junction disjunction = RestrictionsFactoryUtil.disjunction();
			disjunction.add( PropertyFactoryUtil.forName("paymentMethod").ne( paymentMethod ) )
						.add( PropertyFactoryUtil.forName("paymentMethod").isNull() );
			dynamicQuery.add( disjunction );
			return vendrLocalService.dynamicQuery(dynamicQuery, start, end);
//			return this.vendrPersistence.findByNotPaymentMethod ( paymentMethod, start, end );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public int countByNotPaymentMethod ( String paymentMethod ) throws ApplicationWorkFlowException{
		try {
			DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(VendrImpl.class,
					PortletClassLoaderUtil.getClassLoader());
			
			Junction disjunction = RestrictionsFactoryUtil.disjunction();
			disjunction.add( PropertyFactoryUtil.forName("paymentMethod").ne( paymentMethod ) )
						.add( PropertyFactoryUtil.forName("paymentMethod").isNull() );
			dynamicQuery.add( disjunction );
			
			return (int) vendrLocalService.dynamicQueryCount( dynamicQuery );
//			return vendrPersistence.countByNotPaymentMethod( new String[] {paymentMethod, ""} );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return 0;
	}
	
}