package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.VcgUx;
import gov.va.caret.service.base.VcgUxLocalServiceBaseImpl;

/**
 * The implementation of the vcg ux local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.VcgUxLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.VcgUxLocalServiceBaseImpl
 * @see gov.va.caret.service.VcgUxLocalServiceUtil
 */
public class VcgUxLocalServiceImpl extends VcgUxLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.VcgUxLocalServiceUtil} to access the vcg ux local service.
     *
     */
	
	public List<VcgUx> findByApplication(long vcgAnId ) throws ApplicationWorkFlowException {
		try {
			return this.vcgUxPersistence.findByApplication(vcgAnId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<VcgUx> findByApplication(long userId, long vcgAnId ) throws ApplicationWorkFlowException {
		try {
			return this.vcgUxPersistence.findByApplication(vcgAnId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<VcgUx> findByTentenRole(long userId, long tentenRoleId ) throws ApplicationWorkFlowException {
		try {
			return this.vcgUxPersistence.findByTentenRole( userId, tentenRoleId ); 
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<VcgUx> findByTentenRole(long userId, long[] tentenRoleIds, boolean complete ) throws ApplicationWorkFlowException {
		try {
			return this.vcgUxPersistence.findByTentenRoleComplete ( userId, tentenRoleIds, complete ); 
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<VcgUx> findByUserState( long userId, String uxState ) throws ApplicationWorkFlowException {
		try {
			return this.vcgUxPersistence.findByUserState(userId, uxState);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
}
