/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchStiPtException;
import gov.va.caret.model.StiPt;
import gov.va.caret.service.base.StiPtLocalServiceBaseImpl;

/**
 * The implementation of the sti pt local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.StiPtLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.StiPtLocalServiceBaseImpl
 * @see gov.va.caret.service.StiPtLocalServiceUtil
 */
public class StiPtLocalServiceImpl extends StiPtLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.StiPtLocalServiceUtil} to access the sti pt local service.
	 */
	
	
	//Only applicable for OCC Primary work Items
	public StiPt findByWorIm ( long worImId ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByWorkId_First( worImId, null );
		} catch ( NoSuchStiPtException n){
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	//Only applicable for OCC Primary work Items
	public List<StiPt> findByWorkId ( long worImId ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByWorkId( worImId, -1, -1 );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findByVcg ( long vcgId, int start, int end, OrderByComparator orderByComparator ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByVcgId(vcgId, start, end, orderByComparator);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<StiPt> findByVcgRecurring ( long vcgId ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByVcgRecurring(vcgId, -1, -1, null);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<StiPt> findByApprovedRecurring ( int start, int end, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByApprovedRecurring( stipendStatus);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public int countByApprovedRecurring ( String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.countByApprovedRecurring( stipendStatus);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return 0;
	}
	
	public List<StiPt> findByRecurring ( long vendrId, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByRecurrent(vendrId, stipendStatus);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findByOneTimeStatus ( long vendrId, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByOneTimeStatus(vendrId, stipendStatus);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public int countByOneTime ( long vcgId, String stipendAmount, Date date ) throws ApplicationWorkFlowException{
		try {
			Set<Long> stiPdIds = new HashSet<Long>();
			for ( StiPt stiPt :stiPtPersistence.findByOneAmount( vcgId, stipendAmount ) ) {
				stiPdIds.add(stiPt.getStiPtId());
			}
			for ( StiPt stiPt :stiPtPersistence.findByOneDate( vcgId, date ) ) {
				stiPdIds.add(stiPt.getStiPtId());
			}
			return stiPdIds.size();
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return 0;
	}
	
	public List<StiPt> findByOneAmount ( long vcgId, String stipendAmount ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByOneAmount( vcgId, stipendAmount );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findByPreempPending ( long vcgId, long worImId, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByPreempPending(vcgId, worImId, stipendStatus);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public int countByPreempPending ( long vcgId, long worImId, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.countByPreempPending(vcgId, worImId, stipendStatus);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return 0;
	}
	
	public List<StiPt> findByOneDate ( long vcgId, Date date ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByOneDate( vcgId, date);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findByRecurrentVendor ( long vendrId, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByRecurrentVendor(vendrId, stipendStatus);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findByRecurringBefore ( long vcgId, String[] stipendStatus, Date startDate ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByRecurrentBefore(vcgId, stipendStatus, startDate);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findAllByRecurringBefore ( String[] stipendStatus, Date startDate ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByAllRecurrentBefore(stipendStatus, startDate);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
		
	public List<StiPt> findByRecurringAfter ( long vcgId, String[] stipendStatus, Date startDate ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByRecurrentAfter(vcgId, stipendStatus, startDate);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findByVcgRecurringStatus ( long vcgId, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByVcgRecurringStatus (vcgId, stipendStatus );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public StiPt findByOneTimeBefore ( long vcgId, String[] stipendStatus, Date startDate, Date approvalDate ) throws ApplicationWorkFlowException{
		try {
			List<StiPt> list = stiPtPersistence.findByOneTimeBefore(vcgId, stipendStatus, startDate, approvalDate, 0, 10);
			if ( !list.isEmpty() ) {
				return list.get(0);
			}
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public List<StiPt> findByVendorId ( long vendorId, int start, int end ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByVendor( vendorId, start, end );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<StiPt> findByVendorId ( long vendorId, String[] stipendStatus ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByVendorStatus( vendorId, stipendStatus );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<StiPt> findByVendorCycle ( long vendorId, long cycleId ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByVendorCycle(vendorId, cycleId);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<StiPt> findByCycle ( long cycleId ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByCycle(cycleId);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
		
	public List<StiPt> findByUpdatePending ( String stipendType, Date stipendStartDate ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByUpdatePending(stipendType, stipendStartDate);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public int countByStipends ( String stipendType, Date stipendStartDate ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.countByUpdatePending(stipendType, stipendStartDate);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return 0;
	}
	
//	public List<StiPt> findByPaymentVendrStart ( String[] stipendStatus, long vendrId, Date stipendStartDate ) throws ApplicationWorkFlowException{
//		try {
//			return stiPtPersistence.findByPaymentVendrStart( vendrId, stipendStatus, stipendStartDate );
//		} catch (SystemException e) {
//			ApplicationWorkFlowException.handleException(e);
//		}
//		return Collections.emptyList();
//	}
	
}