/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.LumCg;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.StiPt;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.base.PayLgLocalServiceBaseImpl;

/**
 * The implementation of the pay lg local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.PayLgLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.PayLgLocalServiceBaseImpl
 * @see gov.va.caret.service.PayLgLocalServiceUtil
 */
public class PayLgLocalServiceImpl extends PayLgLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.PayLgLocalServiceUtil} to access the pay lg local service.
	 */
	
	public List<PayLg> findByVendor ( long vendorId, int start, int end ) throws ApplicationWorkFlowException {
		try {
			return payLgPersistence.findByVendor( vendorId, start, end );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	
	public List<PayLg> findByConfig ( long stiPt, int start, int end ) throws SystemException {

		List<LumCg> lumCgs = lumCgPersistence.findByStipendConfig( stiPt );
		long[] configIds = new long[lumCgs.size()];
		int i = 0;
		for ( LumCg config: lumCgs ) {
			configIds[i++] = config.getCycleId();
		}
		if ( configIds.length == 0 ) {
			return Collections.emptyList();
		}
		return payLgPersistence.findByVendrCycles( lumCgs.get(0).getVendrId(), configIds );
	}
	
	public PayLg findByVendorCycle ( long vendrId, long cycleId ) throws ApplicationWorkFlowException {
		try {
			return payLgPersistence.fetchByVendrCycle(vendrId, cycleId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public PayLg fetchLastPayment ( long vendrId ) throws ApplicationWorkFlowException {
		try {
			return payLgPersistence.fetchBySuccessReason_Last( vendrId, null );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<PayLg> findBySuccessReason ( long vendrId ) throws ApplicationWorkFlowException {
		try {
			return payLgPersistence.findBySuccessReason(vendrId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
}