package gov.va.caret.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.LumCg;
import gov.va.caret.model.PayLg;
import gov.va.caret.service.base.LumCgLocalServiceBaseImpl;

/**
 * The implementation of the lum cg local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.LumCgLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.LumCgLocalServiceBaseImpl
 * @see gov.va.caret.service.LumCgLocalServiceUtil
 */
public class LumCgLocalServiceImpl extends LumCgLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.LumCgLocalServiceUtil} to access the lum cg local service.
     */
	
	public List<LumCg> findByVendrCycle ( long vendrId, long cycleId ) throws SystemException {
		return lumCgPersistence.findByVendrLumpedCycle(vendrId, cycleId, -1, -1);
	}
	
	public List<LumCg> findByStiPtId ( long stiPt, int start, int end ) throws SystemException {
		return lumCgPersistence.findByStipendConfig( stiPt );
	}
	
}
