package gov.va.caret.service.impl;

import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.FmsOg;
import gov.va.caret.model.FmsOgWrapper;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.support.Vendor;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.thread.NonClusteredMonitor;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.OwnerQueue;
import gov.va.caret.workflow.QueAction;

public class FmsOgSupport extends FmsOgWrapper {

	private static final long serialVersionUID = 1L;

	private static Log _log = LogFactoryUtil.getLog( FmsOgSupport.class );
	
	public static final String FMS_OUTGOING_READY = "FMS_OUTGOING_READY";
	public static final String FMS_INCOMING_LOADED = "FMS_INCOMING_LOADED";
	public static final int LAST_DAY_OF_FMS_MONTH = 27;
	
	public FmsOgSupport(FmsOg fmsOg) {
		super(fmsOg);
	}
	
//	WorkItemSupport workitem = null;
	
//	public static void mockMonth (  ) {
//		
//		if ( !CaretUtil.isMockFmsInitEnabled() ) {
//			_log.info("FMS mock not enabled: mock.fms.init.enabled");
//			return;
//		}
//		
//		Calendar calendar = Calendar.getInstance();
//		calendar.set( Calendar.DAY_OF_MONTH, 1);
//		calendar.set( Calendar.HOUR_OF_DAY, 0);
//		calendar.set( Calendar.MINUTE, 0);
//		calendar.set( Calendar.MILLISECOND, 22);
//		
//		List<Date> list = new ArrayList<Date> ();
////		list.add( calendar.getTime() );
//		for ( int i = 8; i > 1; i-- ) {
//			calendar.roll(Calendar.MONTH, false);
//			if ( calendar.get(Calendar.MONTH) == Calendar.DECEMBER ) {
//				calendar.roll(Calendar.YEAR, false);
//			}
//			list.add( calendar.getTime() );
//		}
//		for ( int i = list.size()-1; i >= 0; i-- ) {
//			calendar.setTime( list.get( i ) );
//			try {
//				Calendar cloned = (Calendar)calendar.clone();
//				BgLae bgLae0 = Vendor.initMonth( calendar );
//				
//				for ( StiPt stiPt: StiPtLocalServiceUtil.getStiPts(-1, -1)) {
//					if ( stiPt.getStipendStartDate().before( cloned.getTime() ) && stiPt.getStipendApprovedDate() != null && StipendConfig.PAYMENT_FINANCE.equals( stiPt.getStipendStatus()) ) {
//						if ( stiPt.getPayslipDate() == null ) {
//							Date stipendStartDate = stiPt.getStipendStartDate();
//							String payment = stiPt.getPayment();
//							String tierHours = stiPt.getTierHours();
//							String blsRateHourly = stiPt.getBlsRateHourly();
//							if ( StipendConfig.RECURRING.equals( stiPt.getStipendType() ) ) {
//								stiPt.setOneTimePayment( InitialPayment.getFinalAmount ( stipendStartDate, payment, tierHours, blsRateHourly, StipendConfig.getPayday( cloned ) ) );
//							}
//						}
//						stiPt.setCycleId( bgLae0.getBgLaeId() );
//						StiPtLocalServiceUtil.updateStiPt(stiPt);
//					}
//				}
//				bgLae0 = stageMonth(cloned);
//				mockService ( (Calendar)calendar.clone(), mockApprove ( (Calendar)calendar.clone(), bgLae0 ) );
//			} catch (ApplicationWorkFlowException e) {
//				e.printStackTrace();
//			} catch (SystemException e) {
//				e.printStackTrace();
//			} catch (PortalException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//		}
//	}
	
	
	public static BgLae stageMonth(Calendar calendar) throws SystemException, PortalException {
		
		ServiceContext sc = new ServiceContext();
		sc.setUserId( UserLocalServiceUtil.getDefaultUserId( PortalUtil.getDefaultCompanyId() ) );
		sc.setCompanyId( PortalUtil.getDefaultCompanyId() );
		sc.setCreateDate( new Date() );
		sc.setAddGuestPermissions(false);
		
		
		BgLae boxGpLae = Vendor.initMonth( Calendar.getInstance(), false );
		
		BgLae bgLae0 = Vendor.initMonth( calendar );
		bgLae0.setLargeText( StipendConfig.STAGED + Toolbox.formatDate( calendar.getTime() ) );
		CaretLocalServiceUtil.save( bgLae0 );
		if ( CaretUtil.isEmailEnabled() ) {
			Map<String,Object> otherInfo = new HashMap<String,Object>();
			otherInfo.put("to", PropsUtil.get( "stage.month.email.to" ) );
			otherInfo.put("from", PropsUtil.get( "stage.month.email.from" ) );
			String month = Toolbox.MONTHS[calendar.get( Calendar.MONTH) ];
			otherInfo.put("subject", MessageFormat.format( PortletProps.get( "stage.month.email.subject" ), month ) );
			otherInfo.put("body", MessageFormat.format( PortletProps.get( "stage.month.email.body" ), month) );
			CaretUtil.sendPaymentNotificationMail( otherInfo );
		} else {
			_log.info("Emails not enabled: email.enabled");
		}
		
		
		return bgLae0;
	}
	
	public static BgLae stageWeek(Calendar calendar) throws SystemException, PortalException {
		
		ServiceContext sc = new ServiceContext();
		sc.setUserId( UserLocalServiceUtil.getDefaultUserId( PortalUtil.getDefaultCompanyId() ) );
		sc.setCompanyId( PortalUtil.getDefaultCompanyId() );
		sc.setCreateDate( new Date() );
		sc.setAddGuestPermissions(false);
		
		//----------------
		
		BgLae bgLae = null;
		long lockId = 0;
		int count = 0;
		double total = 0;
		for ( StiPt stiPt: StiPtLocalServiceUtil.findByUpdatePending(StipendConfig.ONE_TIME, sc.getCreateDate() ) ) {
			
			if ( stiPt != null && stiPt.getCycleId() > 0 ){
				BgLae bgl = BgLaeLocalServiceUtil.fetchBgLae( stiPt.getCycleId() );
				if ( bgl != null && bgLae != null && //daily was already staged/submitted for this payment... 
						bgl.getLargeText().startsWith(StipendConfig.STAGED) || 
						bgl.getLargeText().startsWith("FMS") || 
						bgl.getBoxGpId() == bgLae.getBoxGpId() ) { 
					_log.warn("Payment submitted previously " + stiPt.getStiPtId() + " with transaction ID " + bgl);
					continue;
				}
			}
			if ( bgLae == null ) {
				boolean isThursday = false,
						isMonthLastDay = false;
				
				Calendar today = Calendar.getInstance();
				if ( today.get(Calendar.DAY_OF_WEEK) == Calendar.THURSDAY ) {
					isThursday = true;
				}
				if ( today.get(Calendar.DAY_OF_MONTH) == LAST_DAY_OF_FMS_MONTH ) {
					isMonthLastDay = true;
				}
				
				if ( isThursday || isMonthLastDay ) {
					bgLae = Vendor.getPaymentStep(sc); //First the weekly schedule if not used, otherwise monthly
					if ( bgLae.getLargeText().startsWith("FMS_") ||	bgLae.getLargeText().startsWith(StipendConfig.COMPLETED) ) { //payment was already submitted/responded, re-issue as daily...
						bgLae = null;
					}
				}
				
				if ( bgLae == null ){
					bgLae = BgLaeLocalServiceUtil.getLastBgLae( Toolbox.getBgLaeDay() );
					if ( bgLae != null && ( bgLae.getLargeText().startsWith("FMS_") || bgLae.getLargeText().startsWith(StipendConfig.COMPLETED) ) ) { 
						bgLae = null;
					}
				}
				
				if ( bgLae == null ){
					//set up new daily payment request...
					Calendar calendar2 = Calendar.getInstance();
					BoxGp boxGp = Vendor.getOneTimeDailyBg(calendar2);
					bgLae = new BgLaeImpl();
					bgLae.setOwnerId( Toolbox.getBgLaeDay() );
					bgLae.setBoxGpId( boxGp.getBoxGpId() );
				}
				
				bgLae.setLargeText( StipendConfig.STAGED + Toolbox.formatDateTime( sc.getCreateDate()) );
				CaretLocalServiceUtil.save(bgLae);
				
				
			}
			
			lockId = NonClusteredMonitor.lock(bgLae.getBoxGpId(), bgLae.getBgLaeId());
			if ( bgLae.getBgLaeId() != lockId ){//could not capture lock...
				_log.error("multiple processes not allowed to submit to OCC FM for payment concurrently");
				//protect against race condition, 1 submit to OCC FM at a time...
				continue;
			}

			stiPt.setCycleId( bgLae.getBgLaeId() );
			CaretLocalServiceUtil.save( stiPt );
			double amount;
			
			if ( stiPt.getPayslipDate() == null ){
				amount = Double.valueOf( stiPt.getOneTimePayment() );
			} else {
				amount = Double.valueOf( stiPt.getPayment() );
			}
			total = total + amount;
			if ( _log.isInfoEnabled() ) {
				_log.info("Staged payment:" + stiPt.getOneTimePayment() + " for Vendor:" + stiPt.getVendrId() + " with cycleId:" + bgLae.getBgLaeId() );
			}
			
			NonClusteredMonitor.unlock( bgLae.getBoxGpId() );
			count++;
		}
		
		//----------------
		
		BgLae bgLae0 = Vendor.initWeek( calendar, sc );
		bgLae0.setLargeText( StipendConfig.STAGED + Toolbox.formatDate( calendar.getTime() ) );
		CaretLocalServiceUtil.save( bgLae0 );
		
		Map<String,Object> otherInfo = new HashMap<String,Object>();
		otherInfo.put("to", PropsUtil.get( "stage.week.email.to" ) );
		otherInfo.put("from", PropsUtil.get( "stage.week.email.from" ) );
		otherInfo.put("subject", PortletProps.get( "stage.week.email.subject" ) );
		otherInfo.put("body", PortletProps.get( "stage.week.email.body" ) );
		if ( CaretUtil.isEmailEnabled() ) {
			CaretUtil.sendPaymentNotificationMail( otherInfo );
		} else {
			_log.warn("Emails disabled");
		}
		
		return bgLae0;
	}

	public static BgLae stageDaily( ServiceContext sc ) throws ApplicationWorkFlowException, SystemException {
		

		boolean isThursday = false;
		boolean isMonthLastDay = false;
		
		Calendar today = Calendar.getInstance();
		if ( today.get(Calendar.DAY_OF_WEEK) == Calendar.THURSDAY ) {
			isThursday = true;
		}
//		today.roll(Calendar.DAY_OF_MONTH, true);
		if ( today.get(Calendar.DAY_OF_MONTH) == LAST_DAY_OF_FMS_MONTH ) {
			isMonthLastDay = true;
		}
		
		BgLae bgLae = null;
		if ( isThursday || isMonthLastDay ) {
			bgLae = Vendor.getPaymentStep(sc); //First the weekly schedule if not used, otherwise monthly
			if ( bgLae.getLargeText().startsWith("FMS_") ||	bgLae.getLargeText().startsWith(StipendConfig.COMPLETED) ) { //payment was already submitted/responded, re-issue as daily...
				bgLae = null;
			}
		}
		
		long ownerId = Toolbox.getBgLaeDay();
		if ( bgLae == null ){
			bgLae = BgLaeLocalServiceUtil.getLastBgLae( ownerId );
			if ( bgLae != null && ( bgLae.getLargeText().startsWith("FMS_") || bgLae.getLargeText().startsWith(StipendConfig.COMPLETED) ) ) { 
				bgLae = null;
			}
		}
		
		if ( bgLae == null ){
			//set up new daily payment request...
			Calendar calendar = Calendar.getInstance();
			BoxGp boxGp = Vendor.getOneTimeDailyBg(calendar);
			bgLae = new BgLaeImpl();
			bgLae.setOwnerId( ownerId );
			bgLae.setBoxGpId( boxGp.getBoxGpId() );
		}
		
		bgLae.setLargeText( StipendConfig.STAGED + Toolbox.formatDateTime( sc.getCreateDate()) );
		CaretLocalServiceUtil.save(bgLae);
		
		return bgLae;
		
	}
	
	
	private static BgLae mockApprove( Calendar calendar, BgLae bgLae ) throws ApplicationWorkFlowException, SystemException {
//		BoxGp boxGp = Vendor.getRecurringBoxGp( calendar );
//		int ownerMonth = calendar.get( Calendar.MONTH ) + calendar.get( Calendar.YEAR )* 12;
//		BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( ownerMonth, boxGp.getBoxGpId() );
		
//		if ( bgLae == null ) {
//			try {
//				bgLae = new BgLaeImpl();
//				bgLae.setOwnerId( ownerMonth );
//				bgLae.setBoxGpId( boxGp.getBoxGpId() );
//				bgLae.setLargeText( StipendConfig.STAGED + Toolbox.formatDate( calendar.getTime() ) );
//				BgLaeLocalServiceUtil.addBgLae( bgLae);
//				_log.info("created..:" + bgLae );
//			} catch (SystemException e) {
//				e.printStackTrace();
//			}
//		}
		if ( bgLae.getLargeText().startsWith(StipendConfig.STAGED) ) {
			CaretLocalServiceUtil.setFmsOut( calendar.getTime(), bgLae, true );//String.valueOf( bgLae.getOwnerId() ), String.valueOf( bgLae.getBgLaeId() )
		}
		return bgLae;
	}
	
//	public static void mockService ( Calendar calendar, BgLae bgLae ) {
//		
//			
//		try {
//			_log.info("Using BgLae:" + bgLae + ", with BoxGpId:" + bgLae.getBoxGpId() );
//			if ( bgLae != null && !bgLae.getLargeText().startsWith("COMPLETED-") ) {
//				
//				CaretLocalServiceUtil.mockService( String.valueOf( bgLae.getOwnerId() ), String.valueOf( bgLae.getBgLaeId() ), true );
//				Double updates = loadPayLog(bgLae, calendar.getTime() );
//				if ( updates != null ) {
//					try {
//						BgNum num = new BoxNumberSupport( BoxGpLocalServiceUtil.getBoxGroupBgNum( CbopcFmDashboardConfig.AVAILABLE_ID ).get(0) );
//						num.setValue( num.getValue() - updates );
//						CaretLocalServiceUtil.save(num);
//					} catch (ApplicationWorkFlowException e) {
//						e.printStackTrace();
//					}
//				}
//				
//				////
//				List<FmsIc> list = CaretLocalServiceUtil.getFmsIn( (int)bgLae.getOwnerId(), bgLae.getBgLaeId(), "REJECTED", 0, 50); //TODO identify all incoming rejection statuses
//				try {
//					do {
//						for ( FmsIc fmsIc: list ) {
//							FmsOg og = FmsOgLocalServiceUtil.getFmsOg( Long.valueOf(fmsIc.getVoucherId() ) );
//							PayLg payLg = new PayLgImpl();
//							payLg.setAmount( Double.valueOf(fmsIc.getAmount()) );
//	//						payLg.setCreationDate(calendar.getTime());
//							payLg.setPaymentDate( fmsIc.getCreationDate() );
//							payLg.setReason(StipendConfig.PAYMENT_REJECTED);
//							payLg.setCycleId( og.getCycleId());
//							payLg.setStatus(StringPool.BLANK);
//							payLg.setVendrId( og.getVendrId() );
//							payLg.setFmsIcId( fmsIc.getFmsIcId() );
////							payLg.setPaymentMethod(paymentMethod);
////							payLg.setPaymentNumber(paymentNumber);
//							
//							_log.info("adding..." + payLg);
//							CaretLocalServiceUtil.save(payLg);
//							fmsIc.setType("failure-loaded");
//							FmsIcLocalServiceUtil.updateFmsIc(fmsIc);
//							updates = (updates == null)? Double.valueOf(0): updates;
//							
//							StiPt stiPt = new PaymentLog(payLg).getStipendConfig();
//							
//							_log.info("putting on hold..." + stiPt);
//							stiPt.setStipendStatus(StipendConfig.ON_HOLD);
//							CaretLocalServiceUtil.save(stiPt);
//							
//							Vendr vendr = VendrLocalServiceUtil.fetchVendr(stiPt.getVendrId());
//							if ( vendr != null ) {
//								vendr.setStatus( StipendConfig.ON_HOLD );
//								CaretLocalServiceUtil.save(vendr);
//							} else {
//								_log.error("Could not place hold on Vendor:" + stiPt.getVendrId() );
//							}
//							
//							WorIm worIm = WorImLocalServiceUtil.getWorIm(stiPt.getWorImId());
//							WorIm wis = CaretUtil.createWorkItem( ServiceContextThreadLocal.getServiceContext(), worIm.getGroupId(),
//									worIm.getClassId(), worIm.getClassPk(), worIm.getPersnId(), WorkType.REJECTED_PAYMENT.name(), worIm.getCaregiverId(), null );
//							wis.setQueueId(OwnerQueue.REJ_PAY_Q.getQueueId());
//							wis.setVcgId(worIm.getVcgId());
//							wis.setGroupId(payLg.getPaymentLogId());
//							wis.setStatus(CaretStrPool.HOLD_PLACED_ON_ACCOUNT);
//							_log.info("creating hold work item..." + wis);
//							CaretLocalServiceUtil.save(wis);
//							
//							WorSe workItemStep = new WorSeImpl();
//							workItemStep.setWorImId( wis.getWorImId() );
//							workItemStep.setCreationDate( ServiceContextThreadLocal.getServiceContext().getCreateDate() );
//							workItemStep.setUserId( ServiceContextThreadLocal.getServiceContext().getUserId() );
//							int count = WorSeLocalServiceUtil.getCount ( wis.getWorImId() );
//							workItemStep.setStep( (count < 10? "0":StringPool.BLANK) + count + StringPool.COLON + wis.getType() + StringPool.COLON + wis.getStatus() );
//							workItemStep.setStepNumber(count+1);
//							CaretLocalServiceUtil.save( workItemStep );
//						}
//						list = CaretLocalServiceUtil.getFmsIn( (int)bgLae.getOwnerId(), bgLae.getBgLaeId(), "REJECTED", 0, 50);
//					} while ( list.size() > 0 );
//					bgLae.setLargeText( "COMPLETED-" + bgLae.getLargeText().substring(bgLae.getLargeText().indexOf("-"), bgLae.getLargeText().length()-1 ) );
//					CaretLocalServiceUtil.save(bgLae);
//				} catch (SystemException e) {
//					e.printStackTrace();
//				} catch (PortalException e) {
//					e.printStackTrace();
//				}
//				
//			}
//		} catch (ApplicationWorkFlowException e) {
//			e.printStackTrace();
//		}
//	}
	
//	public static Double loadPayLog(BgLae bgLae, Date createDate ) throws ApplicationWorkFlowException {
//
//		List<FmsIc> list = CaretLocalServiceUtil.getFmsIn( (int)bgLae.getOwnerId(), bgLae.getBgLaeId(), "successful", 0, 50);
//		int errs = 0;
//		Double updates = null;
//		double rejects = 0;
//		
//		do {
//			try {
//				for ( FmsIc fmsIc: list ) {
//					// search for lump sum types
//					// create pay-log for each item
//					
//					FmsOg og = FmsOgLocalServiceUtil.getFmsOg( Long.valueOf( fmsIc.getVoucherId() ) );
//					double count = 0;
//					double amount = 0;
//					//TODO: rename FmsOg stiPt column to vendrId
//					Set<Long> configs = new HashSet<Long>();
//					for ( StiPt config: StiPtLocalServiceUtil.findByVendorCycle( og.getVendrId(),  og.getCycleId() ) ) {
//						configs.add(config.getStiPtId());
//						if ( StipendConfig.RECURRING.equals( config.getStipendType() ) ){
//							if ( config.getPayslipDate() == null ) {
//								amount = Double.valueOf( config.getOneTimePayment() );
//								config.setPayslipDate( createDate );
//							} else {
//								amount = Double.valueOf( config.getPayment() );
//							}
//							count = count + amount;
//						} else {
//							amount = Double.valueOf( config.getOneTimePayment() );
//							count = count + amount;
////							config.setStipendStatus( StipendConfig.OBSOLETE_PAYMENT );
//							config.setPayslipDate( createDate );
//						}
//						CaretLocalServiceUtil.save(config);
//					}
//					for ( Long stiPtId: configs ) {
//						LumCg lumCg = new LumCgImpl();
//						lumCg.setCycleId( fmsIc.getCycleId() );
//						lumCg.setStiPtId( stiPtId );
//						lumCg.setVendrId( og.getVendrId() );
//						lumCg.setStatus( fmsIc.getStatus() );
//						LumCgLocalServiceUtil.addLumCg( lumCg );
//					}
//					PayLg payLg = new PayLgImpl();
//					payLg.setAmount( Double.valueOf( fmsIc.getAmount() ) );
//					payLg.setPaymentDate( fmsIc.getCreationDate() );
//					payLg.setReason( fmsIc.getStatus() );
//					payLg.setVendrId( og.getVendrId() );
//					payLg.setFmsIcId( fmsIc.getFmsIcId() );
////					payLg.setCreationDate(createDate);
////					payLg.setPaymentMethod(paymentMethod);
////					payLg.setPaymentNumber(paymentNumber);
//					payLg.setCycleId( og.getCycleId() );
////						payLg.setStatus( "" );
//					CaretLocalServiceUtil.save(payLg);
//					
//					_log.info("Payment comparison for Lumps, we logged:" + count + ", we expected:" + fmsIc.getAmount() );
//					fmsIc.setType("successful-loaded");
//					FmsIcLocalServiceUtil.updateFmsIc(fmsIc);
//					updates = (updates == null)? Double.valueOf(fmsIc.getAmount()) : updates + Double.valueOf(fmsIc.getAmount());
//				}
//
//				
//				list = CaretLocalServiceUtil.getFmsIn( (int)bgLae.getOwnerId(), bgLae.getBgLaeId(), "successful", 0, 50);
//				if ( updates == null ) {
//					updates = 0.0;
//				}
//				
//			} catch (SystemException e) {
//				e.printStackTrace();
//				errs++;
//			} catch (NumberFormatException e) {
//				e.printStackTrace();
//			} catch (PortalException e) {
//				e.printStackTrace();
//			}
//		} while ( list.size() > 1 && errs < 1 );
//		
//		
//		////Manage the rejected payments...
//		list = CaretLocalServiceUtil.getFmsIn( (int)bgLae.getOwnerId(), bgLae.getBgLaeId(), "REJECTED", 0, 50); //TODO identify all incoming rejection statuses
//		try {
//		do {
//			for ( FmsIc fmsIc: list ) {
//				// search for lump sum types
//				// create pay-log for each item
//				
//				FmsOg og = FmsOgLocalServiceUtil.getFmsOg( Long.valueOf( fmsIc.getVoucherId() ) );
//				
//				double count = 0;
//				double amount = 0;
//				Set<Long> configs = new HashSet<Long>();
//				List<WorIm> rejectedWorks = new ArrayList<WorIm>();
//				for ( StiPt config: StiPtLocalServiceUtil.findByVendorCycle( og.getVendrId(),  og.getCycleId() ) ) {
//					configs.add(config.getStiPtId());
//					if ( StipendConfig.RECURRING.equals( config.getStipendType() ) ){
//						if ( config.getPayslipDate() == null ) {
//							amount += Double.valueOf( config.getOneTimePayment() );
//							config.setPayslipDate( createDate );
//						} else {
//							amount += Double.valueOf( config.getPayment() );
//						}
//						count = count + amount;
//					} else {
//						amount += Double.valueOf( config.getOneTimePayment() );
//						count = count + amount;
//						config.setPayslipDate( createDate );
//					}
//
//					config.setStipendStatus(StipendConfig.ON_HOLD);
//					_log.info("putting on hold..." + config);
//					CaretLocalServiceUtil.save(config);
//					
//					WorIm worIm = WorImLocalServiceUtil.getWorIm( config.getWorImId() );
//					WorIm rejectedWorIm = CaretUtil.createWorkItem( ServiceContextThreadLocal.getServiceContext(), worIm.getGroupId(),
//							worIm.getClassId(), worIm.getClassPk(), worIm.getPersnId(), WorkType.REJECTED_PAYMENT.name(), worIm.getCaregiverId(),
//							WorkType.REJECTED_PAYMENT.getDueDate( ServiceContextThreadLocal.getServiceContext().getCreateDate() ) );
//					rejectedWorIm.setQueueId(OwnerQueue.REJ_PAY_Q.getQueueId());
//					rejectedWorIm.setVcgId(worIm.getVcgId());
//					
//					rejectedWorIm.setStatus(CaretStrPool.HOLD_PLACED_ON_ACCOUNT);
//					_log.info("creating hold work item..." + rejectedWorIm);
//					rejectedWorks.add(rejectedWorIm);
//					
//				}
//				
//				for ( Long stiPtId: configs ) {
//					LumCg lumCg = new LumCgImpl();
//					lumCg.setCycleId( fmsIc.getCycleId() );
//					lumCg.setStiPtId( stiPtId );
//					lumCg.setVendrId( og.getVendrId() );
//					lumCg.setStatus( fmsIc.getStatus() );
//					LumCgLocalServiceUtil.addLumCg( lumCg );
//				}
//				PayLg payLg = new PayLgImpl();
//				payLg.setAmount( amount );
//				payLg.setPaymentDate( fmsIc.getCreationDate() );
//				payLg.setReason( StipendConfig.PAYMENT_REJECTED );
//				payLg.setCycleId( og.getCycleId() );
//				payLg.setVendrId( og.getVendrId() );
//				payLg.setFmsIcId( fmsIc.getFmsIcId() );
//				CaretLocalServiceUtil.save(payLg);
//				
//				for ( WorIm rejectedWork : rejectedWorks ) {
//					rejectedWork.setGroupId( payLg.getPaymentLogId() );
//					CaretLocalServiceUtil.save(rejectedWork);
//				}
//				
//				_log.info("Payment comparison for Lump rejection, we logged:" + count + ", we expected:" + fmsIc.getAmount() );
//				fmsIc.setType("failure-loaded");
//				FmsIcLocalServiceUtil.updateFmsIc(fmsIc);
//				rejects = rejects + Double.valueOf(fmsIc.getAmount());
//			}
//			
//			list = CaretLocalServiceUtil.getFmsIn( (int)bgLae.getOwnerId(), bgLae.getBgLaeId(), "REJECTED", 0, 50);
//		} while ( list.size() > 0 );
//		} catch (SystemException e) {
//			e.printStackTrace();
//		} catch (PortalException e) {
//			e.printStackTrace();
//		}
//		_log.info("Total Succesful Payments we logged:" + updates );
//		_log.info("Total Rejections we logged:" + rejects );
//		
//		try {
//			bgLae.setLargeText( bgLae.getLargeText().replaceAll(FMS_INCOMING_LOADED, StipendConfig.COMPLETED) + " S:" + updates + " R:" + rejects );
//			CaretLocalServiceUtil.save(bgLae);
//			BgNum num = new BoxNumberSupport( BoxGpLocalServiceUtil.getBoxGroupBgNum( CbopcFmDashboardConfig.AVAILABLE_ID ).get(0) );
//			num.setValue( num.getValue() - updates - rejects );
//			CaretLocalServiceUtil.save(num);
//			
//			BgNum threshold = BoxGpLocalServiceUtil.getBoxGroupBgNum( CbopcFmDashboardConfig.THRESHOLD_ID ).get(0);
//			if ( threshold.getValue() > num.getValue() && CaretUtil.isEmailEnabled()) {
//				Map<String,Object> otherInfo = new HashMap<String,Object>();
//				otherInfo.put("to", PropsUtil.get( "occfm.threshold.email.to" ) );
//				otherInfo.put("from", PropsUtil.get( "occfm.threshold.email.from" ) );//"PII                           "
//				otherInfo.put("subject", PortletProps.get( "occfm.threshold.email.subject" ) );
//				otherInfo.put("body", PortletProps.get( "occfm.threshold.email.body" ) );
//				CaretUtil.sendPaymentNotificationMail(otherInfo);
//			}
//			
//		} catch (ApplicationWorkFlowException e) {
//			e.printStackTrace();
//		}
//		
//		return updates;
//	}
	
	
	public static void removeHold(ServiceContext sc, Set<Long> workIds) throws SystemException, PortalException {

		for ( long workId: workIds ) {
			
			WorIm work = WorImLocalServiceUtil.getWorIm(workId);
			Vendr vendr = VendrLocalServiceUtil.findByPersnId(work.getCaregiverId());
			for ( StiPt stiPt: StiPtLocalServiceUtil.findByVendorId( vendr.getVendrId(),  new String[] {StipendConfig.ON_HOLD} ) ) {
				stiPt.setStipendStatus( StipendConfig.PAYMENT_FINANCE );
				CaretLocalServiceUtil.save(stiPt);
			}
			if ( StipendConfig.ON_HOLD.equals( vendr.getStatus() ) ){
				vendr.setStatus( StringPool.BLANK );
				CaretLocalServiceUtil.save(vendr);
			}
				
			work.setCompletionBy(sc.getUserId());
			work.setCompletionDate(sc.getCreateDate());
			work.setStatus(QueAction.HOLD_REMOVED.name());
			work.setQueueId(OwnerQueue.VERIFIED_COMPLETED_Q.getQueueId());
			CaretLocalServiceUtil.save(work);
			
		}

		
	}

	public static void SubmitStagedPayments() throws ApplicationWorkFlowException {
		// TODO Auto-generated method stub
		
		Date logDate = new Date();
		
		List<BgLae> getAllStaged = BgLaeLocalServiceUtil.getStaged( Toolbox.getBgLaeDay() );
//		if ( CaretUtil.isMockFmsEnabled() ) {
			//mock the FMS service response...
//			for ( BgLae bgLae: getAllStaged ) {
//				CaretLocalServiceUtil.mockService( String.valueOf( bgLae.getOwnerId() ), String.valueOf( bgLae.getBgLaeId() ), true );
//				//TODO: test it where a response is not returned and additional payments are submitted
//				FmsOgSupport.loadPayLog( bgLae, logDate );
//			}
//		} else {
			int i = 0;
			for ( BgLae bgLae: getAllStaged ) {
				i++;
				CaretLocalServiceUtil.setFmsOut( logDate, bgLae, i == getAllStaged.size() );
				bgLae.setLargeText( bgLae.getLargeText().replaceAll(StipendConfig.STAGED, FMS_OUTGOING_READY));
				CaretLocalServiceUtil.save(bgLae);
				_log.info(FMS_OUTGOING_READY + " OwnerId:" + bgLae.getOwnerId() + ", BgLaeId:" + bgLae.getBgLaeId() );
			}
//		}
		
	}

}
